/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.impl;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import org.dcm4che3.conf.api.ConfigurationException;
import org.dcm4che3.conf.api.ConfigurationNotFoundException;
import org.dcm4che3.conf.api.DicomConfiguration;
import org.dcm4che3.data.SpecificCharacterSet;
import org.dcm4che3.hl7.HL7Charset;
import org.dcm4che3.imageio.codec.ImageReaderFactory;
import org.dcm4che3.imageio.codec.ImageWriterFactory;
import org.dcm4che3.io.TemplatesCache;
import org.dcm4che3.net.Device;
import org.dcm4che3.net.imageio.ImageReaderExtension;
import org.dcm4che3.net.imageio.ImageWriterExtension;
import org.dcm4che3.util.StringUtils;
import org.dcm4chee.arc.conf.ArchiveDeviceExtension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class ArchiveDeviceProducer {
    private static final Logger LOG = LoggerFactory.getLogger(ArchiveDeviceProducer.class);
    private static final String DEF_DEVICE_NAME = "dcm4chee-arc";
    private static String[] JBOSS_PROPERITIES = new String[]{"jboss.home", "jboss.modules", "jboss.server.base", "jboss.server.config", "jboss.server.data", "jboss.server.deploy", "jboss.server.log", "jboss.server.temp"};
    @Resource(lookup="java:app/AppName")
    private String appName;
    @Inject
    private DicomConfiguration conf;
    private Device device;

    @PostConstruct
    private void init() {
        ArchiveDeviceProducer.addJBossDirURLSystemProperties();
        try {
            this.device = this.findDevice();
            this.initImageReaderFactory();
            this.initImageWriterFactory();
            this.initDICOMCharsetNameMappings();
            this.initHL7CharsetNameMappings();
            this.extractVendorData();
        }
        catch (ConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    private void extractVendorData() {
        String unzipTo;
        ArchiveDeviceExtension arcDev = (ArchiveDeviceExtension)this.device.getDeviceExtension(ArchiveDeviceExtension.class);
        String string = unzipTo = arcDev != null ? arcDev.getUnzipVendorDataToURI() : null;
        if (unzipTo == null) {
            return;
        }
        byte[][] vendorData = this.device.getVendorData();
        if (vendorData.length == 0) {
            LOG.warn("UnzipVendorDataToURI={}, but no Vendor Data", (Object)unzipTo);
            return;
        }
        Path basePath = Paths.get(URI.create(StringUtils.replaceSystemProperties((String)unzipTo)));
        ZipInputStream input = new ZipInputStream(new ByteArrayInputStream(vendorData[0]));
        try {
            ZipEntry entry;
            while ((entry = input.getNextEntry()) != null) {
                if (entry.isDirectory()) continue;
                Path filePath = basePath.resolve(entry.getName());
                Files.createDirectories(filePath.getParent(), new FileAttribute[0]);
                Files.copy(input, filePath, StandardCopyOption.REPLACE_EXISTING);
            }
        }
        catch (IOException e) {
            LOG.error("Failed to extract Device Vendor Data", (Throwable)e);
        }
        this.device.setVendorData((byte[][])new byte[0][]);
        TemplatesCache.getDefault().clear();
    }

    @Produces
    public Device getDevice() {
        return this.device;
    }

    public void reloadConfiguration() throws Exception {
        this.device.reconfigure(this.findDevice());
        this.initImageReaderFactory();
        this.initImageWriterFactory();
        this.initDICOMCharsetNameMappings();
        this.initHL7CharsetNameMappings();
        this.extractVendorData();
    }

    private Device findDevice() throws ConfigurationException {
        String key = this.appName + ".DeviceName";
        String name = System.getProperty(key, DEF_DEVICE_NAME);
        Device arcDevice = null;
        try {
            arcDevice = this.conf.findDevice(name);
        }
        catch (ConfigurationNotFoundException e) {
            LOG.error("Missing Configuration for Device '{}' - you may change the Device name by System Property '{}'", (Object)name, (Object)key);
            throw e;
        }
        return arcDevice;
    }

    private void initImageReaderFactory() {
        ImageReaderExtension ext = (ImageReaderExtension)this.device.getDeviceExtension(ImageReaderExtension.class);
        if (ext != null) {
            ImageReaderFactory.setDefault((ImageReaderFactory)ext.getImageReaderFactory());
        } else {
            ImageReaderFactory.resetDefault();
        }
    }

    private void initImageWriterFactory() {
        ImageWriterExtension ext = (ImageWriterExtension)this.device.getDeviceExtension(ImageWriterExtension.class);
        if (ext != null) {
            ImageWriterFactory.setDefault((ImageWriterFactory)ext.getImageWriterFactory());
        } else {
            ImageWriterFactory.resetDefault();
        }
        ImageWriterFactory.getImageWriter((ImageWriterFactory.ImageWriterParam)ImageWriterFactory.getImageWriterParam((String)"1.2.840.10008.1.2.4.80"));
    }

    private void initDICOMCharsetNameMappings() {
        ArchiveDeviceExtension ext = (ArchiveDeviceExtension)this.device.getDeviceExtension(ArchiveDeviceExtension.class);
        if (ext != null) {
            SpecificCharacterSet.resetCharsetNameMappings();
            ext.getDicomCharsetNameMappings().forEach(SpecificCharacterSet::setCharsetNameMapping);
        }
    }

    private void initHL7CharsetNameMappings() {
        ArchiveDeviceExtension ext = (ArchiveDeviceExtension)this.device.getDeviceExtension(ArchiveDeviceExtension.class);
        if (ext != null) {
            HL7Charset.resetCharsetNameMappings();
            ext.getHL7CharsetNameMappings().forEach(HL7Charset::setCharsetNameMapping);
        }
    }

    private static void addJBossDirURLSystemProperties() {
        for (String key : JBOSS_PROPERITIES) {
            String url = new File(System.getProperty(key + ".dir")).toURI().toString();
            System.setProperty(key + ".url", url.substring(0, url.length() - 1));
        }
    }
}

