/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.dcm4che3.data.IDWithIssuer;
import org.dcm4chee.arc.Cache;
import org.dcm4chee.arc.conf.Duration;

class HL7ExportOrPrefetchHistory {
    private final Map<String, Cache<IDWithIssuer, IDWithIssuer>> map = new ConcurrentHashMap<String, Cache<IDWithIssuer, IDWithIssuer>>();

    HL7ExportOrPrefetchHistory() {
    }

    public void clear() {
        this.map.clear();
    }

    protected boolean suppressDuplicate(String ruleName, Duration suppressInterval, int historyLength, IDWithIssuer idWithIssuer) {
        if (suppressInterval == null) {
            return false;
        }
        Cache history = this.map.computeIfAbsent(ruleName, name -> new Cache(historyLength, suppressInterval.getSeconds() * 1000L));
        if (history.getEntry(idWithIssuer) != null) {
            return true;
        }
        history.put(idWithIssuer, idWithIssuer);
        return false;
    }
}

