/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc;

import java.net.Socket;
import org.dcm4che3.net.Connection;

public class ConnectionEvent {
    private final Type type;
    private final Connection connection;
    private final Connection remoteConnection;
    private final Socket socket;
    private final Throwable exception;

    private ConnectionEvent(Type type, Connection connection, Connection remoteConnection, Socket socket, Throwable exception) {
        this.type = type;
        this.connection = connection;
        this.remoteConnection = remoteConnection;
        this.socket = socket;
        this.exception = exception;
    }

    public static ConnectionEvent onConnectionEstablished(Connection conn, Connection remoteConn, Socket s) {
        return new ConnectionEvent(Type.ESTABLISHED, conn, remoteConn, s, null);
    }

    public static ConnectionEvent onConnectionFailed(Connection conn, Connection remoteConn, Socket s, Throwable e) {
        return new ConnectionEvent(Type.FAILED, conn, remoteConn, s, e);
    }

    public static ConnectionEvent onConnectionRejectedBlacklisted(Connection conn, Socket s) {
        return new ConnectionEvent(Type.REJECTED_BLACKLISTED, conn, null, s, null);
    }

    public static ConnectionEvent onConnectionRejected(Connection conn, Socket s, Throwable e) {
        return new ConnectionEvent(Type.REJECTED, conn, null, s, e);
    }

    public static ConnectionEvent onConnectionAccepted(Connection conn, Socket s) {
        return new ConnectionEvent(Type.ACCEPTED, conn, null, s, null);
    }

    public Type getType() {
        return this.type;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public Connection getRemoteConnection() {
        return this.remoteConnection;
    }

    public Socket getSocket() {
        return this.socket;
    }

    public Throwable getException() {
        return this.exception;
    }

    public static enum Type {
        ESTABLISHED,
        FAILED,
        REJECTED,
        REJECTED_BLACKLISTED,
        ACCEPTED;

    }
}

