/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.retrieve.scu.impl;

import java.util.EnumSet;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.dcm4che3.conf.api.IApplicationEntityCache;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.VR;
import org.dcm4che3.net.ApplicationEntity;
import org.dcm4che3.net.Association;
import org.dcm4che3.net.DimseRSP;
import org.dcm4che3.net.QueryOption;
import org.dcm4che3.net.pdu.AAssociateRQ;
import org.dcm4che3.net.pdu.ExtendedNegotiation;
import org.dcm4che3.net.pdu.PresentationContext;
import org.dcm4che3.net.service.DicomServiceException;
import org.dcm4che3.net.service.RetrieveTask;
import org.dcm4chee.arc.retrieve.ExternalRetrieveContext;
import org.dcm4chee.arc.retrieve.RetrieveContext;
import org.dcm4chee.arc.retrieve.RetrieveEnd;
import org.dcm4chee.arc.retrieve.RetrieveStart;
import org.dcm4chee.arc.retrieve.scu.CMoveSCU;
import org.dcm4chee.arc.retrieve.scu.impl.ForwardRetrieveTask;
import org.dcm4chee.arc.store.scu.CStoreForwardSCU;

@ApplicationScoped
public class CMoveSCUImpl
implements CMoveSCU {
    @Inject
    private IApplicationEntityCache aeCache;
    @Inject
    private CStoreForwardSCU storeForwardSCU;
    @Inject
    private Event<ExternalRetrieveContext> instancesRetrievedEvent;
    @Inject
    @RetrieveStart
    private Event<RetrieveContext> retrieveStart;
    @Inject
    @RetrieveEnd
    private Event<RetrieveContext> retrieveEnd;

    @Override
    public RetrieveTask newForwardRetrieveTask(RetrieveContext ctx, PresentationContext pc, Attributes rq, Attributes keys, String callingAET, String otherCMoveSCP, String otherMoveDest) throws DicomServiceException {
        try {
            Association fwdas = this.openAssociation(ctx, pc, callingAET, otherCMoveSCP);
            if (otherMoveDest == null) {
                ctx.setForwardAssociation(fwdas);
                return new ForwardRetrieveTask.BackwardCMoveRSP(ctx, pc, rq, keys, fwdas, this.instancesRetrievedEvent);
            }
            ctx.setFallbackAssociation(fwdas);
            rq.setString(1536, VR.AE, otherMoveDest);
            String cMoveSCPorCallingAET = CMoveSCUImpl.bindByCMoveSCP(ctx, otherCMoveSCP) ? otherCMoveSCP : callingAET;
            this.storeForwardSCU.addRetrieveContext(ctx, cMoveSCPorCallingAET);
            fwdas.addAssociationListener(as -> this.storeForwardSCU.removeRetrieveContext(ctx, cMoveSCPorCallingAET));
            return new ForwardRetrieveTask.ForwardCStoreRQ(ctx, pc, rq, keys, fwdas, this.instancesRetrievedEvent, this.retrieveStart, this.retrieveEnd);
        }
        catch (Exception e) {
            throw new DicomServiceException(42754, (Throwable)e);
        }
    }

    private static boolean bindByCMoveSCP(RetrieveContext ctx, String cMoveSCP) {
        return ctx.getArchiveAEExtension().getArchiveDeviceExtension().getCStoreSCUOfCMoveSCPs().values().contains(cMoveSCP);
    }

    @Override
    public void forwardMoveRQ(RetrieveContext ctx, PresentationContext pc, Attributes rq, Attributes keys, String callingAET, String otherCMoveSCP, String otherMoveDest) throws DicomServiceException {
        try {
            Association fwdas = this.openAssociation(ctx, pc, callingAET, otherCMoveSCP);
            if (otherMoveDest == null) {
                ctx.setForwardAssociation(fwdas);
                new ForwardRetrieveTask.UpdateRetrieveCtx(ctx, pc, rq, keys, fwdas, this.instancesRetrievedEvent).forwardMoveRQ();
            } else {
                ctx.setFallbackAssociation(fwdas);
                rq.setString(1536, VR.AE, otherMoveDest);
                String cMoveSCPorCallingAET = CMoveSCUImpl.bindByCMoveSCP(ctx, otherCMoveSCP) ? otherCMoveSCP : callingAET;
                this.storeForwardSCU.addRetrieveContext(ctx, cMoveSCPorCallingAET);
                fwdas.addAssociationListener(as -> this.storeForwardSCU.removeRetrieveContext(ctx, cMoveSCPorCallingAET));
                new ForwardRetrieveTask.ForwardCStoreRQ(ctx, pc, rq, keys, fwdas, this.instancesRetrievedEvent, this.retrieveStart, this.retrieveEnd).forwardMoveRQ();
            }
        }
        catch (Exception e) {
            throw new DicomServiceException(42754, (Throwable)e);
        }
    }

    @Override
    public Association openAssociation(ApplicationEntity localAE, String calledAET) throws Exception {
        return localAE.connect(this.aeCache.get(calledAET), this.createAARQ());
    }

    private AAssociateRQ createAARQ() {
        AAssociateRQ aarq = new AAssociateRQ();
        aarq.addPresentationContext(new PresentationContext(1, "1.2.840.10008.5.1.4.1.2.2.2", new String[]{"1.2.840.10008.1.2"}));
        return aarq;
    }

    @Override
    public DimseRSP cmove(Association as, int priority, String destAET, Attributes keys) throws Exception {
        return as.cmove("1.2.840.10008.5.1.4.1.2.2.2", priority, keys, "1.2.840.10008.1.2", destAET);
    }

    private Association openAssociation(RetrieveContext ctx, PresentationContext pc, String callingAET, String otherCMoveSCP) throws Exception {
        ApplicationEntity remoteAE = this.aeCache.findApplicationEntity(otherCMoveSCP);
        Association as = ctx.getRequestAssociation();
        PresentationContext rqpc = as.getAAssociateRQ().getPresentationContext(pc.getPCID());
        AAssociateRQ aarq = new AAssociateRQ();
        if (callingAET != null) {
            aarq.setCallingAET(callingAET);
        }
        aarq.addPresentationContext(rqpc);
        aarq.addExtendedNegotiation(new ExtendedNegotiation(rqpc.getAbstractSyntax(), QueryOption.toExtendedNegotiationInformation(EnumSet.of(QueryOption.RELATIONAL))));
        Association fwdas = ctx.getLocalApplicationEntity().connect(remoteAE, aarq);
        fwdas.setProperty("forward-C-MOVE-RQ-for-Study", (Object)ctx.getStudyInstanceUID());
        return fwdas;
    }
}

