/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.retrieve.scp;

import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.inject.Inject;
import org.dcm4che3.conf.api.ConfigurationException;
import org.dcm4che3.conf.api.ConfigurationNotFoundException;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.net.Association;
import org.dcm4che3.net.QueryOption;
import org.dcm4che3.net.pdu.PresentationContext;
import org.dcm4che3.net.service.BasicCMoveSCP;
import org.dcm4che3.net.service.DicomServiceException;
import org.dcm4che3.net.service.QueryRetrieveLevel2;
import org.dcm4che3.net.service.RetrieveTask;
import org.dcm4chee.arc.conf.ArchiveAEExtension;
import org.dcm4chee.arc.entity.Completeness;
import org.dcm4chee.arc.retrieve.RetrieveContext;
import org.dcm4chee.arc.retrieve.RetrieveService;
import org.dcm4chee.arc.retrieve.SeriesInfo;
import org.dcm4chee.arc.retrieve.StudyInfo;
import org.dcm4chee.arc.retrieve.scu.CMoveSCU;
import org.dcm4chee.arc.store.scu.CStoreSCU;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CommonCMoveSCP
extends BasicCMoveSCP {
    private static final Logger LOG = LoggerFactory.getLogger(CommonCMoveSCP.class);
    private final EnumSet<QueryRetrieveLevel2> qrLevels;
    @Inject
    private RetrieveService retrieveService;
    @Inject
    private CStoreSCU storeSCU;
    @Inject
    private CMoveSCU moveSCU;

    public CommonCMoveSCP(String sopClass, EnumSet<QueryRetrieveLevel2> qrLevels) {
        super(new String[]{sopClass});
        this.qrLevels = qrLevels;
    }

    protected RetrieveTask calculateMatches(Association as, PresentationContext pc, Attributes rq, Attributes keys) throws DicomServiceException {
        LOG.info("{}: Process C-MOVE RQ:\n{}", (Object)as, (Object)keys);
        EnumSet queryOpts = as.getQueryOptionsFor(rq.getString(2));
        QueryRetrieveLevel2 qrLevel = QueryRetrieveLevel2.validateRetrieveIdentifier((Attributes)keys, this.qrLevels, (boolean)queryOpts.contains(QueryOption.RELATIONAL), (boolean)CommonCMoveSCP.relationalRetrieveNegotiationLenient(as));
        ArchiveAEExtension arcAE = (ArchiveAEExtension)as.getApplicationEntity().getAEExtension(ArchiveAEExtension.class);
        if (!arcAE.isAcceptedMoveDestination(rq.getString(1536))) {
            throw new DicomServiceException(51201, "Move Destination not allowed");
        }
        RetrieveContext ctx = this.newRetrieveContext(arcAE, as, rq, qrLevel, keys);
        String fallbackCMoveSCP = arcAE.fallbackCMoveSCP();
        String fallbackCMoveSCPCallingAET = arcAE.fallbackCMoveSCPCallingAET(as);
        String fallbackCMoveSCPDestination = arcAE.fallbackCMoveSCPDestination();
        if (!this.retrieveService.calculateMatches(ctx)) {
            if (fallbackCMoveSCP == null) {
                return null;
            }
            ctx.setRetryFailedRetrieve(true);
            LOG.info("{}: No objects of study{} found - forward C-MOVE RQ to {}", new Object[]{as, Arrays.toString(ctx.getStudyInstanceUIDs()), fallbackCMoveSCP});
            return this.moveSCU.newForwardRetrieveTask(ctx, pc, rq, keys, fallbackCMoveSCPCallingAET, fallbackCMoveSCP, fallbackCMoveSCPDestination);
        }
        if (!this.retrieveService.restrictRetrieveAccordingTransferCapabilities(ctx)) {
            if (ctx.failed() > 0) {
                throw new DicomServiceException(42754).setNumberOfCompletedFailedWarningSuboperations(ctx.completed(), ctx.failed(), ctx.warning());
            }
            return null;
        }
        Map notAccessable = this.retrieveService.removeNotAccessableMatches(ctx);
        String altCMoveSCP = arcAE.alternativeCMoveSCP();
        if (ctx.getMoveOriginatorAETitle().equals(altCMoveSCP)) {
            ctx.setMoveOriginatorAETitle(ctx.getDestinationAETitle());
            ctx.setNumberOfMatches(ctx.getMatches().size());
        } else {
            boolean retryFailedRetrieve = fallbackCMoveSCP != null && fallbackCMoveSCPDestination != null && this.retryFailedRetrieve(ctx, qrLevel);
            Collection notRetrieveable = (Collection)notAccessable.remove(null);
            Iterator notAccessableIter = notAccessable.entrySet().iterator();
            if (notAccessableIter.hasNext()) {
                String otherMoveDest;
                Map.Entry notAccessableNext = notAccessableIter.next();
                String otherCMoveSCP = (String)notAccessableNext.getKey();
                String string = otherMoveDest = otherCMoveSCP.equals(altCMoveSCP) ? null : arcAE.externalRetrieveAEDestination();
                while (notAccessableIter.hasNext()) {
                    LOG.info("{}: {} objects of study{} not locally accessable - send C-MOVE RQ to {}", new Object[]{as, ((Collection)notAccessableNext.getValue()).size(), Arrays.toString(ctx.getStudyInstanceUIDs()), otherCMoveSCP});
                    this.moveSCU.forwardMoveRQ(ctx, pc, rq, keys, as.getCallingAET(), otherCMoveSCP, otherMoveDest);
                    notAccessableNext = notAccessableIter.next();
                    otherCMoveSCP = (String)notAccessableNext.getKey();
                    otherMoveDest = otherCMoveSCP.equals(altCMoveSCP) ? null : arcAE.externalRetrieveAEDestination();
                }
                LOG.info("{}: {} objects of study{} not locally accessable - send C-MOVE RQ to {}", new Object[]{as, ((Collection)notAccessableNext.getValue()).size(), Arrays.toString(ctx.getStudyInstanceUIDs()), otherCMoveSCP});
                if (!retryFailedRetrieve && ctx.getMatches().isEmpty()) {
                    return this.moveSCU.newForwardRetrieveTask(ctx, pc, rq, keys, as.getCallingAET(), otherCMoveSCP, otherMoveDest);
                }
                this.moveSCU.forwardMoveRQ(ctx, pc, rq, keys, null, otherCMoveSCP, otherMoveDest);
            }
            if (retryFailedRetrieve) {
                ctx.setRetryFailedRetrieve(true);
                LOG.info("{}: Some objects of study{} not found - retry forward C-MOVE RQ to {}", new Object[]{as, Arrays.toString(ctx.getStudyInstanceUIDs()), fallbackCMoveSCP});
                if (ctx.getMatches().isEmpty()) {
                    return this.moveSCU.newForwardRetrieveTask(ctx, pc, rq, keys, fallbackCMoveSCPCallingAET, fallbackCMoveSCP, fallbackCMoveSCPDestination);
                }
                this.moveSCU.forwardMoveRQ(ctx, pc, rq, keys, fallbackCMoveSCPCallingAET, fallbackCMoveSCP, fallbackCMoveSCPDestination);
            }
        }
        return this.storeSCU.newRetrieveTaskMOVE(as, pc, rq, ctx);
    }

    private static boolean relationalRetrieveNegotiationLenient(Association as) {
        ArchiveAEExtension arcAE = (ArchiveAEExtension)as.getApplicationEntity().getAEExtension(ArchiveAEExtension.class);
        return arcAE != null && arcAE.relationalRetrieveNegotiationLenient();
    }

    private RetrieveContext newRetrieveContext(ArchiveAEExtension arcAE, Association as, Attributes rq, QueryRetrieveLevel2 qrLevel, Attributes keys) throws DicomServiceException {
        try {
            return this.retrieveService.newRetrieveContextMOVE(arcAE, as, rq, qrLevel, keys);
        }
        catch (ConfigurationNotFoundException e) {
            throw new DicomServiceException(43009, e.getMessage());
        }
        catch (ConfigurationException e) {
            throw new DicomServiceException(42754, (Throwable)e);
        }
    }

    private boolean retryFailedRetrieve(RetrieveContext ctx, QueryRetrieveLevel2 qrLevel) {
        HashSet<String> uids = new HashSet<String>();
        ArchiveAEExtension arcae = ctx.getArchiveAEExtension();
        int maxRetrieveRetries = arcae.fallbackCMoveSCPRetries();
        switch (qrLevel) {
            case STUDY: {
                uids.addAll(Arrays.asList(ctx.getStudyInstanceUIDs()));
                for (StudyInfo studyInfo : ctx.getStudyInfos()) {
                    if (studyInfo.getCompleteness() != Completeness.COMPLETE) {
                        if (maxRetrieveRetries == 0 || studyInfo.getFailedRetrieves() < maxRetrieveRetries) {
                            return true;
                        }
                        LOG.warn("{}: Maximal number of retries[{}] to retrieve objects of study[{}] from {} exceeded", new Object[]{ctx.getRequestAssociation(), maxRetrieveRetries, studyInfo.getStudyInstanceUID(), arcae.fallbackCMoveSCP()});
                    }
                    uids.remove(studyInfo.getStudyInstanceUID());
                }
            }
            case SERIES: {
                uids.addAll(Arrays.asList(ctx.getSeriesInstanceUIDs()));
                for (SeriesInfo seriesInfo : ctx.getSeriesInfos()) {
                    if (seriesInfo.getCompleteness() != Completeness.COMPLETE) {
                        if (maxRetrieveRetries == 0 || seriesInfo.getFailedRetrieves() < maxRetrieveRetries) {
                            return true;
                        }
                        LOG.warn("{}: Maximal number of retries[{}] to retrieve objects of series[{}] from {} exceeded", new Object[]{ctx.getRequestAssociation(), maxRetrieveRetries, seriesInfo.getSeriesInstanceUID(), arcae.fallbackCMoveSCP()});
                    }
                    uids.remove(seriesInfo.getSeriesInstanceUID());
                }
                break;
            }
        }
        return !uids.isEmpty();
    }
}

