/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.retrieve.scp;

import java.util.EnumSet;
import javax.inject.Inject;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.net.Association;
import org.dcm4che3.net.QueryOption;
import org.dcm4che3.net.pdu.PresentationContext;
import org.dcm4che3.net.service.BasicCGetSCP;
import org.dcm4che3.net.service.DicomServiceException;
import org.dcm4che3.net.service.QueryRetrieveLevel2;
import org.dcm4che3.net.service.RetrieveTask;
import org.dcm4chee.arc.conf.ArchiveAEExtension;
import org.dcm4chee.arc.retrieve.RetrieveContext;
import org.dcm4chee.arc.retrieve.RetrieveService;
import org.dcm4chee.arc.store.scu.CStoreSCU;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CommonCGetSCP
extends BasicCGetSCP {
    private static final Logger LOG = LoggerFactory.getLogger(CommonCGetSCP.class);
    private final EnumSet<QueryRetrieveLevel2> qrLevels;
    @Inject
    private RetrieveService retrieveService;
    @Inject
    private CStoreSCU storeSCU;

    public CommonCGetSCP(String sopClass, EnumSet<QueryRetrieveLevel2> qrLevels) {
        super(new String[]{sopClass});
        this.qrLevels = qrLevels;
    }

    protected RetrieveTask calculateMatches(Association as, PresentationContext pc, Attributes rq, Attributes keys) throws DicomServiceException {
        LOG.info("{}: Process C-GET RQ:\n{}", (Object)as, (Object)keys);
        EnumSet queryOpts = as.getQueryOptionsFor(rq.getString(2));
        QueryRetrieveLevel2 qrLevel = QueryRetrieveLevel2.validateRetrieveIdentifier((Attributes)keys, this.qrLevels, (boolean)queryOpts.contains(QueryOption.RELATIONAL), (boolean)CommonCGetSCP.relationalRetrieveNegotiationLenient(as));
        ArchiveAEExtension arcAE = (ArchiveAEExtension)as.getApplicationEntity().getAEExtension(ArchiveAEExtension.class);
        RetrieveContext ctx = this.retrieveService.newRetrieveContextGET(arcAE, as, rq, qrLevel, keys);
        if (!this.retrieveService.calculateMatches(ctx)) {
            return null;
        }
        return this.storeSCU.newRetrieveTaskGET(as, pc, rq, ctx);
    }

    private static boolean relationalRetrieveNegotiationLenient(Association as) {
        ArchiveAEExtension arcAE = (ArchiveAEExtension)as.getApplicationEntity().getAEExtension(ArchiveAEExtension.class);
        return arcAE != null && arcAE.relationalRetrieveNegotiationLenient();
    }
}

