/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.query.util;

import java.util.Arrays;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.util.ByteUtils;
import org.dcm4chee.arc.conf.AttributesBuilder;
import org.dcm4chee.arc.query.util.QueryAttributes;

public enum QIDO {
    PATIENT(ByteUtils.EMPTY_INTS, 0x100010, 0x100020, 0x100030, 0x100040),
    STUDY(new int[]{0x20000D}, 524320, 524336, 524368, 524385, 524432, 0x100010, 0x100020, 0x100030, 0x100040, 0x200010, 0x20000D, 2101766, 2101768),
    SERIES(new int[]{0x20000E}, 524384, 528446, 0x200011, 0x20000E, 2101769, 0x400244, 4194885, 4194933),
    INSTANCE(new int[]{524312}, 524310, 524312, 536578, 2097171, 2621456, 2621457, 2621696, 0x280008),
    MWL(ByteUtils.EMPTY_INTS, new int[]{524368, 524432, 528656, 528672, 0x100010, 0x100020, 0x100021, 1048612, 0x100030, 0x100040, 0x101002, 0x101030, 0x102000, 0x102110, 1057216, 0x20000D, 3280946, 3280992, 3280996, 3670032, 3670096, 0x380300, 3671296, 0x400100, 0x401001, 4198403, 0x401004, 4206593, 7606786}){

        @Override
        public void addReturnTags(QueryAttributes queryAttributes) {
            queryAttributes.addReturnTags(this.includetags);
            Attributes spsKeys = queryAttributes.getQueryKeys().getNestedDataset(0x400100);
            if (spsKeys != null && !spsKeys.isEmpty()) {
                AttributesBuilder.setNullIfAbsent((Attributes)spsKeys, (int[])1.MWL_SPS.includetags);
            }
        }
    }
    ,
    MPPS(new int[]{524312}, 524310, 524312, 524384, 528434, 0x100010, 0x100020, 0x100021, 1048612, 0x100030, 0x100040, 0x101002, 0x200010, 4194881, 0x400242, 4194883, 0x400244, 4194885, 4194896, 4194897, 4194898, 4194899, 4194900, 4194901, 4194912, 4194928, 0x400340),
    UPS(new int[]{524312}, 524310, 524312, 528512, 528516, 0x100010, 0x100020, 0x100021, 1048612, 0x100030, 0x100040, 0x101002, 0x102000, 0x102110, 1057216, 0x20000D, 3670032, 3670036, 3670096, 0x404005, 4210712, 4210721, 4210725, 4210726, 4210727, 0x404034, 0x404041, 4236144, 7606272, 7606274, 7606784, 7606786, 7606788, 7606800, 7606806),
    STUDY_SERIES(new int[]{0x20000D, 0x20000E}, QIDO.catAndSort(QIDO.STUDY.includetags, QIDO.SERIES.includetags)),
    STUDY_SERIES_INSTANCE(new int[]{524312, 0x20000D, 0x20000E}, QIDO.catAndSort(QIDO.STUDY.includetags, QIDO.SERIES.includetags, QIDO.INSTANCE.includetags)),
    SERIES_INSTANCE(new int[]{524312, 0x20000E}, QIDO.catAndSort(QIDO.SERIES.includetags, QIDO.INSTANCE.includetags)),
    MWL_SPS(ByteUtils.EMPTY_INTS, 524384, 0x102210, 3281008, 0x400001, 0x400002, 0x400003, 0x400006, 0x400007, 0x400008, 0x400009, 0x400020, 0x400010, 0x400011, 4194322);

    public final int[] uids;
    public final int[] includetags;

    private QIDO(int[] uids, int ... includetags) {
        this.uids = uids;
        this.includetags = includetags;
    }

    private static int[] catAndSort(int[] ... srcs) {
        int totlen = 0;
        for (int[] src : srcs) {
            totlen += src.length;
        }
        int[] dest = new int[totlen];
        int off = 0;
        for (int[] src : srcs) {
            System.arraycopy(src, 0, dest, off, src.length);
            off += src.length;
        }
        Arrays.sort(dest);
        return dest;
    }

    public void addReturnTags(QueryAttributes queryAttributes) {
        queryAttributes.addReturnTags(this.includetags);
    }
}

