/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.query.util;

import java.util.Date;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.Code;
import org.dcm4che3.data.Sequence;
import org.dcm4che3.data.VR;
import org.dcm4che3.util.UIDUtils;

public class KOSBuilder {
    private final Attributes attrs = new Attributes(30);

    public KOSBuilder(Code conceptNameCode, int seriesNumber, int instanceNumber) {
        this.attrs.setString(524310, VR.UI, "1.2.840.10008.5.1.4.1.1.88.59");
        this.attrs.setString(524312, VR.UI, UIDUtils.createUID());
        this.attrs.setDate(2251950138064947L, new Date[]{new Date()});
        this.attrs.setString(524384, VR.CS, "KO");
        this.attrs.setNull(528657, VR.SQ);
        this.attrs.setString(0x20000E, VR.UI, UIDUtils.createUID());
        this.attrs.setInt(0x200011, VR.IS, new int[]{seriesNumber});
        this.attrs.setInt(2097171, VR.IS, new int[]{instanceNumber});
        this.attrs.setString(0x40A040, VR.CS, "CONTAINER");
        this.attrs.setString(4235344, VR.CS, "SEPARATE");
        this.attrs.newSequence(4235331, 1).add(conceptNameCode.toItem());
        this.attrs.newSequence(4236548, 1).add(this.templateIdentifier());
        this.attrs.newSequence(4236149, 1);
        this.attrs.newSequence(4237104, 1);
    }

    public Attributes getAttributes() {
        return this.attrs;
    }

    public KOSBuilder addInstanceRef(Attributes inst) {
        Sequence contentSeq = this.attrs.getSequence(4237104);
        if (contentSeq.isEmpty()) {
            this.attrs.addSelected(inst, new int[]{524293, 524320, 524336, 524368, 524369, 0x100010, 0x100020, 0x100021, 0x100030, 0x100040, 0x20000D, 0x200010});
        }
        String cuid = inst.getString(524310);
        String iuid = inst.getString(524312);
        this.refSeries(inst.getString(0x20000D), inst.getString(0x20000E)).getSequence(528793).add(this.refSOP(cuid, iuid));
        contentSeq.add(this.contentItem(this.typeOf(cuid), this.refSOP(cuid, iuid)));
        return this;
    }

    private Attributes refSeries(String studyIUID, String seriesIUID) {
        Sequence refSeriess = this.refStudy(studyIUID).getSequence(528661);
        for (Attributes refSeries : refSeriess) {
            if (!seriesIUID.equals(refSeries.getString(0x20000E))) continue;
            return refSeries;
        }
        Attributes refSeries = new Attributes(2);
        refSeries.newSequence(528793, 100);
        refSeries.setString(0x20000E, VR.UI, seriesIUID);
        refSeriess.add(refSeries);
        return refSeries;
    }

    private Attributes refStudy(String studyIUID) {
        Sequence refStudies = this.attrs.getSequence(4236149);
        for (Attributes refStudy : refStudies) {
            if (!studyIUID.equals(refStudy.getString(0x20000D))) continue;
            return refStudy;
        }
        Attributes refStudy = new Attributes(2);
        refStudy.newSequence(528661, 10);
        refStudy.setString(0x20000D, VR.UI, studyIUID);
        refStudies.add(refStudy);
        return refStudy;
    }

    private String typeOf(String cuid) {
        return "COMPOSITE";
    }

    private Attributes templateIdentifier() {
        Attributes attrs = new Attributes(2);
        attrs.setString(524549, VR.CS, "DCMR");
        attrs.setString(4250368, VR.CS, "2010");
        return attrs;
    }

    private Attributes contentItem(String valueType, Attributes refSOP) {
        Attributes item = new Attributes(3);
        item.setString(4235280, VR.CS, "CONTAINS");
        item.setString(0x40A040, VR.CS, valueType);
        item.newSequence(528793, 1).add(refSOP);
        return item;
    }

    private Attributes refSOP(String cuid, String iuid) {
        Attributes item = new Attributes(2);
        item.setString(528720, VR.UI, cuid);
        item.setString(528725, VR.UI, iuid);
        return item;
    }
}

