/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.query.scu.impl;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.xml.transform.Templates;
import javax.xml.transform.TransformerConfigurationException;
import org.dcm4che3.conf.api.IApplicationEntityCache;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.AttributesCoercion;
import org.dcm4che3.data.DateRange;
import org.dcm4che3.data.ElementDictionary;
import org.dcm4che3.data.IDWithIssuer;
import org.dcm4che3.data.NullifyAttributesCoercion;
import org.dcm4che3.data.TrimISO2020CharacterSetAttributesCoercion;
import org.dcm4che3.data.VR;
import org.dcm4che3.data.Value;
import org.dcm4che3.io.SAXTransformer;
import org.dcm4che3.io.TemplatesCache;
import org.dcm4che3.io.XSLTAttributesCoercion;
import org.dcm4che3.net.ApplicationEntity;
import org.dcm4che3.net.Association;
import org.dcm4che3.net.Device;
import org.dcm4che3.net.Dimse;
import org.dcm4che3.net.DimseRSP;
import org.dcm4che3.net.QueryOption;
import org.dcm4che3.net.TransferCapability;
import org.dcm4che3.net.pdu.AAssociateRQ;
import org.dcm4che3.net.pdu.ExtendedNegotiation;
import org.dcm4che3.net.pdu.PresentationContext;
import org.dcm4che3.net.service.DicomServiceException;
import org.dcm4che3.util.StringUtils;
import org.dcm4chee.arc.MergeMWLQueryParam;
import org.dcm4chee.arc.coerce.CoercionFactory;
import org.dcm4chee.arc.conf.ArchiveAEExtension;
import org.dcm4chee.arc.conf.ArchiveAttributeCoercion;
import org.dcm4chee.arc.conf.ArchiveAttributeCoercion2;
import org.dcm4chee.arc.conf.AttributesBuilder;
import org.dcm4chee.arc.conf.Duration;
import org.dcm4chee.arc.conf.UseCallingAETitleAsCoercion;
import org.dcm4chee.arc.mima.SupplementAssigningAuthorities;
import org.dcm4chee.arc.query.scu.CFindSCU;
import org.dcm4chee.arc.query.scu.impl.SplitQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class CFindSCUImpl
implements CFindSCU {
    private static final Logger LOG = LoggerFactory.getLogger(CFindSCUImpl.class);
    private static final ElementDictionary DICT = ElementDictionary.getStandardElementDictionary();
    private static final int PCID = 1;
    @Inject
    private IApplicationEntityCache aeCache;
    @Inject
    private CoercionFactory coercionFactory;
    private static Attributes.Visitor nullifyTM = new Attributes.Visitor(){

        public boolean visit(Attributes attrs, int tag, VR vr, Object value) throws Exception {
            if (vr == VR.TM && value != Value.NULL) {
                attrs.setNull(tag, VR.TM);
            }
            return true;
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Attributes> findPatient(ApplicationEntity localAE, String calledAET, int priority, IDWithIssuer pid, int ... returnKeys) throws Exception {
        Association as = this.openAssociation(localAE, calledAET, "1.2.840.10008.5.1.4.1.2.1.1", CFindSCUImpl.queryOptions(false));
        try {
            List<Attributes> list = this.findPatient(as, priority, pid, returnKeys);
            return list;
        }
        finally {
            as.waitForOutstandingRSP();
            as.release();
        }
    }

    @Override
    public List<Attributes> findPatient(Association as, int priority, IDWithIssuer pid, int ... returnKeys) throws Exception {
        return this.find(as, priority, pid.exportPatientIDWithIssuer(CFindSCUImpl.withQueryLevelAndReturnKeys("PATIENT", returnKeys, new Attributes(3 + returnKeys.length))));
    }

    @Override
    public List<Attributes> findStudiesOfPatient(ApplicationEntity localAE, String calledAET, int priority, IDWithIssuer pid, int ... returnKeys) throws Exception {
        return this.find(localAE, calledAET, CFindSCUImpl.queryOptions(false), priority, pid.exportPatientIDWithIssuer(CFindSCUImpl.withQueryLevelAndReturnKeys("STUDY", returnKeys, new Attributes(3 + returnKeys.length))));
    }

    @Override
    public List<Attributes> find(ApplicationEntity localAE, String calledAET, EnumSet<QueryOption> queryOptions, int priority, Attributes keys) throws Exception {
        return this.find(localAE, calledAET, "1.2.840.10008.5.1.4.1.2.2.1", queryOptions, priority, keys);
    }

    @Override
    public List<Attributes> findMWLItems(ApplicationEntity localAE, MergeMWLQueryParam queryParam, int priority) throws Exception {
        Attributes keys = new Attributes();
        AttributesBuilder.setNullIfAbsent((Attributes)keys, (int[])new int[]{524368, 524369, 528656, 524432, 0x100010, 0x100020, 0x100021, 1048612, 0x100030, 0x100040, 0x101020, 0x101030, 0x101040, 1057283, 0x20000D, 3280945, 3280946, 3280947, 3280948, 3280992, 3280996, 3670032, 3670036, 0x400100, 0x401001, 4198402, 4198410});
        queryParam.setMatchingKeys(keys);
        return this.findMWLItems(localAE, queryParam.mwlSCP, EnumSet.noneOf(QueryOption.class), priority, keys);
    }

    @Override
    public List<Attributes> findMWLItems(ApplicationEntity localAE, String calledAET, EnumSet<QueryOption> queryOptions, int priority, Attributes keys) throws Exception {
        return this.find(localAE, calledAET, "1.2.840.10008.5.1.4.31", queryOptions, priority, keys);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Attributes> find(ApplicationEntity localAE, String calledAET, String cuid, EnumSet<QueryOption> queryOptions, int priority, Attributes keys) throws Exception {
        Association as = this.openAssociation(localAE, calledAET, cuid, queryOptions);
        try {
            List<Attributes> list = this.find(as, priority, keys);
            return list;
        }
        finally {
            as.waitForOutstandingRSP();
            as.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Attributes> findStudy(ApplicationEntity localAE, String calledAET, int priority, String studyIUID, int ... returnKeys) throws Exception {
        Association as = this.openAssociation(localAE, calledAET, "1.2.840.10008.5.1.4.1.2.2.1", CFindSCUImpl.queryOptions(false));
        try {
            List<Attributes> list = this.findStudy(as, priority, studyIUID, returnKeys);
            return list;
        }
        finally {
            as.waitForOutstandingRSP();
            as.release();
        }
    }

    @Override
    public List<Attributes> findStudiesByAccessionNumber(ApplicationEntity localAE, String calledAET, int priority, String accNo, int ... returnKeys) throws Exception {
        Attributes keys = CFindSCUImpl.withQueryLevelAndReturnKeys("STUDY", returnKeys, new Attributes(2 + returnKeys.length));
        keys.setString(524368, VR.SH, accNo);
        return this.find(localAE, calledAET, CFindSCUImpl.queryOptions(false), priority, keys);
    }

    @Override
    public List<Attributes> findStudy(Association as, int priority, String studyIUID, int ... returnKeys) throws Exception {
        return this.find(as, priority, CFindSCUImpl.withUID(0x20000D, studyIUID, CFindSCUImpl.withQueryLevelAndReturnKeys("STUDY", returnKeys, new Attributes(2 + returnKeys.length))));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Attributes> findSeries(ApplicationEntity localAE, String calledAET, int priority, String studyIUID, String seriesIUID, int ... returnKeys) throws Exception {
        Association as = this.openAssociation(localAE, calledAET, "1.2.840.10008.5.1.4.1.2.2.1", CFindSCUImpl.queryOptions(studyIUID == null));
        try {
            List<Attributes> list = this.findSeries(as, priority, studyIUID, seriesIUID, returnKeys);
            return list;
        }
        finally {
            as.waitForOutstandingRSP();
            as.release();
        }
    }

    @Override
    public List<Attributes> findSeries(Association as, int priority, String studyIUID, String seriesIUID, int ... returnKeys) throws Exception {
        return this.find(as, priority, CFindSCUImpl.withUID(0x20000E, seriesIUID, CFindSCUImpl.withUID(0x20000D, studyIUID, CFindSCUImpl.withQueryLevelAndReturnKeys("SERIES", returnKeys, new Attributes(3 + returnKeys.length)))));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Attributes> findInstance(ApplicationEntity localAE, String calledAET, int priority, String studyIUID, String seriesIUID, String sopIUID, int ... returnKeys) throws Exception {
        Association as = this.openAssociation(localAE, calledAET, "1.2.840.10008.5.1.4.1.2.2.1", CFindSCUImpl.queryOptions(studyIUID == null || seriesIUID == null));
        try {
            List<Attributes> list = this.findInstance(as, priority, studyIUID, seriesIUID, sopIUID, returnKeys);
            return list;
        }
        finally {
            as.waitForOutstandingRSP();
            as.release();
        }
    }

    @Override
    public List<Attributes> findInstance(Association as, int priority, String studyIUID, String seriesIUID, String sopIUID, int ... returnKeys) throws Exception {
        return this.find(as, priority, CFindSCUImpl.withUID(524312, sopIUID, CFindSCUImpl.withUID(0x20000E, seriesIUID, CFindSCUImpl.withUID(0x20000D, studyIUID, CFindSCUImpl.withQueryLevelAndReturnKeys("IMAGE", returnKeys, new Attributes(4 + returnKeys.length))))));
    }

    @Override
    public Association openAssociation(ApplicationEntity localAE, String calledAET, String cuid, EnumSet<QueryOption> queryOptions) throws Exception {
        return localAE.connect(this.aeCache.findApplicationEntity(calledAET), CFindSCUImpl.createAARQ(cuid, queryOptions));
    }

    @Override
    public DimseRSP query(Association as, int priority, Attributes keys, int autoCancel, int capacity, Duration splitStudyDateRange) throws Exception {
        DateRange dateRange;
        String cuid = CFindSCUImpl.getAbstractSyntax(as);
        if (as.getRequestedQueryOptionsFor(cuid).contains(QueryOption.DATETIME) && !as.getQueryOptionsFor(cuid).contains(QueryOption.DATETIME)) {
            keys.accept(nullifyTM, true);
        }
        if (splitStudyDateRange != null && !keys.containsValue(0x20000D) && !keys.containsValue(524336) && (dateRange = keys.getDateRange(524320)) != null && dateRange.getStartDate() != null) {
            long endDate;
            long startDate = dateRange.getStartDate().getTime();
            long l = endDate = dateRange.getEndDate() != null ? dateRange.getEndDate().getTime() : System.currentTimeMillis();
            if (endDate - startDate > splitStudyDateRange.getSeconds() * 1000L) {
                return new SplitQuery(as, cuid, priority, keys, autoCancel, capacity, startDate, endDate, splitStudyDateRange);
            }
        }
        return as.cfind(cuid, priority, keys, "1.2.840.10008.1.2", autoCancel, capacity);
    }

    private static String getAbstractSyntax(Association as) {
        return as.getAAssociateRQ().getPresentationContext(1).getAbstractSyntax();
    }

    private List<Attributes> find(Association as, int priority, Attributes keys) throws Exception {
        ArrayList<Attributes> list = new ArrayList<Attributes>();
        DimseRSP rsp = this.query(as, priority, this.coerceCFindRQ(as, keys), 0, 1, null);
        rsp.next();
        Attributes match = rsp.getDataset();
        String defaultCharacterSet = ((ArchiveAEExtension)as.getApplicationEntity().getAEExtensionNotNull(ArchiveAEExtension.class)).defaultCharacterSet();
        while (rsp.next()) {
            if (defaultCharacterSet != null && !match.containsValue(524293)) {
                LOG.info("{}: No Specific Character Set (0008,0005) in received C-FIND RSP - supplement configured Default Character Set: {}", (Object)as, (Object)defaultCharacterSet);
                match.setString(524293, VR.CS, defaultCharacterSet);
            }
            list.add(this.coerceCFindRSP(as, match));
            match = rsp.getDataset();
        }
        Attributes cmd = rsp.getCommand();
        int status = cmd.getInt(2304, -1);
        if (status != 0) {
            throw new DicomServiceException(status, cmd.getString(2306));
        }
        return list;
    }

    private static EnumSet<QueryOption> queryOptions(boolean relational) {
        EnumSet<QueryOption> queryOptions = EnumSet.noneOf(QueryOption.class);
        if (relational) {
            queryOptions.add(QueryOption.RELATIONAL);
        }
        return queryOptions;
    }

    private static Attributes withQueryLevelAndReturnKeys(String level, int[] returnKeys, Attributes keys) {
        keys.setString(524370, VR.CS, level);
        for (int tag : returnKeys) {
            keys.setNull(tag, DICT.vrOf(tag));
        }
        return keys;
    }

    private static Attributes withUID(int tag, String value, Attributes keys) {
        if (value != null) {
            keys.setString(tag, VR.UI, value);
        }
        return keys;
    }

    private static AAssociateRQ createAARQ(String cuid, EnumSet<QueryOption> queryOptions) {
        AAssociateRQ aarq = new AAssociateRQ();
        aarq.addPresentationContext(new PresentationContext(1, cuid, new String[]{"1.2.840.10008.1.2"}));
        if (queryOptions != null) {
            aarq.addExtendedNegotiation(new ExtendedNegotiation(cuid, QueryOption.toExtendedNegotiationInformation(queryOptions)));
        }
        return aarq;
    }

    @Override
    public Attributes coerceCFindRQ(Association as, Attributes keys) throws Exception {
        return this.coerce(Dimse.C_FIND_RQ, as, keys);
    }

    @Override
    public Attributes coerceCFindRSP(Association as, Attributes keys) throws Exception {
        return this.coerce(Dimse.C_FIND_RSP, as, keys);
    }

    private Attributes coerce(Dimse dimse, Association as, Attributes keys) throws Exception {
        ArchiveAEExtension arcAE = (ArchiveAEExtension)as.getApplicationEntity().getAEExtension(ArchiveAEExtension.class);
        List coercions = arcAE.attributeCoercions2().filter(descriptor -> descriptor.match(TransferCapability.Role.SCP, dimse, CFindSCUImpl.getAbstractSyntax(as), as.getLocalHostName(), as.getCallingAET(), as.getRemoteHostName(), as.getCalledAET(), keys)).collect(Collectors.toList());
        if (coercions.isEmpty()) {
            ArchiveAttributeCoercion rule = arcAE.findAttributeCoercion(dimse, TransferCapability.Role.SCP, CFindSCUImpl.getAbstractSyntax(as), as.getLocalHostName(), as.getCallingAET(), as.getRemoteHostName(), as.getCalledAET(), keys);
            if (rule != null) {
                return this.coerceLegacy(as, rule, keys);
            }
        } else {
            block6: for (ArchiveAttributeCoercion2 coercion : coercions) {
                try {
                    if (!this.coercionFactory.getCoercionProcessor(coercion).coerce(coercion, CFindSCUImpl.getAbstractSyntax(as), as.getLocalHostName(), as.getCallingAET(), as.getRemoteHostName(), as.getCalledAET(), keys, null) || !coercion.isCoercionSufficient()) continue;
                }
                catch (Exception e) {
                    LOG.info("Failed to apply {}:\n", (Object)coercion, (Object)e);
                    switch (coercion.getCoercionOnFailure()) {
                        case RETHROW: {
                            throw e;
                        }
                        case CONTINUE: {
                            continue block6;
                        }
                    }
                }
                break;
            }
        }
        return keys;
    }

    private Attributes coerceLegacy(Association as, ArchiveAttributeCoercion rule, Attributes keys) throws Exception {
        AttributesCoercion coercion = null;
        coercion = this.coerceAttributesByXSL(as, rule, coercion);
        coercion = SupplementAssigningAuthorities.forQuery((Device)rule.getSupplementFromDevice(), (AttributesCoercion)coercion);
        coercion = rule.supplementIssuerOfPatientID(coercion);
        coercion = rule.nullifyIssuerOfPatientID(keys, coercion);
        coercion = rule.mergeAttributes(coercion);
        coercion = NullifyAttributesCoercion.valueOf((int[])rule.getNullifyTags(), (AttributesCoercion)coercion);
        if (rule.isTrimISO2022CharacterSet()) {
            coercion = new TrimISO2020CharacterSetAttributesCoercion(coercion);
        }
        if ((coercion = UseCallingAETitleAsCoercion.of((UseCallingAETitleAsCoercion.Type)rule.getUseCallingAETitleAs(), (String)as.getCallingAET(), (AttributesCoercion)coercion)) != null) {
            LOG.info("{}: Coerce Attributes from rule: {}", (Object)as, (Object)rule);
            keys = new Attributes(keys);
            coercion.coerce(keys, null);
        }
        return keys;
    }

    private AttributesCoercion coerceAttributesByXSL(Association as, ArchiveAttributeCoercion rule, AttributesCoercion next) {
        String xsltStylesheetURI = rule.getXSLTStylesheetURI();
        if (xsltStylesheetURI != null) {
            try {
                Templates tpls = TemplatesCache.getDefault().get(StringUtils.replaceSystemProperties((String)xsltStylesheetURI));
                return new XSLTAttributesCoercion(tpls, null).includeKeyword(!rule.isNoKeywords()).setupTransformer(this.setupTransformer(as));
            }
            catch (TransformerConfigurationException e) {
                LOG.error("{}: Failed to compile XSL: {}", new Object[]{as, xsltStylesheetURI, e});
            }
        }
        return next;
    }

    private SAXTransformer.SetupTransformer setupTransformer(Association as) {
        return t -> {
            t.setParameter("LocalAET", as.getCallingAET());
            t.setParameter("RemoteAET", as.getCalledAET());
            t.setParameter("RemoteHost", as.getRemoteHostName());
        };
    }
}

