/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.query.impl;

import java.util.Date;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Tuple;
import javax.persistence.TupleElement;
import javax.persistence.criteria.CollectionJoin;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.IDWithIssuer;
import org.dcm4che3.data.Issuer;
import org.dcm4che3.data.VR;
import org.dcm4che3.util.StringUtils;
import org.dcm4chee.arc.code.CodeCache;
import org.dcm4chee.arc.conf.Availability;
import org.dcm4chee.arc.entity.AttributesBlob;
import org.dcm4chee.arc.entity.AttributesBlob_;
import org.dcm4chee.arc.entity.Completeness;
import org.dcm4chee.arc.entity.ExpirationState;
import org.dcm4chee.arc.entity.Patient;
import org.dcm4chee.arc.entity.Patient_;
import org.dcm4chee.arc.entity.RejectionState;
import org.dcm4chee.arc.entity.Study;
import org.dcm4chee.arc.entity.StudyQueryAttributes;
import org.dcm4chee.arc.entity.StudyQueryAttributes_;
import org.dcm4chee.arc.entity.Study_;
import org.dcm4chee.arc.query.QueryContext;
import org.dcm4chee.arc.query.impl.AbstractQuery;
import org.dcm4chee.arc.query.impl.PatientQuery;
import org.dcm4chee.arc.query.util.QueryBuilder;
import org.dcm4chee.arc.query.util.QueryParam;

class StudyQuery
extends AbstractQuery {
    private final CodeCache codeCache;
    private Join<Study, Patient> patient;
    private Root<Study> study;
    private CollectionJoin<Study, StudyQueryAttributes> studyQueryAttributes;
    private Path<byte[]> patientAttrBlob;
    private Path<byte[]> studyAttrBlob;

    StudyQuery(QueryContext context, EntityManager em, CodeCache codeCache) {
        super(context, em);
        this.codeCache = codeCache;
    }

    @Override
    protected CriteriaQuery<Tuple> multiselect() {
        CriteriaQuery q = this.cb.createTupleQuery();
        this.study = q.from(Study.class);
        this.patient = this.study.join(Study_.patient);
        String viewID = this.context.getQueryParam().getViewID();
        this.studyQueryAttributes = QueryBuilder.joinStudyQueryAttributes((CriteriaBuilder)this.cb, this.study, (String)viewID);
        Selection[] selectionArray = new Selection[29];
        selectionArray[0] = this.study.get(Study_.pk);
        selectionArray[1] = this.patient.get(Patient_.numberOfStudies);
        selectionArray[2] = this.patient.get(Patient_.createdTime);
        selectionArray[3] = this.patient.get(Patient_.updatedTime);
        selectionArray[4] = this.patient.get(Patient_.verificationTime);
        selectionArray[5] = this.patient.get(Patient_.verificationStatus);
        selectionArray[6] = this.patient.get(Patient_.failedVerifications);
        selectionArray[7] = this.study.get(Study_.createdTime);
        selectionArray[8] = this.study.get(Study_.updatedTime);
        selectionArray[9] = this.study.get(Study_.modifiedTime);
        selectionArray[10] = this.study.get(Study_.accessTime);
        selectionArray[11] = this.study.get(Study_.expirationState);
        selectionArray[12] = this.study.get(Study_.expirationDate);
        selectionArray[13] = this.study.get(Study_.expirationExporterID);
        selectionArray[14] = this.study.get(Study_.rejectionState);
        selectionArray[15] = this.study.get(Study_.completeness);
        selectionArray[16] = this.study.get(Study_.failedRetrieves);
        selectionArray[17] = this.study.get(Study_.accessControlID);
        selectionArray[18] = this.study.get(Study_.storageIDs);
        selectionArray[19] = this.study.get(Study_.externalRetrieveAET);
        selectionArray[20] = this.study.get(Study_.size);
        selectionArray[21] = this.studyQueryAttributes.get(StudyQueryAttributes_.numberOfInstances);
        selectionArray[22] = this.studyQueryAttributes.get(StudyQueryAttributes_.numberOfSeries);
        selectionArray[23] = this.studyQueryAttributes.get(StudyQueryAttributes_.modalitiesInStudy);
        selectionArray[24] = this.studyQueryAttributes.get(StudyQueryAttributes_.sopClassesInStudy);
        selectionArray[25] = this.studyQueryAttributes.get(StudyQueryAttributes_.retrieveAETs);
        selectionArray[26] = this.studyQueryAttributes.get(StudyQueryAttributes_.availability);
        this.patientAttrBlob = this.patient.join(Patient_.attributesBlob).get(AttributesBlob_.encodedAttributes);
        selectionArray[27] = this.patientAttrBlob;
        this.studyAttrBlob = this.study.join(Study_.attributesBlob).get(AttributesBlob_.encodedAttributes);
        selectionArray[28] = this.studyAttrBlob;
        return this.order(this.restrict(q, this.patient, this.study, new Predicate[0])).multiselect(selectionArray);
    }

    @Override
    protected CriteriaQuery<Long> count() {
        CriteriaQuery q = this.cb.createQuery(Long.class);
        Root study = q.from(Study.class);
        return this.createQuery((CriteriaQuery<Long>)q, (Root<Study>)study, (Expression<Long>)this.cb.count((Expression)study), new Predicate[0]);
    }

    @Override
    protected CriteriaQuery<Long> sumStudySize() {
        CriteriaQuery q = this.cb.createQuery(Long.class);
        Root study = q.from(Study.class);
        return this.createQuery((CriteriaQuery<Long>)q, (Root<Study>)study, (Expression<Long>)this.cb.sum((Expression)study.get(Study_.size)), new Predicate[0]);
    }

    @Override
    protected CriteriaQuery<Long> withUnknownSize() {
        CriteriaQuery q = this.cb.createQuery(Long.class);
        Root study = q.from(Study.class);
        return this.createQuery((CriteriaQuery<Long>)q, (Root<Study>)study, (Expression<Long>)study.get(Study_.pk), this.cb.equal((Expression)study.get(Study_.size), (Object)-1L));
    }

    @Override
    protected Attributes toAttributes(Tuple results) {
        Availability availability;
        String retrieveAETs;
        String sopClassesInStudy;
        String modalitiesInStudy;
        int numberOfStudyRelatedSeries;
        int numberOfStudyRelatedInstances;
        Long studyPk = (Long)results.get((TupleElement)this.study.get(Study_.pk));
        long studySize = (Long)results.get((TupleElement)this.study.get(Study_.size));
        if (studySize < 0L) {
            studySize = this.context.getQueryService().calculateStudySize(studyPk);
        }
        Integer numberOfInstancesI = (Integer)results.get((TupleElement)this.studyQueryAttributes.get(StudyQueryAttributes_.numberOfInstances));
        QueryParam queryParam = this.context.getQueryParam();
        if (numberOfInstancesI != null) {
            numberOfStudyRelatedInstances = numberOfInstancesI;
            if (numberOfStudyRelatedInstances == 0) {
                return null;
            }
            numberOfStudyRelatedSeries = (Integer)results.get((TupleElement)this.studyQueryAttributes.get(StudyQueryAttributes_.numberOfSeries));
            modalitiesInStudy = (String)results.get((TupleElement)this.studyQueryAttributes.get(StudyQueryAttributes_.modalitiesInStudy));
            sopClassesInStudy = (String)results.get((TupleElement)this.studyQueryAttributes.get(StudyQueryAttributes_.sopClassesInStudy));
            retrieveAETs = (String)results.get((TupleElement)this.studyQueryAttributes.get(StudyQueryAttributes_.retrieveAETs));
            availability = (Availability)results.get((TupleElement)this.studyQueryAttributes.get(StudyQueryAttributes_.availability));
        } else {
            StudyQueryAttributes studyView = this.context.getQueryService().calculateStudyQueryAttributes(studyPk, queryParam.getQueryRetrieveView());
            numberOfStudyRelatedInstances = studyView.getNumberOfInstances();
            if (numberOfStudyRelatedInstances == 0) {
                return null;
            }
            numberOfStudyRelatedSeries = studyView.getNumberOfSeries();
            modalitiesInStudy = studyView.getModalitiesInStudy();
            sopClassesInStudy = studyView.getSOPClassesInStudy();
            retrieveAETs = studyView.getRetrieveAETs();
            availability = studyView.getAvailability();
        }
        Attributes studyAttrs = AttributesBlob.decodeAttributes((byte[])((byte[])results.get(this.studyAttrBlob)), null);
        Attributes patAttrs = AttributesBlob.decodeAttributes((byte[])((byte[])results.get(this.patientAttrBlob)), null);
        Attributes.unifyCharacterSets((Attributes[])new Attributes[]{patAttrs, studyAttrs});
        Attributes attrs = new Attributes(patAttrs.size() + studyAttrs.size() + 20);
        attrs.addAll(patAttrs);
        attrs.addAll(studyAttrs, true);
        PatientQuery.addPatientQRAttrs(this.patient, this.context, results, attrs);
        String externalRetrieveAET = (String)results.get((TupleElement)this.study.get(Study_.externalRetrieveAET));
        attrs.setString(524372, VR.AE, this.retrieveAETs(retrieveAETs, externalRetrieveAET));
        attrs.setString(524374, VR.CS, ((Availability)StringUtils.maskNull((Object)availability, (Object)Availability.UNAVAILABLE)).toString());
        StudyQuery.addStudyQRAddrs(this.study, this.context, results, studySize, numberOfStudyRelatedInstances, numberOfStudyRelatedSeries, modalitiesInStudy, sopClassesInStudy, attrs);
        return attrs;
    }

    private CriteriaQuery<Tuple> order(CriteriaQuery<Tuple> q) {
        if (this.context.getOrderByTags() != null) {
            q.orderBy(this.builder.orderStudies(this.patient, this.study, this.context.getOrderByTags()));
        }
        return q;
    }

    private <T> CriteriaQuery<T> restrict(CriteriaQuery<T> q, Join<Study, Patient> patient, Root<Study> study, Predicate ... extra) {
        List predicates = this.builder.studyPredicates(q, patient, study, this.context.getPatientIDs(), this.context.getIssuerOfPatientID(), this.context.getQueryKeys(), this.context.getQueryParam(), this.codeCache.findOrCreateEntities(this.context.getQueryParam().getQueryRetrieveView().getShowInstancesRejectedByCodes()));
        for (Predicate predicate : extra) {
            predicates.add(predicate);
        }
        if (!predicates.isEmpty()) {
            q.where(predicates.toArray(new Predicate[0]));
        }
        return q;
    }

    private CriteriaQuery<Long> createQuery(CriteriaQuery<Long> q, Root<Study> study, Expression<Long> longExpression, Predicate ... extra) {
        boolean hasPatientLevelPredicates = QueryBuilder.hasPatientLevelPredicates((IDWithIssuer[])this.context.getPatientIDs(), (Issuer)this.context.getIssuerOfPatientID(), (Attributes)this.context.getQueryKeys(), (QueryParam)this.context.getQueryParam());
        Join patient = null;
        if (hasPatientLevelPredicates) {
            patient = study.join(Study_.patient);
        }
        return this.restrict(q, (Join<Study, Patient>)patient, study, extra).select(longExpression);
    }

    static void addStudyQRAddrs(Path<Study> study, QueryContext context, Tuple results, long studySize, int numberOfStudyRelatedInstances, int numberOfStudyRelatedSeries, String modalitiesInStudy, String sopClassesInStudy, Attributes attrs) {
        attrs.setString(524385, VR.CS, StringUtils.split((String)modalitiesInStudy, (char)'\\'));
        attrs.setString(524386, VR.UI, StringUtils.split((String)sopClassesInStudy, (char)'\\'));
        attrs.setInt(2101766, VR.IS, new int[]{numberOfStudyRelatedSeries});
        attrs.setInt(2101768, VR.IS, new int[]{numberOfStudyRelatedInstances});
        if (!context.isReturnPrivate()) {
            return;
        }
        StudyQuery.setDTwTZ(attrs, 0x77770020, (Date)results.get((TupleElement)study.get(Study_.createdTime)));
        StudyQuery.setDTwTZ(attrs, 2004287521, (Date)results.get((TupleElement)study.get(Study_.updatedTime)));
        StudyQuery.setDTwTZ(attrs, 2004287533, (Date)results.get((TupleElement)study.get(Study_.modifiedTime)));
        StudyQuery.setDTwTZ(attrs, 0x77770022, (Date)results.get((TupleElement)study.get(Study_.accessTime)));
        if (results.get((TupleElement)study.get(Study_.expirationState)) != ExpirationState.UPDATEABLE) {
            attrs.setString("DCM4CHEE Archive 5", 2004287531, VR.CS, ((ExpirationState)results.get((TupleElement)study.get(Study_.expirationState))).toString());
        }
        if (results.get((TupleElement)study.get(Study_.expirationDate)) != null) {
            attrs.setString("DCM4CHEE Archive 5", 2004287523, VR.DA, (String)results.get((TupleElement)study.get(Study_.expirationDate)));
        }
        if (results.get((TupleElement)study.get(Study_.expirationExporterID)) != null) {
            attrs.setString("DCM4CHEE Archive 5", 2004287532, VR.LO, (String)results.get((TupleElement)study.get(Study_.expirationExporterID)));
        }
        if (results.get((TupleElement)study.get(Study_.rejectionState)) != RejectionState.NONE) {
            attrs.setString("DCM4CHEE Archive 5", 2004287524, VR.CS, ((RejectionState)results.get((TupleElement)study.get(Study_.rejectionState))).toString());
        }
        if (results.get((TupleElement)study.get(Study_.completeness)) != Completeness.COMPLETE) {
            attrs.setString("DCM4CHEE Archive 5", 2004287525, VR.CS, ((Completeness)results.get((TupleElement)study.get(Study_.completeness))).toString());
        }
        if ((Integer)results.get((TupleElement)study.get(Study_.failedRetrieves)) != 0) {
            attrs.setInt("DCM4CHEE Archive 5", 2004287526, VR.US, new int[]{(Integer)results.get((TupleElement)study.get(Study_.failedRetrieves))});
        }
        if (!((String)results.get((TupleElement)study.get(Study_.accessControlID))).equals("*")) {
            attrs.setString("DCM4CHEE Archive 5", 0x77770027, VR.LO, (String)results.get((TupleElement)study.get(Study_.accessControlID)));
        }
        attrs.setString("DCM4CHEE Archive 5", 2004287528, VR.LO, StringUtils.split((String)((String)results.get((TupleElement)study.get(Study_.storageIDs))), (char)'\\'));
        attrs.setInt("DCM4CHEE Archive 5", 2004287529, VR.UL, new int[]{(int)(studySize / 1000L)});
        attrs.setInt("DCM4CHEE Archive 5", 2004287530, VR.US, new int[]{(int)(studySize % 1000L)});
    }

    @Override
    public boolean isOptionalKeysNotSupported() {
        return false;
    }
}

