/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.query.impl;

import java.io.Closeable;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.List;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.IDWithIssuer;
import org.dcm4che3.data.Issuer;
import org.dcm4che3.net.ApplicationEntity;
import org.dcm4che3.net.Association;
import org.dcm4che3.net.service.QueryRetrieveLevel2;
import org.dcm4che3.util.ReverseDNS;
import org.dcm4che3.util.SafeClose;
import org.dcm4chee.arc.conf.ArchiveAEExtension;
import org.dcm4chee.arc.conf.ArchiveDeviceExtension;
import org.dcm4chee.arc.keycloak.HttpServletRequestInfo;
import org.dcm4chee.arc.query.QueryContext;
import org.dcm4chee.arc.query.QueryService;
import org.dcm4chee.arc.query.util.OrderByTag;
import org.dcm4chee.arc.query.util.QueryParam;
import org.dcm4chee.arc.storage.Storage;

class QueryContextImpl
implements QueryContext {
    private Association as;
    private String calledAET;
    private HttpServletRequestInfo httpRequest;
    private final ApplicationEntity ae;
    private final QueryParam queryParam;
    private final QueryService queryService;
    private QueryRetrieveLevel2 qrLevel;
    private IDWithIssuer[] patientIDs = new IDWithIssuer[0];
    private Issuer issuerOfPatientID;
    private Attributes queryKeys;
    private Attributes coercedQueryKeys = new Attributes();
    private Attributes returnKeys;
    private boolean returnPrivate;
    private String sopClassUID;
    private String searchMethod;
    private final HashMap<String, Storage> storageMap = new HashMap();
    private List<OrderByTag> orderByTags;

    QueryContextImpl(ApplicationEntity ae, QueryParam queryParam, QueryService queryService) {
        this.ae = ae;
        this.calledAET = ae.getAETitle();
        this.queryService = queryService;
        this.queryParam = queryParam;
    }

    QueryContextImpl find(Association as, String sopClassUID) {
        this.as = as;
        this.calledAET = as.getCalledAET();
        this.sopClassUID = sopClassUID;
        return this;
    }

    QueryContextImpl qido(HttpServletRequestInfo httpRequest, String searchMethod, String aet) {
        this.httpRequest = httpRequest;
        this.searchMethod = searchMethod;
        this.calledAET = aet;
        return this;
    }

    @Override
    public QueryRetrieveLevel2 getQueryRetrieveLevel() {
        return this.qrLevel;
    }

    @Override
    public void setQueryRetrieveLevel(QueryRetrieveLevel2 qrLevel) {
        this.qrLevel = qrLevel;
    }

    @Override
    public Association getAssociation() {
        return this.as;
    }

    @Override
    public String getSOPClassUID() {
        return this.sopClassUID;
    }

    @Override
    public void setSOPClassUID(String sopClassUID) {
        this.sopClassUID = sopClassUID;
    }

    @Override
    public String getSearchMethod() {
        return this.searchMethod;
    }

    @Override
    public HttpServletRequestInfo getHttpRequest() {
        return this.httpRequest;
    }

    @Override
    public ApplicationEntity getLocalApplicationEntity() {
        return this.ae;
    }

    @Override
    public String getCalledAET() {
        return this.calledAET;
    }

    @Override
    public String getCallingAET() {
        return this.as != null ? this.as.getCallingAET() : null;
    }

    @Override
    public String getRemoteHostName() {
        return this.httpRequest != null ? this.httpRequest.requesterHost : ReverseDNS.hostNameOf((InetAddress)this.as.getSocket().getInetAddress());
    }

    @Override
    public String getLocalHostName() {
        return this.httpRequest != null ? this.httpRequest.localHost : ReverseDNS.hostNameOf((InetAddress)this.as.getSocket().getLocalAddress());
    }

    @Override
    public ArchiveAEExtension getArchiveAEExtension() {
        return (ArchiveAEExtension)this.ae.getAEExtension(ArchiveAEExtension.class);
    }

    @Override
    public IDWithIssuer[] getPatientIDs() {
        return this.patientIDs;
    }

    @Override
    public void setPatientIDs(IDWithIssuer ... patientIDs) {
        this.patientIDs = patientIDs != null ? patientIDs : IDWithIssuer.EMPTY;
    }

    @Override
    public Issuer getIssuerOfPatientID() {
        return this.issuerOfPatientID;
    }

    @Override
    public void setIssuerOfPatientID(Issuer issuerOfPatientID) {
        this.issuerOfPatientID = issuerOfPatientID;
    }

    @Override
    public QueryService getQueryService() {
        return this.queryService;
    }

    @Override
    public Attributes getReturnKeys() {
        return this.returnKeys;
    }

    @Override
    public void setReturnKeys(Attributes returnKeys) {
        this.returnKeys = returnKeys;
    }

    @Override
    public Attributes getQueryKeys() {
        return this.queryKeys;
    }

    @Override
    public void setQueryKeys(Attributes keys) {
        this.queryKeys = keys;
    }

    @Override
    public Attributes getCoercedQueryKeys() {
        return this.coercedQueryKeys;
    }

    @Override
    public boolean isReturnPrivate() {
        return this.returnPrivate;
    }

    @Override
    public void setReturnPrivate(boolean returnPrivate) {
        this.returnPrivate = returnPrivate;
    }

    @Override
    public QueryParam getQueryParam() {
        return this.queryParam;
    }

    @Override
    public boolean containsUniqueKey() {
        return this.patientIDs.length > 0 || this.queryKeys.containsValue(0x20000D) || this.qrLevel.compareTo((Enum)QueryRetrieveLevel2.SERIES) >= 0 && (this.queryKeys.containsValue(0x20000E) || this.qrLevel == QueryRetrieveLevel2.IMAGE && this.queryKeys.containsValue(524312));
    }

    @Override
    public List<OrderByTag> getOrderByTags() {
        return this.orderByTags;
    }

    @Override
    public void setOrderByTags(List<OrderByTag> orderByTags) {
        this.orderByTags = orderByTags;
    }

    @Override
    public boolean isConsiderPurgedInstances() {
        return this.qrLevel == QueryRetrieveLevel2.IMAGE && this.getArchiveDeviceExtension().isPurgeInstanceRecords() && (this.queryKeys.containsValue(0x20000D) || this.queryKeys.containsValue(0x20000E));
    }

    private ArchiveDeviceExtension getArchiveDeviceExtension() {
        return (ArchiveDeviceExtension)this.ae.getDevice().getDeviceExtension(ArchiveDeviceExtension.class);
    }

    @Override
    public Storage getStorage(String storageID) {
        return this.storageMap.get(storageID);
    }

    @Override
    public void putStorage(String storageID, Storage storage) {
        this.storageMap.put(storageID, storage);
    }

    @Override
    public void close() {
        for (Storage storage : this.storageMap.values()) {
            SafeClose.close((Closeable)storage);
        }
    }
}

