/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.query.impl;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Tuple;
import javax.persistence.TupleElement;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.VR;
import org.dcm4chee.arc.entity.AttributesBlob;
import org.dcm4chee.arc.entity.AttributesBlob_;
import org.dcm4chee.arc.entity.MWLItem;
import org.dcm4chee.arc.entity.MWLItem_;
import org.dcm4chee.arc.entity.Patient;
import org.dcm4chee.arc.entity.Patient_;
import org.dcm4chee.arc.query.QueryContext;
import org.dcm4chee.arc.query.impl.AbstractQuery;

public class MWLQuery
extends AbstractQuery {
    private Root<MWLItem> mwlItem;
    private Join<MWLItem, Patient> patient;
    private Path<byte[]> patientAttrBlob;
    private Path<byte[]> mwlAttrBlob;

    public MWLQuery(QueryContext context, EntityManager em) {
        super(context, em);
    }

    @Override
    protected CriteriaQuery<Tuple> multiselect() {
        CriteriaQuery q = this.cb.createTupleQuery();
        this.mwlItem = q.from(MWLItem.class);
        this.patient = this.mwlItem.join(MWLItem_.patient);
        Selection[] selectionArray = new Selection[3];
        selectionArray[0] = this.patient.get(Patient_.numberOfStudies);
        this.patientAttrBlob = this.patient.join(Patient_.attributesBlob).get(AttributesBlob_.encodedAttributes);
        selectionArray[1] = this.patientAttrBlob;
        this.mwlAttrBlob = this.mwlItem.join(MWLItem_.attributesBlob).get(AttributesBlob_.encodedAttributes);
        selectionArray[2] = this.mwlAttrBlob;
        return this.order(this.restrict(q, this.patient, this.mwlItem)).multiselect(selectionArray);
    }

    @Override
    protected CriteriaQuery<Long> count() {
        CriteriaQuery q = this.cb.createQuery(Long.class);
        Root mwlItem = q.from(MWLItem.class);
        Join patient = mwlItem.join(MWLItem_.patient);
        return this.restrict(q, (Join<MWLItem, Patient>)patient, (Root<MWLItem>)mwlItem).select((Selection)this.cb.count((Expression)mwlItem));
    }

    @Override
    protected Attributes toAttributes(Tuple results) {
        Attributes mwlAttrs = AttributesBlob.decodeAttributes((byte[])((byte[])results.get(this.mwlAttrBlob)), null);
        Attributes patAttrs = AttributesBlob.decodeAttributes((byte[])((byte[])results.get(this.patientAttrBlob)), null);
        Attributes.unifyCharacterSets((Attributes[])new Attributes[]{patAttrs, mwlAttrs});
        Attributes attrs = new Attributes(patAttrs.size() + mwlAttrs.size() + 1);
        attrs.addAll(patAttrs);
        attrs.addAll(mwlAttrs);
        attrs.setInt(0x201200, VR.IS, new int[]{(Integer)results.get((TupleElement)this.patient.get(Patient_.numberOfStudies))});
        return attrs;
    }

    @Override
    public boolean isOptionalKeysNotSupported() {
        return false;
    }

    private CriteriaQuery<Tuple> order(CriteriaQuery<Tuple> q) {
        if (this.context.getOrderByTags() != null) {
            q.orderBy(this.builder.orderMWLItems(this.patient, this.mwlItem, this.context.getOrderByTags()));
        }
        return q;
    }

    private <T> CriteriaQuery<T> restrict(CriteriaQuery<T> q, Join<MWLItem, Patient> patient, Root<MWLItem> mwlItem) {
        List predicates = this.builder.mwlItemPredicates(q, patient, mwlItem, this.context.getPatientIDs(), this.context.getIssuerOfPatientID(), this.context.getQueryKeys(), this.context.getQueryParam());
        if (!predicates.isEmpty()) {
            q.where(predicates.toArray(new Predicate[0]));
        }
        return q;
    }
}

