/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.query.impl;

import java.util.Date;
import java.util.Iterator;
import java.util.stream.Stream;
import javax.persistence.EntityManager;
import javax.persistence.Tuple;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.DatePrecision;
import org.dcm4che3.data.VR;
import org.dcm4che3.net.service.DicomServiceException;
import org.dcm4che3.util.DateUtils;
import org.dcm4che3.util.StringUtils;
import org.dcm4chee.arc.query.Query;
import org.dcm4chee.arc.query.QueryContext;
import org.dcm4chee.arc.query.util.QueryBuilder;

abstract class AbstractQuery
implements Query {
    protected final QueryContext context;
    protected final EntityManager em;
    protected final CriteriaBuilder cb;
    protected final QueryBuilder builder;
    private Stream<Tuple> resultStream;
    private Iterator<Tuple> results;
    private int offset;
    private int limit;
    private int fetchSize;
    private int rejected;
    private int matches;

    AbstractQuery(QueryContext context, EntityManager em) {
        this.context = context;
        this.em = em;
        this.cb = em.getCriteriaBuilder();
        this.builder = new QueryBuilder(this.cb);
    }

    @Override
    public QueryContext getQueryContext() {
        return this.context;
    }

    @Override
    public void executeQuery(int fetchSize) {
        this.executeQuery(fetchSize, 0, -1);
    }

    @Override
    public void executeQuery(int fetchSize, int offset, int limit) {
        this.fetchSize = fetchSize;
        this.offset = offset;
        this.limit = limit;
        this.rejected = 0;
        this.matches = 0;
        this.close(this.resultStream);
        TypedQuery query = this.em.createQuery(this.multiselect()).setHint("org.hibernate.fetchSize", (Object)fetchSize);
        if (offset > 0) {
            query.setFirstResult(offset);
        }
        if (limit > 0) {
            query.setMaxResults(limit);
        }
        this.resultStream = query.getResultStream();
        this.results = this.resultStream.iterator();
    }

    @Override
    public long fetchCount() {
        return QueryBuilder.unbox((Long)((Long)this.em.createQuery(this.count()).getSingleResult()), (long)0L);
    }

    @Override
    public long fetchSize() {
        return QueryBuilder.unbox((Long)((Long)this.em.createQuery(this.sumStudySize()).getSingleResult()), (long)0L);
    }

    @Override
    public Stream<Long> withUnknownSize(int fetchSize) {
        return this.em.createQuery(this.withUnknownSize()).setHint("org.hibernate.fetchSize", (Object)fetchSize).getResultStream();
    }

    @Override
    public boolean hasMoreMatches() throws DicomServiceException {
        boolean hasNext = this.results.hasNext();
        if (hasNext || this.rejected == 0 || this.limit != this.matches) {
            return hasNext;
        }
        this.executeQuery(this.fetchSize, this.offset + this.matches, this.rejected);
        return this.results.hasNext();
    }

    @Override
    public Attributes nextMatch() {
        Attributes attrs = this.toAttributes(this.results.next());
        ++this.matches;
        if (attrs == null) {
            ++this.rejected;
        }
        return attrs;
    }

    @Override
    public void incrementLimit() {
        ++this.rejected;
    }

    @Override
    public Attributes adjust(Attributes match) {
        if (match == null) {
            return null;
        }
        Attributes returnKeys = this.context.getReturnKeys();
        if (returnKeys == null) {
            return match;
        }
        Attributes filtered = new Attributes(returnKeys.size());
        filtered.addSelected(match, returnKeys);
        filtered.supplementEmpty(returnKeys);
        return filtered;
    }

    @Override
    public void close() {
        this.close(this.resultStream);
        this.context.close();
    }

    private void close(Stream<Tuple> resultStream) {
        if (resultStream != null) {
            resultStream.close();
        }
    }

    protected abstract CriteriaQuery<Tuple> multiselect();

    protected abstract CriteriaQuery<Long> count();

    protected CriteriaQuery<Long> sumStudySize() {
        throw new UnsupportedOperationException();
    }

    protected CriteriaQuery<Long> withUnknownSize() {
        throw new UnsupportedOperationException();
    }

    protected abstract Attributes toAttributes(Tuple var1);

    static String[] splitAndAppend(String s, String append) {
        String[] ss = StringUtils.split((String)s, (char)'\\');
        if (append != null && !append.equals("*")) {
            String[] src = ss;
            ss = new String[src.length + 1];
            System.arraycopy(src, 0, ss, 0, src.length);
            ss[src.length] = append;
        }
        return ss;
    }

    protected String[] retrieveAETs(String retrieveAETs, String externalRetrieveAET) {
        String[] aets = this.context.getArchiveAEExtension().returnRetrieveAETitles();
        return aets.length > 0 ? aets : AbstractQuery.splitAndAppend(retrieveAETs, externalRetrieveAET);
    }

    static void setDTwTZ(Attributes attrs, int tag, Date value) {
        attrs.setString("DCM4CHEE Archive 5", tag, VR.DT, DateUtils.formatDT(null, (Date)value, (DatePrecision)new DatePrecision(14, true)));
    }
}

