/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.qmgt.impl;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Semaphore;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.dcm4chee.arc.NamedCDIBeanCache;
import org.dcm4chee.arc.Scheduler;
import org.dcm4chee.arc.conf.ArchiveDeviceExtension;
import org.dcm4chee.arc.conf.Duration;
import org.dcm4chee.arc.conf.QueueDescriptor;
import org.dcm4chee.arc.conf.ScheduleExpression;
import org.dcm4chee.arc.entity.Task;
import org.dcm4chee.arc.qmgt.Outcome;
import org.dcm4chee.arc.qmgt.TaskProcessor;
import org.dcm4chee.arc.qmgt.impl.TaskManagerEJB;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class TaskScheduler
extends Scheduler {
    private static final Logger LOG = LoggerFactory.getLogger(TaskScheduler.class);
    @Inject
    private NamedCDIBeanCache namedCDIBeanCache;
    @Inject
    private TaskManagerEJB ejb;
    @Inject
    private Instance<TaskProcessor> taskProcessors;
    private Set<String> inProcess = Collections.synchronizedSet(new HashSet());
    private Set<String> rescheduleInProcess = Collections.synchronizedSet(new HashSet());

    protected TaskScheduler() {
        super(Scheduler.Mode.scheduleAtFixedRate);
    }

    protected Logger log() {
        return LOG;
    }

    protected Duration getPollingInterval() {
        return ((ArchiveDeviceExtension)this.device.getDeviceExtensionNotNull(ArchiveDeviceExtension.class)).getTaskPollingInterval();
    }

    protected void execute() {
        ArchiveDeviceExtension arcDev = (ArchiveDeviceExtension)this.device.getDeviceExtensionNotNull(ArchiveDeviceExtension.class);
        int fetchSize = arcDev.getTaskFetchSize();
        for (QueueDescriptor desc : arcDev.getQueueDescriptors()) {
            this.process(desc, fetchSize);
        }
    }

    public void process(QueueDescriptor desc, int fetchSize) {
        String queueName = desc.getQueueName();
        if (desc.isInstalled() && !this.inProcess.contains(queueName) && ScheduleExpression.emptyOrAnyContainsNow((ScheduleExpression[])desc.getSchedules())) {
            List<Long> pks;
            if (this.rescheduleInProcess.add(queueName)) {
                this.ejb.rescheduleInProcess(queueName);
            }
            if (!(pks = this.ejb.findTasksToProcess(queueName, fetchSize)).isEmpty()) {
                this.device.execute(() -> this.process(desc, pks));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void process(QueueDescriptor desc, List<Long> pks) {
        if (this.inProcess.add(desc.getQueueName())) {
            try {
                if (desc.getMaxTasksParallel() > 1) {
                    this.processTasksParallel(desc, pks);
                } else {
                    this.processTasksSequential(desc, pks);
                }
            }
            catch (Throwable e) {
                LOG.warn("Processing Tasks from {} throws:\n", (Object)desc, (Object)e);
            }
            finally {
                this.inProcess.remove(desc.getQueueName());
            }
        }
    }

    private void processTasksSequential(QueueDescriptor desc, List<Long> pks) {
        ArchiveDeviceExtension arcDev = (ArchiveDeviceExtension)this.device.getDeviceExtensionNotNull(ArchiveDeviceExtension.class);
        String queueName = desc.getQueueName();
        do {
            for (Long pk : pks) {
                if (arcDev.getTaskPollingInterval() == null || !arcDev.getQueueDescriptor(queueName).isInstalled() || !ScheduleExpression.emptyOrAnyContainsNow((ScheduleExpression[])desc.getSchedules())) {
                    return;
                }
                Task task = this.onProcessingStart(pk);
                if (task == null) continue;
                this.processTask(task);
            }
        } while (!(pks = this.ejb.findTasksToProcess(queueName, arcDev.getTaskFetchSize())).isEmpty());
    }

    private Task onProcessingStart(Long pk) {
        try {
            return this.ejb.onProcessingStart(pk);
        }
        catch (Exception e) {
            LOG.info("Suppress processing of Task[pk={}] caused by:\n", (Object)pk, (Object)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processTasksParallel(QueueDescriptor desc, List<Long> pks) throws InterruptedException {
        ArchiveDeviceExtension arcDev = (ArchiveDeviceExtension)this.device.getDeviceExtensionNotNull(ArchiveDeviceExtension.class);
        String queueName = desc.getQueueName();
        int maxTasksParallel = desc.getMaxTasksParallel();
        Semaphore semaphore = new Semaphore(maxTasksParallel);
        do {
            try {
                do {
                    for (Long pk : pks) {
                        if (!semaphore.tryAcquire()) {
                            LOG.debug("Acquiring thread for processing Task[pk={}] from {}", (Object)pk, (Object)desc);
                            semaphore.acquire();
                            LOG.debug("Acquired thread for processing Task[pk={}] from {}", (Object)pk, (Object)desc);
                        }
                        if (arcDev.getTaskPollingInterval() == null || !arcDev.getQueueDescriptor(queueName).isInstalled() || !ScheduleExpression.emptyOrAnyContainsNow((ScheduleExpression[])desc.getSchedules())) {
                            semaphore.release();
                            return;
                        }
                        Task task = this.onProcessingStart(pk);
                        if (task != null) {
                            this.device.execute(() -> {
                                try {
                                    this.processTask(task);
                                }
                                finally {
                                    semaphore.release();
                                }
                            });
                            continue;
                        }
                        semaphore.release();
                    }
                } while (!(pks = this.ejb.findTasksToProcess(queueName, arcDev.getTaskFetchSize())).isEmpty());
            }
            finally {
                LOG.debug("Wait for finishing {} processing Tasks from {}", (Object)(maxTasksParallel - semaphore.availablePermits()), (Object)desc);
                semaphore.acquire(maxTasksParallel);
                LOG.debug("All processing Tasks from {} finished", (Object)desc);
                semaphore.release(maxTasksParallel);
            }
        } while (!(pks = this.ejb.findTasksToProcess(queueName, arcDev.getTaskFetchSize())).isEmpty());
    }

    private void processTask(Task task) {
        try {
            LOG.info("Start processing {}", (Object)task);
            TaskProcessor processor = (TaskProcessor)this.namedCDIBeanCache.get(this.taskProcessors, task.getType().name());
            Outcome outcome = processor.process(task);
            this.ejb.onProcessingSuccessful(task, outcome);
        }
        catch (Throwable e) {
            this.ejb.onProcessingFailed(task, e);
        }
    }
}

