/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.procedure.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.dcm4che3.conf.api.ConfigurationNotFoundException;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.DateRange;
import org.dcm4che3.data.VR;
import org.dcm4che3.net.ApplicationEntity;
import org.dcm4che3.net.Device;
import org.dcm4che3.net.Dimse;
import org.dcm4che3.net.QueryOption;
import org.dcm4che3.util.StringUtils;
import org.dcm4che3.util.TagUtils;
import org.dcm4chee.arc.conf.ArchiveAEExtension;
import org.dcm4chee.arc.conf.ArchiveDeviceExtension;
import org.dcm4chee.arc.conf.AttributesBuilder;
import org.dcm4chee.arc.conf.Duration;
import org.dcm4chee.arc.conf.Entity;
import org.dcm4chee.arc.conf.MWLImport;
import org.dcm4chee.arc.conf.SPSStatus;
import org.dcm4chee.arc.entity.HL7PSUTask;
import org.dcm4chee.arc.entity.MPPS;
import org.dcm4chee.arc.entity.MWLItem;
import org.dcm4chee.arc.keycloak.HttpServletRequestInfo;
import org.dcm4chee.arc.mpps.MPPSContext;
import org.dcm4chee.arc.procedure.ImportResult;
import org.dcm4chee.arc.procedure.ProcedureContext;
import org.dcm4chee.arc.procedure.ProcedureService;
import org.dcm4chee.arc.procedure.impl.ProcedureContextImpl;
import org.dcm4chee.arc.procedure.impl.ProcedureServiceEJB;
import org.dcm4chee.arc.query.scu.CFindSCU;
import org.dcm4chee.arc.query.util.QIDO;
import org.dcm4chee.arc.query.util.QueryParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class ProcedureServiceImpl
implements ProcedureService {
    private static final Logger LOG = LoggerFactory.getLogger(ProcedureServiceImpl.class);
    @Inject
    private Device device;
    @Inject
    private CFindSCU findSCU;
    @Inject
    private ProcedureServiceEJB ejb;
    @Inject
    private Event<ProcedureContext> procedureEvent;

    @Override
    public ProcedureContext createProcedureContext() {
        return new ProcedureContextImpl();
    }

    @Override
    public MWLItem findMWLItem(ProcedureContext ctx) {
        return this.ejb.findMWLItem(ctx);
    }

    @Override
    public Attributes getMWLItemAttrs(String studyInstanceUID, String spsID) {
        return this.ejb.getMWLItemAttrs(studyInstanceUID, spsID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ImportResult importMWL(HttpServletRequestInfo request, String mwlscu, String mwlscp, String worklistLabel, int priority, Attributes filter, Attributes keys, boolean fuzzymatching, boolean filterbyscu, boolean delete, boolean simulate) throws Exception {
        ApplicationEntity localAE = this.device.getApplicationEntity(mwlscu, true);
        if (localAE == null || !localAE.isInstalled()) {
            throw new ConfigurationNotFoundException("No such Application Entity: " + mwlscu);
        }
        EnumSet<QueryOption> queryOptions = EnumSet.of(QueryOption.DATETIME);
        if (fuzzymatching) {
            queryOptions.add(QueryOption.FUZZY);
        }
        List mwlItems = this.findSCU.findMWLItems(localAE, mwlscp, queryOptions, priority, keys);
        if (filterbyscu) {
            mwlItems.removeIf(item -> !item.matches(filter, false, false));
        }
        Set toDelete = delete ? this.ejb.findMWLItemIDs(localAE, this.addWorklistLabel(filter, worklistLabel), fuzzymatching) : Collections.emptySet();
        int created = 0;
        int updated = 0;
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        for (Attributes mwlItem : mwlItems) {
            if (worklistLabel != null) {
                mwlItem.setString(7606786, VR.LO, worklistLabel);
            }
            MWLItem.IDs spsID = new MWLItem.IDs(mwlItem.getNestedDataset(0x400100).getString(0x400009), mwlItem.getString(0x20000D));
            toDelete.remove(spsID);
            ProcedureContext ctx = this.createProcedureContext().setHttpServletRequest(request);
            ctx.setAttributes(mwlItem);
            ctx.setSpsID(spsID.scheduledProcedureStepID);
            ctx.setSourceMwlScp(mwlscp);
            try {
                this.ejb.createOrUpdateMWLItem(ctx, simulate);
                String eventActionCode = ctx.getEventActionCode();
                if (eventActionCode == null) continue;
                if (eventActionCode.equals("C")) {
                    ++created;
                    continue;
                }
                ++updated;
            }
            catch (Exception e) {
                exceptions.add(e);
                ctx.setException(e);
            }
            finally {
                if (simulate || ctx.getEventActionCode() == null) continue;
                this.procedureEvent.fire((Object)ctx);
            }
        }
        if (!simulate) {
            Iterator iter = toDelete.iterator();
            while (iter.hasNext()) {
                try {
                    MWLItem.IDs next = (MWLItem.IDs)iter.next();
                    ProcedureContext ctx = this.createProcedureContext().setHttpServletRequest(request);
                    ctx.setStudyInstanceUID(next.studyInstanceUID);
                    ctx.setSpsID(next.scheduledProcedureStepID);
                    this.deleteProcedure(ctx);
                }
                catch (Exception e) {
                    exceptions.add(e);
                    iter.remove();
                }
            }
        }
        return new ImportResult(mwlItems.size(), created, updated, toDelete.size(), exceptions);
    }

    private Attributes addWorklistLabel(Attributes filter, String worklistLabel) {
        if (worklistLabel != null) {
            filter = new Attributes(filter);
            filter.setString(7606786, VR.LO, worklistLabel);
        }
        return filter;
    }

    @Override
    public ImportResult importMWL(MWLImport rule) throws Exception {
        Attributes filter = ProcedureServiceImpl.toFilter(rule);
        return this.importMWL(null, rule.getAETitle(), rule.getMWLSCP(), rule.getMWLWorklistLabel(), 0, filter, this.toKeys(rule, filter), false, rule.isFilterBySCU(), rule.isDeleteNotFound(), false);
    }

    private static Attributes toFilter(MWLImport rule) {
        Attributes keys = new Attributes();
        DateRange range = ProcedureServiceImpl.toDateRange(rule.getNotOlderThan(), rule.getPrefetchBefore());
        if (range != null) {
            Attributes item = new Attributes();
            item.setDateRange(18014407103610883L, range);
            keys.newSequence(0x400100, 1).add(item);
        }
        AttributesBuilder builder = new AttributesBuilder(keys);
        for (Map.Entry entry : rule.getFilter().entrySet()) {
            builder.setString(TagUtils.parseTagPath((String)((String)entry.getKey())), new String[]{(String)entry.getValue()});
        }
        return keys;
    }

    private static DateRange toDateRange(Duration notOlderThan, Duration prefetchBefore) {
        if (notOlderThan == null && prefetchBefore == null) {
            return null;
        }
        long now = System.currentTimeMillis();
        return new DateRange(notOlderThan != null ? new Date(now - notOlderThan.getSeconds() * 1000L) : null, prefetchBefore != null ? new Date(now + prefetchBefore.getSeconds() * 1000L) : null);
    }

    private Attributes toKeys(MWLImport rule, Attributes filter) {
        Attributes keys = new Attributes(filter);
        AttributesBuilder builder = new AttributesBuilder(keys);
        Object[] includeFields = rule.getIncludeFields();
        if (StringUtils.contains((Object[])includeFields, (Object)"all")) {
            ArchiveDeviceExtension arcdev = (ArchiveDeviceExtension)this.device.getDeviceExtensionNotNull(ArchiveDeviceExtension.class);
            AttributesBuilder.setNullIfAbsent((Attributes)keys, (int[])arcdev.getAttributeFilter(Entity.MWL).getSelection(false));
            AttributesBuilder.setNullIfAbsent((Attributes)keys, (int[])arcdev.getAttributeFilter(Entity.Patient).getSelection(false));
        } else {
            for (Object tagPath : includeFields) {
                builder.setNullIfAbsent(TagUtils.parseTagPath((String)tagPath));
            }
            AttributesBuilder.setNullIfAbsent((Attributes)keys, (int[])QIDO.MWL.includetags);
            Attributes spsKeys = keys.getNestedDataset(0x400100);
            if (spsKeys != null && !spsKeys.isEmpty()) {
                AttributesBuilder.setNullIfAbsent((Attributes)spsKeys, (int[])QIDO.MWL_SPS.includetags);
            }
        }
        return keys;
    }

    @Override
    public void updateProcedure(ProcedureContext ctx) {
        try {
            this.ejb.updateProcedure(ctx);
        }
        catch (RuntimeException e) {
            ctx.setException(e);
            throw e;
        }
        finally {
            if (ctx.getEventActionCode() != null) {
                this.procedureEvent.fire((Object)ctx);
            }
        }
    }

    @Override
    public void deleteProcedure(ProcedureContext ctx) {
        this.ejb.deleteProcedure(ctx);
        if (ctx.getEventActionCode() != null) {
            LOG.info("Successfully deleted MWLItem {} from database." + ctx.getSpsID());
            this.procedureEvent.fire((Object)ctx);
        }
    }

    @Override
    public void updateStudySeriesAttributes(ProcedureContext ctx) {
        try {
            this.ejb.updateStudySeriesAttributes(ctx);
        }
        finally {
            if (ctx.getEventActionCode() != null) {
                this.procedureEvent.fire((Object)ctx);
            }
        }
    }

    @Override
    public List<MWLItem> updateMWLStatus(String studyIUID, SPSStatus status) {
        return this.ejb.updateMWLStatus(studyIUID, status);
    }

    @Override
    public List<MWLItem> updateMWLStatus(ArchiveAEExtension arcAE, HL7PSUTask task, SPSStatus status) {
        return this.ejb.updateMWLStatus(arcAE, task, status);
    }

    @Override
    public void updateMWLStatus(ProcedureContext ctx) {
        try {
            this.ejb.updateMWLStatus(ctx);
        }
        catch (Exception e) {
            ctx.setException(e);
        }
        finally {
            if (ctx.getEventActionCode() != null) {
                this.procedureEvent.fire((Object)ctx);
            }
        }
    }

    @Override
    public void updateMWLStatus(ProcedureContext ctx, SPSStatus from) {
        List<MWLItem.IDs> spsIDs = this.ejb.spsOfPatientWithStatus(ctx.getPatient(), from);
        for (MWLItem.IDs spsID : spsIDs) {
            ctx.setSpsID(spsID.scheduledProcedureStepID);
            ctx.setStudyInstanceUID(spsID.studyInstanceUID);
            ctx.setEventActionCode(null);
            ctx.setException(null);
            this.updateMWLStatus(ctx);
        }
    }

    @Override
    public int updateMatchingSPS(SPSStatus spsStatus, Attributes queryKeys, QueryParam queryParam, int mwlFetchSize) {
        return this.ejb.updateMatchingSPS(spsStatus, queryKeys, queryParam, mwlFetchSize);
    }

    public void onMPPS(@Observes MPPSContext ctx) {
        if (ctx.getException() != null) {
            return;
        }
        String mppsStatus = ctx.getAttributes().getString(4194898);
        if (mppsStatus != null) {
            MPPS mergedMPPS = ctx.getMPPS();
            ProcedureContext pCtx = this.createProcedureContext().setAssociation(ctx.getAssociation());
            pCtx.setPatient(mergedMPPS.getPatient());
            pCtx.setSpsStatus(mppsStatus.equals("IN PROGRESS") ? SPSStatus.STARTED : SPSStatus.valueOf((String)mppsStatus));
            pCtx.setMppsUID(mergedMPPS.getSopInstanceUID());
            for (Attributes attrs : mergedMPPS.getAttributes().getSequence(4194928)) {
                pCtx.setSpsID(attrs.getString(0x400009));
                pCtx.setAttributes(attrs);
                if (pCtx.getSpsID() == null) continue;
                this.updateSPSStatus(pCtx, ctx);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSPSStatus(ProcedureContext pCtx, MPPSContext ctx) {
        try {
            this.ejb.updateSPSStatus(pCtx);
        }
        catch (RuntimeException e) {
            block6: {
                try {
                    pCtx.setException(e);
                    LOG.warn(e.getMessage());
                    if (pCtx.getEventActionCode() != null) break block6;
                    pCtx.setStatus(ctx.getAttributes().getString(4194898));
                }
                catch (Throwable throwable) {
                    if (pCtx.getEventActionCode() == null) {
                        pCtx.setStatus(ctx.getAttributes().getString(4194898));
                        pCtx.setEventActionCode(ctx.getDimse() == Dimse.N_CREATE_RQ ? "C" : "U");
                    }
                    this.procedureEvent.fire((Object)pCtx);
                    throw throwable;
                }
                pCtx.setEventActionCode(ctx.getDimse() == Dimse.N_CREATE_RQ ? "C" : "U");
            }
            this.procedureEvent.fire((Object)pCtx);
        }
        if (pCtx.getEventActionCode() == null) {
            pCtx.setStatus(ctx.getAttributes().getString(4194898));
            pCtx.setEventActionCode(ctx.getDimse() == Dimse.N_CREATE_RQ ? "C" : "U");
        }
        this.procedureEvent.fire((Object)pCtx);
    }
}

