/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.procedure.impl;

import java.net.InetAddress;
import java.net.Socket;
import java.util.HashSet;
import java.util.Set;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.Sequence;
import org.dcm4che3.net.Association;
import org.dcm4che3.net.hl7.UnparsedHL7Message;
import org.dcm4che3.util.ReverseDNS;
import org.dcm4chee.arc.conf.ArchiveAEExtension;
import org.dcm4chee.arc.conf.ArchiveHL7ApplicationExtension;
import org.dcm4chee.arc.conf.SPSStatus;
import org.dcm4chee.arc.entity.Patient;
import org.dcm4chee.arc.keycloak.HttpServletRequestInfo;
import org.dcm4chee.arc.procedure.ProcedureContext;

public class ProcedureContextImpl
implements ProcedureContext {
    private HttpServletRequestInfo httpRequest;
    private Socket socket;
    private UnparsedHL7Message hl7msg;
    private Patient patient;
    private String studyInstanceUID;
    private String studyInstanceUIDInstRefs;
    private Attributes attributes;
    private String eventActionCode;
    private Exception exception;
    private String outcomeMsg;
    private String spsID;
    private SPSStatus spsStatus;
    private Association as;
    private Attributes sourceInstanceRefs;
    private Attributes.UpdatePolicy attributeUpdatePolicy = Attributes.UpdatePolicy.OVERWRITE;
    private ArchiveHL7ApplicationExtension arcHL7App;
    private ArchiveAEExtension arcAE;
    private String localAET;
    private String sourceMwlScp;
    private String mppsUID;
    private String status;
    private String linkStrategy;

    @Override
    public ProcedureContext setHttpServletRequest(HttpServletRequestInfo httpRequest) {
        this.httpRequest = httpRequest;
        return this;
    }

    @Override
    public ProcedureContext setAssociation(Association as) {
        this.as = as;
        return this.setSocket(as.getSocket());
    }

    @Override
    public ProcedureContext setSocket(Socket socket) {
        this.socket = socket;
        return this;
    }

    @Override
    public ProcedureContext setHL7Message(UnparsedHL7Message hl7msg) {
        this.hl7msg = hl7msg;
        return this;
    }

    public String toString() {
        return this.httpRequest != null ? this.httpRequest.requesterHost : (this.as != null ? this.as.toString() : (this.socket != null ? this.socket.toString() : this.localAET));
    }

    @Override
    public Patient getPatient() {
        return this.patient;
    }

    @Override
    public void setPatient(Patient patient) {
        this.patient = patient;
    }

    @Override
    public HttpServletRequestInfo getHttpRequest() {
        return this.httpRequest;
    }

    @Override
    public UnparsedHL7Message getUnparsedHL7Message() {
        return this.hl7msg;
    }

    @Override
    public String getRemoteHostName() {
        return this.httpRequest != null ? this.httpRequest.requesterHost : ReverseDNS.hostNameOf((InetAddress)this.socket.getInetAddress());
    }

    @Override
    public String getStudyInstanceUID() {
        return this.studyInstanceUID;
    }

    @Override
    public Attributes getAttributes() {
        return this.attributes;
    }

    @Override
    public void setAttributes(Attributes attrs) {
        this.attributes = attrs;
        this.studyInstanceUID = attrs.getString(0x20000D);
    }

    @Override
    public String getEventActionCode() {
        return this.eventActionCode;
    }

    @Override
    public void setEventActionCode(String eventActionCode) {
        this.eventActionCode = eventActionCode;
    }

    @Override
    public Exception getException() {
        return this.exception;
    }

    @Override
    public void setException(Exception exception) {
        this.exception = exception;
    }

    @Override
    public String getOutcomeMsg() {
        return this.outcomeMsg;
    }

    @Override
    public void setOutcomeMsg(String outcomeMsg) {
        this.outcomeMsg = outcomeMsg;
    }

    @Override
    public void setStudyInstanceUID(String studyUID) {
        this.studyInstanceUID = studyUID;
    }

    @Override
    public Association getAssociation() {
        return this.as;
    }

    @Override
    public String getSpsID() {
        return this.spsID;
    }

    @Override
    public void setSpsID(String spsID) {
        this.spsID = spsID;
    }

    @Override
    public SPSStatus getSpsStatus() {
        return this.spsStatus;
    }

    @Override
    public void setSpsStatus(SPSStatus spsStatus) {
        this.spsStatus = spsStatus;
        this.setStatus(spsStatus.name());
    }

    @Override
    public Attributes getSourceInstanceRefs() {
        return this.sourceInstanceRefs;
    }

    @Override
    public void setSourceInstanceRefs(Attributes sourceInstanceRefs) {
        this.sourceInstanceRefs = sourceInstanceRefs;
    }

    @Override
    public Attributes.UpdatePolicy getAttributeUpdatePolicy() {
        return this.attributeUpdatePolicy;
    }

    @Override
    public void setAttributeUpdatePolicy(Attributes.UpdatePolicy updatePolicy) {
        this.attributeUpdatePolicy = updatePolicy;
    }

    @Override
    public String getLocalAET() {
        return this.localAET;
    }

    @Override
    public void setLocalAET(String localAET) {
        this.localAET = localAET;
    }

    @Override
    public String getSourceMwlScp() {
        return this.sourceMwlScp;
    }

    @Override
    public void setSourceMwlScp(String sourceMwlScp) {
        this.sourceMwlScp = sourceMwlScp;
    }

    @Override
    public ArchiveAEExtension getArchiveAEExtension() {
        return this.arcAE;
    }

    @Override
    public void setArchiveAEExtension(ArchiveAEExtension arcAE) {
        this.arcAE = arcAE;
    }

    @Override
    public ArchiveHL7ApplicationExtension getArchiveHL7AppExtension() {
        return this.arcHL7App;
    }

    @Override
    public void setArchiveHL7AppExtension(ArchiveHL7ApplicationExtension arcHL7App) {
        this.arcHL7App = arcHL7App;
    }

    @Override
    public String getMppsUID() {
        return this.mppsUID;
    }

    @Override
    public void setMppsUID(String mppsUID) {
        this.mppsUID = mppsUID;
    }

    @Override
    public String getStatus() {
        return this.status;
    }

    @Override
    public void setStatus(String status) {
        this.status = status;
    }

    @Override
    public String getLinkStrategy() {
        return this.linkStrategy;
    }

    @Override
    public void setLinkStrategy(String linkStrategy) {
        this.linkStrategy = linkStrategy;
    }

    @Override
    public String getStudyInstanceUIDInstRefs() {
        return this.studyInstanceUIDInstRefs;
    }

    @Override
    public void setStudyInstanceUIDInstRefs(String studyInstanceUIDInstRefs) {
        this.studyInstanceUIDInstRefs = studyInstanceUIDInstRefs;
    }

    @Override
    public Set<String> getSourceSeriesInstanceUIDs() {
        Sequence seq;
        Sequence sequence = seq = this.sourceInstanceRefs != null ? this.sourceInstanceRefs.getSequence(528661) : null;
        if (seq == null) {
            return null;
        }
        HashSet<String> uids = new HashSet<String>(seq.size() * 3 / 4 + 1);
        for (Attributes item : seq) {
            uids.add(item.getString(0x20000E));
        }
        return uids;
    }
}

