/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.pdq.scheduler;

import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.Period;
import java.util.Date;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.dcm4che3.data.Attributes;
import org.dcm4chee.arc.Scheduler;
import org.dcm4chee.arc.conf.ArchiveDeviceExtension;
import org.dcm4chee.arc.conf.Duration;
import org.dcm4chee.arc.conf.PDQServiceDescriptor;
import org.dcm4chee.arc.entity.Patient;
import org.dcm4chee.arc.patient.PatientMgtContext;
import org.dcm4chee.arc.patient.PatientService;
import org.dcm4chee.arc.pdq.PDQService;
import org.dcm4chee.arc.pdq.PDQServiceContext;
import org.dcm4chee.arc.pdq.PDQServiceException;
import org.dcm4chee.arc.pdq.PDQServiceFactory;
import org.dcm4chee.arc.pdq.scheduler.PatientVerificationEJB;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class PatientVerificationScheduler
extends Scheduler {
    private static final Logger LOG = LoggerFactory.getLogger(PatientVerificationScheduler.class);
    @Inject
    private PDQServiceFactory serviceFactory;
    @Inject
    private PatientService patientService;
    @Inject
    private PatientVerificationEJB ejb;

    protected PatientVerificationScheduler() {
        super(Scheduler.Mode.scheduleWithFixedDelay);
    }

    protected Logger log() {
        return LOG;
    }

    protected Duration getPollingInterval() {
        ArchiveDeviceExtension arcDev = (ArchiveDeviceExtension)this.device.getDeviceExtension(ArchiveDeviceExtension.class);
        return arcDev != null && arcDev.getPatientVerificationPDQServiceID() != null ? arcDev.getPatientVerificationPollingInterval() : null;
    }

    protected void execute() {
        int maxRetries;
        Duration interval;
        Period period;
        int fetchSize;
        PDQService pdqService;
        String serviceID;
        ArchiveDeviceExtension arcDev = (ArchiveDeviceExtension)this.device.getDeviceExtension(ArchiveDeviceExtension.class);
        PDQServiceDescriptor descriptor = arcDev.getPDQServiceDescriptor(serviceID = arcDev.getPatientVerificationPDQServiceID());
        if (descriptor == null) {
            LOG.warn("No such PDQ Service: {}", (Object)serviceID);
            return;
        }
        try {
            pdqService = this.serviceFactory.getPDQService(descriptor);
        }
        catch (Exception e) {
            LOG.warn("Failed to initialize {}:\n", (Object)descriptor, (Object)e);
            return;
        }
        boolean adjustIssuerOfPatientID = arcDev.isPatientVerificationAdjustIssuerOfPatientID();
        while (arcDev.getPatientVerificationPollingInterval() != null && this.verifyPatients(pdqService, this.ejb.findByVerificationStatus(Patient.VerificationStatus.UNVERIFIED, fetchSize = arcDev.getPatientVerificationFetchSize()), fetchSize, adjustIssuerOfPatientID)) {
        }
        while (arcDev.getPatientVerificationPollingInterval() != null && (period = arcDev.getPatientVerificationPeriod()) != null) {
            fetchSize = arcDev.getPatientVerificationFetchSize();
            if (this.verifyPatients(pdqService, this.ejb.findByVerificationStatusAndTime(Patient.VerificationStatus.VERIFIED, Timestamp.valueOf(LocalDateTime.now().minus(period)), fetchSize), fetchSize, adjustIssuerOfPatientID)) continue;
        }
        while (arcDev.getPatientVerificationPollingInterval() != null && (period = arcDev.getPatientVerificationPeriodOnNotFound()) != null) {
            fetchSize = arcDev.getPatientVerificationFetchSize();
            if (this.verifyPatients(pdqService, this.ejb.findByVerificationStatusAndTime(Patient.VerificationStatus.NOT_FOUND, Timestamp.valueOf(LocalDateTime.now().minus(period)), fetchSize), fetchSize, adjustIssuerOfPatientID)) continue;
        }
        while (arcDev.getPatientVerificationPollingInterval() != null && (interval = arcDev.getPatientVerificationRetryInterval()) != null && (maxRetries = arcDev.getPatientVerificationMaxRetries()) != 0) {
            fetchSize = arcDev.getPatientVerificationFetchSize();
            if (this.verifyPatients(pdqService, this.ejb.findByVerificationStatusAndTimeAndRetries(Patient.VerificationStatus.VERIFICATION_FAILED, new Date(System.currentTimeMillis() - interval.getSeconds() * 1000L), maxRetries, fetchSize), fetchSize, adjustIssuerOfPatientID)) continue;
        }
    }

    private boolean verifyPatients(PDQService pdqService, List<Patient.IDWithPkAndVerificationStatus> patients, int fetchSize, boolean adjustIssuerOfPatientID) {
        for (Patient.IDWithPkAndVerificationStatus patient : patients) {
            try {
                if (!this.ejb.claimPatientVerification(patient)) continue;
                this.verifyPatient(pdqService, patient, adjustIssuerOfPatientID);
            }
            catch (Exception e) {
                LOG.warn("Verification of {} failed:\n", (Object)patient, (Object)e);
            }
        }
        return patients.size() == fetchSize;
    }

    private void verifyPatient(PDQService pdqService, Patient.IDWithPkAndVerificationStatus patient, boolean adjustIssuerOfPatientID) {
        Attributes attrs;
        PatientMgtContext ctx = this.patientService.createPatientMgtContextScheduler();
        ctx.setPatientID(patient.idWithIssuer);
        ctx.setPDQServiceURI(pdqService.getPDQServiceDescriptor().getPDQServiceURI().toString());
        try {
            PDQServiceContext pdqServiceCtx = new PDQServiceContext(adjustIssuerOfPatientID ? patient.idWithIssuer.withoutIssuer() : patient.idWithIssuer);
            pdqServiceCtx.setSearchMethod(PDQServiceContext.SearchMethod.PatientVerificationScheduler);
            attrs = pdqService.query(pdqServiceCtx);
        }
        catch (PDQServiceException e) {
            ctx.setPatientVerificationStatus(Patient.VerificationStatus.VERIFICATION_FAILED);
            this.patientService.updatePatientStatus(ctx);
            LOG.info("Verification of {} failed against {}\n:", new Object[]{patient, pdqService.getPDQServiceDescriptor(), e});
            return;
        }
        if (attrs == null) {
            ctx.setPatientVerificationStatus(Patient.VerificationStatus.NOT_FOUND);
            this.patientService.updatePatientStatus(ctx);
            LOG.info("{} not found at {} - no verification", (Object)patient, (Object)pdqService.getPDQServiceDescriptor());
            return;
        }
        ctx.setAttributes(attrs);
        ctx.setPatientVerificationStatus(Patient.VerificationStatus.VERIFIED);
        if (adjustIssuerOfPatientID && !ctx.getPatientID().equals((Object)patient.idWithIssuer)) {
            ctx.setPreviousAttributes(patient.idWithIssuer.exportPatientIDWithIssuer(null));
            this.patientService.changePatientID(ctx);
            LOG.info("Updated {} on verification against {}", (Object)patient, (Object)pdqService.getPDQServiceDescriptor());
        } else {
            this.patientService.updatePatient(ctx);
            LOG.info(ctx.getEventActionCode().equals("U") ? "Updated {} on verification against {}" : "Verified {} against {}", (Object)patient, (Object)pdqService.getPDQServiceDescriptor());
        }
    }
}

