/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.pdq.dicom;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.IDWithIssuer;
import org.dcm4che3.net.ApplicationEntity;
import org.dcm4che3.net.Device;
import org.dcm4chee.arc.conf.ArchiveDeviceExtension;
import org.dcm4chee.arc.conf.Entity;
import org.dcm4chee.arc.conf.PDQServiceDescriptor;
import org.dcm4chee.arc.pdq.AbstractPDQService;
import org.dcm4chee.arc.pdq.PDQServiceContext;
import org.dcm4chee.arc.pdq.PDQServiceException;
import org.dcm4chee.arc.query.scu.CFindSCU;

public class DicomPDQService
extends AbstractPDQService {
    private final Device device;
    private final CFindSCU cFindSCU;

    public DicomPDQService(PDQServiceDescriptor descriptor, Device device, CFindSCU cFindSCU) {
        super(descriptor);
        this.device = device;
        this.cFindSCU = cFindSCU;
    }

    public Attributes query(PDQServiceContext ctx) throws PDQServiceException {
        IDWithIssuer pid = ctx.getPatientID();
        return this.descriptor.getEntity() == Entity.Patient ? this.queryPatient(pid) : this.queryStudiesOfPatient(pid);
    }

    private Attributes queryPatient(IDWithIssuer pid) throws PDQServiceException {
        List<Attributes> attrs = this.findPatient(this.localAE(), this.calledAET(), pid, this.returnKeys());
        switch (attrs.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return attrs.get(0);
            }
        }
        throw new PDQServiceException("Patient ID '" + pid + "' not unique at " + this.descriptor);
    }

    private Attributes queryStudiesOfPatient(IDWithIssuer pid) throws PDQServiceException {
        return this.findStudiesOfPatient(this.localAE(), this.calledAET(), pid, DicomPDQService.addStudyDate(this.returnKeys())).stream().max(Comparator.comparing(s -> s.getString(524320, ""))).orElse(null);
    }

    private ApplicationEntity localAE() throws PDQServiceException {
        String aet = this.descriptor.getProperty("LocalAET", null);
        if (aet == null) {
            throw new PDQServiceException("No property 'LocalAET' configured in " + this.descriptor);
        }
        ApplicationEntity ae = this.device.getApplicationEntity(aet, true);
        if (ae == null) {
            throw new PDQServiceException("Device '" + this.device.getDeviceName() + "' does not provide AE '" + aet + "' configured in property 'LocalAET' of " + this.descriptor);
        }
        return ae;
    }

    private String calledAET() {
        return this.descriptor.getPDQServiceURI().getSchemeSpecificPart();
    }

    private int[] returnKeys() {
        return this.descriptor.getSelection().length > 0 ? this.descriptor.getSelection() : ((ArchiveDeviceExtension)this.device.getDeviceExtensionNotNull(ArchiveDeviceExtension.class)).getAttributeFilter(Entity.Patient).getSelection();
    }

    private static int[] addStudyDate(int[] original) {
        int[] result = Arrays.copyOf(original, original.length + 1);
        result[original.length] = 524320;
        return result;
    }

    private List<Attributes> findPatient(ApplicationEntity localAE, String calledAET, IDWithIssuer pid, int[] returnKeys) throws PDQServiceException {
        try {
            return this.cFindSCU.findPatient(localAE, calledAET, 0, pid, returnKeys);
        }
        catch (Exception e) {
            throw new PDQServiceException((Throwable)e);
        }
    }

    private List<Attributes> findStudiesOfPatient(ApplicationEntity localAE, String calledAET, IDWithIssuer pid, int ... returnKeys) throws PDQServiceException {
        try {
            return this.cFindSCU.findStudiesOfPatient(localAE, calledAET, 0, pid, returnKeys);
        }
        catch (Exception e) {
            throw new PDQServiceException((Throwable)e);
        }
    }
}

