/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.pdq;

import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.IDWithIssuer;
import org.dcm4che3.net.hl7.UnparsedHL7Message;
import org.dcm4chee.arc.keycloak.HttpServletRequestInfo;

public class PDQServiceContext {
    private final IDWithIssuer patientID;
    private HttpServletRequestInfo httpServletRequestInfo;
    private SearchMethod searchMethod;
    private UnparsedHL7Message hl7Msg;
    private UnparsedHL7Message rsp;
    private String sendingAppFacility;
    private String receivingAppFacility;
    private Attributes patientAttrs;
    private String fhirWebAppName;
    private String fhirQueryParams;

    public PDQServiceContext(IDWithIssuer patientID) {
        this.patientID = patientID;
    }

    public IDWithIssuer getPatientID() {
        return this.patientID;
    }

    public HttpServletRequestInfo getHttpServletRequestInfo() {
        return this.httpServletRequestInfo;
    }

    public void setHttpServletRequestInfo(HttpServletRequestInfo httpServletRequestInfo) {
        this.httpServletRequestInfo = httpServletRequestInfo;
    }

    public String getSearchMethod() {
        return this.searchMethod.name();
    }

    public void setSearchMethod(SearchMethod searchMethod) {
        this.searchMethod = searchMethod;
    }

    public UnparsedHL7Message getHl7Msg() {
        return this.hl7Msg;
    }

    public void setHl7Msg(UnparsedHL7Message hl7Msg) {
        this.hl7Msg = hl7Msg;
    }

    public UnparsedHL7Message getRsp() {
        return this.rsp;
    }

    public void setRsp(UnparsedHL7Message rsp) {
        this.rsp = rsp;
    }

    public String getSendingAppFacility() {
        return this.sendingAppFacility;
    }

    public void setSendingAppFacility(String sendingAppFacility) {
        this.sendingAppFacility = sendingAppFacility;
    }

    public String getReceivingAppFacility() {
        return this.receivingAppFacility;
    }

    public void setReceivingAppFacility(String receivingAppFacility) {
        this.receivingAppFacility = receivingAppFacility;
    }

    public String getFhirWebAppName() {
        return this.fhirWebAppName;
    }

    public void setFhirWebAppName(String fhirWebAppName) {
        this.fhirWebAppName = fhirWebAppName;
    }

    public String getFhirQueryParams() {
        return this.fhirQueryParams;
    }

    public void setFhirQueryParams(String fhirQueryParams) {
        this.fhirQueryParams = fhirQueryParams;
    }

    public Attributes getPatientAttrs() {
        return this.patientAttrs;
    }

    public void setPatientAttrs(Attributes patientAttrs) {
        this.patientAttrs = patientAttrs;
    }

    public String toString() {
        return "PDQServiceContext[sender=" + this.sendingAppFacility + ", receiver=" + this.receivingAppFacility + ", patientID=" + this.patientID + ", httpServletRequestInfo=" + this.httpServletRequestInfo + ", searchMethod=" + this.searchMethod + "]";
    }

    public static enum SearchMethod {
        ComparePatientDemographics,
        UpdatePatientDemographics,
        QueryPatientDemographics,
        PatientVerificationScheduler;

    }
}

