/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.patient.impl;

import java.net.Socket;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import javax.persistence.criteria.CriteriaQuery;
import org.dcm4che3.data.IDWithIssuer;
import org.dcm4che3.net.Association;
import org.dcm4che3.net.Device;
import org.dcm4che3.net.hl7.HL7Application;
import org.dcm4che3.net.hl7.UnparsedHL7Message;
import org.dcm4che3.util.AttributesFormat;
import org.dcm4chee.arc.conf.ArchiveDeviceExtension;
import org.dcm4chee.arc.entity.Patient;
import org.dcm4chee.arc.entity.Study;
import org.dcm4chee.arc.keycloak.HttpServletRequestInfo;
import org.dcm4chee.arc.patient.CircularPatientMergeException;
import org.dcm4chee.arc.patient.NonUniquePatientException;
import org.dcm4chee.arc.patient.PatientMergedException;
import org.dcm4chee.arc.patient.PatientMgtContext;
import org.dcm4chee.arc.patient.PatientService;
import org.dcm4chee.arc.patient.PatientTrackingNotAllowedException;
import org.dcm4chee.arc.patient.PatientUnmergedException;
import org.dcm4chee.arc.patient.impl.PatientMgtContextImpl;
import org.dcm4chee.arc.patient.impl.PatientServiceEJB;

@ApplicationScoped
public class PatientServiceImpl
implements PatientService {
    @Inject
    private PatientServiceEJB ejb;
    @Inject
    private Device device;
    @Inject
    private Event<PatientMgtContext> patientMgtEvent;

    @Override
    public PatientMgtContext createPatientMgtContextDIMSE(Association as) {
        PatientMgtContextImpl ctx = new PatientMgtContextImpl(this.device);
        ctx.setAssociation(as);
        return ctx;
    }

    @Override
    public PatientMgtContext createPatientMgtContextWEB(HttpServletRequestInfo httpRequest) {
        PatientMgtContextImpl ctx = new PatientMgtContextImpl(this.device);
        ctx.setHttpServletRequestInfo(httpRequest);
        return ctx;
    }

    @Override
    public PatientMgtContext createPatientMgtContextHL7(HL7Application hl7App, Socket socket, UnparsedHL7Message msg) {
        PatientMgtContextImpl ctx = new PatientMgtContextImpl(this.device);
        ctx.setSocket(socket);
        ctx.setUnparsedHL7Message(msg);
        ctx.setHL7Application(hl7App);
        return ctx;
    }

    @Override
    public PatientMgtContext createPatientMgtContextScheduler() {
        return new PatientMgtContextImpl(this.device);
    }

    @Override
    public List<Patient> findPatients(IDWithIssuer pid) {
        return this.ejb.findPatients(pid);
    }

    @Override
    public Patient findPatient(IDWithIssuer pid) {
        return this.ejb.findPatient(pid);
    }

    @Override
    public Patient createPatient(PatientMgtContext ctx) {
        try {
            Patient patient = this.ejb.createPatient(ctx);
            return patient;
        }
        catch (RuntimeException e) {
            ctx.setException(e);
            throw e;
        }
        finally {
            if (ctx.getEventActionCode() != null) {
                this.patientMgtEvent.fire((Object)ctx);
            }
        }
    }

    @Override
    public Patient updatePatient(PatientMgtContext ctx) throws NonUniquePatientException, PatientMergedException {
        try {
            Patient patient;
            while (this.deleteDuplicateCreatedPatient(ctx, patient = this.ejb.updatePatient(ctx))) {
            }
            Patient patient2 = patient;
            return patient2;
        }
        catch (RuntimeException e) {
            ctx.setException(e);
            throw e;
        }
        finally {
            if (ctx.getEventActionCode() != null) {
                this.patientMgtEvent.fire((Object)ctx);
            }
        }
    }

    private boolean deleteDuplicateCreatedPatient(PatientMgtContext ctx, Patient patient) {
        if (ctx.getEventActionCode() == "C" && this.deleteDuplicateCreatedPatient(ctx.getPatientID(), patient, null)) {
            ctx.setEventActionCode("R");
            return true;
        }
        return false;
    }

    @Override
    public synchronized boolean deleteDuplicateCreatedPatient(IDWithIssuer pid, Patient createdPatient, Study createdStudy) {
        return this.ejb.deleteDuplicateCreatedPatient(pid, createdPatient, createdStudy);
    }

    @Override
    public Patient mergePatient(PatientMgtContext ctx) throws NonUniquePatientException, PatientMergedException, CircularPatientMergeException {
        if (ctx.getPatientID().matches(ctx.getPreviousPatientID())) {
            throw new CircularPatientMergeException("PriorPatientID same as target PatientID");
        }
        try {
            Patient patient = this.ejb.mergePatient(ctx);
            return patient;
        }
        catch (RuntimeException e) {
            ctx.setException(e);
            throw e;
        }
        finally {
            if (ctx.getEventActionCode() != null) {
                this.patientMgtEvent.fire((Object)ctx);
            }
        }
    }

    @Override
    public boolean unmergePatient(PatientMgtContext ctx) throws NonUniquePatientException, PatientUnmergedException {
        try {
            boolean bl = this.ejb.unmergePatient(ctx);
            return bl;
        }
        catch (RuntimeException e) {
            ctx.setException(e);
            throw e;
        }
        finally {
            if (ctx.getEventActionCode() != null) {
                this.patientMgtEvent.fire((Object)ctx);
            }
        }
    }

    @Override
    public Patient changePatientID(PatientMgtContext ctx) throws NonUniquePatientException, PatientMergedException, PatientTrackingNotAllowedException {
        if (((ArchiveDeviceExtension)this.device.getDeviceExtensionNotNull(ArchiveDeviceExtension.class)).isHL7TrackChangedPatientID()) {
            if (this.isEitherHavingNoIssuer(ctx)) {
                throw new PatientTrackingNotAllowedException("Either previous or new Patient ID has missing issuer and change patient id tracking is enabled. Disable change patient id tracking feature and retry update");
            }
            if (ctx.getPatientID().equals((Object)ctx.getPreviousPatientID())) {
                throw new CircularPatientMergeException("PriorPatientID same as target PatientID");
            }
            this.createPatient(ctx);
            return this.mergePatient(ctx);
        }
        try {
            Patient patient = this.ejb.changePatientID(ctx);
            return patient;
        }
        catch (RuntimeException e) {
            ctx.setException(e);
            throw e;
        }
        finally {
            if (ctx.getEventActionCode() != null) {
                this.patientMgtEvent.fire((Object)ctx);
            }
        }
    }

    private boolean isEitherHavingNoIssuer(PatientMgtContext ctx) {
        IDWithIssuer prevPatientID = ctx.getPreviousPatientID();
        IDWithIssuer newPatientID = ctx.getPatientID();
        return prevPatientID.getIssuer() == null && newPatientID.getIssuer() != null || prevPatientID.getIssuer() != null && newPatientID.getIssuer() == null;
    }

    @Override
    public Patient findPatient(PatientMgtContext ctx) {
        return this.ejb.findPatient(ctx);
    }

    @Override
    public void deletePatient(PatientMgtContext ctx) {
        this.ejb.deletePatient(ctx.getPatient());
        this.patientMgtEvent.fire((Object)ctx);
    }

    @Override
    public Patient updatePatientStatus(PatientMgtContext ctx) {
        try {
            Patient patient = this.ejb.updatePatientStatus(ctx);
            return patient;
        }
        finally {
            this.patientMgtEvent.fire((Object)ctx);
        }
    }

    @Override
    public List<String> studyInstanceUIDsOf(Patient patient) {
        return this.ejb.studyInstanceUIDsOf(patient);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean supplementIssuer(PatientMgtContext ctx, Patient patient, IDWithIssuer idWithIssuer, Map<IDWithIssuer, Long> ambiguous) {
        try {
            boolean bl = this.ejb.supplementIssuer(ctx, patient, idWithIssuer, ambiguous);
            return bl;
        }
        finally {
            if (ctx.getEventActionCode() != null) {
                this.patientMgtEvent.fire((Object)ctx);
            }
        }
    }

    @Override
    public <T> List<T> queryWithOffsetAndLimit(CriteriaQuery<T> query, int offset, int limit) {
        return this.ejb.queryWithOffsetAndLimit(query, offset, limit);
    }

    @Override
    public <T> T merge(T entity) {
        return this.ejb.merge(entity);
    }

    @Override
    public void testSupplementIssuers(CriteriaQuery<Patient> query, int fetchSize, Set<IDWithIssuer> success, Map<IDWithIssuer, Long> ambiguous, AttributesFormat issuer) {
        this.ejb.testSupplementIssuers(query, fetchSize, success, ambiguous, issuer);
    }
}

