/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.patient.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.ejb.Stateless;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.IDWithIssuer;
import org.dcm4che3.data.Issuer;
import org.dcm4che3.data.VR;
import org.dcm4che3.net.Device;
import org.dcm4che3.util.AttributesFormat;
import org.dcm4chee.arc.conf.ArchiveDeviceExtension;
import org.dcm4chee.arc.conf.ArchiveHL7ApplicationExtension;
import org.dcm4chee.arc.conf.AttributeFilter;
import org.dcm4chee.arc.entity.MPPS;
import org.dcm4chee.arc.entity.MWLItem;
import org.dcm4chee.arc.entity.Patient;
import org.dcm4chee.arc.entity.PatientID;
import org.dcm4chee.arc.entity.PatientID_;
import org.dcm4chee.arc.entity.Study;
import org.dcm4chee.arc.entity.UPS;
import org.dcm4chee.arc.patient.NonUniquePatientException;
import org.dcm4chee.arc.patient.PatientAlreadyExistsException;
import org.dcm4chee.arc.patient.PatientMergedException;
import org.dcm4chee.arc.patient.PatientMgtContext;
import org.dcm4chee.arc.patient.PatientUnmergedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Stateless
public class PatientServiceEJB {
    private static final Logger LOG = LoggerFactory.getLogger(PatientServiceEJB.class);
    @PersistenceContext(unitName="dcm4chee-arc")
    private EntityManager em;
    @Inject
    private Device device;

    public List<Patient> findPatients(IDWithIssuer pid) {
        List<Patient> list = this.em.createNamedQuery("Patient.findByPatientIDEager", Patient.class).setParameter(1, (Object)pid.getID()).getResultList();
        Issuer issuer = pid.getIssuer();
        return issuer != null ? this.removeNonMatchingIssuer(list, issuer) : list;
    }

    private List<Patient> removeNonMatchingIssuer(List<Patient> list, Issuer issuer) {
        Iterator<Patient> it = list.iterator();
        while (it.hasNext()) {
            Issuer other = it.next().getPatientID().getIssuer();
            if (other == null || other.matches(issuer)) continue;
            it.remove();
        }
        if (list.size() > 1) {
            List<Patient> withIssuer = list.stream().filter(patient -> patient.getPatientID().getIssuer() != null).collect(Collectors.toList());
            if (withIssuer.size() > 1) {
                withIssuer.removeIf(patient -> patient.getPatientID().getIssuer().getUniversalEntityID() == null);
            }
            if (!withIssuer.isEmpty()) {
                return withIssuer;
            }
        }
        return list;
    }

    public Patient createPatient(PatientMgtContext ctx) {
        ctx.setEventActionCode("C");
        return this.createPatient(ctx, ctx.getPatientID(), ctx.getAttributes());
    }

    private Patient createPatient(PatientMgtContext ctx, IDWithIssuer patientID, Attributes attributes) {
        Patient patient = new Patient();
        patient.setVerificationStatus(ctx.getPatientVerificationStatus());
        if (ctx.getPatientVerificationStatus() != Patient.VerificationStatus.UNVERIFIED) {
            patient.setVerificationTime(new Date());
        }
        patient.setAttributes(attributes, ctx.getAttributeFilter(), false, ctx.getFuzzyStr());
        patient.setPatientID(this.createPatientID(patientID));
        this.em.persist((Object)patient);
        LOG.info("{}: Create {}", (Object)ctx, (Object)patient);
        return patient;
    }

    public Patient updatePatient(PatientMgtContext ctx) throws NonUniquePatientException, PatientMergedException {
        Patient pat = this.findPatient(ctx.getPatientID());
        if (pat == null) {
            if (ctx.isNoPatientCreate()) {
                this.logSuppressPatientCreate(ctx);
                return null;
            }
            return this.createPatient(ctx);
        }
        this.updatePatient(pat, ctx);
        return pat;
    }

    private void logSuppressPatientCreate(PatientMgtContext ctx) {
        LOG.info("{}: Suppress creation of Patient[id={}] by {}", new Object[]{ctx, ctx.getPatientID(), ctx.getUnparsedHL7Message().msh()});
    }

    public Patient findPatient(IDWithIssuer pid) throws NonUniquePatientException, PatientMergedException {
        List<Patient> list = this.findPatients(pid);
        if (list.isEmpty()) {
            return null;
        }
        if (list.size() > 1) {
            throw new NonUniquePatientException("Multiple Patients with ID " + pid);
        }
        Patient pat = list.get(0);
        Patient mergedWith = pat.getMergedWith();
        if (mergedWith != null) {
            throw new PatientMergedException(pat + " merged with " + mergedWith);
        }
        return pat;
    }

    public boolean unmergePatient(PatientMgtContext ctx) throws NonUniquePatientException, PatientUnmergedException {
        IDWithIssuer pid = ctx.getPatientID();
        List<Patient> list = this.findPatients(pid);
        if (list.isEmpty()) {
            return false;
        }
        if (list.size() > 1) {
            throw new NonUniquePatientException("Multiple Patients with ID : " + pid);
        }
        Patient pat = list.get(0);
        Patient mergedWith = pat.getMergedWith();
        if (mergedWith == null) {
            throw new PatientUnmergedException("Patient is not merged : " + pid);
        }
        ctx.setAttributes(pat.getAttributes());
        ctx.setEventActionCode("C");
        pat.setMergedWith(null);
        return true;
    }

    private void updatePatient(Patient pat, PatientMgtContext ctx) {
        if (ctx.getPatientVerificationStatus() != Patient.VerificationStatus.UNVERIFIED) {
            pat.setVerificationStatus(ctx.getPatientVerificationStatus());
            pat.setVerificationTime(new Date());
            pat.resetFailedVerifications();
        }
        Attributes.UpdatePolicy updatePolicy = ctx.getAttributeUpdatePolicy();
        AttributeFilter filter = ctx.getAttributeFilter();
        Attributes attrs = pat.getAttributes();
        Attributes newAttrs = new Attributes(ctx.getAttributes(), filter.getSelection());
        Attributes modified = new Attributes();
        if (updatePolicy == Attributes.UpdatePolicy.REPLACE) {
            if (attrs.diff(newAttrs, filter.getSelection(false), modified, true) == 0) {
                return;
            }
            newAttrs.addSelected(attrs, null, 67110241);
            attrs = newAttrs;
        } else {
            Attributes.unifyCharacterSets((Attributes[])new Attributes[]{attrs, newAttrs});
            if (!attrs.updateSelected(updatePolicy, newAttrs, modified, filter.getSelection(false))) {
                return;
            }
        }
        if (ctx.getPatientID().getIssuer() != null) {
            PatientID patientID = pat.getPatientID();
            patientID.setIssuer(ctx.getPatientID().getIssuer());
            this.em.merge((Object)patientID);
        }
        ctx.setEventActionCode("U");
        pat.setAttributes(this.recordAttributeModification(ctx) ? attrs.addOriginalAttributes(null, new Date(), "CORRECT", this.device.getDeviceName(), modified) : attrs, filter, true, ctx.getFuzzyStr());
        this.em.createNamedQuery("Series.scheduleMetadataUpdateForPatient").setParameter(1, (Object)pat).executeUpdate();
    }

    public Patient mergePatient(PatientMgtContext ctx) throws NonUniquePatientException, PatientMergedException {
        Patient pat = this.findPatient(ctx.getPatientID());
        Patient prev = this.findPatient(ctx.getPreviousPatientID());
        if (pat == null && prev == null && ctx.isNoPatientCreate()) {
            this.logSuppressPatientCreate(ctx);
            return null;
        }
        if (pat == null) {
            pat = this.createPatient(ctx);
        } else {
            this.updatePatient(pat, ctx);
        }
        if (prev == null) {
            prev = this.createPatient(ctx, ctx.getPreviousPatientID(), ctx.getPreviousAttributes());
            this.suppressMergedPatientDeletionAudit(ctx);
        } else {
            this.moveStudies(ctx, prev, pat);
            this.moveMPPS(prev, pat);
            this.moveMWLItems(prev, pat);
            this.moveUPS(prev, pat);
        }
        if (ctx.getHttpServletRequestInfo() != null) {
            if (pat.getPatientName() != null) {
                ctx.getAttributes().setString(0x100010, VR.PN, pat.getPatientName().toString());
            }
            if (prev.getPatientName() != null) {
                ctx.getPreviousAttributes().setString(0x100010, VR.PN, prev.getPatientName().toString());
            }
        }
        prev.setMergedWith(pat);
        return pat;
    }

    private void suppressMergedPatientDeletionAudit(PatientMgtContext ctx) {
        ctx.setPreviousAttributes(null);
    }

    public Patient changePatientID(PatientMgtContext ctx) throws NonUniquePatientException, PatientMergedException, PatientAlreadyExistsException {
        Patient pat = this.findPatient(ctx.getPreviousPatientID());
        if (pat == null) {
            if (ctx.isNoPatientCreate()) {
                this.logSuppressPatientCreate(ctx);
                return null;
            }
            this.suppressMergedPatientDeletionAudit(ctx);
            return this.createPatient(ctx);
        }
        IDWithIssuer patientID = ctx.getPatientID();
        Patient pat2 = this.findPatient(patientID);
        if (pat2 == null) {
            pat.setPatientID(this.createPatientID(patientID));
        } else if (pat2 == pat) {
            PatientID patientID1 = pat.getPatientID();
            patientID1.setIssuer(patientID.getIssuer());
            this.em.merge((Object)patientID1);
        } else {
            throw new PatientAlreadyExistsException("Patient with Patient ID " + pat2.getPatientID() + "already exists");
        }
        ctx.setEventActionCode("U");
        this.updatePatientAttrs(ctx, pat);
        return pat;
    }

    private void updatePatientAttrs(PatientMgtContext ctx, Patient pat) {
        IDWithIssuer patientID = ctx.getPatientID();
        Attributes patientAttrs = pat.getAttributes();
        Attributes modified = new Attributes(patientAttrs, new int[]{0x100020, 0x100021, 1048612});
        if (patientAttrs.getString(0x100021) != null) {
            Issuer patientIDIssuer = patientID.getIssuer();
            if (patientIDIssuer == null) {
                patientAttrs.remove(0x100021);
                patientAttrs.remove(1048612);
            } else if (patientIDIssuer.getUniversalEntityID() == null) {
                patientAttrs.remove(1048612);
            }
        }
        pat.setAttributes(this.recordAttributeModification(ctx) ? patientID.exportPatientIDWithIssuer(patientAttrs).addOriginalAttributes(null, new Date(), "CORRECT", this.device.getDeviceName(), modified) : patientID.exportPatientIDWithIssuer(patientAttrs), ctx.getAttributeFilter(), true, ctx.getFuzzyStr());
        this.em.createNamedQuery("Series.scheduleMetadataUpdateForPatient").setParameter(1, (Object)pat).executeUpdate();
    }

    public Patient findPatient(PatientMgtContext ctx) {
        Patient pat;
        Patient mergedWith;
        IDWithIssuer patientID = ctx.getPatientID();
        if (patientID == null) {
            LOG.info("{}: No Patient ID in received object", (Object)ctx);
            return null;
        }
        List<Patient> list = this.findPatients(patientID);
        if (patientID.getIssuer() == null && this.getArchiveDeviceExtension().isIdentifyPatientByAllAttributes()) {
            PatientServiceEJB.removeNonMatching(ctx, list);
            if (list.size() > 1) {
                LOG.info("{}: Found {} Patients with ID: {} and matching attributes", new Object[]{ctx, list.size(), patientID});
                return null;
            }
        }
        if (list.isEmpty()) {
            return null;
        }
        if (list.size() > 1) {
            LOG.info("{}: Found {} Patients with ID: {}", new Object[]{ctx, list.size(), patientID});
            PatientServiceEJB.removeNonMatching(ctx, list);
            if (list.size() != 1) {
                return null;
            }
            LOG.info("{}: Select {} with matching attributes", (Object)ctx, (Object)list.get(0));
        }
        if ((mergedWith = (pat = list.get(0)).getMergedWith()) == null) {
            return pat;
        }
        HashSet<Long> patPks = new HashSet<Long>();
        do {
            if (patPks.add(mergedWith.getPk())) continue;
            LOG.warn("{}: Detected circular merged {}", (Object)ctx, (Object)patientID);
            return null;
        } while ((mergedWith = (pat = mergedWith).getMergedWith()) != null);
        return pat;
    }

    private static void removeNonMatching(PatientMgtContext ctx, List<Patient> list) {
        Attributes attrs = ctx.getAttributes();
        int before = list.size();
        list.removeIf(p -> !attrs.matches(p.getAttributes(), false, true));
        int removed = before - list.size();
        if (removed > 0) {
            LOG.info("{}: Found {} Patients with ID: {} but non-matching other attributes", new Object[]{ctx, removed, ctx.getPatientID()});
        }
    }

    private void moveStudies(PatientMgtContext ctx, Patient from, Patient to) {
        this.em.createNamedQuery("Study.findByPatient", Study.class).setParameter(1, (Object)from).getResultList().forEach(study -> {
            Attributes modified = new Attributes();
            from.getAttributes().diff(to.getAttributes(), ctx.getAttributeFilter().getSelection(false), modified);
            study.setPatient(to);
            study.setAttributes(this.recordAttributeModification(ctx) ? study.getAttributes().addOriginalAttributes(null, new Date(), "CORRECT", this.device.getDeviceName(), modified) : study.getAttributes(), ctx.getStudyAttributeFilter(), true, ctx.getFuzzyStr());
            to.incrementNumberOfStudies();
            from.decrementNumberOfStudies();
        });
    }

    private void moveMPPS(Patient from, Patient to) {
        this.em.createNamedQuery("MPPS.findByPatient", MPPS.class).setParameter(1, (Object)from).getResultList().forEach(mpps -> mpps.setPatient(to));
    }

    private void moveMWLItems(Patient from, Patient to) {
        this.em.createNamedQuery("MWLItem.findByPatient", MWLItem.class).setParameter(1, (Object)from).getResultList().forEach(mwl -> mwl.setPatient(to));
    }

    private void moveUPS(Patient from, Patient to) {
        this.em.createNamedQuery("UPS.findByPatient", UPS.class).setParameter(1, (Object)from).getResultList().forEach(ups -> ups.setPatient(to));
    }

    private PatientID createPatientID(IDWithIssuer idWithIssuer) {
        if (idWithIssuer == null) {
            return null;
        }
        PatientID patientID = new PatientID();
        patientID.setID(idWithIssuer.getID());
        patientID.setIssuer(idWithIssuer.getIssuer());
        return patientID;
    }

    public void deletePatient(Patient patient) {
        List patients = this.em.createNamedQuery("Patient.findByMergedWith", Patient.class).setParameter(1, (Object)patient).getResultList();
        for (Patient p : patients) {
            this.deletePatient(p);
        }
        this.removeMPPSMWLUWLAndPatient(patient);
    }

    private void removeMPPSMWLUWLAndPatient(Patient patient) {
        this.em.createNamedQuery("MPPS.deleteByPatient").setParameter(1, (Object)patient).executeUpdate();
        this.em.createNamedQuery("MWLItem.findByPatient", MWLItem.class).setParameter(1, (Object)patient).getResultList().forEach(mwl -> this.em.remove(mwl));
        this.em.createNamedQuery("UPS.findByPatient", UPS.class).setParameter(1, (Object)patient).getResultList().forEach(ups -> this.em.remove(ups));
        this.em.remove(this.em.contains((Object)patient) ? patient : this.em.getReference(Patient.class, (Object)patient.getPk()));
        LOG.info("Successfully removed {} from database along with any of its MPPS, MWLs and UPS", (Object)patient);
    }

    public Patient updatePatientStatus(PatientMgtContext ctx) {
        Patient pat = this.findPatient(ctx.getPatientID());
        if (pat != null) {
            pat.setVerificationStatus(ctx.getPatientVerificationStatus());
            pat.setVerificationTime(new Date());
            if (ctx.getPatientVerificationStatus() == Patient.VerificationStatus.VERIFICATION_FAILED) {
                pat.incrementFailedVerifications();
            } else {
                pat.resetFailedVerifications();
            }
        }
        return pat;
    }

    private boolean recordAttributeModification(PatientMgtContext ctx) {
        return ctx.getArchiveAEExtension() != null ? ctx.getArchiveAEExtension().recordAttributeModification() : (ctx.getHL7Application() != null ? ((ArchiveHL7ApplicationExtension)ctx.getHL7Application().getHL7AppExtensionNotNull(ArchiveHL7ApplicationExtension.class)).recordAttributeModification() : this.getArchiveDeviceExtension().isRecordAttributeModification());
    }

    private ArchiveDeviceExtension getArchiveDeviceExtension() {
        return (ArchiveDeviceExtension)this.device.getDeviceExtensionNotNull(ArchiveDeviceExtension.class);
    }

    public List<String> studyInstanceUIDsOf(Patient patient) {
        return this.em.createNamedQuery("Study.studyIUIDsByPatient", String.class).setParameter(1, (Object)patient).getResultList();
    }

    public boolean supplementIssuer(PatientMgtContext ctx, Patient patient, IDWithIssuer idWithIssuer, Map<IDWithIssuer, Long> ambiguous) {
        Long count = this.countPatientIDWithIssuers(idWithIssuer);
        if (count != null && count != 0L) {
            ambiguous.put(idWithIssuer, count);
            return false;
        }
        PatientID patientID = patient.getPatientID();
        patientID.setIssuer(idWithIssuer.getIssuer());
        this.em.merge((Object)patientID);
        Attributes patAttrs = patient.getAttributes();
        ctx.setAttributes(idWithIssuer.exportPatientIDWithIssuer(patAttrs));
        this.updatePatientAttrs(ctx, patient);
        ctx.setEventActionCode("U");
        this.em.merge((Object)patient);
        return true;
    }

    public Long countPatientIDWithIssuers(IDWithIssuer idWithIssuer) {
        CriteriaBuilder cb = this.em.getCriteriaBuilder();
        CriteriaQuery q = cb.createQuery(Long.class);
        Root patientID = q.from(PatientID.class);
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        predicates.add(cb.equal((Expression)patientID.get(PatientID_.id), (Object)idWithIssuer.getID()));
        Issuer issuer = idWithIssuer.getIssuer();
        String entityID = issuer.getLocalNamespaceEntityID();
        String entityUID = issuer.getUniversalEntityID();
        String entityUIDType = issuer.getUniversalEntityIDType();
        if (entityID == null) {
            predicates.add(cb.equal((Expression)patientID.get(PatientID_.universalEntityID), (Object)entityUID));
            predicates.add(cb.equal((Expression)patientID.get(PatientID_.universalEntityIDType), (Object)entityUIDType));
        } else if (entityUID == null) {
            predicates.add(cb.equal((Expression)patientID.get(PatientID_.localNamespaceEntityID), (Object)entityID));
        } else {
            predicates.add(cb.or((Expression)cb.equal((Expression)patientID.get(PatientID_.localNamespaceEntityID), (Object)entityID), (Expression)cb.and((Expression)cb.equal((Expression)patientID.get(PatientID_.universalEntityID), (Object)entityUID), (Expression)cb.equal((Expression)patientID.get(PatientID_.universalEntityIDType), (Object)entityUIDType))));
        }
        return (Long)this.em.createQuery(q.where(predicates.toArray(new Predicate[0])).select((Selection)cb.count((Expression)patientID))).getSingleResult();
    }

    public <T> List<T> queryWithOffsetAndLimit(CriteriaQuery<T> query, int offset, int limit) {
        return this.em.createQuery(query).setFirstResult(offset).setMaxResults(limit).getResultList();
    }

    public <T> T merge(T entity) {
        return (T)this.em.merge(entity);
    }

    public void testSupplementIssuers(CriteriaQuery<Patient> query, int fetchSize, Set<IDWithIssuer> success, Map<IDWithIssuer, Long> ambiguous, AttributesFormat issuer) {
        try (Stream resultStream = this.em.createQuery(query).setHint("org.hibernate.fetchSize", (Object)fetchSize).getResultStream();){
            resultStream.map(p -> new IDWithIssuer(p.getPatientID().getID(), issuer.format((Object)p.getAttributes()))).collect(Collectors.groupingBy(Function.identity(), Collectors.counting())).forEach((idWithIssuer, count) -> {
                if (count == 1L) {
                    Long countIDWithIssuers = this.countPatientIDWithIssuers((IDWithIssuer)idWithIssuer);
                    if (countIDWithIssuers != null && countIDWithIssuers != 0L) {
                        ambiguous.put((IDWithIssuer)idWithIssuer, countIDWithIssuers);
                    } else {
                        success.add((IDWithIssuer)idWithIssuer);
                    }
                } else {
                    ambiguous.put((IDWithIssuer)idWithIssuer, (Long)count);
                }
            });
        }
    }

    public boolean deleteDuplicateCreatedPatient(IDWithIssuer pid, Patient createdPatient, Study createdStudy) {
        List<Patient> patients = this.findPatients(pid);
        if (patients.size() == 1) {
            LOG.info("No duplicate record with equal Patient ID found {}", (Object)createdPatient);
            return false;
        }
        long createdPatientPk = createdPatient.getPk();
        Optional<Patient> createdPatientFound = patients.stream().filter(p -> p.getPk() == createdPatientPk).findFirst();
        if (!createdPatientFound.isPresent()) {
            LOG.warn("Failed to find created {}", (Object)createdPatient);
            return false;
        }
        byte[] encodedAttrs = createdPatient.getEncodedAttributes();
        Optional<Patient> otherPatientFound = patients.stream().filter(p -> p.getPk() != createdPatientPk && Arrays.equals(p.getEncodedAttributes(), encodedAttrs)).findFirst();
        if (!otherPatientFound.isPresent()) {
            LOG.info("No duplicate record with equal Patient attributes found {}", (Object)createdPatient);
            return false;
        }
        Patient otherPatient = otherPatientFound.get();
        if (otherPatient.getMergedWith() != null) {
            LOG.warn("Keep duplicate created {} because existing {} is circular merged", (Object)createdPatient, (Object)otherPatient);
            return false;
        }
        LOG.info("Delete duplicate created {}", (Object)createdPatient);
        if (createdStudy != null) {
            ((Study)this.em.merge((Object)createdStudy)).setPatient(otherPatient);
            otherPatient.incrementNumberOfStudies();
        }
        this.em.remove((Object)createdPatientFound.get());
        return true;
    }
}

