/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.mpps.impl;

import java.net.InetAddress;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.net.ApplicationEntity;
import org.dcm4che3.net.Association;
import org.dcm4che3.net.Dimse;
import org.dcm4che3.util.ReverseDNS;
import org.dcm4chee.arc.conf.ArchiveAEExtension;
import org.dcm4chee.arc.entity.MPPS;
import org.dcm4chee.arc.mpps.MPPSContext;

public class MPPSContextImpl
implements MPPSContext {
    private final Association as;
    private final ApplicationEntity ae;
    private Attributes attributes;
    private String sopInstanceUID;
    private Dimse dimse;
    private MPPS mpps;
    private Exception exception;

    public MPPSContextImpl(Association as) {
        this.as = as;
        this.ae = as.getApplicationEntity();
    }

    @Override
    public Association getAssociation() {
        return this.as;
    }

    @Override
    public ApplicationEntity getLocalApplicationEntity() {
        return this.ae;
    }

    @Override
    public ArchiveAEExtension getArchiveAEExtension() {
        return (ArchiveAEExtension)this.ae.getAEExtension(ArchiveAEExtension.class);
    }

    @Override
    public String getCalledAET() {
        return this.as.getCalledAET();
    }

    @Override
    public String getCallingAET() {
        return this.as.getCallingAET();
    }

    @Override
    public String getRemoteHostName() {
        return ReverseDNS.hostNameOf((InetAddress)this.as.getSocket().getInetAddress());
    }

    @Override
    public String getLocalHostName() {
        return ReverseDNS.hostNameOf((InetAddress)this.as.getSocket().getLocalAddress());
    }

    @Override
    public String getSopInstanceUID() {
        return this.sopInstanceUID;
    }

    @Override
    public void setSopInstanceUID(String sopInstanceUID) {
        this.sopInstanceUID = sopInstanceUID;
    }

    @Override
    public Attributes getAttributes() {
        return this.attributes;
    }

    @Override
    public void setAttributes(Attributes attrs) {
        this.attributes = attrs;
    }

    @Override
    public Dimse getDimse() {
        return this.dimse;
    }

    @Override
    public void setDimse(Dimse dimse) {
        this.dimse = dimse;
    }

    @Override
    public MPPS getMPPS() {
        return this.mpps;
    }

    @Override
    public void setMPPS(MPPS mpps) {
        this.mpps = mpps;
    }

    @Override
    public Exception getException() {
        return this.exception;
    }

    @Override
    public void setException(Exception exception) {
        this.exception = exception;
    }

    public String toString() {
        return this.as.toString();
    }
}

