/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.metadata;

import java.util.Date;
import java.util.List;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.TemporalType;
import org.dcm4chee.arc.entity.Metadata;
import org.dcm4chee.arc.entity.Series;

@Stateless
public class UpdateMetadataEJB {
    @PersistenceContext(unitName="dcm4chee-arc")
    private EntityManager em;

    public List<Series.MetadataUpdate> findSeriesForScheduledMetadataUpdate(int fetchSize) {
        return this.em.createNamedQuery("Series.scheduledMetadataUpdate", Series.MetadataUpdate.class).setMaxResults(fetchSize).getResultList();
    }

    public boolean claim(Series.MetadataUpdate metadataUpdate) {
        return this.em.createNamedQuery("Series.claimUpdateMetadata").setParameter(1, (Object)metadataUpdate.seriesPk).setParameter(2, (Object)metadataUpdate.scheduledUpdateTime).executeUpdate() > 0;
    }

    public void incrementMetadataUpdateFailures(Long seriesPk, Date time) {
        this.em.createNamedQuery("Series.setMetadataScheduledUpdateTime").setParameter(1, (Object)seriesPk).setParameter(2, time, TemporalType.TIMESTAMP).executeUpdate();
    }

    public void commit(Long seriesPk, Metadata metadata) {
        this.em.persist((Object)metadata);
        this.em.createNamedQuery("Metadata.SetStatusBySeriesPk").setParameter(1, (Object)seriesPk).setParameter(2, (Object)Metadata.Status.TO_DELETE).executeUpdate();
        this.em.createNamedQuery("Series.setMetadata").setParameter(1, (Object)seriesPk).setParameter(2, (Object)metadata).executeUpdate();
    }
}

