/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.keycloak;

import javax.servlet.http.HttpServletRequest;
import org.keycloak.KeycloakSecurityContext;

public class KeycloakContext {
    private final HttpServletRequest request;
    private final KeycloakSecurityContext ksc;

    public static KeycloakContext valueOf(HttpServletRequest request) {
        return new KeycloakContext(request);
    }

    private KeycloakContext(HttpServletRequest req) {
        this.request = req;
        this.ksc = (KeycloakSecurityContext)this.request.getAttribute("org.keycloak.KeycloakSecurityContext");
    }

    public String getUserName() {
        return this.ksc != null ? this.ksc.getToken().getPreferredUsername() : this.request.getRemoteAddr();
    }

    public String getToken() {
        return this.ksc != null ? this.ksc.getTokenString() : null;
    }

    public int getExpiration() {
        return this.ksc != null ? this.ksc.getToken().getExpiration() : 0;
    }

    public boolean isSecured() {
        return this.ksc != null;
    }

    public boolean isUserInRole(String role) {
        return this.ksc != null && this.ksc.getToken().getRealmAccess().isUserInRole(role);
    }

    public String[] getRoles() {
        return this.ksc != null ? this.ksc.getToken().getRealmAccess().getRoles().toArray(new String[0]) : new String[]{};
    }
}

