/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.keycloak;

import java.io.InputStream;
import java.security.PublicKey;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import javax.annotation.Resource;
import javax.enterprise.concurrent.ManagedExecutorService;
import javax.enterprise.concurrent.ManagedScheduledExecutorService;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Invocation;
import org.dcm4che3.net.Device;
import org.dcm4che3.net.KeycloakClient;
import org.dcm4che3.net.WebApplication;
import org.dcm4chee.arc.event.ArchiveServiceEvent;
import org.jboss.resteasy.client.jaxrs.ResteasyClient;
import org.jboss.resteasy.client.jaxrs.ResteasyClientBuilder;
import org.jboss.resteasy.client.jaxrs.ResteasyWebTarget;
import org.keycloak.TokenVerifier;
import org.keycloak.admin.client.Keycloak;
import org.keycloak.admin.client.KeycloakBuilder;
import org.keycloak.admin.client.token.TokenManager;
import org.keycloak.common.util.KeycloakUriBuilder;
import org.keycloak.jose.jwk.JSONWebKeySet;
import org.keycloak.jose.jwk.JWK;
import org.keycloak.jose.jws.JWSInput;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.AccessTokenResponse;
import org.keycloak.util.JWKSUtils;
import org.keycloak.util.JsonSerialization;

@ApplicationScoped
public class AccessTokenRequestor {
    @Inject
    private Device device;
    @Resource
    private ManagedExecutorService executor;
    @Resource
    private ManagedScheduledExecutorService scheduledExecutor;
    private volatile CachedKeycloak cachedKeycloakClient;
    private volatile CachedPublicKey cachedPublicKey;

    public void onArchiveServiceEvent(@Observes ArchiveServiceEvent event) {
        if (event.getType() == ArchiveServiceEvent.Type.RELOADED) {
            this.cachedKeycloakClient = null;
            this.cachedPublicKey = null;
        }
    }

    public AccessTokenWithExpiration getAccessToken2(WebApplication webApp) throws Exception {
        CachedKeycloak tmp = this.toCachedKeycloakClient(webApp);
        TokenManager tokenManager = tmp.keycloak.tokenManager();
        AccessTokenResponse accessToken = tokenManager.getAccessToken();
        return new AccessTokenWithExpiration(accessToken.getToken(), accessToken.getExpiresIn());
    }

    public AccessTokenWithExpiration getAccessToken2(KeycloakClient keycloakClient) throws Exception {
        CachedKeycloak tmp = this.toCachedKeycloakClient(keycloakClient);
        TokenManager tokenManager = tmp.keycloak.tokenManager();
        AccessTokenResponse accessToken = tokenManager.getAccessToken();
        return new AccessTokenWithExpiration(accessToken.getToken(), accessToken.getExpiresIn());
    }

    private CachedKeycloak toCachedKeycloakClient(WebApplication webApp) throws Exception {
        CachedKeycloak tmp = this.cachedKeycloakClient;
        if (tmp == null || !tmp.keycloakID.equals(webApp.getKeycloakClientID())) {
            KeycloakClient keycloakClient = webApp.getKeycloakClient();
            if (keycloakClient == null) {
                throw new IllegalArgumentException("No Keycloak Client configured with ID:" + webApp.getKeycloakClientID());
            }
            this.cachedKeycloakClient = tmp = new CachedKeycloak(keycloakClient.getKeycloakClientID(), this.toKeycloak(keycloakClient));
        }
        return tmp;
    }

    private CachedKeycloak toCachedKeycloakClient(KeycloakClient kc) throws Exception {
        CachedKeycloak tmp = this.cachedKeycloakClient;
        if (tmp == null || !tmp.keycloakID.equals(kc.getKeycloakClientID())) {
            this.cachedKeycloakClient = tmp = new CachedKeycloak(kc.getKeycloakClientID(), this.toKeycloak(kc));
        }
        return tmp;
    }

    public ResteasyClientBuilder resteasyClientBuilder(String url, boolean allowAnyHostname, boolean disableTrustManager) throws Exception {
        ResteasyClientBuilder builder = (ResteasyClientBuilder)ClientBuilder.newBuilder();
        if (url.toLowerCase().startsWith("https")) {
            builder.sslContext(this.device.sslContext()).hostnameVerification(allowAnyHostname ? ResteasyClientBuilder.HostnameVerificationPolicy.ANY : ResteasyClientBuilder.HostnameVerificationPolicy.WILDCARD);
            if (disableTrustManager) {
                builder.disableTrustManager();
            }
        }
        builder.executorService((ExecutorService)this.executor);
        builder.scheduledExecutorService((ScheduledExecutorService)this.scheduledExecutor);
        return builder;
    }

    public boolean verifyUsernamePasscode(KeycloakClient kc, String role) throws Exception {
        try (Keycloak keycloak = this.toKeycloak(kc);){
            TokenManager tokenManager = keycloak.tokenManager();
            JWSInput jws = new JWSInput(tokenManager.getAccessToken().getToken());
            AccessToken token = (AccessToken)jws.readJsonContent(AccessToken.class);
            boolean bl = role == null || token.getRealmAccess().isUserInRole(role);
            return bl;
        }
    }

    private Keycloak toKeycloak(KeycloakClient kc) throws Exception {
        return KeycloakBuilder.builder().serverUrl(kc.getKeycloakServerURL()).realm(kc.getKeycloakRealm()).clientId(kc.getKeycloakClientID()).clientSecret(kc.getKeycloakClientSecret()).username(kc.getUserID()).password(kc.getPassword()).grantType(kc.getKeycloakGrantType().name()).resteasyClient((Client)this.resteasyClientBuilder(kc.getKeycloakServerURL(), kc.isTLSAllowAnyHostname(), kc.isTLSDisableTrustManager()).build()).build();
    }

    public boolean verifyJWT(String tokenString, KeycloakClient kc, String role) throws Exception {
        String serverURL = kc.getKeycloakServerURL();
        String realmName = kc.getKeycloakRealm();
        KeycloakUriBuilder authUrlBuilder = KeycloakUriBuilder.fromUri((String)serverURL);
        String jwksUrl = authUrlBuilder.clone().path("/realms/{realm-name}/protocol/openid-connect/certs").build(new Object[]{realmName}).toString();
        String realmUrl = authUrlBuilder.clone().path("/realms/{realm-name}").build(new Object[]{realmName}).toString();
        TokenVerifier tokenVerifier = TokenVerifier.create((String)tokenString, AccessToken.class);
        tokenVerifier.withDefaultChecks().realmUrl(realmUrl);
        String kid = tokenVerifier.getHeader().getKeyId();
        PublicKey publicKey = this.getPublicKey(kid, jwksUrl, kc);
        tokenVerifier.publicKey(publicKey);
        tokenVerifier.verify();
        return role == null || ((AccessToken)tokenVerifier.getToken()).getRealmAccess().isUserInRole(role);
    }

    private PublicKey getPublicKey(String kid, String jwksUrl, KeycloakClient kc) throws Exception {
        CachedPublicKey tmp = this.cachedPublicKey;
        if (tmp != null && tmp.jwksUrl.equals(jwksUrl) && tmp.kid.equals(kid)) {
            return tmp.key;
        }
        try (ResteasyClient client = this.resteasyClientBuilder(kc.getKeycloakServerURL(), kc.isTLSAllowAnyHostname(), kc.isTLSDisableTrustManager()).build();){
            PublicKey publicKey;
            block11: {
                ResteasyWebTarget target = client.target(jwksUrl);
                Invocation.Builder request = target.request();
                InputStream is = (InputStream)request.get(InputStream.class);
                try {
                    JSONWebKeySet jwks = (JSONWebKeySet)JsonSerialization.readValue((InputStream)is, JSONWebKeySet.class);
                    Map publicKeys = JWKSUtils.getKeysForUse((JSONWebKeySet)jwks, (JWK.Use)JWK.Use.SIG);
                    PublicKey publicKey2 = (PublicKey)publicKeys.get(kid);
                    if (publicKey2 != null) {
                        this.cachedPublicKey = new CachedPublicKey(jwksUrl, kid, publicKey2);
                    }
                    publicKey = publicKey2;
                    if (is == null) break block11;
                }
                catch (Throwable throwable) {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                is.close();
            }
            return publicKey;
        }
    }

    private static class CachedPublicKey {
        final String jwksUrl;
        final String kid;
        final PublicKey key;

        private CachedPublicKey(String jwksUrl, String kid, PublicKey key) {
            this.jwksUrl = jwksUrl;
            this.kid = kid;
            this.key = key;
        }
    }

    public static class AccessTokenWithExpiration {
        final String token;
        final long expiration;

        AccessTokenWithExpiration(String tokenStr, long expiresIn) {
            this.token = tokenStr;
            this.expiration = expiresIn;
        }

        public String getToken() {
            return this.token;
        }

        public long getExpiration() {
            return this.expiration;
        }
    }

    private static class CachedKeycloak {
        final String keycloakID;
        final Keycloak keycloak;

        CachedKeycloak(String keycloakID, Keycloak keycloak) {
            this.keycloakID = keycloakID;
            this.keycloak = keycloak;
        }
    }
}

