/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.iocm.rs;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import javax.json.Json;
import javax.json.stream.JsonGenerator;
import javax.json.stream.JsonParsingException;
import javax.servlet.http.HttpServletRequest;
import javax.validation.constraints.Pattern;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.IDWithIssuer;
import org.dcm4che3.data.Issuer;
import org.dcm4che3.data.VR;
import org.dcm4che3.json.JSONReader;
import org.dcm4che3.net.ApplicationEntity;
import org.dcm4che3.net.Device;
import org.dcm4che3.net.WebApplication;
import org.dcm4che3.net.service.QueryRetrieveLevel2;
import org.dcm4chee.arc.conf.ArchiveAEExtension;
import org.dcm4chee.arc.conf.ArchiveDeviceExtension;
import org.dcm4chee.arc.entity.ExpirationState;
import org.dcm4chee.arc.entity.Patient;
import org.dcm4chee.arc.keycloak.HttpServletRequestInfo;
import org.dcm4chee.arc.keycloak.KeycloakContext;
import org.dcm4chee.arc.query.Query;
import org.dcm4chee.arc.query.QueryContext;
import org.dcm4chee.arc.query.QueryService;
import org.dcm4chee.arc.query.RunInTransaction;
import org.dcm4chee.arc.query.util.QueryAttributes;
import org.dcm4chee.arc.query.util.QueryParam;
import org.dcm4chee.arc.study.StudyMgtContext;
import org.dcm4chee.arc.study.StudyService;
import org.dcm4chee.arc.validation.ParseDateTime;
import org.dcm4chee.arc.validation.constraints.InvokeValidate;
import org.dcm4chee.arc.validation.constraints.ValidValueOf;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequestScoped
@Path(value="aets/{AETitle}/rs")
@InvokeValidate(type=UpdateMatchingRS.class)
public class UpdateMatchingRS {
    private static final Logger LOG = LoggerFactory.getLogger(UpdateMatchingRS.class);
    private static final String SUPER_USER_ROLE = "super-user-role";
    @PathParam(value="AETitle")
    private String aet;
    @Context
    private HttpServletRequest request;
    @Context
    private UriInfo uriInfo;
    @Inject
    private Device device;
    @Inject
    private QueryService queryService;
    @Inject
    private StudyService studyService;
    @Inject
    private RunInTransaction runInTx;
    @javax.ws.rs.QueryParam(value="batchID")
    private String batchID;
    @javax.ws.rs.QueryParam(value="scheduledTime")
    @ValidValueOf(type=ParseDateTime.class)
    private String scheduledTime;
    @javax.ws.rs.QueryParam(value="fuzzymatching")
    @Pattern(regexp="true|false")
    private @Pattern(regexp="true|false") String fuzzymatching;
    @javax.ws.rs.QueryParam(value="incomplete")
    @Pattern(regexp="true|false")
    private @Pattern(regexp="true|false") String incomplete;
    @javax.ws.rs.QueryParam(value="retrievefailed")
    @Pattern(regexp="true|false")
    private @Pattern(regexp="true|false") String retrievefailed;
    @javax.ws.rs.QueryParam(value="ExpirationDate")
    private String expirationDate;
    @javax.ws.rs.QueryParam(value="storageVerificationFailed")
    @Pattern(regexp="true|false")
    private @Pattern(regexp="true|false") String storageVerificationFailed;
    @javax.ws.rs.QueryParam(value="metadataUpdateFailed")
    @Pattern(regexp="true|false")
    private @Pattern(regexp="true|false") String metadataUpdateFailed;
    @javax.ws.rs.QueryParam(value="compressionfailed")
    @Pattern(regexp="true|false")
    private @Pattern(regexp="true|false") String compressionfailed;
    @javax.ws.rs.QueryParam(value="ExternalRetrieveAET")
    private String externalRetrieveAET;
    @javax.ws.rs.QueryParam(value="ExternalRetrieveAET!")
    private String externalRetrieveAETNot;
    @javax.ws.rs.QueryParam(value="patientVerificationStatus")
    @Pattern(regexp="UNVERIFIED|VERIFIED|NOT_FOUND|VERIFICATION_FAILED")
    private @Pattern(regexp="UNVERIFIED|VERIFIED|NOT_FOUND|VERIFICATION_FAILED") String patientVerificationStatus;
    @javax.ws.rs.QueryParam(value="storageID")
    private String storageID;
    @javax.ws.rs.QueryParam(value="storageClustered")
    @Pattern(regexp="true|false")
    private @Pattern(regexp="true|false") String storageClustered;
    @javax.ws.rs.QueryParam(value="storageExported")
    @Pattern(regexp="true|false")
    private @Pattern(regexp="true|false") String storageExported;
    @javax.ws.rs.QueryParam(value="allOfModalitiesInStudy")
    @Pattern(regexp="true|false")
    private @Pattern(regexp="true|false") String allOfModalitiesInStudy;
    @javax.ws.rs.QueryParam(value="StudySizeInKB")
    @Pattern(regexp="\\d{1,6}(-\\d{0,6})?|-\\d{1,6}")
    private @Pattern(regexp="\\d{1,6}(-\\d{0,6})?|-\\d{1,6}") String studySizeInKB;
    @javax.ws.rs.QueryParam(value="ExpirationState")
    @Pattern(regexp="UPDATEABLE|FROZEN|REJECTED|EXPORT_SCHEDULED|FAILED_TO_EXPORT|FAILED_TO_REJECT")
    private @Pattern(regexp="UPDATEABLE|FROZEN|REJECTED|EXPORT_SCHEDULED|FAILED_TO_EXPORT|FAILED_TO_REJECT") String expirationState;
    @javax.ws.rs.QueryParam(value="updatePolicy")
    @DefaultValue(value="OVERWRITE")
    @Pattern(regexp="SUPPLEMENT|MERGE|OVERWRITE")
    private @Pattern(regexp="SUPPLEMENT|MERGE|OVERWRITE") String updatePolicyName;
    @javax.ws.rs.QueryParam(value="reasonForModification")
    @Pattern(regexp="COERCE|CORRECT")
    private @Pattern(regexp="COERCE|CORRECT") String reasonForModification;
    @javax.ws.rs.QueryParam(value="sourceOfPreviousValues")
    private String sourceOfPreviousValues;
    private QueryAttributes queryAttrs;

    private static Boolean parseBoolean(String s) {
        return s != null ? Boolean.valueOf(s) : null;
    }

    @POST
    @Path(value="/studies/update")
    @Consumes(value={"application/dicom+json,application/json"})
    @Produces(value={"application/json"})
    public Response updateMatchingStudies(InputStream in) {
        return this.updateMatching(this.aet, "updateMatchingStudies", QueryRetrieveLevel2.STUDY, null, in);
    }

    @POST
    @Path(value="/series/update")
    @Produces(value={"application/json"})
    public Response updateMatchingSeries(InputStream in) {
        return this.updateMatching(this.aet, "updateMatchingSeries", QueryRetrieveLevel2.SERIES, null, in);
    }

    @POST
    @Path(value="/studies/{StudyInstanceUID}/series/update")
    @Produces(value={"application/json"})
    public Response updateMatchingSeriesOfStudy(@PathParam(value="StudyInstanceUID") String studyInstanceUID, InputStream in) {
        return this.updateMatching(this.aet, "updateMatchingSeriesOfStudy", QueryRetrieveLevel2.SERIES, studyInstanceUID, in);
    }

    public String toString() {
        String requestURI = this.request.getRequestURI();
        String queryString = this.request.getQueryString();
        return queryString == null ? requestURI : requestURI + "?" + queryString;
    }

    public void validate() {
        this.logRequest();
        this.queryAttrs = new QueryAttributes(this.uriInfo, null);
    }

    private Attributes toAttributes(InputStream in) {
        try {
            return new JSONReader(Json.createParser((Reader)new InputStreamReader(in, StandardCharsets.UTF_8))).readDataset(null);
        }
        catch (JsonParsingException e) {
            throw new WebApplicationException(this.errResponse(e.getMessage() + " at location : " + e.getLocation(), Response.Status.BAD_REQUEST));
        }
        catch (Exception e) {
            throw new WebApplicationException(this.errResponseAsTextPlain(this.exceptionAsString(e), Response.Status.INTERNAL_SERVER_ERROR));
        }
    }

    Response updateMatching(String aet, String method, QueryRetrieveLevel2 qrlevel, String studyInstanceUID, InputStream in) {
        ArchiveAEExtension arcAE = this.getArchiveAE();
        if (arcAE == null) {
            return this.errResponse("No such Application Entity: " + aet, Response.Status.NOT_FOUND);
        }
        this.validateAcceptedUserRoles(arcAE);
        ApplicationEntity ae = arcAE.getApplicationEntity();
        if (aet.equals(ae.getAETitle())) {
            this.validateWebAppServiceClass();
        }
        StudyMgtContext studyMgtCtx = this.studyService.createStudyMgtContextWEB(HttpServletRequestInfo.valueOf((HttpServletRequest)this.request), arcAE.getApplicationEntity());
        studyMgtCtx.setReasonForModification(this.reasonForModification);
        studyMgtCtx.setSourceOfPreviousValues(this.sourceOfPreviousValues);
        Attributes attrs = new Attributes(this.toAttributes(in), (qrlevel == QueryRetrieveLevel2.STUDY ? studyMgtCtx.getStudyAttributeFilter() : studyMgtCtx.getSeriesAttributeFilter()).getSelection());
        QueryContext ctx = this.queryContext(method, qrlevel, studyInstanceUID, ae);
        try (Query query = this.queryService.createQuery(ctx);){
            int queryMaxNumberOfResults = ctx.getArchiveAEExtension().queryMaxNumberOfResults();
            if (queryMaxNumberOfResults > 0 && !ctx.containsUniqueKey() && query.fetchCount() > (long)queryMaxNumberOfResults) {
                Response response = this.errResponse("Request entity too large", Response.Status.BAD_REQUEST);
                return response;
            }
            UpdateMatchingEntities updateMatchingObjects = new UpdateMatchingEntities(aet, attrs, qrlevel, studyMgtCtx, query);
            this.runInTx.execute((Runnable)updateMatchingObjects);
            Response response = updateMatchingObjects.buildResponse();
            return response;
        }
    }

    private void logRequest() {
        LOG.info("Process {} {} from {}@{}", new Object[]{this.request.getMethod(), this.toString(), this.request.getRemoteUser(), this.request.getRemoteHost()});
    }

    private QueryContext queryContext(String method, QueryRetrieveLevel2 qrlevel, String studyInstanceUID, ApplicationEntity ae) {
        QueryContext ctx = this.queryService.newQueryContextQIDO(HttpServletRequestInfo.valueOf((HttpServletRequest)this.request), method, this.aet, ae, this.queryParam(ae));
        ctx.setQueryRetrieveLevel(qrlevel);
        QueryAttributes queryAttrs = new QueryAttributes(this.uriInfo, null);
        Attributes keys = queryAttrs.getQueryKeys();
        IDWithIssuer idWithIssuer = IDWithIssuer.pidOf((Attributes)keys);
        if (idWithIssuer != null && !idWithIssuer.getID().equals("*")) {
            ctx.setPatientIDs(new IDWithIssuer[]{idWithIssuer});
        } else if (ctx.getArchiveAEExtension().filterByIssuerOfPatientID()) {
            ctx.setIssuerOfPatientID(Issuer.fromIssuerOfPatientID((Attributes)keys));
        }
        if (studyInstanceUID != null) {
            keys.setString(0x20000D, VR.UI, studyInstanceUID);
        }
        ctx.setQueryKeys(keys);
        return ctx;
    }

    private QueryParam queryParam(ApplicationEntity ae) {
        QueryParam queryParam = new QueryParam(ae);
        queryParam.setCombinedDatetimeMatching(true);
        queryParam.setFuzzySemanticMatching(Boolean.parseBoolean(this.fuzzymatching));
        queryParam.setAllOfModalitiesInStudy(Boolean.parseBoolean(this.allOfModalitiesInStudy));
        queryParam.setIncomplete(Boolean.parseBoolean(this.incomplete));
        queryParam.setRetrieveFailed(Boolean.parseBoolean(this.retrievefailed));
        queryParam.setStorageVerificationFailed(Boolean.parseBoolean(this.storageVerificationFailed));
        queryParam.setMetadataUpdateFailed(Boolean.parseBoolean(this.metadataUpdateFailed));
        queryParam.setCompressionFailed(Boolean.parseBoolean(this.compressionfailed));
        queryParam.setExternalRetrieveAET(this.externalRetrieveAET);
        queryParam.setExternalRetrieveAETNot(this.externalRetrieveAETNot);
        queryParam.setExpirationDate(this.expirationDate);
        if (this.patientVerificationStatus != null) {
            queryParam.setPatientVerificationStatus(Patient.VerificationStatus.valueOf((String)this.patientVerificationStatus));
        }
        if (this.storageID != null) {
            queryParam.setStudyStorageIDs(this.arcDev().getStudyStorageIDs(this.storageID, UpdateMatchingRS.parseBoolean(this.storageClustered), UpdateMatchingRS.parseBoolean(this.storageExported)));
        }
        queryParam.setStudySizeRange(this.studySizeInKB);
        if (this.expirationState != null) {
            queryParam.setExpirationState(new ExpirationState[]{ExpirationState.valueOf((String)this.expirationState)});
        }
        return queryParam;
    }

    private ArchiveDeviceExtension arcDev() {
        return (ArchiveDeviceExtension)this.device.getDeviceExtensionNotNull(ArchiveDeviceExtension.class);
    }

    private Response errResponse(String msg, Response.Status status) {
        return this.errResponseAsTextPlain("{\"errorMessage\":\"" + msg + "\"}", status);
    }

    private Response errResponseAsTextPlain(String errorMsg, Response.Status status) {
        LOG.warn("Response {} caused by {}", (Object)status, (Object)errorMsg);
        return Response.status((Response.Status)status).entity((Object)errorMsg).type("text/plain").build();
    }

    private String exceptionAsString(Exception e) {
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    private void validateAcceptedUserRoles(ArchiveAEExtension arcAE) {
        KeycloakContext keycloakContext = KeycloakContext.valueOf((HttpServletRequest)this.request);
        if (keycloakContext.isSecured() && !keycloakContext.isUserInRole(System.getProperty(SUPER_USER_ROLE)) && !arcAE.isAcceptedUserRole(keycloakContext.getRoles())) {
            throw new WebApplicationException("Application Entity " + arcAE.getApplicationEntity().getAETitle() + " does not list role of accessing user", Response.Status.FORBIDDEN);
        }
    }

    private void validateWebAppServiceClass() {
        this.device.getWebApplications().stream().filter(webApp -> this.request.getRequestURI().startsWith(webApp.getServicePath()) && Arrays.asList(webApp.getServiceClasses()).contains(WebApplication.ServiceClass.DCM4CHEE_ARC_AET)).findFirst().orElseThrow(() -> new WebApplicationException(this.errResponse("No Web Application with DCM4CHEE_ARC_AET service class found for Application Entity: " + this.aet, Response.Status.NOT_FOUND)));
    }

    private ArchiveAEExtension getArchiveAE() {
        ApplicationEntity ae = this.device.getApplicationEntity(this.aet, true);
        return ae == null || !ae.isInstalled() ? null : (ArchiveAEExtension)ae.getAEExtensionNotNull(ArchiveAEExtension.class);
    }

    class UpdateMatchingEntities
    implements Runnable {
        private final StudyMgtContext studyMgtCtx;
        private final Attributes.UpdatePolicy updatePolicy;
        private final String aet;
        private final Attributes attrs;
        private final QueryRetrieveLevel2 qrLevel;
        private final Query query;
        private int count;
        private int updated;
        private int failed;
        private Exception ex;

        UpdateMatchingEntities(String aet, Attributes attrs, QueryRetrieveLevel2 qrLevel, StudyMgtContext studyMgtCtx, Query query) {
            this.aet = aet;
            this.attrs = attrs;
            this.qrLevel = qrLevel;
            this.studyMgtCtx = studyMgtCtx;
            this.query = query;
            this.updatePolicy = Attributes.UpdatePolicy.valueOf((String)UpdateMatchingRS.this.updatePolicyName);
        }

        int getCount() {
            return this.count;
        }

        Exception getException() {
            return this.ex;
        }

        @Override
        public void run() {
            try {
                this.query.executeQuery(UpdateMatchingRS.this.arcDev().getQueryFetchSize());
                while (this.query.hasMoreMatches()) {
                    Attributes match = this.query.nextMatch();
                    if (match == null) continue;
                    Attributes.unifyCharacterSets((Attributes[])new Attributes[]{match, this.attrs});
                    if (match.update(this.updatePolicy, this.attrs, null)) {
                        try {
                            this.studyMgtCtx.setPatient(null);
                            this.studyMgtCtx.setAttributes(match);
                            if (this.qrLevel == QueryRetrieveLevel2.STUDY) {
                                UpdateMatchingRS.this.studyService.updateStudy(this.studyMgtCtx);
                            } else {
                                assert (this.qrLevel == QueryRetrieveLevel2.SERIES);
                                UpdateMatchingRS.this.studyService.updateSeries(this.studyMgtCtx);
                            }
                            ++this.updated;
                        }
                        catch (Exception e) {
                            this.ex = e;
                            ++this.failed;
                        }
                    }
                    ++this.count;
                }
            }
            catch (Exception e) {
                this.ex = e;
            }
        }

        Response buildResponse() {
            if (this.count == 0) {
                return this.ex == null ? Response.noContent().build() : UpdateMatchingRS.this.errResponse(this.ex.getMessage(), Response.Status.INTERNAL_SERVER_ERROR);
            }
            return Response.status((Response.Status)(this.failed == 0 ? Response.Status.OK : (this.updated > 0 ? Response.Status.ACCEPTED : Response.Status.CONFLICT))).entity(this::writeTo).build();
        }

        private void writeTo(OutputStream out) {
            JsonGenerator gen = Json.createGenerator((OutputStream)out);
            gen.writeStartObject();
            gen.write("count", this.count);
            if (this.updated > 0) {
                gen.write("updated", this.updated);
            }
            if (this.failed > 0) {
                gen.write("failed", this.failed);
            }
            if (this.ex != null) {
                gen.write("error", this.ex.getMessage());
            }
            gen.writeEnd();
            gen.flush();
        }
    }
}

