/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.iocm.rs;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.function.IntFunction;
import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import javax.json.Json;
import javax.json.stream.JsonGenerator;
import javax.servlet.http.HttpServletRequest;
import javax.validation.constraints.Pattern;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import javax.ws.rs.core.UriInfo;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.Code;
import org.dcm4che3.data.VR;
import org.dcm4che3.json.JSONWriter;
import org.dcm4che3.net.ApplicationEntity;
import org.dcm4che3.net.Device;
import org.dcm4che3.net.WebApplication;
import org.dcm4che3.net.service.DicomServiceException;
import org.dcm4che3.util.StringUtils;
import org.dcm4chee.arc.conf.ArchiveAEExtension;
import org.dcm4chee.arc.conf.ArchiveDeviceExtension;
import org.dcm4chee.arc.conf.Entity;
import org.dcm4chee.arc.conf.RSOperation;
import org.dcm4chee.arc.conf.RejectionNote;
import org.dcm4chee.arc.delete.RejectionService;
import org.dcm4chee.arc.entity.MWLItem;
import org.dcm4chee.arc.iocm.rs.IocmUtils;
import org.dcm4chee.arc.keycloak.HttpServletRequestInfo;
import org.dcm4chee.arc.keycloak.KeycloakContext;
import org.dcm4chee.arc.procedure.ProcedureContext;
import org.dcm4chee.arc.procedure.ProcedureService;
import org.dcm4chee.arc.query.QueryService;
import org.dcm4chee.arc.query.util.QueryAttributes;
import org.dcm4chee.arc.retrieve.RetrieveService;
import org.dcm4chee.arc.rs.client.RSForward;
import org.dcm4chee.arc.store.StoreService;
import org.dcm4chee.arc.store.StoreSession;
import org.dcm4chee.arc.validation.ParseDateTime;
import org.dcm4chee.arc.validation.constraints.InvokeValidate;
import org.dcm4chee.arc.validation.constraints.ValidValueOf;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequestScoped
@Path(value="aets/{AETitle}/rs")
@InvokeValidate(type=IocmRS.class)
public class IocmRS {
    private static final Logger LOG = LoggerFactory.getLogger(IocmRS.class);
    private static final String SUPER_USER_ROLE = "super-user-role";
    @Inject
    private Device device;
    @Inject
    private QueryService queryService;
    @Inject
    private RetrieveService retrieveService;
    @Inject
    private StoreService storeService;
    @Inject
    private RejectionService rejectionService;
    @Inject
    private RSForward rsForward;
    @Inject
    private ProcedureService procedureService;
    @PathParam(value="AETitle")
    private String aet;
    @QueryParam(value="queue")
    private boolean queue;
    @QueryParam(value="batchID")
    private String batchID;
    @QueryParam(value="scheduledTime")
    @ValidValueOf(type=ParseDateTime.class)
    private String scheduledTime;
    @Context
    private HttpServletRequest request;
    @Context
    private UriInfo uriInfo;
    private Attributes coerceAttrs;

    public String toString() {
        String requestURI = this.request.getRequestURI();
        String queryString = this.request.getQueryString();
        return queryString == null ? requestURI : requestURI + "?" + queryString;
    }

    @POST
    @Path(value="/studies/{StudyUID}/reject/{CodeValue}^{CodingSchemeDesignator}")
    @Produces(value={"application/json"})
    public Response rejectStudy(@PathParam(value="StudyUID") String studyUID, @PathParam(value="CodeValue") String codeValue, @PathParam(value="CodingSchemeDesignator") String designator) {
        return this.reject(RSOperation.RejectStudy, studyUID, null, null, codeValue, designator);
    }

    @POST
    @Path(value="/studies/{StudyUID}/series/{SeriesUID}/reject/{CodeValue}^{CodingSchemeDesignator}")
    @Produces(value={"application/json"})
    public Response rejectSeries(@PathParam(value="StudyUID") String studyUID, @PathParam(value="SeriesUID") String seriesUID, @PathParam(value="CodeValue") String codeValue, @PathParam(value="CodingSchemeDesignator") String designator) {
        return this.reject(RSOperation.RejectSeries, studyUID, seriesUID, null, codeValue, designator);
    }

    @POST
    @Path(value="/studies/{StudyUID}/series/{SeriesUID}/instances/{ObjectUID}/reject/{CodeValue}^{CodingSchemeDesignator}")
    @Produces(value={"application/json"})
    public Response rejectInstance(@PathParam(value="StudyUID") String studyUID, @PathParam(value="SeriesUID") String seriesUID, @PathParam(value="ObjectUID") String objectUID, @PathParam(value="CodeValue") String codeValue, @PathParam(value="CodingSchemeDesignator") String designator) {
        return this.reject(RSOperation.RejectInstance, studyUID, seriesUID, objectUID, codeValue, designator);
    }

    @POST
    @Path(value="/studies/{StudyUID}/copy")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response copyInstances(@PathParam(value="StudyUID") String studyUID, InputStream in) {
        return this.copyOrMoveInstances(studyUID, in, null, null);
    }

    @POST
    @Path(value="/studies/{StudyUID}/move/{CodeValue}^{CodingSchemeDesignator}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response moveInstances(@PathParam(value="StudyUID") String studyUID, @PathParam(value="CodeValue") String codeValue, @PathParam(value="CodingSchemeDesignator") String designator, InputStream in) {
        return this.copyOrMoveInstances(studyUID, in, codeValue, designator);
    }

    @POST
    @Path(value="/mwlitems/{studyUID}/{spsID}/move/{codeValue}^{codingSchemeDesignator}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response linkInstancesWithMWLEntry(@PathParam(value="studyUID") String studyUID, @PathParam(value="spsID") String spsID, @PathParam(value="codeValue") String codeValue, @PathParam(value="codingSchemeDesignator") String designator, @QueryParam(value="strategy") @Pattern(regexp="IOCM|MERGE") @Pattern(regexp="IOCM|MERGE") String strategy, InputStream in) {
        ArchiveAEExtension arcAE = this.getArchiveAE();
        if (arcAE == null) {
            return this.errResponse("No such Application Entity: " + this.aet, Response.Status.NOT_FOUND);
        }
        this.validateAcceptedUserRoles(arcAE);
        if (this.aet.equals(arcAE.getApplicationEntity().getAETitle())) {
            this.validateWebAppServiceClass();
        }
        RejectionNote rjNote = this.toRejectionNote(codeValue, designator);
        try {
            ProcedureContext ctx = this.procedureService.createProcedureContext().setHttpServletRequest(HttpServletRequestInfo.valueOf((HttpServletRequest)this.request));
            ctx.setArchiveAEExtension(arcAE);
            ctx.setStudyInstanceUID(studyUID);
            ctx.setSpsID(spsID);
            MWLItem mwl = this.procedureService.findMWLItem(ctx);
            if (mwl == null) {
                return this.errResponse("MWLItem[studyUID=" + studyUID + ", spsID=" + spsID + "] does not exist.", Response.Status.NOT_FOUND);
            }
            ctx.setAttributes(mwl.getAttributes());
            ctx.setPatient(mwl.getPatient());
            ctx.setLinkStrategy(strategy);
            String changeRequesterAET = arcAE.changeRequesterAET();
            StoreSession session = this.storeService.newStoreSession(HttpServletRequestInfo.valueOf((HttpServletRequest)this.request), arcAE.getApplicationEntity(), this.aet, changeRequesterAET != null ? changeRequesterAET : arcAE.getApplicationEntity().getAETitle()).withObjectStorageID(this.rejectionNoteObjectStorageID());
            Attributes result = IocmUtils.linkInstancesWithMWL(session, this.retrieveService, this.procedureService, ctx, this.queryService, rjNote, this.instAttrs(mwl), in);
            if (this.linkStudyToMWLMerge(ctx, strategy)) {
                this.rsForward.forward(RSOperation.LinkStudyToMWLMerge, arcAE, ctx.getSourceInstanceRefs(), this.request);
            }
            return result == null ? this.errResponse("No Instances found.", Response.Status.NOT_FOUND) : this.toResponse(result);
        }
        catch (IllegalStateException e) {
            return this.errResponse(e.getMessage(), Response.Status.NOT_FOUND);
        }
        catch (IllegalArgumentException e) {
            return this.errResponse(e.getMessage(), Response.Status.BAD_REQUEST);
        }
        catch (Exception e) {
            return this.errResponseAsTextPlain(this.exceptionAsString(e), Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    private boolean linkStudyToMWLMerge(ProcedureContext ctx, String strategy) {
        return strategy == null ? ctx.getStudyInstanceUID().equals(ctx.getSourceInstanceRefs().getString(0x20000D)) : strategy.equals("MERGE");
    }

    private Attributes instAttrs(MWLItem mwlItem) {
        Attributes mwlItemAttrs = mwlItem.getAttributes();
        Attributes patAttrs = mwlItem.getPatient().getAttributes();
        Attributes.unifyCharacterSets((Attributes[])new Attributes[]{mwlItemAttrs, patAttrs});
        Attributes attrs = new Attributes(mwlItemAttrs, this.arcDev().getAttributeFilter(Entity.Study).getSelection());
        attrs.addAll(patAttrs);
        attrs.setString(528432, VR.LO, mwlItemAttrs.getString(3280992));
        attrs.setString(0x200010, VR.SH, mwlItemAttrs.getString(0x401001));
        mwlItem.addItemToRequestAttributesSequence(attrs.newSequence(4194933, 1));
        return attrs;
    }

    private Response toResponse(Attributes result) {
        StreamingOutput entity = out -> {
            try (JsonGenerator gen = Json.createGenerator((OutputStream)out);){
                new JSONWriter(gen).write(result);
            }
        };
        return Response.status((Response.Status)this.status(result)).entity((Object)entity).build();
    }

    public void validate() {
        this.logRequest();
        String[] uriPath = StringUtils.split((String)this.uriInfo.getPath(), (char)'/');
        if ("copy".equals(uriPath[uriPath.length - 1]) || "move".equals(uriPath[uriPath.length - 2]) && "studies".equals(uriPath[uriPath.length - 4])) {
            this.coerceAttrs = new QueryAttributes(this.uriInfo, null).getQueryKeys();
        }
    }

    private ArchiveAEExtension getArchiveAE() {
        ApplicationEntity ae = this.device.getApplicationEntity(this.aet, true);
        return ae == null || !ae.isInstalled() ? null : (ArchiveAEExtension)ae.getAEExtensionNotNull(ArchiveAEExtension.class);
    }

    private void logRequest() {
        LOG.info("Process {} {} from {}@{}", new Object[]{this.request.getMethod(), this.toString(), this.request.getRemoteUser(), this.request.getRemoteHost()});
    }

    private Response reject(RSOperation rsOp, String studyUID, String seriesUID, String objectUID, String codeValue, String designator) {
        ArchiveAEExtension arcAE = this.getArchiveAE();
        if (arcAE == null) {
            return this.errResponse("No such Application Entity: " + this.aet, Response.Status.NOT_FOUND);
        }
        this.validateAcceptedUserRoles(arcAE);
        if (this.aet.equals(arcAE.getApplicationEntity().getAETitle())) {
            this.validateWebAppServiceClass();
        }
        try {
            RejectionNote rjNote = this.toRejectionNote(codeValue, designator);
            if (this.queue) {
                return this.queueReject(rsOp, arcAE, studyUID, seriesUID, objectUID, rjNote);
            }
            int count = this.rejectionService.reject(arcAE.getApplicationEntity(), this.aet, studyUID, seriesUID, objectUID, rjNote, HttpServletRequestInfo.valueOf((HttpServletRequest)this.request));
            if (count == 0) {
                return this.errResponse("No instances of Study[UID=" + studyUID + "] found for rejection.", Response.Status.NOT_FOUND);
            }
            this.rsForward.forward(rsOp, arcAE, null, this.request);
            return Response.ok((Object)("{\"count\":" + count + "}")).build();
        }
        catch (IllegalStateException e) {
            return this.errResponse(e.getMessage(), Response.Status.NOT_FOUND);
        }
        catch (DicomServiceException e) {
            return this.errResponse(IocmRS::rejectFailed, e);
        }
        catch (Exception e) {
            throw new WebApplicationException(this.errResponseAsTextPlain(this.exceptionAsString(e), Response.Status.INTERNAL_SERVER_ERROR));
        }
    }

    private Response queueReject(RSOperation rsOp, ArchiveAEExtension arcAE, String studyUID, String seriesUID, String objectUID, RejectionNote rjNote) {
        this.rejectionService.createRejectionTask(this.aet, rjNote.getRejectionNoteCode(), HttpServletRequestInfo.valueOf((HttpServletRequest)this.request), this.batchID, this.scheduledTime(), studyUID, seriesUID, objectUID);
        this.rsForward.forward(rsOp, arcAE, null, this.request);
        return Response.accepted().build();
    }

    private Response copyOrMoveInstances(String studyUID, InputStream in, String codeValue, String designator) {
        ArchiveAEExtension arcAE = this.getArchiveAE();
        if (arcAE == null) {
            return this.errResponse("No such Application Entity: " + this.aet, Response.Status.NOT_FOUND);
        }
        this.validateAcceptedUserRoles(arcAE);
        if (this.aet.equals(arcAE.getApplicationEntity().getAETitle())) {
            this.validateWebAppServiceClass();
        }
        RejectionNote rjNote = this.toRejectionNote(codeValue, designator);
        try {
            Attributes result;
            String changeRequesterAET = arcAE.changeRequesterAET();
            StoreSession session = this.storeService.newStoreSession(HttpServletRequestInfo.valueOf((HttpServletRequest)this.request), arcAE.getApplicationEntity(), this.aet, changeRequesterAET != null ? changeRequesterAET : arcAE.getApplicationEntity().getAETitle());
            if (rjNote != null) {
                session.withObjectStorageID(this.rejectionNoteObjectStorageID());
            }
            return (result = IocmUtils.copyMove(session, this.retrieveService, this.queryService, studyUID, this.coerceAttrs, rjNote, in)) == null ? this.errResponse("No Instances found.", Response.Status.NOT_FOUND) : this.toResponse(result);
        }
        catch (IllegalStateException e) {
            return this.errResponse(e.getMessage(), Response.Status.NOT_FOUND);
        }
        catch (IllegalArgumentException e) {
            return this.errResponse(e.getMessage(), Response.Status.BAD_REQUEST);
        }
        catch (DicomServiceException e) {
            return this.errResponse(IocmRS::rejectFailed, e);
        }
        catch (Exception e) {
            return this.errResponseAsTextPlain(this.exceptionAsString(e), Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    private RejectionNote toRejectionNote(String codeValue, String designator) {
        if (codeValue == null) {
            return null;
        }
        RejectionNote rjNote = this.arcDev().getRejectionNote(new Code(codeValue, designator, null, ""));
        if (rjNote == null) {
            throw new WebApplicationException(this.errResponse("Unknown Rejection Note Code: (" + codeValue + ", " + designator + ")", Response.Status.NOT_FOUND));
        }
        return rjNote;
    }

    private Response.Status status(Attributes result) {
        return result.getSequence(528793).isEmpty() ? Response.Status.CONFLICT : (result.getSequence(528792) == null || result.getSequence(528792).isEmpty() ? Response.Status.OK : Response.Status.ACCEPTED);
    }

    private Date scheduledTime() {
        if (this.scheduledTime != null) {
            try {
                return new SimpleDateFormat("yyyyMMddhhmmss").parse(this.scheduledTime);
            }
            catch (Exception e) {
                LOG.info(e.getMessage());
            }
        }
        return new Date();
    }

    private String rejectionNoteObjectStorageID() {
        ArchiveAEExtension rjArcAE;
        String rjNoteStorageAET = this.arcDev().getRejectionNoteStorageAET();
        if (rjNoteStorageAET == null) {
            return null;
        }
        ApplicationEntity rjAE = this.device.getApplicationEntity(rjNoteStorageAET, true);
        if (rjAE == null || !rjAE.isInstalled() || (rjArcAE = (ArchiveAEExtension)rjAE.getAEExtension(ArchiveAEExtension.class)) == null) {
            LOG.warn("Rejection Note Storage Application Entity with an Archive AE Extension not configured: {}", (Object)rjNoteStorageAET);
            return null;
        }
        String[] objectStorageIDs = rjArcAE.getObjectStorageIDs();
        if (objectStorageIDs.length > 0) {
            return objectStorageIDs[0];
        }
        LOG.warn("Object storage for rejection notes shall fall back on those configured for AE: {} since none are configured for RejectionNoteStorageAE: {}", (Object)this.aet, (Object)rjNoteStorageAET);
        return null;
    }

    private ArchiveDeviceExtension arcDev() {
        return (ArchiveDeviceExtension)this.device.getDeviceExtensionNotNull(ArchiveDeviceExtension.class);
    }

    private Response errResponse(String msg, Response.Status status) {
        return this.errResponseAsTextPlain("{\"errorMessage\":\"" + msg + "\"}", status);
    }

    private Response errResponseAsTextPlain(String errorMsg, Response.Status status) {
        LOG.info("Response {} caused by {}", (Object)status, (Object)errorMsg);
        return Response.status((Response.Status)status).entity((Object)errorMsg).type("text/plain").build();
    }

    private String exceptionAsString(Exception e) {
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    private Response errResponse(IntFunction<Response.Status> httpStatusOf, DicomServiceException e) {
        return this.errResponse(e.getMessage(), httpStatusOf.apply(e.getStatus()));
    }

    private static Response.Status rejectFailed(int status) {
        switch (status) {
            case 42872: 
            case 42873: {
                return Response.Status.CONFLICT;
            }
            case 42864: 
            case 42865: 
            case 42868: 
            case 42871: {
                return Response.Status.BAD_REQUEST;
            }
            case 42866: {
                return Response.Status.NOT_FOUND;
            }
            case 42869: 
            case 42870: {
                return Response.Status.FORBIDDEN;
            }
        }
        return Response.Status.INTERNAL_SERVER_ERROR;
    }

    private void validateAcceptedUserRoles(ArchiveAEExtension arcAE) {
        KeycloakContext keycloakContext = KeycloakContext.valueOf((HttpServletRequest)this.request);
        if (keycloakContext.isSecured() && !keycloakContext.isUserInRole(System.getProperty(SUPER_USER_ROLE)) && !arcAE.isAcceptedUserRole(keycloakContext.getRoles())) {
            throw new WebApplicationException("Application Entity " + arcAE.getApplicationEntity().getAETitle() + " does not list role of accessing user", Response.Status.FORBIDDEN);
        }
    }

    private void validateWebAppServiceClass() {
        this.device.getWebApplications().stream().filter(webApp -> this.request.getRequestURI().startsWith(webApp.getServicePath()) && Arrays.asList(webApp.getServiceClasses()).contains(WebApplication.ServiceClass.DCM4CHEE_ARC_AET)).findFirst().orElseThrow(() -> new WebApplicationException(this.errResponse("No Web Application with DCM4CHEE_ARC_AET service class found for Application Entity: " + this.aet, Response.Status.NOT_FOUND)));
    }
}

