/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.iocm.rs;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.EnumSet;
import java.util.List;
import java.util.function.IntFunction;
import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import javax.json.Json;
import javax.json.stream.JsonGenerator;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import javax.ws.rs.core.UriInfo;
import org.dcm4che3.conf.api.ConfigurationException;
import org.dcm4che3.conf.api.IApplicationEntityCache;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.Code;
import org.dcm4che3.data.Sequence;
import org.dcm4che3.data.VR;
import org.dcm4che3.json.JSONWriter;
import org.dcm4che3.net.ApplicationEntity;
import org.dcm4che3.net.Device;
import org.dcm4che3.net.QueryOption;
import org.dcm4che3.net.service.DicomServiceException;
import org.dcm4chee.arc.conf.ArchiveAEExtension;
import org.dcm4chee.arc.conf.ArchiveDeviceExtension;
import org.dcm4chee.arc.conf.Entity;
import org.dcm4chee.arc.conf.RejectionNote;
import org.dcm4chee.arc.iocm.rs.IocmUtils;
import org.dcm4chee.arc.keycloak.HttpServletRequestInfo;
import org.dcm4chee.arc.keycloak.KeycloakContext;
import org.dcm4chee.arc.procedure.ProcedureContext;
import org.dcm4chee.arc.procedure.ProcedureService;
import org.dcm4chee.arc.query.QueryService;
import org.dcm4chee.arc.query.scu.CFindSCU;
import org.dcm4chee.arc.retrieve.RetrieveService;
import org.dcm4chee.arc.store.StoreService;
import org.dcm4chee.arc.store.StoreSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequestScoped
@Path(value="aets/{AETitle}/dimse/{mwlscp}")
public class IocmDimseRS {
    private static final Logger LOG = LoggerFactory.getLogger(IocmDimseRS.class);
    private static final String SUPER_USER_ROLE = "super-user-role";
    @Context
    private HttpServletRequest request;
    @Context
    private UriInfo uriInfo;
    @Inject
    private Device device;
    @Inject
    private IApplicationEntityCache aeCache;
    @Inject
    private ProcedureService procedureService;
    @Inject
    private StoreService storeService;
    @Inject
    private RetrieveService retrieveService;
    @Inject
    private QueryService queryService;
    @Inject
    private CFindSCU cFindSCU;
    @PathParam(value="AETitle")
    private String aet;
    @PathParam(value="mwlscp")
    private String mwlscp;
    private static final int[] REQUEST_ATTR = new int[]{524368, 0x401001, 0x20000D, 3280992};
    private static final int[] SPS_REQUEST_ATTR = new int[]{0x400007, 0x400008, 0x400009};

    public String toString() {
        String requestURI = this.request.getRequestURI();
        String queryString = this.request.getQueryString();
        return queryString == null ? requestURI : requestURI + "?" + queryString;
    }

    @POST
    @Path(value="/mwlitems/{studyUID}/{spsID}/move/{codeValue}^{codingSchemeDesignator}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response linkInstancesWithMWLEntry(@PathParam(value="studyUID") String studyUID, @PathParam(value="spsID") String spsID, @PathParam(value="codeValue") String codeValue, @PathParam(value="codingSchemeDesignator") String designator, InputStream in) {
        this.logRequest();
        ArchiveAEExtension arcAE = this.getArchiveAE();
        if (arcAE == null) {
            return this.errResponse("No such Application Entity: " + this.aet, Response.Status.NOT_FOUND);
        }
        this.validateAcceptedUserRoles(arcAE);
        RejectionNote rjNote = this.toRejectionNote(codeValue, designator);
        ProcedureContext ctx = this.procedureService.createProcedureContext().setHttpServletRequest(HttpServletRequestInfo.valueOf((HttpServletRequest)this.request));
        ctx.setArchiveAEExtension(arcAE);
        ctx.setStudyInstanceUID(studyUID);
        ctx.setSpsID(spsID);
        try {
            this.aeCache.findApplicationEntity(this.mwlscp);
            List mwlItems = this.cFindSCU.findMWLItems(arcAE.getApplicationEntity(), this.mwlscp, EnumSet.noneOf(QueryOption.class), 0, this.keys(studyUID, spsID));
            if (mwlItems.isEmpty()) {
                return this.errResponse("MWLItem[studyUID=" + studyUID + ", spsID=" + spsID + "] does not exist.", Response.Status.NOT_FOUND);
            }
            if (mwlItems.size() > 1) {
                return this.errResponse(this.mwlscp + " returned multiple MWLItems for [studyUID=" + studyUID + ", spsID=" + spsID + "]", Response.Status.CONFLICT);
            }
            Attributes mwlAttrs = (Attributes)mwlItems.get(0);
            ctx.setAttributes(mwlAttrs);
            String changeRequesterAET = arcAE.changeRequesterAET();
            StoreSession session = this.storeService.newStoreSession(HttpServletRequestInfo.valueOf((HttpServletRequest)this.request), arcAE.getApplicationEntity(), this.aet, changeRequesterAET != null ? changeRequesterAET : arcAE.getApplicationEntity().getAETitle()).withObjectStorageID(this.rejectionNoteObjectStorageID());
            Attributes result = IocmUtils.linkInstancesWithMWL(session, this.retrieveService, this.procedureService, ctx, this.queryService, rjNote, this.instAttrs(mwlAttrs), in);
            return result == null ? this.errResponse("No Instances found.", Response.Status.NOT_FOUND) : this.toResponse(result);
        }
        catch (IllegalStateException | ConfigurationException e) {
            return this.errResponse(e.getMessage(), Response.Status.NOT_FOUND);
        }
        catch (IllegalArgumentException e) {
            return this.errResponse(e.getMessage(), Response.Status.BAD_REQUEST);
        }
        catch (DicomServiceException e) {
            return this.errResponse(IocmDimseRS::rejectFailed, e);
        }
        catch (Exception e) {
            return this.errResponseAsTextPlain(this.exceptionAsString(e), Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    private Attributes keys(String studyIUID, String spsID) {
        Attributes sps = new Attributes(4);
        sps.setNull(0x400006, VR.PN);
        sps.setNull(0x400007, VR.LO);
        sps.setNull(0x400008, VR.SQ);
        sps.setString(0x400009, VR.SH, spsID);
        Attributes keys = new Attributes(27);
        keys.setNull(524368, VR.SH);
        keys.setNull(524369, VR.SQ);
        keys.setNull(528656, VR.SQ);
        keys.setNull(524432, VR.PN);
        keys.setNull(0x100010, VR.PN);
        keys.setNull(0x100020, VR.LO);
        keys.setNull(0x100021, VR.LO);
        keys.setNull(1048612, VR.SQ);
        keys.setNull(0x100030, VR.DA);
        keys.setNull(0x100040, VR.CS);
        keys.setNull(0x101020, VR.DS);
        keys.setNull(0x101030, VR.DS);
        keys.setNull(0x101040, VR.LO);
        keys.setNull(1057283, VR.CS);
        keys.setString(0x20000D, VR.UI, studyIUID);
        keys.setNull(3280945, VR.SQ);
        keys.setNull(3280946, VR.PN);
        keys.setNull(3280947, VR.LO);
        keys.setNull(3280948, VR.SQ);
        keys.setNull(3280992, VR.LO);
        keys.setNull(3280996, VR.SQ);
        keys.setNull(3670032, VR.LO);
        keys.setNull(3670036, VR.SQ);
        keys.newSequence(0x400100, 1).add(sps);
        keys.setNull(0x401001, VR.SH);
        keys.setNull(4198402, VR.LO);
        keys.setNull(4198410, VR.SQ);
        return keys;
    }

    private Response toResponse(Attributes result) {
        StreamingOutput entity = out -> {
            try (JsonGenerator gen = Json.createGenerator((OutputStream)out);){
                new JSONWriter(gen).write(result);
            }
        };
        return Response.status((Response.Status)this.status(result)).entity((Object)entity).build();
    }

    private Response.Status status(Attributes result) {
        return result.getSequence(528793).isEmpty() ? Response.Status.CONFLICT : (result.getSequence(528792) == null || result.getSequence(528792).isEmpty() ? Response.Status.OK : Response.Status.ACCEPTED);
    }

    private Attributes instAttrs(Attributes mwlItemAttrs) {
        Attributes attrs = new Attributes(mwlItemAttrs, this.arcDev().getAttributeFilter(Entity.Study).getSelection());
        attrs.addSelected(mwlItemAttrs, this.arcDev().getAttributeFilter(Entity.Patient).getSelection());
        attrs.setString(528432, VR.LO, mwlItemAttrs.getString(3280992));
        attrs.setString(0x200010, VR.SH, mwlItemAttrs.getString(0x401001));
        Sequence reqAttrSeq = attrs.newSequence(4194933, 1);
        Attributes spsItem = mwlItemAttrs.getNestedDataset(0x400100);
        Attributes item = new Attributes(7);
        reqAttrSeq.add(item);
        item.addSelected(mwlItemAttrs, REQUEST_ATTR);
        item.addSelected(spsItem, SPS_REQUEST_ATTR);
        return attrs;
    }

    private ArchiveAEExtension getArchiveAE() {
        ApplicationEntity ae = this.device.getApplicationEntity(this.aet, true);
        return ae == null || !ae.isInstalled() ? null : (ArchiveAEExtension)ae.getAEExtensionNotNull(ArchiveAEExtension.class);
    }

    private RejectionNote toRejectionNote(String codeValue, String designator) {
        if (codeValue == null) {
            return null;
        }
        RejectionNote rjNote = this.arcDev().getRejectionNote(new Code(codeValue, designator, null, ""));
        if (rjNote == null) {
            throw new WebApplicationException(this.errResponse("Unknown Rejection Note Code: (" + codeValue + ", " + designator + ")", Response.Status.NOT_FOUND));
        }
        return rjNote;
    }

    private ArchiveDeviceExtension arcDev() {
        return (ArchiveDeviceExtension)this.device.getDeviceExtensionNotNull(ArchiveDeviceExtension.class);
    }

    private String rejectionNoteObjectStorageID() {
        ArchiveAEExtension rjArcAE;
        String rjNoteStorageAET = this.arcDev().getRejectionNoteStorageAET();
        if (rjNoteStorageAET == null) {
            return null;
        }
        ApplicationEntity rjAE = this.device.getApplicationEntity(rjNoteStorageAET, true);
        if (rjAE == null || !rjAE.isInstalled() || (rjArcAE = (ArchiveAEExtension)rjAE.getAEExtension(ArchiveAEExtension.class)) == null) {
            LOG.warn("Rejection Note Storage Application Entity with an Archive AE Extension not configured: {}", (Object)rjNoteStorageAET);
            return null;
        }
        String[] objectStorageIDs = rjArcAE.getObjectStorageIDs();
        if (objectStorageIDs.length > 0) {
            return objectStorageIDs[0];
        }
        LOG.warn("Object storage for rejection notes shall fall back on those configured for AE: {} since none are configured for RejectionNoteStorageAE: {}", (Object)this.aet, (Object)rjNoteStorageAET);
        return null;
    }

    private void logRequest() {
        LOG.info("Process {} {} from {}@{}", new Object[]{this.request.getMethod(), this.toString(), this.request.getRemoteUser(), this.request.getRemoteHost()});
    }

    private Response errResponse(String msg, Response.Status status) {
        return this.errResponseAsTextPlain("{\"errorMessage\":\"" + msg + "\"}", status);
    }

    private Response errResponseAsTextPlain(String errorMsg, Response.Status status) {
        LOG.info("Response {} caused by {}", (Object)status, (Object)errorMsg);
        return Response.status((Response.Status)status).entity((Object)errorMsg).type("text/plain").build();
    }

    private String exceptionAsString(Exception e) {
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    private Response errResponse(IntFunction<Response.Status> httpStatusOf, DicomServiceException e) {
        return this.errResponse(e.getMessage(), httpStatusOf.apply(e.getStatus()));
    }

    private static Response.Status rejectFailed(int status) {
        switch (status) {
            case 42872: 
            case 42873: {
                return Response.Status.CONFLICT;
            }
            case 42864: 
            case 42865: 
            case 42868: 
            case 42871: {
                return Response.Status.BAD_REQUEST;
            }
            case 42866: {
                return Response.Status.NOT_FOUND;
            }
            case 42869: 
            case 42870: {
                return Response.Status.FORBIDDEN;
            }
        }
        return Response.Status.INTERNAL_SERVER_ERROR;
    }

    private void validateAcceptedUserRoles(ArchiveAEExtension arcAE) {
        KeycloakContext keycloakContext = KeycloakContext.valueOf((HttpServletRequest)this.request);
        if (keycloakContext.isSecured() && !keycloakContext.isUserInRole(System.getProperty(SUPER_USER_ROLE)) && !arcAE.isAcceptedUserRole(keycloakContext.getRoles())) {
            throw new WebApplicationException("Application Entity " + arcAE.getApplicationEntity().getAETitle() + " does not list role of accessing user", Response.Status.FORBIDDEN);
        }
    }
}

