/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.ian.scu.impl;

import java.io.IOException;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.dcm4che3.conf.api.IApplicationEntityCache;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.net.ApplicationEntity;
import org.dcm4che3.net.Association;
import org.dcm4che3.net.Device;
import org.dcm4che3.net.DimseRSP;
import org.dcm4che3.net.TransferCapability;
import org.dcm4che3.net.pdu.AAssociateRQ;
import org.dcm4che3.net.pdu.PresentationContext;
import org.dcm4chee.arc.entity.Task;
import org.dcm4chee.arc.ian.scu.IANSCU;
import org.dcm4chee.arc.qmgt.Outcome;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class IANSCUImpl
implements IANSCU {
    private static final Logger LOG = LoggerFactory.getLogger(IANSCUImpl.class);
    @Inject
    private Device device;
    @Inject
    private IApplicationEntityCache aeCache;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Outcome sendIAN(String localAET, String remoteAET, String sopInstanceUID, Attributes attrs) throws Exception {
        ApplicationEntity localAE = this.device.getApplicationEntity(localAET, true);
        ApplicationEntity remoteAE = this.aeCache.findApplicationEntity(remoteAET);
        AAssociateRQ aarq = this.mkAAssociateRQ(localAE);
        Association as = localAE.connect(remoteAE, aarq);
        try {
            DimseRSP rsp = as.ncreate("1.2.840.10008.5.1.4.33", sopInstanceUID, attrs, null);
            rsp.next();
            int status = rsp.getCommand().getInt(2304, -1);
            Outcome outcome = status == 0 ? new Outcome(Task.Status.COMPLETED, "Send IAN[uid=" + sopInstanceUID + "] to AE: " + remoteAET) : new Outcome(Task.Status.WARNING, "Send IAN[uid=" + sopInstanceUID + "] to AE: " + remoteAET + " failed with error status: " + Integer.toHexString(status) + "H");
            return outcome;
        }
        finally {
            try {
                as.release();
            }
            catch (IOException e) {
                LOG.info("{}: Failed to release association to {}", (Object)as, (Object)remoteAET);
            }
        }
    }

    @Override
    public DimseRSP sendIANRQ(String localAET, String remoteAET, String sopInstanceUID, Attributes ian) throws Exception {
        return this.sendIANRQ(this.device.getApplicationEntity(localAET, true), this.aeCache.findApplicationEntity(remoteAET), sopInstanceUID, ian);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DimseRSP sendIANRQ(ApplicationEntity localAE, ApplicationEntity remoteAE, String sopInstanceUID, Attributes ian) throws Exception {
        AAssociateRQ aarq = this.mkAAssociateRQ(localAE);
        Association as = localAE.connect(remoteAE, aarq);
        try {
            DimseRSP dimseRSP = as.ncreate("1.2.840.10008.5.1.4.33", sopInstanceUID, ian, null);
            return dimseRSP;
        }
        finally {
            try {
                as.release();
            }
            catch (IOException e) {
                LOG.info("{}: Failed to release association to {}", (Object)as, (Object)remoteAE.getAETitle());
            }
        }
    }

    private AAssociateRQ mkAAssociateRQ(ApplicationEntity localAE) {
        String[] stringArray;
        AAssociateRQ aarq = new AAssociateRQ();
        TransferCapability tc = localAE.getTransferCapabilityFor("1.2.840.10008.5.1.4.33", TransferCapability.Role.SCU);
        if (tc == null) {
            LOG.warn("No Transfer ServiceClass for Instance Availability Notification SOP Class as SCU configured for {}", (Object)localAE.getAETitle());
        }
        if (tc != null) {
            stringArray = tc.getTransferSyntaxes();
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "1.2.840.10008.1.2";
        }
        aarq.addPresentationContext(new PresentationContext(1, "1.2.840.10008.5.1.4.33", stringArray));
        return aarq;
    }
}

