/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.ian.scu.impl;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import javax.ejb.Stateless;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.net.ApplicationEntity;
import org.dcm4che3.net.Device;
import org.dcm4che3.util.UIDUtils;
import org.dcm4chee.arc.conf.ArchiveAEExtension;
import org.dcm4chee.arc.conf.Duration;
import org.dcm4chee.arc.entity.AttributesBlob;
import org.dcm4chee.arc.entity.IanTask;
import org.dcm4chee.arc.entity.MPPS;
import org.dcm4chee.arc.entity.Task;
import org.dcm4chee.arc.qmgt.TaskManager;

@Stateless
public class IANEJB {
    @PersistenceContext(unitName="dcm4chee-arc")
    private EntityManager em;
    @Inject
    private TaskManager taskManager;
    @Inject
    private Device device;

    public IanTask createIANTaskForMPPS(ArchiveAEExtension arcAE, String callingAET, MPPS mpps) {
        ApplicationEntity ae = arcAE.getApplicationEntity();
        IanTask task = new IanTask();
        task.setDeviceName(ae.getDevice().getDeviceName());
        task.setCallingAET(callingAET);
        task.setIanDestinations(arcAE.ianDestinations());
        task.setScheduledTime(this.scheduledTime(arcAE.ianTimeout()));
        task.setMpps(mpps);
        this.em.persist((Object)task);
        return task;
    }

    public IanTaskAction createOrUpdateIANTaskForStudy(ArchiveAEExtension arcAE, String callingAET, String studyInstanceUID) {
        try {
            IanTask task = (IanTask)this.em.createNamedQuery("IanTask.findByStudyIUID", IanTask.class).setParameter(1, (Object)studyInstanceUID).getSingleResult();
            task.setScheduledTime(this.scheduledTime(arcAE.ianDelay()));
            return new IanTaskAction(task, Action.UPDATED);
        }
        catch (NoResultException nre) {
            IanTask task = new IanTask();
            task.setDeviceName(arcAE.getApplicationEntity().getDevice().getDeviceName());
            task.setCallingAET(callingAET);
            task.setIanDestinations(arcAE.ianDestinations());
            task.setStudyInstanceUID(studyInstanceUID);
            task.setScheduledTime(this.scheduledTime(arcAE.ianDelay()));
            this.em.persist((Object)task);
            return new IanTaskAction(task, Action.CREATED);
        }
    }

    private Date scheduledTime(Duration duration) {
        return duration != null ? new Date(System.currentTimeMillis() + duration.getSeconds() * 1000L) : null;
    }

    public List<IanTask> fetchIANTasksForMPPS(String deviceName, long prevPk, int fetchSize) {
        return this.em.createNamedQuery("IanTask.findWithMppsByDeviceName", IanTask.class).setParameter(1, (Object)deviceName).setParameter(2, (Object)prevPk).setMaxResults(fetchSize).getResultList();
    }

    public List<IanTask> fetchIANTasksForStudy(String deviceName, int fetchSize) {
        return this.em.createNamedQuery("IanTask.findScheduledByDeviceName", IanTask.class).setParameter(1, (Object)deviceName).setMaxResults(fetchSize).getResultList();
    }

    public void scheduleIANTask(IanTask task, Attributes attrs) {
        for (String remoteAET : task.getIanDestinations()) {
            this.scheduleMessage(task.getCallingAET(), attrs, remoteAET, new Date(), null);
        }
        this.removeIANTask(task);
    }

    public void scheduleMessage(String callingAET, Attributes attrs, String remoteAET, Date scheduledTime, String batchID) {
        Task task = new Task();
        task.setDeviceName(this.device.getDeviceName());
        task.setQueueName("IANSCU");
        task.setType(Task.Type.IAN);
        task.setScheduledTime(scheduledTime);
        task.setLocalAET(callingAET);
        task.setRemoteAET(remoteAET);
        task.setSOPInstanceUID(UIDUtils.createUID());
        task.setPayload((Serializable)attrs);
        task.setStatus(Task.Status.SCHEDULED);
        task.setBatchID(batchID);
        this.taskManager.scheduleTask(task);
    }

    public void removeIANTask(IanTask task) {
        this.em.remove(this.em.getReference(task.getClass(), (Object)task.getPk()));
    }

    public boolean addPPSRef(String studyUID, String seriesUID, Attributes ian) {
        try {
            Attributes ppsRef = AttributesBlob.decodeAttributes((byte[])((byte[])this.em.createNamedQuery("Series.attrsBySeriesIUID", byte[].class).setParameter(1, (Object)studyUID).setParameter(2, (Object)seriesUID).getSingleResult()), null).getNestedDataset(528657);
            if (ppsRef == null) {
                return false;
            }
            ian.newSequence(528657, 1).add(new Attributes(ppsRef));
            return true;
        }
        catch (NoResultException e) {
            return false;
        }
    }

    public static class IanTaskAction {
        public final IanTask ianTask;
        public final Action action;

        public IanTaskAction(IanTask ianTask, Action action) {
            this.ianTask = ianTask;
            this.action = action;
        }
    }

    public static enum Action {
        CREATED,
        UPDATED;

    }
}

