/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.ian.scu;

import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.Sequence;
import org.dcm4che3.data.VR;
import org.dcm4che3.net.ApplicationEntity;
import org.dcm4che3.util.StringUtils;
import org.dcm4che3.util.UIDUtils;
import org.dcm4chee.arc.Scheduler;
import org.dcm4chee.arc.conf.ArchiveAEExtension;
import org.dcm4chee.arc.conf.ArchiveDeviceExtension;
import org.dcm4chee.arc.conf.Duration;
import org.dcm4chee.arc.conf.ExporterDescriptor;
import org.dcm4chee.arc.conf.RejectionNote;
import org.dcm4chee.arc.entity.IanTask;
import org.dcm4chee.arc.entity.MPPS;
import org.dcm4chee.arc.entity.Task;
import org.dcm4chee.arc.exporter.ExportContext;
import org.dcm4chee.arc.ian.scu.impl.IANEJB;
import org.dcm4chee.arc.mpps.MPPSContext;
import org.dcm4chee.arc.query.QueryService;
import org.dcm4chee.arc.store.StoreContext;
import org.dcm4chee.arc.store.StoreSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class IANScheduler
extends Scheduler {
    private static final Logger LOG = LoggerFactory.getLogger(IANScheduler.class);
    @Inject
    private IANEJB ejb;
    @Inject
    private QueryService queryService;

    protected IANScheduler() {
        super(Scheduler.Mode.scheduleWithFixedDelay);
    }

    protected Logger log() {
        return LOG;
    }

    protected Duration getPollingInterval() {
        ArchiveDeviceExtension arcDev = (ArchiveDeviceExtension)this.device.getDeviceExtension(ArchiveDeviceExtension.class);
        return arcDev.getIanTaskPollingInterval();
    }

    protected void execute() {
        Attributes ian;
        ApplicationEntity ae;
        List<IanTask> ianTasks;
        ArchiveDeviceExtension arcDev = (ArchiveDeviceExtension)this.device.getDeviceExtension(ArchiveDeviceExtension.class);
        int fetchSize = arcDev.getIanTaskFetchSize();
        long ianTaskPk = 0L;
        do {
            ianTasks = this.ejb.fetchIANTasksForMPPS(this.device.getDeviceName(), ianTaskPk, fetchSize);
            for (IanTask ianTask : ianTasks) {
                if (this.getPollingInterval() == null) {
                    return;
                }
                try {
                    ianTaskPk = ianTask.getPk();
                    ae = this.device.getApplicationEntity(ianTask.getCallingAET(), true);
                    LOG.info("Check availability of {}", (Object)ianTask.getMpps());
                    ian = this.createIANForMPPS(ae, ianTask.getMpps(), true);
                    if (ian == null) continue;
                    LOG.info("Schedule {}", (Object)ianTask);
                    this.ejb.scheduleIANTask(ianTask, ian);
                }
                catch (Exception e) {
                    LOG.warn("Failed to process {}", (Object)ianTask, (Object)e);
                }
            }
        } while (ianTasks.size() == fetchSize);
        do {
            ianTasks = this.ejb.fetchIANTasksForStudy(this.device.getDeviceName(), fetchSize);
            for (IanTask ianTask : ianTasks) {
                if (this.getPollingInterval() == null) {
                    return;
                }
                try {
                    ae = this.device.getApplicationEntity(ianTask.getCallingAET(), true);
                    if (ianTask.getMpps() == null) {
                        ian = this.queryService.createIAN(ae, ianTask.getStudyInstanceUID(), null, null, null, null, null);
                        if (ian != null) {
                            LOG.info("Schedule {}", (Object)ianTask);
                            this.ejb.scheduleIANTask(ianTask, ian);
                            continue;
                        }
                        LOG.info("Ignore {} without referenced objects", (Object)ianTask);
                        this.ejb.removeIANTask(ianTask);
                        continue;
                    }
                    if (((ArchiveAEExtension)ae.getAEExtension(ArchiveAEExtension.class)).ianOnTimeout() && (ian = this.createIANForMPPS(ae, ianTask.getMpps(), false)) != null) {
                        LOG.warn("Timeout for {} exceeded - schedule IAN for available instances", (Object)ianTask);
                        this.ejb.scheduleIANTask(ianTask, ian);
                        continue;
                    }
                    LOG.warn("Timeout for {} exceeded - no IAN", (Object)ianTask);
                    this.ejb.removeIANTask(ianTask);
                }
                catch (Exception e) {
                    LOG.warn("Failed to process {}", (Object)ianTask, (Object)e);
                }
            }
        } while (ianTasks.size() == fetchSize);
    }

    void onMPPSReceive(@Observes MPPSContext ctx) {
        ArchiveAEExtension arcAE;
        String[] ianDestinations;
        if (ctx.getException() != null) {
            return;
        }
        MPPS mpps = ctx.getMPPS();
        if (mpps.getStatus() == MPPS.Status.COMPLETED && (ianDestinations = (arcAE = ctx.getArchiveAEExtension()).ianDestinations()).length != 0 && arcAE.ianDelay() == null) {
            try {
                IanTask ianTaskForMPPS = this.ejb.createIANTaskForMPPS(arcAE, ctx.getCalledAET(), mpps);
                LOG.info("{}: Created {}", (Object)ctx, (Object)ianTaskForMPPS);
            }
            catch (Exception e) {
                LOG.warn("{}: Failed to create IanTask", (Object)ctx, (Object)e);
            }
        }
    }

    public void onStore(@Observes StoreContext ctx) {
        if (ctx.getLocations().isEmpty() || ctx.getException() != null) {
            return;
        }
        StoreSession session = ctx.getStoreSession();
        ArchiveAEExtension arcAE = session.getArchiveAEExtension();
        String[] ianDestinations = arcAE.ianDestinations();
        if (ianDestinations.length == 0) {
            return;
        }
        RejectionNote rejectionNote = ctx.getRejectionNote();
        if (rejectionNote != null) {
            if (!rejectionNote.isRevokeRejection()) {
                Attributes ian = this.createIANOnReject(ctx);
                for (String ianDestination : ianDestinations) {
                    this.ejb.scheduleMessage(session.getCalledAET(), ian, ianDestination, new Date(), null);
                }
            }
            return;
        }
        if (arcAE.ianDelay() != null) {
            try {
                IANEJB.IanTaskAction ianTaskAction = this.ejb.createOrUpdateIANTaskForStudy(arcAE, session.getCalledAET(), ctx.getStudyInstanceUID());
                switch (ianTaskAction.action) {
                    case CREATED: {
                        LOG.info("{}: Created {}", (Object)ctx, (Object)ianTaskAction.ianTask);
                        break;
                    }
                    case UPDATED: {
                        LOG.debug("{}: Updated {}", (Object)ctx, (Object)ianTaskAction.ianTask);
                    }
                }
            }
            catch (Exception e) {
                LOG.warn("{}: Failed to create or update IanTask", (Object)ctx, (Object)e);
            }
        }
    }

    private Attributes createIANOnReject(StoreContext ctx) {
        StoreSession session = ctx.getStoreSession();
        boolean addPPSRef = ctx.getRejectionNote().isIncorrectModalityWorklistEntry();
        String studyUID = ctx.getStudyInstanceUID();
        Attributes ian = this.queryService.createIAN(session.getLocalApplicationEntity(), studyUID, StringUtils.EMPTY_STRING, null, null, null, null);
        if (ian == null) {
            ian = new Attributes(2);
            ian.newSequence(528661, 10);
            ian.setString(0x20000D, VR.UI, studyUID);
            ian.setNull(528657, VR.SQ);
        }
        for (Attributes studyRef : ctx.getAttributes().getSequence(4236149)) {
            if (studyUID.equals(studyRef.getString(0x20000D))) {
                for (Attributes seriesRef : studyRef.getSequence(528661)) {
                    String seriesUID = seriesRef.getString(0x20000E);
                    Sequence sopSeq = seriesRef.getSequence(528793);
                    Sequence ianSeriesSOPSeq = IANScheduler.ianSeriesSOPSeq(ian, seriesUID, sopSeq);
                    List rejected = sopSeq.stream().filter(sopRef -> !IANScheduler.contains(ianSeriesSOPSeq, sopRef)).collect(Collectors.toList());
                    if (rejected.isEmpty()) continue;
                    rejected.stream().map(sopRef -> IANScheduler.ianUnavailableSOPRef(sopRef, session.getCalledAET())).forEach(ianSOPRef -> ianSeriesSOPSeq.add(ianSOPRef));
                    if (!addPPSRef) continue;
                    try {
                        if (!this.ejb.addPPSRef(studyUID, seriesUID, ian)) continue;
                        addPPSRef = false;
                    }
                    catch (Exception e) {
                        LOG.info("{}: Failed to determine referenced Performed Procedure Step in rejected objects", (Object)session, (Object)e);
                    }
                }
            } else {
                LOG.info("{}: Rejection Note[uid={}] of Study[uid={}] refers objects of different Study[uid={}] - ignored in emitted IAN", new Object[]{session, ctx.getSopInstanceUID(), studyUID, studyRef.getString(0x20000D)});
            }
            if (!addPPSRef) continue;
            String mppsUID = UIDUtils.createUID();
            ian.newSequence(528657, 1).add(IANScheduler.refMPPS(mppsUID));
            LOG.info("{}: No referenced Performed Procedure Step in rejected objects - create random UID[{}] for IAN", (Object)session, (Object)mppsUID);
        }
        return ian;
    }

    private static Attributes ianUnavailableSOPRef(Attributes sopRef, String retrieveAET) {
        Attributes refSOP = new Attributes(4);
        refSOP.setString(524372, VR.AE, retrieveAET);
        refSOP.setString(524374, VR.CS, "UNAVAILABLE");
        refSOP.setString(528720, VR.UI, sopRef.getString(528720));
        refSOP.setString(528725, VR.UI, sopRef.getString(528725));
        return refSOP;
    }

    private static Sequence ianSeriesSOPSeq(Attributes ian, String seriesUID, Sequence sopSeq) {
        Sequence refSeriesSeq = ian.getSequence(528661);
        Optional<Attributes> seriesRefOpt = refSeriesSeq.stream().filter(seriesRef -> seriesRef.getString(0x20000E).equals(seriesUID)).findFirst();
        if (seriesRefOpt.isPresent()) {
            return seriesRefOpt.get().getSequence(528793);
        }
        Attributes seriesRef2 = new Attributes(2);
        seriesRef2.setString(0x20000E, VR.UI, seriesUID);
        refSeriesSeq.add(seriesRef2);
        return seriesRef2.newSequence(528793, sopSeq.size());
    }

    public void onExport(@Observes ExportContext ctx) {
        if (ctx.getException() != null) {
            return;
        }
        ExporterDescriptor descriptor = ctx.getExporter().getExporterDescriptor();
        if (descriptor.getIanDestinations().length != 0 && ctx.getOutcome().getStatus() == Task.Status.COMPLETED) {
            this.scheduleIAN(ctx, descriptor);
        }
    }

    public void scheduleIAN(ExportContext ctx, ExporterDescriptor descriptor) {
        ApplicationEntity ae = this.device.getApplicationEntity(ctx.getAETitle(), true);
        Attributes ian = this.queryService.createIAN(ae, ctx.getStudyInstanceUID(), null, null, descriptor.getRetrieveAETitles(), descriptor.getRetrieveLocationUID(), descriptor.getInstanceAvailability());
        if (ian != null) {
            for (String remoteAET : descriptor.getIanDestinations()) {
                this.ejb.scheduleMessage(ctx.getAETitle(), ian, remoteAET, new Date(), null);
            }
        }
    }

    public void scheduleIAN(ApplicationEntity ae, String remoteAET, String studyUID, String seriesUID, String batchID, Date scheduledTime) {
        Attributes ian = this.queryService.createIAN(ae, studyUID, new String[]{seriesUID}, null, null, null, null);
        if (ian != null) {
            this.ejb.scheduleMessage(ae.getAETitle(), ian, remoteAET, scheduledTime, batchID);
        }
    }

    private Attributes createIANForMPPS(ApplicationEntity ae, MPPS mpps, boolean allAvailable) {
        Attributes mppsAttrs = mpps.getAttributes();
        String studyInstanceUID = mpps.getStudyInstanceUID();
        Sequence perfSeriesSeq = mppsAttrs.getSequence(0x400340);
        Attributes ian = new Attributes(3);
        Sequence refSeriesSeq = ian.newSequence(528661, perfSeriesSeq.size());
        ian.setString(0x20000D, VR.UI, studyInstanceUID);
        for (Attributes perfSeries : perfSeriesSeq) {
            String seriesInstanceUID = perfSeries.getString(0x20000E);
            Attributes ianForSeries = this.queryService.createIAN(ae, studyInstanceUID, new String[]{seriesInstanceUID}, null, null, null, null);
            if (ianForSeries == null) {
                if (!allAvailable) continue;
                return null;
            }
            Attributes refSeries = ianForSeries.getSequence(528661).remove(0);
            Sequence refImageSeq = perfSeries.getSequence(528704);
            Sequence refNonImageSeq = perfSeries.getSequence(0x400220);
            Sequence available = refSeries.getSequence(528793);
            IANScheduler.removeNotReferred(refImageSeq, refNonImageSeq, available);
            if (!(!allAvailable || IANScheduler.containsAll(available, refImageSeq) && IANScheduler.containsAll(available, refNonImageSeq))) {
                return null;
            }
            if (available.isEmpty()) continue;
            refSeriesSeq.add(refSeries);
        }
        if (refSeriesSeq.isEmpty()) {
            return null;
        }
        ian.newSequence(528657, 1).add(IANScheduler.refMPPS(mpps.getSopInstanceUID()));
        return ian;
    }

    private static void removeNotReferred(Sequence refImageSeq, Sequence refNonImageSeq, Sequence available) {
        Iterator iterator = available.iterator();
        while (iterator.hasNext()) {
            Attributes refSOP = (Attributes)iterator.next();
            if (IANScheduler.contains(refImageSeq, refSOP) || IANScheduler.contains(refNonImageSeq, refSOP)) continue;
            iterator.remove();
        }
    }

    private static Attributes refMPPS(String mppsUID) {
        Attributes refMPPS = new Attributes(3);
        refMPPS.setString(528720, VR.UI, "1.2.840.10008.3.1.2.3.3");
        refMPPS.setString(528725, VR.UI, mppsUID);
        refMPPS.setNull(4210713, VR.SQ);
        return refMPPS;
    }

    private static boolean containsAll(Sequence available, Sequence performed) {
        if (performed != null) {
            for (Attributes ref : performed) {
                if (IANScheduler.contains(available, ref)) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean contains(Sequence refSOPSeq, Attributes refSOP) {
        String iuid = refSOP.getString(528725);
        for (Attributes ref : refSOPSeq) {
            if (!iuid.equals(ref.getString(528725))) continue;
            return true;
        }
        return false;
    }
}

