/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.hl7.psu;

import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.List;
import javax.ejb.Stateless;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.xml.transform.TransformerConfigurationException;
import org.dcm4che3.conf.api.ConfigurationException;
import org.dcm4che3.conf.api.hl7.IHL7ApplicationCache;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.net.Device;
import org.dcm4che3.net.hl7.HL7Application;
import org.dcm4che3.net.hl7.HL7DeviceExtension;
import org.dcm4che3.net.hl7.UnparsedHL7Message;
import org.dcm4chee.arc.conf.ArchiveAEExtension;
import org.dcm4chee.arc.conf.Duration;
import org.dcm4chee.arc.conf.SPSStatus;
import org.dcm4chee.arc.entity.HL7PSUTask;
import org.dcm4chee.arc.entity.MPPS;
import org.dcm4chee.arc.entity.MWLItem;
import org.dcm4chee.arc.entity.Series;
import org.dcm4chee.arc.entity.Study;
import org.dcm4chee.arc.hl7.HL7Sender;
import org.dcm4chee.arc.hl7.HL7SenderUtils;
import org.dcm4chee.arc.mpps.MPPSContext;
import org.dcm4chee.arc.procedure.ProcedureService;
import org.dcm4chee.arc.store.StoreContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

@Stateless
public class HL7PSUEJB {
    private static final Logger LOG = LoggerFactory.getLogger(HL7PSUEJB.class);
    @PersistenceContext(unitName="dcm4chee-arc")
    private EntityManager em;
    @Inject
    private Device device;
    @Inject
    private HL7Sender hl7Sender;
    @Inject
    private IHL7ApplicationCache hl7AppCache;
    @Inject
    private ProcedureService procedureService;

    public void createHL7PSUTaskForMPPS(ArchiveAEExtension arcAE, MPPSContext ctx) {
        HL7PSUTask task = new HL7PSUTask();
        task.setDeviceName(this.device.getDeviceName());
        task.setAETitle(arcAE.getApplicationEntity().getAETitle());
        task.setScheduledTime(this.scheduledTime(arcAE.hl7PSUTimeout()));
        task.setStudyInstanceUID(ctx.getMPPS().getStudyInstanceUID());
        task.setAccessionNumber(ctx.getMPPS().getAccessionNumber());
        task.setMpps(ctx.getMPPS());
        this.em.persist((Object)task);
        LOG.info("{}: Created {}", (Object)ctx, (Object)task);
    }

    public void createOrUpdateHL7PSUTaskForStudy(ArchiveAEExtension arcAE, StoreContext ctx) {
        try {
            HL7PSUTask task = (HL7PSUTask)this.em.createNamedQuery("HL7PSUTask.findByStudyIUID", HL7PSUTask.class).setParameter(1, (Object)ctx.getStudyInstanceUID()).getSingleResult();
            task.setScheduledTime(this.scheduledTime(arcAE.hl7PSUDelay()));
            task.setSeriesInstanceUID(ctx.getSeriesInstanceUID());
            LOG.info("{}: Updated {}", (Object)ctx.getStoreSession(), (Object)task);
        }
        catch (NoResultException nre) {
            HL7PSUTask task = new HL7PSUTask();
            task.setDeviceName(this.device.getDeviceName());
            task.setAETitle(arcAE.getApplicationEntity().getAETitle());
            task.setStudyInstanceUID(ctx.getStudyInstanceUID());
            task.setSeriesInstanceUID(ctx.getSeriesInstanceUID());
            task.setAccessionNumber(ctx.getAttributes().getString(524368));
            task.setScheduledTime(this.scheduledTime(arcAE.hl7PSUDelay()));
            this.em.persist((Object)task);
            LOG.info("{}: Created {}", (Object)ctx.getStoreSession(), (Object)task);
        }
    }

    private Date scheduledTime(Duration duration) {
        return duration != null ? new Date(System.currentTimeMillis() + duration.getSeconds() * 1000L) : null;
    }

    public List<HL7PSUTask> fetchHL7PSUTasksForMPPS(String deviceName, long prevPk, int fetchSize) {
        return this.em.createNamedQuery("HL7PSUTask.findWithMppsByDeviceName", HL7PSUTask.class).setParameter(1, (Object)deviceName).setParameter(2, (Object)prevPk).setMaxResults(fetchSize).getResultList();
    }

    public List<HL7PSUTask> fetchHL7PSUTasksForStudy(String deviceName, int fetchSize) {
        return this.em.createNamedQuery("HL7PSUTask.findScheduledByDeviceName", HL7PSUTask.class).setParameter(1, (Object)deviceName).setMaxResults(fetchSize).getResultList();
    }

    public void removeHL7PSUTask(HL7PSUTask task) {
        this.em.remove(this.em.getReference(task.getClass(), (Object)task.getPk()));
    }

    public void scheduleHL7PSUTask(HL7PSUTask task) {
        LOG.info("Schedule {}", (Object)task);
        this.scheduleHL7Msg(task);
        this.removeHL7PSUTask(task);
    }

    private MWLItem updateMWLStatus(ArchiveAEExtension arcAE, HL7PSUTask task) {
        List mwlItems = this.procedureService.updateMWLStatus(arcAE, task, SPSStatus.COMPLETED);
        if (mwlItems.size() > 0) {
            LOG.info("{} MWL Items status updated to {} by HL7 PSU task {}.", new Object[]{mwlItems.size(), SPSStatus.COMPLETED, task});
        } else {
            LOG.info("Study referenced in the HL7 PSU task {} does not have any associated MWL items.", (Object)task);
        }
        return !mwlItems.isEmpty() ? (MWLItem)mwlItems.get(0) : null;
    }

    private void scheduleHL7Msg(HL7PSUTask task) {
        ArchiveAEExtension arcAE = (ArchiveAEExtension)this.device.getApplicationEntity(task.getAETitle()).getAEExtension(ArchiveAEExtension.class);
        String hl7PSUSendingApplication = arcAE.hl7PSUSendingApplication();
        String[] hl7PSUReceivingApplications = arcAE.hl7PSUReceivingApplications();
        if (!arcAE.hl7PSUMWL() && hl7PSUSendingApplication == null && hl7PSUReceivingApplications.length == 0) {
            LOG.info("HL7 Procedure Status Update Task not processed as neither notification to external HL7 receivers is configured nor update MWL status to COMPLETED is configured");
            return;
        }
        Attributes attrs = this.attributesFrom(arcAE, task);
        if (attrs == null) {
            LOG.info("No attributes available to send out HL7 Procedure Status Update Notifications");
            return;
        }
        HL7Application sender = ((HL7DeviceExtension)this.device.getDeviceExtension(HL7DeviceExtension.class)).getHL7Application(hl7PSUSendingApplication, true);
        UnparsedHL7Message hl7Msg = null;
        MPPS mpps = task.getMpps();
        String uri = mpps != null ? arcAE.hl7PSUMppsTemplateURI() : arcAE.hl7PSUStudyTemplateURI();
        for (String hl7PSUReceivingApplication : hl7PSUReceivingApplications) {
            try {
                HL7Application receiver = this.hl7AppCache.findHL7Application(hl7PSUReceivingApplication);
                if (hl7Msg == null) {
                    hl7Msg = new UnparsedHL7Message(HL7SenderUtils.data((HL7Application)sender, (HL7Application)receiver, (Attributes)attrs, null, (String)arcAE.hl7PSUMessageType().name(), (String)uri, (String)(mpps != null ? task.getPPSStatus().name() : null), (ArchiveAEExtension)arcAE));
                } else {
                    hl7Msg.msh().setReceivingApplicationWithFacility(hl7PSUReceivingApplication);
                }
                this.hl7Sender.scheduleMessage(null, hl7Msg.data());
            }
            catch (ConfigurationException e) {
                LOG.info("HL7 Procedure Status Update notification not sent to {}", (Object)e.getMessage());
            }
            catch (UnsupportedEncodingException | TransformerConfigurationException | SAXException e) {
                LOG.info("Failed to transform attributes to HL7 PSU message");
            }
            catch (Exception e) {
                LOG.info("Failed to schedule HL7 Procedure Status Update to {}:\n", (Object)hl7PSUReceivingApplication, (Object)e);
            }
        }
    }

    private Attributes attributesFrom(ArchiveAEExtension arcAE, HL7PSUTask task) {
        MPPS mpps;
        MWLItem mwl = null;
        if (task.getMpps() == null && arcAE.hl7PSUSendingApplication() != null && arcAE.hl7PSUReceivingApplications().length > 0 || arcAE.hl7PSUMWL()) {
            mwl = this.updateMWLStatus(arcAE, task);
        }
        if ((mpps = task.getMpps()) != null) {
            Attributes attrs = mpps.getAttributes();
            Attributes.unifyCharacterSets((Attributes[])new Attributes[]{attrs, mpps.getPatient().getAttributes()});
            attrs.addAll(mpps.getPatient().getAttributes());
            return attrs;
        }
        if (mwl != null) {
            Attributes attrs = mwl.getAttributes();
            Attributes.unifyCharacterSets((Attributes[])new Attributes[]{attrs, mwl.getPatient().getAttributes()});
            attrs.addAll(mwl.getPatient().getAttributes());
            return attrs;
        }
        if (arcAE.hl7PSUForRequestedProcedure()) {
            LOG.info("HL7 Procedure Status Update notification restricted to existence of MWL associated to study");
            return null;
        }
        Series series = this.findSeries(task);
        if (series == null) {
            return null;
        }
        Study study = series.getStudy();
        Attributes attrs = new Attributes(series.getAttributes());
        Attributes.unifyCharacterSets((Attributes[])new Attributes[]{attrs, study.getAttributes(), study.getPatient().getAttributes()});
        attrs.addAll(study.getAttributes());
        attrs.addAll(study.getPatient().getAttributes());
        return attrs;
    }

    private Series findSeries(HL7PSUTask task) {
        try {
            return (Series)this.em.createNamedQuery("Series.findBySeriesIUID", Series.class).setParameter(1, (Object)task.getStudyInstanceUID()).setParameter(2, (Object)task.getSeriesInstanceUID()).getSingleResult();
        }
        catch (NoResultException e) {
            LOG.info("Series referenced in HL7PSUTask {} does not exist", (Object)task);
            return null;
        }
    }
}

