/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.hl7.impl;

import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.Date;
import java.util.stream.Stream;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.dcm4che3.conf.api.ConfigurationException;
import org.dcm4che3.conf.api.ConfigurationNotFoundException;
import org.dcm4che3.conf.api.hl7.IHL7ApplicationCache;
import org.dcm4che3.hl7.HL7Segment;
import org.dcm4che3.net.Device;
import org.dcm4che3.net.hl7.HL7Application;
import org.dcm4che3.net.hl7.HL7Connection;
import org.dcm4che3.net.hl7.HL7DeviceExtension;
import org.dcm4che3.net.hl7.UnparsedHL7Message;
import org.dcm4che3.util.ReverseDNS;
import org.dcm4chee.arc.HL7ConnectionEvent;
import org.dcm4chee.arc.conf.ArchiveHL7ApplicationExtension;
import org.dcm4chee.arc.conf.HL7Fields;
import org.dcm4chee.arc.conf.HL7ForwardRule;
import org.dcm4chee.arc.entity.Task;
import org.dcm4chee.arc.hl7.HL7Sender;
import org.dcm4chee.arc.keycloak.HttpServletRequestInfo;
import org.dcm4chee.arc.qmgt.TaskManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class HL7SenderImpl
implements HL7Sender {
    private static final Logger LOG = LoggerFactory.getLogger(HL7SenderImpl.class);
    @Inject
    private Device device;
    @Inject
    private IHL7ApplicationCache hl7AppCache;
    @Inject
    private TaskManager taskManager;

    public void onHL7Connection(@Observes HL7ConnectionEvent event) {
        if (event.getType() != HL7ConnectionEvent.Type.MESSAGE_PROCESSED || event.getException() != null) {
            return;
        }
        UnparsedHL7Message msg = event.getHL7Message();
        HL7Application hl7App = ((HL7DeviceExtension)this.device.getDeviceExtension(HL7DeviceExtension.class)).getHL7Application(msg.msh().getReceivingApplicationWithFacility(), true);
        if (hl7App == null) {
            return;
        }
        ArchiveHL7ApplicationExtension arcHL7App = (ArchiveHL7ApplicationExtension)hl7App.getHL7ApplicationExtension(ArchiveHL7ApplicationExtension.class);
        if (arcHL7App == null || !arcHL7App.hasHL7ForwardRules()) {
            return;
        }
        String host = ReverseDNS.hostNameOf((InetAddress)event.getSocket().getInetAddress());
        HL7Fields hl7Fields = new HL7Fields(msg, hl7App.getHL7DefaultCharacterSet());
        arcHL7App.hl7ForwardRules().filter(rule -> rule.match(host, hl7Fields)).map(HL7ForwardRule::getDestinations).flatMap(Stream::of).distinct().forEach(dest -> this.forwardMessage(msg, (String)dest));
    }

    private void forwardMessage(UnparsedHL7Message msg, String dest) {
        HL7Segment msh = msg.msh();
        int field23Len = msh.getField(2, "").length() + msh.getField(3, "").length() + 2;
        int field45Len = msh.getField(4, "").length() + msh.getField(5, "").length() + 2;
        try {
            byte[] data = this.replaceField2345(msg.data(), dest.replace('|', msh.getFieldSeparator()), field23Len, field45Len);
            this.scheduleMessage(null, data);
        }
        catch (Exception e) {
            LOG.warn("Failed to schedule forward of HL7 message to {}:\n", (Object)dest, (Object)e);
        }
    }

    private byte[] replaceField2345(byte[] orighl7msg, String dest, int field23Len, int field45Len) {
        byte[] b = dest.getBytes();
        byte[] hl7msg = new byte[orighl7msg.length + b.length + 1 - field23Len];
        int srcPos = 0;
        int destPos = 0;
        System.arraycopy(orighl7msg, 0, hl7msg, 0, srcPos += 9);
        System.arraycopy(orighl7msg, srcPos += field23Len, hl7msg, destPos += 9, field45Len);
        System.arraycopy(b, 0, hl7msg, destPos += field45Len, b.length);
        System.arraycopy(orighl7msg, srcPos += field45Len - 1, hl7msg, destPos + b.length, orighl7msg.length - srcPos);
        return hl7msg;
    }

    @Override
    public void scheduleMessage(String sendingApplication, String sendingFacility, String receivingApplication, String receivingFacility, String messageType, String messageControlID, byte[] hl7msg, HttpServletRequestInfo httpServletRequestInfo) throws ConfigurationException {
        this.getSendingHl7Application(sendingApplication, sendingFacility);
        this.hl7AppCache.findHL7Application(receivingApplication + "|" + receivingFacility);
        this.scheduleMessage(null, hl7msg);
    }

    @Override
    public UnparsedHL7Message sendMessage(HL7Application sender, String receivingApplication, String receivingFacility, String messageType, String messageControlID, UnparsedHL7Message hl7msg) throws Exception {
        HL7Application receiver = this.hl7AppCache.findHL7Application(receivingApplication + "|" + receivingFacility);
        return this.sendMessage(sender, receiver, hl7msg);
    }

    @Override
    public UnparsedHL7Message sendMessage(HL7Application sender, HL7Application receiver, UnparsedHL7Message hl7Msg) throws Exception {
        try (HL7Connection conn = sender.open(receiver);){
            conn.writeMessage(hl7Msg);
            UnparsedHL7Message rsp = conn.readMessage(hl7Msg);
            if (rsp == null) {
                throw new IOException("TCP connection dropped while waiting for response");
            }
            UnparsedHL7Message unparsedHL7Message = rsp;
            return unparsedHL7Message;
        }
    }

    private HL7Application getSendingHl7Application(String sendingApplication, String sendingFacility) throws ConfigurationNotFoundException {
        String sendingAppWithFacility;
        HL7DeviceExtension hl7Dev = (HL7DeviceExtension)this.device.getDeviceExtension(HL7DeviceExtension.class);
        HL7Application sender = hl7Dev.getHL7Application(sendingAppWithFacility = sendingApplication + "|" + sendingFacility, true);
        if (sender == null) {
            throw new ConfigurationNotFoundException("Sending HL7 Application not configured : " + sendingAppWithFacility);
        }
        return sender;
    }

    @Override
    public void scheduleMessage(HttpServletRequestInfo httpServletRequestInfo, byte[] data) {
        UnparsedHL7Message hl7Msg = new UnparsedHL7Message(data);
        HL7Segment msh = hl7Msg.msh();
        Task task = new Task();
        task.setDeviceName(this.device.getDeviceName());
        task.setQueueName("HL7Send");
        task.setType(Task.Type.HL7);
        task.setScheduledTime(new Date());
        task.setSendingApplicationWithFacility(msh.getSendingApplicationWithFacility());
        task.setReceivingApplicationWithFacility(msh.getReceivingApplicationWithFacility());
        task.setMessageType(msh.getMessageType());
        task.setMessageControlID(msh.getMessageControlID());
        if (httpServletRequestInfo != null) {
            task.setRequesterUserID(httpServletRequestInfo.requesterUserID);
            task.setRequesterHost(httpServletRequestInfo.requesterHost);
            task.setRequestURI(this.requestURL(httpServletRequestInfo));
        }
        task.setPayload((Serializable)data);
        task.setStatus(Task.Status.SCHEDULED);
        this.taskManager.scheduleTask(task);
    }

    private String requestURL(HttpServletRequestInfo httpServletRequestInfo) {
        String requestURI = httpServletRequestInfo.requestURI;
        String queryString = httpServletRequestInfo.queryString;
        return queryString == null ? requestURI : requestURI + "?" + queryString;
    }
}

