/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.hl7;

import java.net.Socket;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Typed;
import javax.inject.Inject;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.VR;
import org.dcm4che3.hl7.ERRSegment;
import org.dcm4che3.hl7.HL7Exception;
import org.dcm4che3.hl7.HL7Message;
import org.dcm4che3.hl7.HL7Segment;
import org.dcm4che3.net.Connection;
import org.dcm4che3.net.hl7.HL7Application;
import org.dcm4che3.net.hl7.UnparsedHL7Message;
import org.dcm4che3.net.hl7.service.DefaultHL7Service;
import org.dcm4che3.net.hl7.service.HL7Service;
import org.dcm4chee.arc.conf.ArchiveHL7ApplicationExtension;
import org.dcm4chee.arc.conf.HL7ReferredMergedPatientPolicy;
import org.dcm4chee.arc.conf.SPSStatus;
import org.dcm4chee.arc.entity.Patient;
import org.dcm4chee.arc.hl7.ArchiveHL7Message;
import org.dcm4chee.arc.hl7.SAXTransformer;
import org.dcm4chee.arc.patient.CircularPatientMergeException;
import org.dcm4chee.arc.patient.NonUniquePatientException;
import org.dcm4chee.arc.patient.PatientMergedException;
import org.dcm4chee.arc.patient.PatientMgtContext;
import org.dcm4chee.arc.patient.PatientService;
import org.dcm4chee.arc.patient.PatientTrackingNotAllowedException;
import org.dcm4chee.arc.procedure.ProcedureContext;
import org.dcm4chee.arc.procedure.ProcedureService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
@Typed(value={HL7Service.class})
class PatientUpdateService
extends DefaultHL7Service {
    private static final Logger LOG = LoggerFactory.getLogger(PatientUpdateService.class);
    private static final String PATIENT_IDENTIFIER = "PID^1^3^1^1";
    private static final String PRIOR_PATIENT_IDENTIFIER = "MRG^1^1^1^1";
    private static final String CHANGE_PATIENT_IDENTIFIER = "ADT^A47";
    private static final String MERGE_PATIENT_IDENTIFIER = "ADT^A40";
    private static final String[] MESSAGE_TYPES = new String[]{"ADT^A01", "ADT^A02", "ADT^A03", "ADT^A04", "ADT^A05", "ADT^A06", "ADT^A07", "ADT^A08", "ADT^A10", "ADT^A11", "ADT^A12", "ADT^A13", "ADT^A28", "ADT^A31", "ADT^A38", "ADT^A40", "ADT^A47"};
    @Inject
    private PatientService patientService;
    @Inject
    private ProcedureService procedureService;

    public PatientUpdateService() {
        super(MESSAGE_TYPES);
    }

    public UnparsedHL7Message onMessage(HL7Application hl7App, Connection conn, Socket s, UnparsedHL7Message msg) throws HL7Exception {
        ArchiveHL7Message archiveHL7Message = new ArchiveHL7Message(HL7Message.makeACK((HL7Segment)msg.msh(), (String)"AA", null).getBytes(null));
        Patient patient = PatientUpdateService.updatePatient(hl7App, s, msg, this.patientService, archiveHL7Message);
        this.updateProcedure(hl7App, s, msg, patient);
        return archiveHL7Message;
    }

    static Patient updatePatient(HL7Application hl7App, Socket s, UnparsedHL7Message msg, PatientService patientService, ArchiveHL7Message archiveHL7Message) throws HL7Exception {
        ArchiveHL7ApplicationExtension arcHL7App = (ArchiveHL7ApplicationExtension)hl7App.getHL7ApplicationExtension(ArchiveHL7ApplicationExtension.class);
        Attributes attrs = PatientUpdateService.transform(msg, arcHL7App);
        if (arcHL7App.hl7VeterinaryUsePatientName()) {
            PatientUpdateService.useHL7VeterinaryPatientName(attrs);
        }
        PatientMgtContext ctx = patientService.createPatientMgtContextHL7(hl7App, s, msg);
        ctx.setAttributes(attrs);
        if (ctx.getPatientID() == null) {
            throw new HL7Exception((HL7Segment)new ERRSegment(msg.msh()).setHL7ErrorCode("101^Required field missing^HL70357").setErrorLocation(PATIENT_IDENTIFIER).setUserMessage("Missing patient identifier"));
        }
        Attributes mrg = attrs.getNestedDataset(0x4000550);
        if (mrg == null) {
            return PatientUpdateService.createOrUpdatePatient(patientService, ctx, archiveHL7Message, msg, arcHL7App);
        }
        ctx.setPreviousAttributes(mrg);
        if (ctx.getPreviousPatientID() == null) {
            throw new HL7Exception((HL7Segment)new ERRSegment(msg.msh()).setHL7ErrorCode("101^Required field missing^HL70357").setErrorLocation(PRIOR_PATIENT_IDENTIFIER).setUserMessage("Missing prior patient identifier"));
        }
        return PatientUpdateService.changePIDOrMergePatient(patientService, ctx, archiveHL7Message, msg, arcHL7App);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Patient createOrUpdatePatient(PatientService patientService, PatientMgtContext ctx, ArchiveHL7Message archiveHL7Message, UnparsedHL7Message msg, ArchiveHL7ApplicationExtension arcHL7App) throws HL7Exception {
        try {
            Patient patient = patientService.updatePatient(ctx);
            return patient;
        }
        catch (NonUniquePatientException e) {
            throw new HL7Exception((HL7Segment)new ERRSegment(msg.msh()).setHL7ErrorCode("205^Duplicate key identifier^HL70357").setUserMessage(e.getMessage()));
        }
        catch (Exception e) {
            if (PatientUpdateService.reject(e, arcHL7App, msg)) {
                throw new HL7Exception((HL7Segment)new ERRSegment(msg.msh()).setHL7ErrorCode("207^Application internal error^HL70357").setUserMessage(e.getMessage()));
            }
            Patient patient = null;
            return patient;
        }
        finally {
            archiveHL7Message.setPatRecEventActionCode(ctx.getEventActionCode());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Patient changePIDOrMergePatient(PatientService patientService, PatientMgtContext ctx, ArchiveHL7Message archiveHL7Message, UnparsedHL7Message msg, ArchiveHL7ApplicationExtension arcHL7App) throws HL7Exception {
        try {
            Patient patient = msg.msh().getMessageType().equals(CHANGE_PATIENT_IDENTIFIER) ? patientService.changePatientID(ctx) : patientService.mergePatient(ctx);
            return patient;
        }
        catch (PatientTrackingNotAllowedException e) {
            throw new HL7Exception((HL7Segment)new ERRSegment(msg.msh()).setHL7ErrorCode("205^Duplicate key identifier^HL70357").setErrorLocation(PATIENT_IDENTIFIER).setUserMessage(e.getMessage()));
        }
        catch (CircularPatientMergeException e) {
            throw new HL7Exception((HL7Segment)new ERRSegment(msg.msh()).setHL7ErrorCode("205^Duplicate key identifier^HL70357").setErrorLocation(PRIOR_PATIENT_IDENTIFIER).setUserMessage("Prior patient identifier matches patient identifier"));
        }
        catch (Exception e) {
            if (PatientUpdateService.reject(e, arcHL7App, msg)) {
                throw new HL7Exception((HL7Segment)new ERRSegment(msg.msh()).setHL7ErrorCode("207^Application internal error^HL70357").setUserMessage(e.getMessage()));
            }
            Patient patient = null;
            return patient;
        }
        finally {
            archiveHL7Message.setPatRecEventActionCode(ctx.getEventActionCode());
        }
    }

    private static boolean reject(Exception e, ArchiveHL7ApplicationExtension arcHL7App, UnparsedHL7Message msg) throws HL7Exception {
        if (e instanceof PatientMergedException) {
            String messageType = msg.msh().getMessageType();
            HL7ReferredMergedPatientPolicy hl7ReferredMergedPatientPolicy = arcHL7App.hl7ReferredMergedPatientPolicy();
            if (hl7ReferredMergedPatientPolicy == HL7ReferredMergedPatientPolicy.REJECT) {
                throw new HL7Exception((HL7Segment)new ERRSegment(msg.msh()).setHL7ErrorCode("204^Unknown key identifier^HL70357").setErrorLocation(messageType.equals(MERGE_PATIENT_IDENTIFIER) ? PRIOR_PATIENT_IDENTIFIER : PATIENT_IDENTIFIER).setUserMessage(e.getMessage()));
            }
            if (hl7ReferredMergedPatientPolicy == HL7ReferredMergedPatientPolicy.IGNORE_DUPLICATE_MERGE && !messageType.equals(MERGE_PATIENT_IDENTIFIER)) {
                throw new HL7Exception((HL7Segment)new ERRSegment(msg.msh()).setHL7ErrorCode("204^Unknown key identifier^HL70357").setErrorLocation(PATIENT_IDENTIFIER).setUserMessage(e.getMessage()));
            }
            LOG.info("Ignore HL7ReferredMergedPatientPolicy[{}] for message type {} : {}", new Object[]{hl7ReferredMergedPatientPolicy, messageType, e.getMessage()});
            return false;
        }
        return true;
    }

    private static void useHL7VeterinaryPatientName(Attributes attrs) {
        String patientName = attrs.getString(0x100010);
        String responsiblePerson = attrs.getString(1057431);
        int index = patientName.indexOf(94, patientName.indexOf(94) + 1);
        patientName = index != -1 ? patientName.substring(0, index) : (!patientName.contains("^") && responsiblePerson != null ? (responsiblePerson.contains("^") ? responsiblePerson.substring(0, responsiblePerson.indexOf(94)) : responsiblePerson) + "^" + patientName : patientName);
        attrs.setString(0x100010, VR.PN, patientName);
    }

    private static Attributes transform(UnparsedHL7Message msg, ArchiveHL7ApplicationExtension arcHL7App) throws HL7Exception {
        try {
            return SAXTransformer.transform(msg, arcHL7App, arcHL7App.patientUpdateTemplateURI(), null);
        }
        catch (Exception e) {
            throw new HL7Exception((HL7Segment)new ERRSegment(msg.msh()).setUserMessage(e.getMessage()), (Throwable)e);
        }
    }

    private void updateProcedure(HL7Application hl7App, Socket s, UnparsedHL7Message msg, Patient pat) {
        ArchiveHL7ApplicationExtension arcHL7App = (ArchiveHL7ApplicationExtension)hl7App.getHL7ApplicationExtension(ArchiveHL7ApplicationExtension.class);
        String messageType = arcHL7App.hl7PatientArrivalMessageType();
        if (messageType != null && messageType.equals(msg.msh().getMessageType())) {
            ProcedureContext ctx = this.procedureService.createProcedureContext().setSocket(s).setHL7Message(msg);
            ctx.setArchiveHL7AppExtension(arcHL7App);
            ctx.setPatient(pat);
            ctx.setSpsStatus(SPSStatus.ARRIVED);
            this.procedureService.updateMWLStatus(ctx, SPSStatus.SCHEDULED);
        }
    }
}

