/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.hl7;

import java.io.UnsupportedEncodingException;
import java.util.Date;
import javax.xml.transform.TransformerConfigurationException;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.IDWithIssuer;
import org.dcm4che3.hl7.HL7Segment;
import org.dcm4che3.net.hl7.HL7Application;
import org.dcm4che3.util.AttributesFormat;
import org.dcm4chee.arc.conf.ArchiveAEExtension;
import org.dcm4chee.arc.conf.ArchiveHL7ApplicationExtension;
import org.dcm4chee.arc.hl7.SAXTransformer;
import org.xml.sax.SAXException;

public class HL7SenderUtils {
    public static byte[] data(HL7Application sender, HL7Application receiver, Attributes attrs, Attributes prev, String msgType, String uri, String ppsStatus, ArchiveAEExtension arcAE) throws TransformerConfigurationException, UnsupportedEncodingException, SAXException {
        return SAXTransformer.transform(attrs, sender.getHL7SendingCharacterSet(), uri, tr -> {
            tr.setParameter("sender", sender.getApplicationName());
            tr.setParameter("receiver", receiver.getApplicationName());
            tr.setParameter("dateTime", HL7Segment.timeStamp((Date)new Date()));
            tr.setParameter("msgControlID", HL7Segment.nextMessageControlID());
            if (!sender.getHL7SendingCharacterSet().equals("ASCII")) {
                tr.setParameter("charset", sender.getHL7SendingCharacterSet());
            }
            tr.setParameter("msgType", msgType);
            if (prev != null) {
                IDWithIssuer prevPID = IDWithIssuer.pidOf((Attributes)prev);
                if (prevPID != null) {
                    tr.setParameter("priorPatientID", prevPID.toString());
                }
                String prevPatName = prev.getString(0x100010);
                if (msgType.equals("ADT^A40^ADT_A39") && prevPatName != null) {
                    tr.setParameter("priorPatientName", prevPatName);
                }
            }
            if (((ArchiveHL7ApplicationExtension)sender.getHL7ApplicationExtension(ArchiveHL7ApplicationExtension.class)).hl7UseNullValue()) {
                tr.setParameter("includeNullValues", "\"\"");
            }
            if (ppsStatus != null) {
                tr.setParameter("ppsStatus", ppsStatus);
            }
            if (arcAE != null) {
                tr.setParameter("isPIDPV1", arcAE.hl7PSUPIDPV1());
                arcAE.getHL7PSUTemplateParams().forEach((k, v) -> tr.setParameter((String)k, new AttributesFormat(v).format((Object)attrs)));
            }
        });
    }
}

