/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.export.dicom;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import javax.inject.Named;
import org.dcm4che3.net.service.RetrieveTask;
import org.dcm4chee.arc.conf.ExporterDescriptor;
import org.dcm4chee.arc.export.dicom.DicomExporter;
import org.dcm4chee.arc.exporter.Exporter;
import org.dcm4chee.arc.exporter.ExporterProvider;
import org.dcm4chee.arc.qmgt.TaskCanceled;
import org.dcm4chee.arc.retrieve.RetrieveService;
import org.dcm4chee.arc.store.scu.CStoreSCU;

@ApplicationScoped
@Named(value="dicom")
public class DicomExporterProvider
implements ExporterProvider {
    @Inject
    private RetrieveService retrieveService;
    @Inject
    private CStoreSCU storeSCU;
    private final Map<Long, RetrieveTask> retrieveTaskMap = Collections.synchronizedMap(new HashMap());

    public Exporter getExporter(ExporterDescriptor descriptor) {
        return new DicomExporter(descriptor, this.retrieveService, this.storeSCU, this.retrieveTaskMap);
    }

    public void cancelRetrieveTask(@Observes TaskCanceled event) {
        RetrieveTask retrieveTask = this.retrieveTaskMap.get(event.task.getPk());
        if (retrieveTask != null) {
            retrieveTask.onCancelRQ(null);
        }
    }
}

