/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.entity;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import javax.json.stream.JsonGenerator;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.apache.commons.csv.CSVPrinter;
import org.dcm4che3.conf.json.JsonWriter;
import org.dcm4che3.data.Code;
import org.dcm4che3.util.StringUtils;
import org.dcm4che3.util.TagUtils;
import org.dcm4chee.arc.conf.StorageVerificationPolicy;
import org.dcm4chee.arc.entity.AttributesBlob;

@Entity
@Table(name="task", indexes={@Index(columnList="device_name"), @Index(columnList="queue_name"), @Index(columnList="task_type"), @Index(columnList="task_status"), @Index(columnList="created_time"), @Index(columnList="updated_time"), @Index(columnList="scheduled_time"), @Index(columnList="batch_id"), @Index(columnList="local_aet"), @Index(columnList="remote_aet"), @Index(columnList="destination_aet"), @Index(columnList="check_missing"), @Index(columnList="check_different"), @Index(columnList="compare_fields"), @Index(columnList="study_iuid, series_iuid, sop_iuid")})
@NamedQueries(value={@NamedQuery(name="Task.FindScheduledByDeviceAndQueueNameAndStatus", query="select o.pk from Task o where o.deviceName=?1 and o.queueName=?2 and o.status=?3 and o.scheduledTime < current_timestamp order by o.scheduledTime"), @NamedQuery(name="Task.FindByExporterIDAndStudyIUID", query="select o from Task o where o.type=?4 and o.exporterID=?1 and o.studyInstanceUID=?2 and o.status=?3"), @NamedQuery(name="Task.FindByExporterIDAndStudyIUIDAndSeriesIUID", query="select o from Task o where o.type=?5 and o.exporterID=?1 and o.studyInstanceUID=?2 and o.seriesInstanceUID in ('*',?3) and o.status=?4"), @NamedQuery(name="Task.FindByExporterIDAndStudyIUIDAndSeriesIUIDAndSopInstanceUID", query="select o from Task o where o.type=?6 and o.exporterID=?1 and o.studyInstanceUID=?2 and o.seriesInstanceUID in ('*',?3) and o.sopInstanceUID in ('*',?4) and o.status=?5"), @NamedQuery(name="Task.FindStudyExportAfter", query="select o from Task o where o.type=?4 and o.updatedTime > ?1 and o.exporterID=?2 and o.studyInstanceUID=?3 and o.seriesInstanceUID='*'"), @NamedQuery(name="Task.DiffAttrsByPk", query="select attrs.encodedAttributes from Task o join o.diffTaskAttributes attrs where o.pk=?1"), @NamedQuery(name="Task.CountByDeviceAndQueueNameAndStatus", query="select count(o) from Task o where o.deviceName=?1 and o.queueName=?2 and o.status=?3"), @NamedQuery(name="Task.CountByBatchIdAndType", query="select count(o) from Task o where o.batchID=?1 and o.type=?2"), @NamedQuery(name="Task.UpdateStatus", query="update Task o set o.status = ?1 where o.status=?2 and o.queueName=?3 and o.deviceName=?4"), @NamedQuery(name="Task.UpdateStgVerResultByPk", query="update Task o set o.updatedTime=current_timestamp, o.completed=?2, o.failed=?3 where pk=?1"), @NamedQuery(name="Task.UpdateRetrieveResultByPk", query="update Task o set o.updatedTime=current_timestamp, o.remaining=?2, o.completed=?3, o.failed=?4, o.warning=?5, o.statusCode=?6, o.errorComment=?7 where o.pk=?1")})
public class Task {
    public static final String FIND_SCHEDULED_BY_DEVICE_AND_QUEUE_NAME_AND_STATUS = "Task.FindScheduledByDeviceAndQueueNameAndStatus";
    public static final String FIND_STUDY_EXPORT_AFTER = "Task.FindStudyExportAfter";
    public static final String FIND_BY_EXPORTER_ID_AND_STUDY_IUID = "Task.FindByExporterIDAndStudyIUID";
    public static final String FIND_BY_EXPORTER_ID_AND_STUDY_IUID_AND_SERIES_IUID = "Task.FindByExporterIDAndStudyIUIDAndSeriesIUID";
    public static final String FIND_BY_EXPORTER_ID_AND_STUDY_IUID_AND_SERIES_IUID_AND_SOP_IUID = "Task.FindByExporterIDAndStudyIUIDAndSeriesIUIDAndSopInstanceUID";
    public static final String DIFF_ATTRS_BY_PK = "Task.DiffAttrsByPk";
    public static final String COUNT_BY_DEVICE_AND_QUEUE_NAME_AND_STATUS = "Task.CountByDeviceAndQueueNameAndStatus";
    public static final String COUNT_BY_BATCH_ID_AND_TYPE = "Task.CountByBatchIdAndType";
    public static final String UPDATE_STATUS = "Task.UpdateStatus";
    public static final String UPDATE_STGVER_RESULT_BY_PK = "Task.UpdateStgVerResultByPk";
    public static final String UPDATE_RETRIEVE_RESULT_BY_PK = "Task.UpdateRetrieveResultByPk";
    public static final String[] EXPORT_CSV_HEADERS = new String[]{"taskID", "createdTime", "updatedTime", "ExporterID", "LocalAET", "StudyInstanceUID", "SeriesInstanceUID", "SOPInstanceUID", "NumberOfInstances", "Modality", "batchID", "dicomDeviceName", "scheduledTime", "status", "queue", "failures", "processingStartTime", "processingEndTime", "errorMessage", "outcomeMessage"};
    public static final String[] RETRIEVE_CSV_HEADERS = new String[]{"taskID", "createdTime", "updatedTime", "LocalAET", "RemoteAET", "DestinationAET", "StudyInstanceUID", "SeriesInstanceUID", "SOPInstanceUID", "remaining", "completed", "failed", "warning", "statusCode", "errorComment", "batchID", "dicomDeviceName", "queue", "scheduledTime", "status", "failures", "processingStartTime", "processingEndTime", "errorMessage", "outcomeMessage"};
    public static final String[] STGVER_CSV_HEADERS = new String[]{"taskID", "createdTime", "updatedTime", "LocalAET", "StgCmtPolicy", "UpdateLocationStatus", "StorageID", "StudyInstanceUID", "SeriesInstanceUID", "SOPInstanceUID", "completed", "failed", "queue", "dicomDeviceName", "status", "scheduledTime", "failures", "batchID", "processingStartTime", "processingEndTime", "errorMessage", "outcomeMessage"};
    public static final String[] DIFF_CSV_HEADERS = new String[]{"taskID", "LocalAET", "PrimaryAET", "SecondaryAET", "QueryString", "checkMissing", "checkDifferent", "matches", "missing", "different", "comparefield", "createdTime", "updatedTime", "queue", "dicomDeviceName", "status", "scheduledTime", "failures", "batchID", "processingStartTime", "processingEndTime", "errorMessage", "outcomeMessage"};
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="pk")
    private long pk;
    @Version
    @Column(name="version")
    private long version;
    @Basic(optional=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="created_time", updatable=false)
    private Date createdTime;
    @Basic(optional=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="updated_time")
    private Date updatedTime;
    @Basic(optional=false)
    @Column(name="device_name")
    private String deviceName;
    @Basic(optional=false)
    @Column(name="queue_name")
    private String queueName;
    @Basic(optional=false)
    @Column(name="task_type")
    private Type type;
    @Basic(optional=false)
    @Column(name="task_status")
    private Status status;
    @Basic(optional=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="scheduled_time")
    private Date scheduledTime;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="proc_start_time")
    private Date processingStartTime;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="proc_end_time")
    private Date processingEndTime;
    @Basic(optional=false)
    @Column(name="num_failures")
    private int numberOfFailures;
    @Column(name="batch_id", updatable=false)
    private String batchID;
    @Column(name="error_msg")
    private String errorMessage;
    @Column(name="outcome_msg")
    private String outcomeMessage;
    @Column(name="local_aet")
    private String localAET;
    @Column(name="remote_aet")
    private String remoteAET;
    @Column(name="destination_aet")
    private String destinationAET;
    @Column(name="exporter_id")
    private String exporterID;
    @Column(name="stgcmt_policy", updatable=false)
    private StorageVerificationPolicy storageVerificationPolicy;
    @Column(name="update_location_status", updatable=false)
    private Boolean updateLocationStatus;
    @Column(name="storage_ids", updatable=false)
    private String storageIDs;
    @Column(name="study_iuid")
    private String studyInstanceUID;
    @Column(name="series_iuid")
    private String seriesInstanceUID;
    @Column(name="sop_iuid")
    private String sopInstanceUID;
    @Column(name="num_instances")
    private Integer numberOfInstances;
    @Column(name="modalities")
    private String modalities;
    @Column(name="remaining")
    private int remaining;
    @Column(name="completed")
    private int completed;
    @Column(name="failed")
    private int failed;
    @Basic(optional=false)
    @Column(name="warning")
    private int warning;
    @Column(name="status_code")
    private int statusCode;
    @Column(name="error_comment")
    private String errorComment;
    @Column(name="rq_user_id", updatable=false)
    private String requesterUserID;
    @Column(name="rq_host", updatable=false)
    private String requesterHost;
    @Column(name="rq_uri", updatable=false, length=4000)
    private String requestURI;
    @Column(name="query_str", updatable=false)
    private String queryString;
    @Column(name="check_missing", updatable=false)
    private boolean checkMissing;
    @Column(name="check_different", updatable=false)
    private boolean checkDifferent;
    @Column(name="compare_fields", updatable=false)
    private String compareFields;
    @Basic(optional=false)
    @Column(name="matches")
    private int matches;
    @Basic(optional=false)
    @Column(name="missing")
    private int missing;
    @Basic(optional=false)
    @Column(name="different")
    private int different;
    @Column(name="payload", updatable=false)
    private byte[] payload;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true)
    @JoinTable(name="rel_task_dicomattrs", joinColumns={@JoinColumn(name="task_fk", referencedColumnName="pk")}, inverseJoinColumns={@JoinColumn(name="dicomattrs_fk", referencedColumnName="pk")})
    private Collection<AttributesBlob> diffTaskAttributes;

    public long getPk() {
        return this.pk;
    }

    public String getDeviceName() {
        return this.deviceName;
    }

    public void setDeviceName(String deviceName) {
        this.deviceName = deviceName;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public Date getProcessingStartTime() {
        return this.processingStartTime;
    }

    public void setProcessingStartTime(Date processingStartTime) {
        this.processingStartTime = processingStartTime;
    }

    public Date getProcessingEndTime() {
        return this.processingEndTime;
    }

    public void setProcessingEndTime(Date processingEndTime) {
        this.processingEndTime = processingEndTime;
    }

    public int getNumberOfFailures() {
        return this.numberOfFailures;
    }

    public int incrementNumberOfFailures() {
        return ++this.numberOfFailures;
    }

    public void setNumberOfFailures(int numberOfFailures) {
        this.numberOfFailures = numberOfFailures;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage != null ? StringUtils.truncate((String)errorMessage, (int)255) : null;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public String getQueueName() {
        return this.queueName;
    }

    public void setQueueName(String queueName) {
        this.queueName = queueName;
    }

    public Date getScheduledTime() {
        return this.scheduledTime;
    }

    public void setScheduledTime(Date scheduledTime) {
        this.scheduledTime = scheduledTime;
    }

    public String getOutcomeMessage() {
        return this.outcomeMessage;
    }

    public void setOutcomeMessage(String outcomeMessage) {
        this.outcomeMessage = outcomeMessage != null ? StringUtils.truncate((String)outcomeMessage, (int)255) : null;
    }

    public String getBatchID() {
        return this.batchID;
    }

    public void setBatchID(String batchID) {
        this.batchID = batchID;
    }

    public String getLocalAET() {
        return this.localAET;
    }

    public void setLocalAET(String localAET) {
        this.localAET = localAET;
    }

    public String getRemoteAET() {
        return this.remoteAET;
    }

    public void setRemoteAET(String remoteAET) {
        this.remoteAET = remoteAET;
    }

    public String getDestinationAET() {
        return this.destinationAET;
    }

    public void setDestinationAET(String destinationAET) {
        this.destinationAET = destinationAET;
    }

    public String getPrimaryAET() {
        return this.remoteAET;
    }

    public void setPrimaryAET(String remoteAET) {
        this.remoteAET = remoteAET;
    }

    public String getSecondaryAET() {
        return this.destinationAET;
    }

    public void setSecondaryAET(String destinationAET) {
        this.destinationAET = destinationAET;
    }

    public String getWebApplicationName() {
        return this.destinationAET;
    }

    public void setWebApplicationName(String webApplicationName) {
        this.destinationAET = webApplicationName;
    }

    public String getSendingApplicationWithFacility() {
        return this.localAET;
    }

    public void setSendingApplicationWithFacility(String appName) {
        this.localAET = appName;
    }

    public String getReceivingApplicationWithFacility() {
        return this.remoteAET;
    }

    public void setReceivingApplicationWithFacility(String appName) {
        this.remoteAET = appName;
    }

    public String getMessageType() {
        return this.exporterID;
    }

    public void setMessageType(String messageType) {
        this.exporterID = messageType;
    }

    public String getMessageControlID() {
        return this.queryString;
    }

    public void setMessageControlID(String messageControlID) {
        this.queryString = messageControlID;
    }

    public String getExporterID() {
        return this.exporterID;
    }

    public void setExporterID(String exporterID) {
        this.exporterID = exporterID;
    }

    public String getRSOperation() {
        return this.exporterID;
    }

    public void setRSOperation(String rsOperation) {
        this.exporterID = rsOperation;
    }

    public String getFindSCP() {
        return this.exporterID;
    }

    public void setFindSCP(String findSCP) {
        this.exporterID = findSCP;
    }

    public String getDIMSE() {
        return this.exporterID;
    }

    public void setDIMSE(String dimse) {
        this.exporterID = dimse;
    }

    public StorageVerificationPolicy getStorageVerificationPolicy() {
        return this.storageVerificationPolicy;
    }

    public void setStorageVerificationPolicy(StorageVerificationPolicy storageVerificationPolicy) {
        this.storageVerificationPolicy = storageVerificationPolicy;
    }

    public Boolean getUpdateLocationStatus() {
        return this.updateLocationStatus;
    }

    public void setUpdateLocationStatus(Boolean updateLocationStatus) {
        this.updateLocationStatus = updateLocationStatus;
    }

    public String getStorageIDsAsString() {
        return this.storageIDs;
    }

    public String[] getStorageIDs() {
        return StringUtils.split((String)this.storageIDs, (char)'\\');
    }

    public void setStorageIDs(String[] storageIDs) {
        if (storageIDs != null && storageIDs.length > 0) {
            Arrays.sort(storageIDs);
            this.storageIDs = StringUtils.concat((String[])storageIDs, (char)'\\');
        } else {
            this.storageIDs = null;
        }
    }

    public String getStudyInstanceUID() {
        return this.studyInstanceUID;
    }

    public void setStudyInstanceUID(String studyInstanceUID) {
        this.studyInstanceUID = studyInstanceUID;
    }

    public String getSeriesInstanceUID() {
        return this.seriesInstanceUID;
    }

    public void setSeriesInstanceUID(String seriesInstanceUID) {
        this.seriesInstanceUID = seriesInstanceUID;
    }

    public String getSOPInstanceUID() {
        return this.sopInstanceUID;
    }

    public void setSOPInstanceUID(String sopInstanceUID) {
        this.sopInstanceUID = sopInstanceUID;
    }

    public Integer getNumberOfInstances() {
        return this.numberOfInstances;
    }

    public void setNumberOfInstances(Integer numberOfInstances) {
        this.numberOfInstances = numberOfInstances;
    }

    public String[] getModalities() {
        return StringUtils.split((String)this.modalities, (char)'\\');
    }

    public void setModalities(String[] modalities) {
        this.modalities = StringUtils.concat((String[])modalities, (char)'\\');
    }

    public String getAccessionNumber() {
        return this.modalities;
    }

    public void setAccessionNumber(String accessionNummber) {
        this.modalities = accessionNummber;
    }

    public int getRemaining() {
        return this.remaining;
    }

    public void setRemaining(int remaining) {
        this.remaining = remaining;
    }

    public int getCompleted() {
        return this.completed;
    }

    public void setCompleted(int completed) {
        this.completed = completed;
    }

    public int getFailed() {
        return this.failed;
    }

    public void setFailed(int failed) {
        this.failed = failed;
    }

    public int getWarning() {
        return this.warning;
    }

    public void setWarning(int warning) {
        this.warning = warning;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public void setStatusCode(int statusCode) {
        this.statusCode = statusCode;
    }

    public String getErrorComment() {
        return this.errorComment;
    }

    public void setErrorComment(String errorComment) {
        this.errorComment = errorComment;
    }

    public String getRequesterUserID() {
        return this.requesterUserID;
    }

    public void setRequesterUserID(String requesterUserID) {
        this.requesterUserID = requesterUserID;
    }

    public String getRequesterHost() {
        return this.requesterHost;
    }

    public void setRequesterHost(String requesterHost) {
        this.requesterHost = requesterHost;
    }

    public String getRequestURI() {
        return this.requestURI;
    }

    public void setRequestURI(String requestURI) {
        this.requestURI = requestURI;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public void setQueryString(String queryString) {
        this.queryString = queryString;
    }

    public Code getCode() {
        return new Code(this.queryString);
    }

    public void setCode(Code code) {
        this.queryString = code.toString();
    }

    public String getPatientName() {
        return this.queryString;
    }

    public void setPatientName(String patientName) {
        this.queryString = patientName;
    }

    public boolean isCheckMissing() {
        return this.checkMissing;
    }

    public void setCheckMissing(boolean checkMissing) {
        this.checkMissing = checkMissing;
    }

    public boolean isTLSAllowAnyHostname() {
        return this.checkMissing;
    }

    public void setTLSAllowAnyHostname(boolean tlsAllowAnyHostname) {
        this.checkMissing = tlsAllowAnyHostname;
    }

    public boolean isCheckDifferent() {
        return this.checkDifferent;
    }

    public void setCheckDifferent(boolean checkDifferent) {
        this.checkDifferent = checkDifferent;
    }

    public boolean isTLSDisableTrustManager() {
        return this.checkDifferent;
    }

    public void setTLSDisableTrustManager(boolean tlsDisableTrustManager) {
        this.checkDifferent = tlsDisableTrustManager;
    }

    public String getCompareFields() {
        return this.compareFields;
    }

    public void setCompareFields(String compareFields) {
        this.compareFields = compareFields;
    }

    public String getPatientID() {
        return this.compareFields;
    }

    public void setPatientID(String patientID) {
        this.compareFields = patientID;
    }

    public int getMatches() {
        return this.matches;
    }

    public void setMatches(int matches) {
        this.matches = matches;
    }

    public int getMissing() {
        return this.missing;
    }

    public void setMissing(int missing) {
        this.missing = missing;
    }

    public int getDifferent() {
        return this.different;
    }

    public void setDifferent(int different) {
        this.different = different;
    }

    public void resetDiffTask() {
        this.matches = 0;
        this.missing = 0;
        this.different = 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T extends Serializable> T getPayload(Class<T> clazz) {
        if (this.payload == null) {
            return null;
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(this.payload);
        try (ObjectInputStream ois = new ObjectInputStream(bais);){
            Serializable serializable = (Serializable)ois.readObject();
            return (T)serializable;
        }
        catch (Exception e) {
            throw new RuntimeException("Unexpected Exception", e);
        }
    }

    public void setPayload(Serializable obj) {
        if (obj == null) {
            this.payload = null;
        } else {
            ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
            try (ObjectOutputStream oos = new ObjectOutputStream(baos);){
                oos.writeObject(obj);
            }
            catch (IOException e) {
                throw new RuntimeException("Unexpected Exception", e);
            }
            this.payload = baos.toByteArray();
        }
    }

    public Collection<AttributesBlob> getDiffTaskAttributes() {
        return this.diffTaskAttributes;
    }

    public void writeAsJSON(JsonGenerator gen) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
        JsonWriter writer = new JsonWriter(gen);
        gen.writeStartObject();
        writer.writeNotNullOrDef("taskID", (Object)this.pk, null);
        writer.writeNotNullOrDef("dicomDeviceName", (Object)this.deviceName, null);
        writer.writeNotNullOrDef("queue", (Object)this.queueName, null);
        writer.writeNotNullOrDef("type", (Object)this.type.toString(), null);
        writer.writeNotNullOrDef("status", (Object)this.status.toString(), null);
        writer.writeNotNullOrDef("batchID", (Object)this.batchID, null);
        writer.writeNotNullOrDef("failures", (Object)this.numberOfFailures, (Object)0);
        writer.writeNotNullOrDef("createdTime", (Object)df.format(this.createdTime), null);
        writer.writeNotNullOrDef("updatedTime", (Object)df.format(this.updatedTime), null);
        writer.writeNotNullOrDef("scheduledTime", (Object)df.format(this.scheduledTime), null);
        if (this.processingStartTime != null) {
            writer.writeNotNullOrDef("processingStartTime", (Object)df.format(this.processingStartTime), null);
        }
        if (this.processingEndTime != null) {
            writer.writeNotNullOrDef("processingEndTime", (Object)df.format(this.processingEndTime), null);
        }
        writer.writeNotNullOrDef("errorMessage", (Object)this.errorMessage, null);
        writer.writeNotNullOrDef("outcomeMessage", (Object)this.outcomeMessage, null);
        writer.writeNotNullOrDef("RequesterUserID", (Object)this.requesterUserID, null);
        writer.writeNotNullOrDef("RequesterHostName", (Object)this.requesterHost, null);
        writer.writeNotNullOrDef("RequestURI", (Object)this.requestURI, null);
        switch (this.type) {
            case EXPORT: {
                writer.writeNotNullOrDef("LocalAET", (Object)this.localAET, null);
                writer.writeNotNullOrDef("ExporterID", (Object)this.exporterID, null);
                writer.writeNotNullOrDef("StudyInstanceUID", (Object)this.studyInstanceUID, null);
                writer.writeNotNullOrDef("SeriesInstanceUID", (Object)this.seriesInstanceUID, (Object)"*");
                writer.writeNotNullOrDef("SOPInstanceUID", (Object)this.sopInstanceUID, (Object)"*");
                writer.writeNotNullOrDef("NumberOfInstances", (Object)this.numberOfInstances, null);
                writer.writeNotEmpty("Modality", (Object[])this.getModalities(), (Object[])new String[0]);
                break;
            }
            case RETRIEVE: {
                writer.writeNotNullOrDef("LocalAET", (Object)this.localAET, null);
                writer.writeNotNullOrDef("RemoteAET", (Object)this.remoteAET, null);
                writer.writeNotNullOrDef("DestinationAET", (Object)this.destinationAET, null);
                writer.writeNotNullOrDef("FindSCP", (Object)this.getFindSCP(), null);
                writer.writeNotNullOrDef("StudyInstanceUID", (Object)this.studyInstanceUID, null);
                writer.writeNotNullOrDef("SeriesInstanceUID", (Object)this.seriesInstanceUID, null);
                writer.writeNotNullOrDef("SOPInstanceUID", (Object)this.sopInstanceUID, null);
                writer.writeNotNullOrDef("remaining", (Object)this.remaining, (Object)0);
                writer.writeNotNullOrDef("completed", (Object)this.completed, (Object)0);
                writer.writeNotNullOrDef("failed", (Object)this.failed, (Object)0);
                writer.writeNotNullOrDef("warning", (Object)this.warning, (Object)0);
                writer.writeNotNullOrDef("statusCode", (Object)TagUtils.shortToHexString((int)this.statusCode), (Object)-1);
                writer.writeNotNullOrDef("errorComment", (Object)this.errorComment, null);
                break;
            }
            case STGVER: {
                writer.writeNotNullOrDef("LocalAET", (Object)this.localAET, null);
                writer.writeNotNullOrDef("StgCmtPolicy", (Object)this.storageVerificationPolicy, null);
                writer.writeNotNull("UpdateLocationStatus", this.updateLocationStatus);
                writer.writeNotEmpty("StorageID", (Object[])this.getStorageIDs(), (Object[])new String[0]);
                writer.writeNotNullOrDef("StudyInstanceUID", (Object)this.studyInstanceUID, null);
                writer.writeNotNullOrDef("SeriesInstanceUID", (Object)this.seriesInstanceUID, null);
                writer.writeNotNullOrDef("SOPInstanceUID", (Object)this.sopInstanceUID, null);
                writer.writeNotNullOrDef("completed", (Object)this.completed, (Object)0);
                writer.writeNotNullOrDef("failed", (Object)this.failed, (Object)0);
                break;
            }
            case DIFF: {
                writer.writeNotNullOrDef("LocalAET", (Object)this.localAET, null);
                writer.writeNotNullOrDef("PrimaryAET", (Object)this.remoteAET, null);
                writer.writeNotNullOrDef("SecondaryAET", (Object)this.destinationAET, null);
                writer.writeNotNullOrDef("QueryString", (Object)this.queryString, null);
                writer.writeNotDef("checkMissing", this.checkMissing, false);
                writer.writeNotDef("checkDifferent", this.checkDifferent, false);
                writer.writeNotNullOrDef("comparefield", (Object)this.compareFields, null);
                writer.writeNotDef("matches", this.matches, 0);
                writer.writeNotDef("missing", this.missing, 0);
                writer.writeNotDef("different", this.different, 0);
                break;
            }
            case STGCMT_SCP: {
                writer.writeNotNullOrDef("LocalAET", (Object)this.localAET, null);
                writer.writeNotNullOrDef("RemoteAET", (Object)this.remoteAET, null);
                break;
            }
            case STGCMT_SCU: {
                writer.writeNotNullOrDef("LocalAET", (Object)this.localAET, null);
                writer.writeNotNullOrDef("RemoteAET", (Object)this.remoteAET, null);
                writer.writeNotNullOrDef("StudyInstanceUID", (Object)this.studyInstanceUID, null);
                writer.writeNotNullOrDef("SeriesInstanceUID", (Object)this.seriesInstanceUID, (Object)"*");
                writer.writeNotNullOrDef("SOPInstanceUID", (Object)this.sopInstanceUID, (Object)"*");
                writer.writeNotNullOrDef("ExporterID", (Object)this.exporterID, null);
                break;
            }
            case REJECT: {
                writer.writeNotNullOrDef("LocalAET", (Object)this.localAET, null);
                writer.writeNotNullOrDef("StudyInstanceUID", (Object)this.studyInstanceUID, null);
                writer.writeNotNullOrDef("SeriesInstanceUID", (Object)this.seriesInstanceUID, (Object)"*");
                writer.writeNotNullOrDef("SOPInstanceUID", (Object)this.sopInstanceUID, (Object)"*");
                writer.writeNotNullOrDef("Code", (Object)this.queryString, null);
                break;
            }
            case HL7: {
                Task.writeApplicationAndFacilityTo("SendingApplication", "SendingFacility", this.getSendingApplicationWithFacility(), gen);
                Task.writeApplicationAndFacilityTo("ReceivingApplication", "ReceivingFacility", this.getReceivingApplicationWithFacility(), gen);
                gen.write("MessageType", this.getMessageType());
                gen.write("MessageControlID", this.getMessageControlID());
                break;
            }
            case REST: {
                gen.write("RSOperation", this.getRSOperation());
                gen.write("WebApplicationName", this.getWebApplicationName());
                writer.writeNotNullOrDef("RequestQueryString", (Object)this.getQueryString(), null);
                writer.writeNotNullOrDef("PatientID", (Object)this.getPatientID(), null);
                writer.writeNotDef("TLSAllowAnyHostname", this.isTLSAllowAnyHostname(), false);
                writer.writeNotDef("TLSDisableTrustManager", this.isTLSDisableTrustManager(), false);
                break;
            }
            case IAN: {
                gen.write("LocalAET", this.localAET);
                gen.write("RemoteAET", this.remoteAET);
                gen.write("SOPInstanceUID", this.sopInstanceUID);
                break;
            }
            case MPPS: {
                gen.write("LocalAET", this.localAET);
                gen.write("RemoteAET", this.remoteAET);
                gen.write("DIMSE", this.getDIMSE());
                gen.write("SOPInstanceUID", this.sopInstanceUID);
                writer.writeNotNullOrDef("AccessionNumber", (Object)this.getAccessionNumber(), null);
                writer.writeNotNullOrDef("StudyInstanceUID", (Object)this.studyInstanceUID, null);
                writer.writeNotNullOrDef("PatientID", (Object)this.getPatientID(), null);
                writer.writeNotNullOrDef("PatientName", (Object)this.getPatientName(), null);
            }
        }
        gen.writeEnd();
    }

    public void writeAsCSV(CSVPrinter printer) {
        try {
            switch (this.type) {
                case EXPORT: {
                    this.writeExportTaskAsCSV(printer);
                    break;
                }
                case RETRIEVE: {
                    this.writeRetrieveTaskAsCSV(printer);
                    break;
                }
                case STGVER: {
                    this.writeStorageVerificationTaskAsCSV(printer);
                    break;
                }
                case DIFF: {
                    this.writeDiffTaskAsCSV(printer);
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void writeExportTaskAsCSV(CSVPrinter printer) throws IOException {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
        printer.printRecord(new Object[]{Long.toString(this.pk), df.format(this.createdTime), df.format(this.updatedTime), this.exporterID, this.localAET, this.studyInstanceUID, !this.seriesInstanceUID.equals("*") ? this.seriesInstanceUID : null, !this.sopInstanceUID.equals("*") ? this.sopInstanceUID : null, this.numberOfInstances != null ? this.numberOfInstances.toString() : null, this.modalities, this.batchID, this.deviceName, this.scheduledTime, this.status, this.queueName, this.numberOfFailures > 0 ? Integer.toString(this.numberOfFailures) : null, this.processingStartTime != null ? df.format(this.processingStartTime) : null, this.processingEndTime != null ? df.format(this.processingEndTime) : null, this.errorMessage, this.outcomeMessage});
    }

    private void writeRetrieveTaskAsCSV(CSVPrinter printer) throws IOException {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
        printer.printRecord(new Object[]{Long.toString(this.pk), df.format(this.createdTime), df.format(this.updatedTime), this.localAET, this.remoteAET, this.destinationAET, this.studyInstanceUID, this.seriesInstanceUID, this.sopInstanceUID, Integer.toString(this.remaining), Integer.toString(this.completed), Integer.toString(this.failed), Integer.toString(this.warning), this.statusCode != -1 ? TagUtils.shortToHexString((int)this.statusCode) : null, this.errorComment, this.batchID, this.deviceName, this.queueName, this.scheduledTime, this.status, this.numberOfFailures > 0 ? Integer.toString(this.numberOfFailures) : null, this.processingStartTime != null ? df.format(this.processingStartTime) : null, this.processingEndTime != null ? df.format(this.processingEndTime) : null, this.errorMessage, this.outcomeMessage});
    }

    private void writeStorageVerificationTaskAsCSV(CSVPrinter printer) throws IOException {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
        printer.printRecord(new Object[]{Long.toString(this.pk), df.format(this.createdTime), df.format(this.updatedTime), this.localAET, this.storageVerificationPolicy, String.valueOf(this.updateLocationStatus), this.storageIDs, this.studyInstanceUID, this.seriesInstanceUID, this.sopInstanceUID, Integer.toString(this.completed), Integer.toString(this.failed), this.queueName, this.deviceName, this.status, this.scheduledTime, this.numberOfFailures > 0 ? Integer.toString(this.numberOfFailures) : null, this.batchID, this.processingStartTime != null ? df.format(this.processingStartTime) : null, this.processingEndTime != null ? df.format(this.processingEndTime) : null, this.errorMessage, this.outcomeMessage});
    }

    private void writeDiffTaskAsCSV(CSVPrinter printer) throws IOException {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
        printer.printRecord(new Object[]{Long.toString(this.pk), this.localAET, this.getPrimaryAET(), this.getSecondaryAET(), this.queryString, Boolean.toString(this.checkMissing), Boolean.toString(this.checkDifferent), this.matches, this.missing, this.different, this.compareFields, df.format(this.createdTime), df.format(this.updatedTime), this.queueName, this.deviceName, this.status, this.scheduledTime, this.numberOfFailures > 0 ? Integer.toString(this.numberOfFailures) : null, this.batchID, this.processingStartTime != null ? df.format(this.processingStartTime) : null, this.processingEndTime != null ? df.format(this.processingEndTime) : null, this.errorMessage, this.outcomeMessage});
    }

    private static void writeApplicationAndFacilityTo(String application, String facility, String value, JsonGenerator gen) {
        String[] ss = StringUtils.split((String)value, (char)'|');
        gen.write(application, ss[0]);
        gen.write(facility, ss[1]);
    }

    @PrePersist
    public void onPrePersist() {
        Date now;
        this.createdTime = now = new Date();
        this.updatedTime = now;
    }

    @PreUpdate
    public void onPreUpdate() {
        this.updatedTime = new Date();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Task{taskID=" + this.pk + ", deviceName='" + this.deviceName + "', queueName='" + this.queueName + "', type=" + this.type + ", status=" + this.status + ", scheduledTime=" + this.scheduledTime + ", numberOfFailures=" + this.numberOfFailures);
        if (this.exporterID != null) {
            sb.append(", exporterID=").append(this.exporterID);
        }
        if (this.errorMessage != null) {
            sb.append(", errorMessage=").append(this.errorMessage);
        }
        if (this.errorComment != null) {
            sb.append(", errorComment=").append(this.errorComment);
        }
        if (this.studyInstanceUID != null) {
            sb.append(", studyInstanceUID=").append(this.studyInstanceUID);
        }
        if (this.seriesInstanceUID != null) {
            sb.append(", seriesInstanceUID=").append(this.seriesInstanceUID);
        }
        if (this.sopInstanceUID != null) {
            sb.append(", sopInstanceUID=").append(this.sopInstanceUID);
        }
        if (this.batchID != null) {
            sb.append(", batchID=").append(this.batchID);
        }
        if (this.localAET != null) {
            sb.append(", localAET=").append(this.localAET);
        }
        if (this.remoteAET != null) {
            sb.append(", remoteAET=").append(this.remoteAET);
        }
        sb.append("}");
        return sb.toString();
    }

    public static enum Type {
        EXPORT,
        RETRIEVE,
        MPPS,
        IAN,
        STGCMT_SCP,
        STGCMT_SCU,
        STGVER,
        HL7,
        REST,
        REJECT,
        DIFF;

    }

    public static enum Status {
        SCHEDULED(false),
        IN_PROCESS(false),
        COMPLETED(true),
        WARNING(true),
        FAILED(true),
        CANCELED(true);

        public final boolean done;

        private Status(boolean done) {
            this.done = done;
        }

        public static Status fromString(String s) {
            return Status.valueOf(s.replace(' ', '_'));
        }

        public String toString() {
            return this.name().replace('_', ' ');
        }
    }
}

