/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.entity;

import java.util.Iterator;
import java.util.StringTokenizer;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import org.dcm4che3.data.PersonName;
import org.dcm4chee.arc.entity.PersonName;

@Entity
@Table(name="soundex_code", indexes={@Index(columnList="sx_pn_comp"), @Index(columnList="sx_pn_comp_part"), @Index(columnList="sx_code_value")})
public class SoundexCode {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="pk")
    private long pk;
    @Column(name="sx_pn_comp", nullable=false)
    private PersonName.Component personNameComponent;
    @Column(name="sx_pn_comp_part", nullable=false)
    private int componentPartIndex;
    @Column(name="sx_code_value", nullable=false)
    private String codeValue;
    @ManyToOne(optional=false)
    @JoinColumn(name="person_name_fk")
    private PersonName personName;

    public SoundexCode() {
    }

    public SoundexCode(PersonName.Component personNameComponent, int componentPartIndex, String codeValue) {
        this.personNameComponent = personNameComponent;
        this.componentPartIndex = componentPartIndex;
        this.codeValue = codeValue.isEmpty() ? "*" : codeValue;
    }

    public static Iterator<String> tokenizePersonNameComponent(String name) {
        final StringTokenizer stk = new StringTokenizer(name, " ,-\t");
        return new Iterator<String>(){

            @Override
            public boolean hasNext() {
                return stk.hasMoreTokens();
            }

            @Override
            public String next() {
                return stk.nextToken();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public long getPk() {
        return this.pk;
    }

    public PersonName.Component getPersonNameComponent() {
        return this.personNameComponent;
    }

    public int getComponentPartIndex() {
        return this.componentPartIndex;
    }

    public String getCodeValue() {
        return this.codeValue.equals("*") ? "" : this.codeValue;
    }

    public PersonName getPersonName() {
        return this.personName;
    }

    public void setPersonName(PersonName personName) {
        this.personName = personName;
    }
}

