/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.entity;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.io.DicomInputStream;
import org.dcm4che3.io.DicomOutputStream;
import org.dcm4chee.arc.entity.BlobCorruptedException;
import org.dcm4chee.arc.entity.BlobCorruptedHandler;

@Entity
@Table(name="dicomattrs")
public class AttributesBlob {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="pk")
    private long pk;
    @Basic(optional=false)
    @Column(name="attrs")
    private byte[] encodedAttributes;
    @Transient
    private Attributes cachedAttributes;
    private static volatile BlobCorruptedHandler blobCorruptedHandler = (b1, result1, ex) -> {
        throw new BlobCorruptedException(ex);
    };

    public AttributesBlob(Attributes attrs) {
        this.setAttributes(attrs);
    }

    protected AttributesBlob() {
    }

    public String toString() {
        return "AttributesBlob[pk=" + this.pk + "]";
    }

    public long getPk() {
        return this.pk;
    }

    public Attributes getAttributes() throws BlobCorruptedException {
        if (this.cachedAttributes == null) {
            this.cachedAttributes = AttributesBlob.decodeAttributes(this.encodedAttributes, null);
        }
        return this.cachedAttributes;
    }

    public void setAttributes(Attributes attrs) {
        this.cachedAttributes = new Attributes(attrs);
        this.cachedAttributes.removeAllBulkData();
        this.encodedAttributes = AttributesBlob.encodeAttributes(this.cachedAttributes);
    }

    public byte[] getEncodedAttributes() {
        return this.encodedAttributes;
    }

    public static byte[] encodeAttributes(Attributes attrs) {
        ByteArrayOutputStream out = new ByteArrayOutputStream(512);
        try {
            DicomOutputStream dos = new DicomOutputStream((OutputStream)out, "1.2.840.10008.1.2.1");
            dos.writeDataset(null, attrs);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return out.toByteArray();
    }

    public static Attributes decodeAttributes(byte[] b, Attributes result) {
        if (b == null || b.length == 0) {
            return result != null ? result : new Attributes(0);
        }
        if (result == null) {
            result = new Attributes();
        }
        ByteArrayInputStream is = new ByteArrayInputStream(b);
        try {
            DicomInputStream dis = new DicomInputStream((InputStream)is);
            dis.readFileMetaInformation();
            dis.readAttributes(result, -1L, -1);
            return result;
        }
        catch (IOException e) {
            return blobCorruptedHandler.apply(b, result, e);
        }
    }

    public static void setBlobCorruptedHandler(BlobCorruptedHandler blobCorruptedHandler) {
        AttributesBlob.blobCorruptedHandler = Objects.requireNonNull(blobCorruptedHandler);
    }
}

