/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.dimse.rs;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.EnumSet;
import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.validation.constraints.Pattern;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.dcm4che3.conf.api.ConfigurationException;
import org.dcm4che3.conf.api.IApplicationEntityCache;
import org.dcm4che3.conf.api.IDeviceCache;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.VR;
import org.dcm4che3.net.ApplicationEntity;
import org.dcm4che3.net.Association;
import org.dcm4che3.net.Device;
import org.dcm4che3.net.DimseRSP;
import org.dcm4che3.net.QueryOption;
import org.dcm4che3.net.Status;
import org.dcm4che3.net.service.QueryRetrieveLevel2;
import org.dcm4che3.util.TagUtils;
import org.dcm4che3.util.UIDUtils;
import org.dcm4chee.arc.conf.ArchiveAEExtension;
import org.dcm4chee.arc.conf.ArchiveDeviceExtension;
import org.dcm4chee.arc.conf.Duration;
import org.dcm4chee.arc.keycloak.HttpServletRequestInfo;
import org.dcm4chee.arc.keycloak.KeycloakContext;
import org.dcm4chee.arc.qmgt.TaskManager;
import org.dcm4chee.arc.query.scu.CFindSCU;
import org.dcm4chee.arc.query.util.QueryAttributes;
import org.dcm4chee.arc.retrieve.ExternalRetrieveContext;
import org.dcm4chee.arc.retrieve.mgt.RetrieveManager;
import org.dcm4chee.arc.validation.ParseDateTime;
import org.dcm4chee.arc.validation.constraints.InvokeValidate;
import org.dcm4chee.arc.validation.constraints.ValidValueOf;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequestScoped
@Path(value="aets/{AETitle}/dimse/{movescp}")
@InvokeValidate(type=QueryRetrieveRS.class)
public class QueryRetrieveRS {
    private static final Logger LOG = LoggerFactory.getLogger(QueryRetrieveRS.class);
    private static final String SUPER_USER_ROLE = "super-user-role";
    @Context
    private HttpServletRequest request;
    @Context
    private UriInfo uriInfo;
    @Inject
    private Device device;
    @Inject
    private IDeviceCache deviceCache;
    @PathParam(value="AETitle")
    private String aet;
    @PathParam(value="movescp")
    private String movescp;
    @QueryParam(value="batchID")
    private String batchID;
    @QueryParam(value="dicomDeviceName")
    private String deviceName;
    @QueryParam(value="scheduledTime")
    @ValidValueOf(type=ParseDateTime.class)
    private String scheduledTime;
    @QueryParam(value="dcmQueueName")
    @DefaultValue(value="Retrieve")
    private String queueName;
    @QueryParam(value="fuzzymatching")
    @Pattern(regexp="true|false")
    private @Pattern(regexp="true|false") String fuzzymatching;
    @QueryParam(value="priority")
    @Pattern(regexp="0|1|2")
    private @Pattern(regexp="0|1|2") String priority;
    @QueryParam(value="SplitStudyDateRange")
    @ValidValueOf(type=Duration.class)
    private String splitStudyDateRange;
    @Inject
    private CFindSCU findSCU;
    @Inject
    private RetrieveManager retrieveManager;
    @Inject
    private TaskManager taskManager;
    @Inject
    private IApplicationEntityCache aeCache;
    @HeaderParam(value="Content-Type")
    private MediaType contentType;
    private int priorityAsInt;

    public String toString() {
        String requestURI = this.request.getRequestURI();
        String queryString = this.request.getQueryString();
        return queryString == null ? requestURI : requestURI + "?" + queryString;
    }

    public void validate() {
        this.logRequest();
        new QueryAttributes(this.uriInfo, null);
    }

    @POST
    @Path(value="/query:{QueryAET}/studies/export/dicom:{DestinationAET}")
    @Produces(value={"application/json"})
    public Response queryRetrieveMatchingStudies(@PathParam(value="QueryAET") String queryAET, @PathParam(value="DestinationAET") String destAET) {
        return this.process(QueryRetrieveLevel2.STUDY, null, null, queryAET, destAET);
    }

    @POST
    @Path(value="/query:{QueryAET}/studies/{StudyInstanceUID}/series/export/dicom:{DestinationAET}")
    @Produces(value={"application/json"})
    public Response queryRetrieveMatchingSeries(@PathParam(value="StudyInstanceUID") String studyInstanceUID, @PathParam(value="QueryAET") String queryAET, @PathParam(value="DestinationAET") String destAET) {
        return this.process(QueryRetrieveLevel2.SERIES, studyInstanceUID, null, queryAET, destAET);
    }

    @POST
    @Path(value="/query:{QueryAET}/studies/{StudyInstanceUID}/series/{SeriesInstanceUID}/instances/export/dicom:{DestinationAET}")
    @Produces(value={"application/json"})
    public Response queryRetrieveMatchingInstances(@PathParam(value="StudyInstanceUID") String studyInstanceUID, @PathParam(value="SeriesInstanceUID") String seriesInstanceUID, @PathParam(value="QueryAET") String queryAET, @PathParam(value="DestinationAET") String destAET) {
        return this.process(QueryRetrieveLevel2.IMAGE, studyInstanceUID, seriesInstanceUID, queryAET, destAET);
    }

    @POST
    @Path(value="/studies/export/dicom:{DestinationAET}")
    @Produces(value={"application/json"})
    public Response retrieveMatchingStudies(@PathParam(value="DestinationAET") String destAET) {
        return this.process(QueryRetrieveLevel2.STUDY, null, null, destAET);
    }

    @POST
    @Path(value="/studies/{StudyInstanceUID}/series/export/dicom:{DestinationAET}")
    @Produces(value={"application/json"})
    public Response retrieveMatchingSeries(@PathParam(value="StudyInstanceUID") String studyInstanceUID, @PathParam(value="DestinationAET") String destAET) {
        return this.process(QueryRetrieveLevel2.SERIES, studyInstanceUID, null, destAET);
    }

    @POST
    @Path(value="/studies/{StudyInstanceUID}/series/{SeriesInstanceUID}/instances/export/dicom:{DestinationAET}")
    @Produces(value={"application/json"})
    public Response retrieveMatchingInstances(@PathParam(value="StudyInstanceUID") String studyInstanceUID, @PathParam(value="SeriesInstanceUID") String seriesInstanceUID, @PathParam(value="DestinationAET") String destAET) {
        return this.process(QueryRetrieveLevel2.IMAGE, studyInstanceUID, seriesInstanceUID, destAET);
    }

    @POST
    @Path(value="/studies/csv:{field}/export/dicom:{destinationAET}")
    @Consumes(value={"text/csv"})
    @Produces(value={"application/json"})
    public Response retrieveMatchingStudiesFromCSV(@PathParam(value="field") int field, @PathParam(value="destinationAET") String destAET, InputStream in) {
        return this.processCSV(field, destAET, in);
    }

    private Response processCSV(int field, String destAET, InputStream in) {
        ApplicationEntity ae = this.device.getApplicationEntity(this.aet, true);
        if (ae == null || !ae.isInstalled()) {
            return this.errResponse("No such Application Entity: " + this.aet, Response.Status.NOT_FOUND);
        }
        try {
            this.validateAcceptedUserRoles((ArchiveAEExtension)ae.getAEExtensionNotNull(ArchiveAEExtension.class));
            this.validate(null);
            Response.Status status = Response.Status.BAD_REQUEST;
            if (field < 1) {
                return this.errResponse("CSV field for Study Instance UID should be greater than or equal to 1", status);
            }
            this.priorityAsInt = QueryRetrieveRS.parseInt(this.priority, 0);
            int count = 0;
            String warning = null;
            ArchiveDeviceExtension arcDev = (ArchiveDeviceExtension)this.device.getDeviceExtensionNotNull(ArchiveDeviceExtension.class);
            int csvUploadChunkSize = arcDev.getCSVUploadChunkSize();
            ArrayList<String> studyUIDs = new ArrayList<String>();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(in));
                 CSVParser parser = new CSVParser((Reader)reader, CSVFormat.DEFAULT.builder().setDelimiter(this.csvDelimiter()).build());){
                boolean header = true;
                for (CSVRecord csvRecord : parser) {
                    if (csvRecord.size() == 0 || csvRecord.get(0).isEmpty()) continue;
                    String studyUID = csvRecord.get(field - 1).replaceAll("\"", "");
                    if (header && studyUID.chars().allMatch(Character::isLetter)) {
                        header = false;
                        continue;
                    }
                    if (!arcDev.isValidateUID() || this.validateUID(studyUID)) {
                        studyUIDs.add(studyUID);
                    }
                    if (studyUIDs.size() != csvUploadChunkSize) continue;
                    count += this.scheduleRetrieveTask(this.createExtRetrieveCtx(destAET, studyUIDs.toArray(new String[0])));
                    studyUIDs.clear();
                }
                if (!studyUIDs.isEmpty()) {
                    count += this.scheduleRetrieveTask(this.createExtRetrieveCtx(destAET, studyUIDs.toArray(new String[0])));
                }
                if (count == 0) {
                    warning = "Empty file or Incorrect field position or Not a CSV file or Invalid UIDs or Duplicate Retrieves suppressed.";
                    status = Response.Status.NO_CONTENT;
                }
            }
            catch (Exception e) {
                warning = e.getMessage();
                status = Response.Status.INTERNAL_SERVER_ERROR;
            }
            if (count > 0 && this.scheduledOnThisDevice() && this.scheduledTime == null) {
                this.taskManager.processQueue(this.queueName);
            }
            if (warning == null && count > 0) {
                return Response.accepted((Object)QueryRetrieveRS.count(count)).build();
            }
            LOG.warn("Response {} caused by {}", (Object)status, (Object)warning);
            Response.ResponseBuilder builder = Response.status((Response.Status)status).header("Warning", (Object)warning);
            if (count > 0) {
                builder.entity((Object)QueryRetrieveRS.count(count));
            }
            return builder.build();
        }
        catch (IllegalArgumentException | IllegalStateException | ConfigurationException e) {
            return this.errResponse(e.getMessage(), Response.Status.NOT_FOUND);
        }
        catch (Exception e) {
            return this.errResponseAsTextPlain(this.exceptionAsString(e), Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    private boolean validateUID(String studyUID) {
        boolean valid = UIDUtils.isValid((String)studyUID);
        if (!valid) {
            LOG.warn("Invalid UID in CSV file: " + studyUID);
        }
        return valid;
    }

    private Response errResponse(String msg, Response.Status status) {
        return this.errResponseAsTextPlain("{\"errorMessage\":\"" + msg + "\"}", status);
    }

    private Response errResponseAsTextPlain(String errorMsg, Response.Status status) {
        LOG.warn("Response {} caused by {}", (Object)status, (Object)errorMsg);
        return Response.status((Response.Status)status).entity((Object)errorMsg).type("text/plain").build();
    }

    private String exceptionAsString(Exception e) {
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    private static int parseInt(String s, int defval) {
        return s != null ? Integer.parseInt(s) : defval;
    }

    private char csvDelimiter() {
        return "semicolon".equals(this.contentType.getParameters().get("delimiter")) ? (char)';' : ',';
    }

    private Duration splitStudyDateRange() {
        return this.splitStudyDateRange != null ? Duration.valueOf((String)this.splitStudyDateRange) : null;
    }

    private Response process(QueryRetrieveLevel2 level, String studyInstanceUID, String seriesInstanceUID, String destAET) {
        return this.process(level, studyInstanceUID, seriesInstanceUID, this.movescp, destAET);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Response process(QueryRetrieveLevel2 level, String studyInstanceUID, String seriesInstanceUID, String queryAET, String destAET) {
        ApplicationEntity localAE = this.device.getApplicationEntity(this.aet, true);
        if (localAE == null || !localAE.isInstalled()) {
            return this.errResponse("No such Application Entity: " + this.aet, Response.Status.NOT_FOUND);
        }
        try {
            String warning;
            this.validateAcceptedUserRoles((ArchiveAEExtension)localAE.getAEExtensionNotNull(ArchiveAEExtension.class));
            this.validate(queryAET);
            QueryAttributes queryAttributes = new QueryAttributes(this.uriInfo, null);
            queryAttributes.addReturnTags(new int[]{level.uniqueKey()});
            Attributes keys = queryAttributes.getQueryKeys();
            keys.setString(524370, VR.CS, level.name());
            if (studyInstanceUID != null) {
                keys.setString(0x20000D, VR.UI, studyInstanceUID);
            }
            if (seriesInstanceUID != null) {
                keys.setString(0x20000E, VR.UI, seriesInstanceUID);
            }
            if (level == QueryRetrieveLevel2.IMAGE && !keys.contains(524312)) {
                keys.setNull(524312, VR.UI);
            }
            EnumSet<QueryOption> queryOptions = EnumSet.of(QueryOption.DATETIME);
            if (Boolean.parseBoolean(this.fuzzymatching)) {
                queryOptions.add(QueryOption.FUZZY);
            }
            Association as = null;
            int count = 0;
            Response.Status errorStatus = Response.Status.BAD_GATEWAY;
            try {
                int status;
                as = this.findSCU.openAssociation(localAE, queryAET, "1.2.840.10008.5.1.4.1.2.2.1", queryOptions);
                this.priorityAsInt = QueryRetrieveRS.parseInt(this.priority, 0);
                DimseRSP dimseRSP = this.findSCU.query(as, this.priorityAsInt, this.findSCU.coerceCFindRQ(as, keys), 0, 1, this.splitStudyDateRange());
                dimseRSP.next();
                do {
                    if (!Status.isPending((int)(status = dimseRSP.getCommand().getInt(2304, -1)))) continue;
                    count += this.scheduleRetrieveTask(this.createExtRetrieveCtx(destAET, queryAET, dimseRSP));
                } while (dimseRSP.next());
                warning = QueryRetrieveRS.warning(status);
            }
            catch (IllegalArgumentException | IllegalStateException | ConfigurationException e) {
                errorStatus = Response.Status.NOT_FOUND;
                warning = e.getMessage();
            }
            catch (Exception e) {
                warning = e.getMessage();
            }
            finally {
                if (as != null) {
                    try {
                        as.release();
                    }
                    catch (IOException e) {
                        LOG.info("{}: Failed to release association:\\n", (Object)as, (Object)e);
                    }
                }
            }
            if (count > 0 && this.scheduledOnThisDevice() && this.scheduledTime == null) {
                this.taskManager.processQueue(this.queueName);
            }
            if (warning == null) {
                return Response.accepted((Object)QueryRetrieveRS.count(count)).build();
            }
            LOG.warn("Response {} caused by {}", (Object)errorStatus, (Object)warning);
            Response.ResponseBuilder builder = Response.status((Response.Status)errorStatus).header("Warning", (Object)warning);
            if (count > 0) {
                builder.entity((Object)QueryRetrieveRS.count(count));
            }
            return builder.build();
        }
        catch (IllegalArgumentException | IllegalStateException | ConfigurationException e) {
            return this.errResponse(e.getMessage(), Response.Status.NOT_FOUND);
        }
        catch (Exception e) {
            return this.errResponseAsTextPlain(this.exceptionAsString(e), Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    private boolean scheduledOnThisDevice() {
        return this.deviceName == null || this.deviceName.equals(this.device.getDeviceName());
    }

    private void validate(String queryAET) throws ConfigurationException {
        if (queryAET != null && !queryAET.equals(this.movescp)) {
            this.aeCache.findApplicationEntity(queryAET);
        }
        this.aeCache.findApplicationEntity(this.movescp);
        if (!this.scheduledOnThisDevice()) {
            Device device = this.deviceCache.findDevice(this.deviceName);
            ApplicationEntity ae = device.getApplicationEntity(this.aet, true);
            if (ae == null || !ae.isInstalled()) {
                throw new ConfigurationException("No such Application Entity: " + this.aet + " found in device: " + this.deviceName);
            }
            this.validateAcceptedUserRoles((ArchiveAEExtension)ae.getAEExtensionNotNull(ArchiveAEExtension.class));
            this.validateQueue(device);
        } else {
            this.validateQueue(this.device);
        }
    }

    private void validateQueue(Device device) {
        ((ArchiveDeviceExtension)device.getDeviceExtensionNotNull(ArchiveDeviceExtension.class)).getQueueDescriptorNotNull(this.queueName);
    }

    private int scheduleRetrieveTask(ExternalRetrieveContext ctx) {
        return this.retrieveManager.scheduleRetrieveTask(ctx, null);
    }

    private void logRequest() {
        LOG.info("Process {} {} from {}@{}", new Object[]{this.request.getMethod(), this.toString(), this.request.getRemoteUser(), this.request.getRemoteHost()});
    }

    private ExternalRetrieveContext createExtRetrieveCtx(String destAET, String queryAET, DimseRSP dimseRSP) {
        Attributes keys = new Attributes(dimseRSP.getDataset(), new int[]{524312, 524370, 0x20000D, 0x20000E});
        return this.createExtRetrieveCtx(destAET, queryAET, keys);
    }

    private ExternalRetrieveContext createExtRetrieveCtx(String destAET, String ... studyIUID) {
        Attributes keys = new Attributes(2);
        keys.setString(524370, VR.CS, QueryRetrieveLevel2.STUDY.name());
        keys.setString(0x20000D, VR.UI, studyIUID);
        return this.createExtRetrieveCtx(destAET, null, keys);
    }

    private ExternalRetrieveContext createExtRetrieveCtx(String destAET, String queryAET, Attributes keys) {
        return new ExternalRetrieveContext().setDeviceName(this.deviceName != null ? this.deviceName : this.device.getDeviceName()).setQueueName(this.queueName).setBatchID(this.batchID).setLocalAET(this.aet).setRemoteAET(this.movescp).setFindSCP(queryAET).setDestinationAET(destAET).setHttpServletRequestInfo(HttpServletRequestInfo.valueOf((HttpServletRequest)this.request)).setScheduledTime(this.scheduledTime != null ? ParseDateTime.valueOf((String)this.scheduledTime) : new Date()).setKeys(keys);
    }

    private static String count(int count) {
        return "{\"count\":" + count + "}";
    }

    private static String warning(int status) {
        switch (status) {
            case 0: {
                return null;
            }
            case 42752: {
                return "A700: Refused: Out of Resources";
            }
            case 43264: {
                return "A900: Identifier does not match SOP Class";
            }
        }
        return TagUtils.shortToHexString((int)status) + ((status & 0xC000) == 49152 ? ": Unable to Process" : ": Unexpected status code");
    }

    private void validateAcceptedUserRoles(ArchiveAEExtension arcAE) {
        KeycloakContext keycloakContext = KeycloakContext.valueOf((HttpServletRequest)this.request);
        if (keycloakContext.isSecured() && !keycloakContext.isUserInRole(System.getProperty(SUPER_USER_ROLE)) && !arcAE.isAcceptedUserRole(keycloakContext.getRoles())) {
            throw new WebApplicationException("Application Entity " + arcAE.getApplicationEntity().getAETitle() + " does not list role of accessing user", Response.Status.FORBIDDEN);
        }
    }
}

