/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.diff.impl;

import java.io.IOException;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.Sequence;
import org.dcm4che3.data.VR;
import org.dcm4che3.net.ApplicationEntity;
import org.dcm4che3.net.Association;
import org.dcm4che3.net.Device;
import org.dcm4che3.net.DimseRSP;
import org.dcm4che3.net.QueryOption;
import org.dcm4che3.net.Status;
import org.dcm4che3.net.service.DicomServiceException;
import org.dcm4chee.arc.diff.DiffContext;
import org.dcm4chee.arc.diff.DiffSCU;
import org.dcm4chee.arc.query.scu.CFindSCU;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiffSCUImpl
implements DiffSCU {
    private static final Logger LOG = LoggerFactory.getLogger(DiffSCUImpl.class);
    private final DiffContext ctx;
    private final CFindSCU findSCU;
    private final Device device;
    private Association as1;
    private Association as2;
    private DimseRSP dimseRSP;
    private DimseRSP dimseRSP2;
    private int missing;
    private int different;
    private int matches;
    private volatile boolean canceled;

    public DiffSCUImpl(DiffContext ctx, CFindSCU findSCU, Device device) {
        this.ctx = ctx;
        this.findSCU = findSCU;
        this.device = device;
    }

    @Override
    public int init() throws Exception {
        EnumSet<QueryOption> queryOptions = EnumSet.of(QueryOption.DATETIME);
        if (this.ctx.isFuzzymatching()) {
            queryOptions.add(QueryOption.FUZZY);
        }
        ApplicationEntity localAE = this.device.getApplicationEntity(this.ctx.getLocalAET(), true);
        this.as1 = this.findSCU.openAssociation(localAE, this.ctx.getPrimaryAE().getAETitle(), "1.2.840.10008.5.1.4.1.2.2.1", queryOptions);
        this.as2 = this.findSCU.openAssociation(localAE, this.ctx.getSecondaryAE().getAETitle(), "1.2.840.10008.5.1.4.1.2.2.1", queryOptions);
        if (!this.ctx.isForceQueryByStudyUID() && this.ctx.supportSorting()) {
            this.dimseRSP2 = this.findSCU.query(this.as2, this.ctx.priority(), this.findSCU.coerceCFindRQ(this.as2, this.ctx.getQueryKeys()), 0, 1, this.ctx.getSplitStudyDateRange());
            this.dimseRSP2.next();
            DiffSCUImpl.checkRSP(this.dimseRSP2);
        }
        this.dimseRSP = this.findSCU.query(this.as1, this.ctx.priority(), this.findSCU.coerceCFindRQ(this.as1, this.ctx.getQueryKeys()), 0, 1, this.ctx.getSplitStudyDateRange());
        this.dimseRSP.next();
        return DiffSCUImpl.checkRSP(this.dimseRSP);
    }

    @Override
    public void countDiffs() throws Exception {
        do {
            Attributes match;
            if ((match = this.dimseRSP.getDataset()) == null) continue;
            match = this.findSCU.coerceCFindRSP(this.as1, match);
            ++this.matches;
            Attributes other = this.findOther(match.getString(0x20000D));
            if (other == null) {
                ++this.missing;
                continue;
            }
            if (this.findSCU.coerceCFindRSP(this.as2, other).diff(match, this.ctx.getCompareKeys(), null) <= 0) continue;
            ++this.different;
        } while (this.dimseRSP.next());
    }

    @Override
    public Attributes nextDiff() throws Exception {
        boolean next;
        do {
            Attributes match = this.dimseRSP.getDataset();
            next = this.dimseRSP.next();
            if (match == null) continue;
            match = this.findSCU.coerceCFindRSP(this.as1, match);
            ++this.matches;
            Attributes other = this.findOther(match.getString(0x20000D));
            if (other == null) {
                if (!this.ctx.isCheckMissing()) continue;
                ++this.missing;
                return this.addOriginalAttributesSequence(match, DiffSCUImpl.modifiedAttributesForMissing());
            }
            if (!this.ctx.isCheckDifferent()) continue;
            other = this.findSCU.coerceCFindRSP(this.as2, other);
            Attributes modified = new Attributes(match.size());
            if (other.diff(match, this.ctx.getCompareKeys(), modified) <= 0) continue;
            ++this.different;
            return this.addOriginalAttributesSequence(match, modified);
        } while (next && !this.canceled);
        DiffSCUImpl.waitForOutstandingRSP(this.as1, this.dimseRSP);
        DiffSCUImpl.waitForOutstandingRSP(this.as2, this.dimseRSP2);
        return null;
    }

    @Override
    public int missing() {
        return this.missing;
    }

    @Override
    public int different() {
        return this.different;
    }

    @Override
    public int matches() {
        return this.matches;
    }

    @Override
    public void cancel() {
        DiffSCUImpl.safeCancel(this.as1, this.dimseRSP);
        DiffSCUImpl.safeCancel(this.as2, this.dimseRSP2);
        this.canceled = true;
    }

    @Override
    public boolean isCancelled() {
        return this.canceled;
    }

    @Override
    public void close() {
        DiffSCUImpl.safeRelease(this.as1);
        DiffSCUImpl.safeRelease(this.as2);
    }

    @Override
    public DiffContext getDiffCtx() {
        return this.ctx;
    }

    private static Attributes modifiedAttributesForMissing() {
        Attributes modified = new Attributes(2);
        modified.setInt(2101766, VR.IS, new int[]{0});
        modified.setInt(2101768, VR.IS, new int[]{0});
        return modified;
    }

    private Attributes addOriginalAttributesSequence(Attributes match, Attributes modified) {
        Sequence sq = match.newSequence(67110241, 1);
        Attributes item = new Attributes();
        sq.add(item);
        item.newSequence(0x4000550, 1).add(modified);
        item.setString(67110244, VR.LO, this.ctx.getSecondaryAE().getAETitle());
        item.setDate(67110242, VR.DT, new Date[]{new Date()});
        item.setString(67110243, VR.LO, this.ctx.getPrimaryAE().getAETitle());
        item.setString(67110245, VR.CS, "DIFFS");
        return match;
    }

    private static int checkRSP(DimseRSP rsp) throws DicomServiceException {
        Attributes cmd = rsp.getCommand();
        int status = cmd.getInt(2304, -1);
        if (!Status.isPending((int)status) && status != 0) {
            throw new DicomServiceException(status, cmd.getString(2306));
        }
        return status;
    }

    private static void safeCancel(Association as, DimseRSP rsp) {
        if (as != null && rsp != null) {
            try {
                rsp.cancel(as);
            }
            catch (IOException e) {
                LOG.info("{}: Failed to cancel C-FIND at association:\\n", (Object)as, (Object)e);
            }
        }
    }

    private static void waitForOutstandingRSP(Association as, DimseRSP dimseRSP) {
        if (as != null && dimseRSP != null) {
            try {
                while (dimseRSP.next()) {
                }
            }
            catch (Exception e) {
                LOG.info("{}: Failed to wait for outstanding C-FIND RSPs at association:\\n", (Object)as, (Object)e);
            }
        }
    }

    private static void safeRelease(Association as) {
        if (as != null) {
            try {
                as.release();
            }
            catch (IOException e) {
                LOG.info("{}: Failed to release association:\\n", (Object)as, (Object)e);
            }
        }
    }

    private Attributes findOther(String studyIUID) throws Exception {
        List matches;
        if (this.dimseRSP2 != null) {
            Attributes other;
            while ((other = this.dimseRSP2.getDataset()) != null) {
                int compare = studyIUID.compareTo(other.getString(0x20000D));
                if (compare == 0) {
                    this.dimseRSP2.next();
                    return other;
                }
                if (compare >= 0 && this.dimseRSP2.next()) continue;
            }
        }
        return !(matches = this.findSCU.findStudy(this.as2, this.ctx.priority(), studyIUID, this.ctx.getReturnKeys())).isEmpty() ? (Attributes)matches.get(0) : null;
    }
}

