/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.delete.impl;

import java.util.Date;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.Code;
import org.dcm4che3.net.ApplicationEntity;
import org.dcm4che3.net.Device;
import org.dcm4chee.arc.conf.ArchiveAEExtension;
import org.dcm4chee.arc.conf.ArchiveDeviceExtension;
import org.dcm4chee.arc.conf.ExporterDescriptor;
import org.dcm4chee.arc.conf.RejectionNote;
import org.dcm4chee.arc.delete.RejectionService;
import org.dcm4chee.arc.delete.impl.DeletionServiceEJB;
import org.dcm4chee.arc.entity.ExpirationState;
import org.dcm4chee.arc.entity.Task;
import org.dcm4chee.arc.exporter.ExportContext;
import org.dcm4chee.arc.keycloak.HttpServletRequestInfo;
import org.dcm4chee.arc.query.QueryService;
import org.dcm4chee.arc.store.StoreContext;
import org.dcm4chee.arc.store.StoreService;
import org.dcm4chee.arc.store.StoreSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class RejectionServiceImpl
implements RejectionService {
    private static final Logger LOG = LoggerFactory.getLogger(RejectionServiceImpl.class);
    @Inject
    private Device device;
    @Inject
    private QueryService queryService;
    @Inject
    private StoreService storeService;
    @Inject
    private DeletionServiceEJB ejb;

    public void onExport(@Observes ExportContext ctx) {
        ExporterDescriptor desc = ctx.getExporter().getExporterDescriptor();
        if (ctx.getException() != null || !desc.isRejectForDataRetentionExpiry() || ctx.getOutcome().getStatus() != Task.Status.COMPLETED) {
            return;
        }
        ApplicationEntity ae = this.getApplicationEntity(desc.getAETitle());
        if (ae == null || !ae.isInstalled()) {
            LOG.warn("No such Application Entity: {}", (Object)desc.getAETitle());
            return;
        }
        ArchiveDeviceExtension arcDev = (ArchiveDeviceExtension)this.device.getDeviceExtension(ArchiveDeviceExtension.class);
        RejectionNote rn = arcDev.getRejectionNote(RejectionNote.Type.DATA_RETENTION_POLICY_EXPIRED);
        if (rn == null) {
            LOG.warn("Data Retention Policy Expired Rejection Note not configured.");
            return;
        }
        LOG.info("Export completed, invoke rejection of objects.");
        try {
            if (this.ejb.claimExpired(ctx.getStudyInstanceUID(), ctx.getSeriesInstanceUID(), ExpirationState.REJECTED)) {
                this.reject(ae, ctx.getAETitle(), ctx.getStudyInstanceUID(), ctx.getSeriesInstanceUID(), ctx.getSopInstanceUID(), rn, ctx.getHttpServletRequestInfo());
            }
        }
        catch (Exception e) {
            LOG.warn("Rejection of Expired Study[UID={}], Series[UID={}], SOPInstance[UID={}] failed.\n", new Object[]{ctx.getStudyInstanceUID(), ctx.getSeriesInstanceUID(), ctx.getSopInstanceUID(), e});
            this.ejb.claimExpired(ctx.getStudyInstanceUID(), ctx.getSeriesInstanceUID(), ExpirationState.FAILED_TO_REJECT);
        }
    }

    @Override
    public int reject(String aet, String studyIUID, String seriesIUID, String sopIUID, Code code, HttpServletRequestInfo httpRequest) throws Exception {
        return this.reject(this.getApplicationEntity(aet), aet, studyIUID, seriesIUID, sopIUID, this.getRejectionNote(code), httpRequest);
    }

    @Override
    public int reject(ApplicationEntity ae, String aet, String studyIUID, String seriesIUID, String sopIUID, RejectionNote rjNote, HttpServletRequestInfo httpRequest) throws Exception {
        String changeRequesterAET = ((ArchiveAEExtension)ae.getAEExtension(ArchiveAEExtension.class)).changeRequesterAET();
        StoreSession storeSession = this.storeService.newStoreSession(httpRequest, ae, aet, changeRequesterAET != null ? changeRequesterAET : ae.getAETitle());
        String rejectionNoteObjectStorageID = this.rejectionNoteObjectStorageID(storeSession);
        storeSession.withObjectStorageID(rejectionNoteObjectStorageID);
        this.storeService.restoreInstances(storeSession, studyIUID, seriesIUID, null);
        Attributes attrs = this.queryService.createRejectionNote(ae, studyIUID, seriesIUID, sopIUID, rjNote);
        if (attrs == null) {
            return 0;
        }
        int count = RejectionServiceImpl.countInstances(attrs);
        LOG.info("Start rejection of {} instances of Study[UID={}], Series[UID={}], SOPInstance[UID={}].", new Object[]{count, studyIUID, seriesIUID, sopIUID});
        StoreContext storeCtx = this.storeService.newStoreContext(storeSession);
        storeCtx.setReceiveTransferSyntax("1.2.840.10008.1.2.1");
        this.storeService.store(storeCtx, attrs);
        LOG.info("Rejection of {} instances of Study[UID={}], Series[UID={}], SOPInstance[UID={}] completed.", new Object[]{count, studyIUID, seriesIUID, sopIUID});
        return count;
    }

    @Override
    public void createRejectionTask(String aet, Code code, HttpServletRequestInfo httpRequest, String batchID, Date scheduledTime, String studyUID, String seriesUID, String sopUID) {
        this.ejb.createRejectionTask(aet, studyUID, seriesUID, sopUID, code, httpRequest, batchID, scheduledTime);
    }

    private static int countInstances(Attributes attrs) {
        return attrs.getNestedDataset(4236149).getSequence(528661).stream().collect(Collectors.summingInt(x -> x.getSequence(528793).size()));
    }

    private String rejectionNoteObjectStorageID(StoreSession storeSession) {
        ArchiveAEExtension rjArcAE;
        String rejectionNoteStorageAET = ((ArchiveDeviceExtension)this.device.getDeviceExtension(ArchiveDeviceExtension.class)).getRejectionNoteStorageAET();
        if (rejectionNoteStorageAET == null) {
            return null;
        }
        ApplicationEntity rjAE = this.getApplicationEntity(rejectionNoteStorageAET);
        if (rjAE == null || !rjAE.isInstalled() || (rjArcAE = (ArchiveAEExtension)rjAE.getAEExtension(ArchiveAEExtension.class)) == null) {
            LOG.warn("Rejection Note Storage Application Entity with an Archive AE Extension not configured: {}", (Object)rejectionNoteStorageAET);
            return null;
        }
        String[] objectStorageIDs = rjArcAE.getObjectStorageIDs();
        if (objectStorageIDs.length > 0) {
            return objectStorageIDs[0];
        }
        LOG.warn("Object storage for rejection notes shall fall back on those configured for AE: {} since none are configured for RejectionNoteStorageAE: {}", (Object)storeSession.getLocalApplicationEntity().getAETitle(), (Object)rejectionNoteStorageAET);
        return null;
    }

    private ApplicationEntity getApplicationEntity(String aet) {
        return this.device.getApplicationEntity(aet, true);
    }

    private RejectionNote getRejectionNote(Code code) {
        return ((ArchiveDeviceExtension)this.device.getDeviceExtension(ArchiveDeviceExtension.class)).getRejectionNote(code);
    }
}

