/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.delete.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import org.dcm4che3.data.Code;
import org.dcm4che3.net.Device;
import org.dcm4chee.arc.conf.AllowDeleteStudyPermanently;
import org.dcm4chee.arc.conf.ArchiveAEExtension;
import org.dcm4chee.arc.conf.ArchiveDeviceExtension;
import org.dcm4chee.arc.delete.DeletionService;
import org.dcm4chee.arc.delete.StudyDeleteContext;
import org.dcm4chee.arc.delete.StudyNotEmptyException;
import org.dcm4chee.arc.delete.StudyNotFoundException;
import org.dcm4chee.arc.delete.impl.DeletionServiceEJB;
import org.dcm4chee.arc.delete.impl.StudyDeleteContextImpl;
import org.dcm4chee.arc.entity.Location;
import org.dcm4chee.arc.entity.RejectionState;
import org.dcm4chee.arc.entity.Series;
import org.dcm4chee.arc.entity.Study;
import org.dcm4chee.arc.keycloak.HttpServletRequestInfo;
import org.dcm4chee.arc.patient.PatientMgtContext;
import org.dcm4chee.arc.patient.PatientService;
import org.dcm4chee.arc.store.StoreService;
import org.dcm4chee.arc.store.StoreSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class DeletionServiceImpl
implements DeletionService {
    private static final Logger LOG = LoggerFactory.getLogger(DeletionServiceImpl.class);
    @PersistenceContext(unitName="dcm4chee-arc")
    private EntityManager em;
    @Inject
    private Device device;
    @Inject
    private DeletionServiceEJB ejb;
    @Inject
    private PatientService patientService;
    @Inject
    private StoreService storeService;
    @Inject
    private Event<StudyDeleteContext> studyDeletedEvent;
    @Inject
    private Event<PatientMgtContext> patientMgtEvent;

    @Override
    public int deleteRejectedInstancesBefore(Code rjCode, Date before, int fetchSize) {
        return this.delete(this.ejb::deleteRejectedInstances, rjCode, before, fetchSize);
    }

    @Override
    public int deleteRejectionNotesBefore(Code rjCode, Date before, int fetchSize) {
        return this.delete(this.ejb::deleteRejectionNotes, rjCode, before, fetchSize);
    }

    private int delete(DeletionServiceEJB.DeleteRejectedInstancesOrRejectionNotes cmd, Code rjCode, Date before, int fetchSize) {
        int deleted;
        int total = 0;
        do {
            deleted = cmd.delete(rjCode, before, fetchSize);
            total += deleted;
        } while (deleted == fetchSize);
        return total;
    }

    @Override
    public StudyDeleteContext createStudyDeleteContext(Long pk, HttpServletRequestInfo httpServletRequestInfo) {
        StudyDeleteContextImpl ctx = new StudyDeleteContextImpl(pk);
        ctx.setHttpServletRequestInfo(httpServletRequestInfo);
        return ctx;
    }

    @Override
    public void deleteStudy(String studyUID, HttpServletRequestInfo httpServletRequestInfo, ArchiveAEExtension arcAE, boolean retainObj) throws Exception {
        this.deleteStudy(this.findStudy(studyUID), httpServletRequestInfo, arcAE, null, retainObj, false);
    }

    private Study findStudy(String studyUID) throws StudyNotFoundException {
        try {
            return (Study)this.em.createNamedQuery("Study.findByStudyIUID", Study.class).setParameter(1, (Object)studyUID).getSingleResult();
        }
        catch (NoResultException e) {
            throw new StudyNotFoundException("No study found for " + studyUID);
        }
    }

    @Override
    public List<Location> reimportStudy(String studyUID, HttpServletRequestInfo httpServletRequestInfo, ArchiveAEExtension arcAE) throws Exception {
        return this.deleteStudy(this.findStudy(studyUID), httpServletRequestInfo, arcAE, null, false, true);
    }

    private List<Location> deleteStudy(Study study, HttpServletRequestInfo httpServletRequestInfo, ArchiveAEExtension arcAE, PatientMgtContext pCtx, boolean retainObj, boolean reimport) throws Exception {
        StudyDeleteContext ctx = this.createStudyDeleteContext(study.getPk(), httpServletRequestInfo);
        try {
            LOG.info("Start deleting {} from database", (Object)study);
            List<Location> list = this.deleteStudy(ctx, study, arcAE, pCtx, retainObj, reimport);
            return list;
        }
        catch (Exception e) {
            LOG.warn("Failed to delete {} from database:\n", (Object)study, (Object)e);
            ctx.setException(e);
            throw e;
        }
        finally {
            if (ctx.getStudy() != null) {
                try {
                    this.studyDeletedEvent.fire((Object)ctx);
                }
                catch (Exception e) {
                    LOG.warn("Unexpected exception in Study Deletion audit : " + e.getMessage());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deletePatient(PatientMgtContext ctx, ArchiveAEExtension arcAE) {
        LOG.info("Start deleting {} from database", (Object)ctx.getPatient());
        List resultList = this.em.createNamedQuery("Study.findByPatient", Study.class).setParameter(1, (Object)ctx.getPatient()).getResultList();
        try {
            for (Study study : resultList) {
                this.deleteStudy(study, ctx.getHttpServletRequestInfo(), arcAE, ctx, false, false);
            }
            this.patientService.deletePatient(ctx);
            LOG.info("Successfully delete {} from database", (Object)ctx.getPatient());
        }
        catch (Exception e) {
            LOG.warn("Failed to delete {} from database:\n", (Object)ctx.getPatient(), (Object)e);
            ctx.setException(e);
        }
        finally {
            this.patientMgtEvent.fire((Object)ctx);
        }
    }

    private List<Location> deleteStudy(StudyDeleteContext ctx, Study study, ArchiveAEExtension arcAE, PatientMgtContext pCtx, boolean retainObj, boolean reimport) throws Exception {
        List<Location> locations1;
        ArrayList<Location> locations = new ArrayList<Location>();
        ArchiveDeviceExtension arcDev = (ArchiveDeviceExtension)this.device.getDeviceExtension(ArchiveDeviceExtension.class);
        RejectionState rejectionState = study.getRejectionState();
        if (!(pCtx != null || reimport || arcAE.allowDeleteStudy() != AllowDeleteStudyPermanently.REJECTED || rejectionState != RejectionState.NONE && rejectionState != RejectionState.PARTIAL)) {
            ctx.setStudy(study);
            throw new StudyNotEmptyException("Deletion of Study with Rejection State: " + rejectionState + " not permitted");
        }
        if (rejectionState == RejectionState.EMPTY) {
            this.ejb.deleteEmptyStudy(ctx);
            return locations;
        }
        List<Series> seriesWithPurgedInstances = this.ejb.findSeriesWithPurgedInstances(study.getPk());
        if (!seriesWithPurgedInstances.isEmpty()) {
            StoreSession session = this.storeService.newStoreSession(arcAE.getApplicationEntity());
            for (Series series : seriesWithPurgedInstances) {
                this.storeService.restoreInstances(session, study.getStudyInstanceUID(), series.getSeriesInstanceUID(), arcDev.getPurgeInstanceRecordsDelay());
            }
        }
        int limit = arcDev.getDeleteStudyChunkSize();
        while (!(locations1 = this.ejb.deleteStudy(ctx, limit, retainObj || reimport)).isEmpty()) {
            locations.addAll(locations1);
        }
        LOG.info("Successfully delete {} from database", (Object)study);
        return locations;
    }
}

