/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.conf.ui.json;

import java.util.Collection;
import javax.enterprise.context.ApplicationScoped;
import javax.json.stream.JsonParser;
import org.dcm4che3.conf.json.ConfigurationDelegate;
import org.dcm4che3.conf.json.JsonConfigurationExtension;
import org.dcm4che3.conf.json.JsonReader;
import org.dcm4che3.conf.json.JsonWriter;
import org.dcm4che3.net.Device;
import org.dcm4che3.net.DeviceExtension;
import org.dcm4che3.util.TagUtils;
import org.dcm4chee.arc.conf.ui.UIAetList;
import org.dcm4chee.arc.conf.ui.UICompareSide;
import org.dcm4chee.arc.conf.ui.UIConfig;
import org.dcm4chee.arc.conf.ui.UIConfigDeviceExtension;
import org.dcm4chee.arc.conf.ui.UICreateDialogTemplate;
import org.dcm4chee.arc.conf.ui.UIDashboardConfig;
import org.dcm4chee.arc.conf.ui.UIDeviceCluster;
import org.dcm4chee.arc.conf.ui.UIDeviceURL;
import org.dcm4chee.arc.conf.ui.UIDiffConfig;
import org.dcm4chee.arc.conf.ui.UIDiffCriteria;
import org.dcm4chee.arc.conf.ui.UIElasticsearchConfig;
import org.dcm4chee.arc.conf.ui.UIElasticsearchURL;
import org.dcm4chee.arc.conf.ui.UIFiltersTemplate;
import org.dcm4chee.arc.conf.ui.UIFunction;
import org.dcm4chee.arc.conf.ui.UILanguageConfig;
import org.dcm4chee.arc.conf.ui.UILanguageProfile;
import org.dcm4chee.arc.conf.ui.UIPermission;
import org.dcm4chee.arc.conf.ui.UITableColumn;
import org.dcm4chee.arc.conf.ui.UITableConfig;
import org.dcm4chee.arc.conf.ui.UIWebAppList;

@ApplicationScoped
public class JsonArchiveUIConfiguration
extends JsonConfigurationExtension {
    protected void storeTo(Device device, JsonWriter writer) {
        UIConfigDeviceExtension ext = (UIConfigDeviceExtension)device.getDeviceExtension(UIConfigDeviceExtension.class);
        if (ext == null) {
            return;
        }
        writer.writeStartArray("dcmuiConfig");
        for (UIConfig uiConfig : ext.getUIConfigs()) {
            this.writeTo(uiConfig, writer);
        }
        writer.writeEnd();
    }

    public boolean loadDeviceExtension(Device device, JsonReader reader, ConfigurationDelegate config) {
        if (!reader.getString().equals("dcmuiConfig")) {
            return false;
        }
        UIConfigDeviceExtension ext = new UIConfigDeviceExtension();
        this.loadFrom(ext, reader);
        device.addDeviceExtension((DeviceExtension)ext);
        return true;
    }

    private void writeTo(UIConfig uiConfig, JsonWriter writer) {
        writer.writeStartObject();
        writer.writeNotNullOrDef("dcmuiConfigName", (Object)uiConfig.getName(), null);
        writer.writeNotEmpty("dcmuiModalities", (Object[])uiConfig.getModalities(), (Object[])new String[0]);
        writer.writeNotEmpty("dcmuiWidgetAets", (Object[])uiConfig.getWidgetAets(), (Object[])new String[0]);
        writer.writeNotNullOrDef("dcmuiXDSInterfaceURL", (Object)uiConfig.getXdsUrl(), null);
        writer.writeNotNullOrDef("dcmuiBackgroundURL", (Object)uiConfig.getBackgroundUrl(), null);
        writer.writeNotNullOrDef("dcmuiDateTimeFormat", (Object)uiConfig.getDateTimeFormat(), null);
        writer.writeNotDef("dcmuiHideClock", uiConfig.isHideClock(), false);
        writer.writeNotNullOrDef("dcmuiPageTitle", (Object)uiConfig.getPageTitle(), null);
        writer.writeNotNullOrDef("dcmuiPersonNameFormat", (Object)uiConfig.getPersonNameFormat(), null);
        writer.writeNotNullOrDef("dcmuiLogoURL", (Object)uiConfig.getLogoUrl(), null);
        writer.writeNotEmpty("dcmuiDefaultWidgetAets", (Object[])uiConfig.getDefaultWidgetAets(), (Object[])new String[0]);
        writer.writeNotEmpty("dcmuiMWLWorklistLabel", (Object[])uiConfig.getMWLWorklistLabels(), (Object[])new String[0]);
        this.writeUIPermissions(writer, uiConfig.getPermissions());
        this.writeUIDiffConfigs(writer, uiConfig.getDiffConfigs());
        this.writeUIDashboardConfigs(writer, uiConfig.getDashboardConfigs());
        this.writeUIElasticsearchConfigs(writer, uiConfig.getElasticsearchConfigs());
        this.writeUILanguageConfigs(writer, uiConfig.getLanguageConfigs());
        this.writeUITableConfigs(writer, uiConfig.getTableConfigs());
        this.writeUIDeviceURLs(writer, uiConfig.getDeviceURLs());
        this.writeUIDeviceClusters(writer, uiConfig.getDeviceClusters());
        this.writeUIFilterTemplate(writer, uiConfig.getFilterTemplates());
        this.writeUIAetList(writer, uiConfig.getAetLists());
        this.writeUICreateDialogTemplate(writer, uiConfig.getCreateDialogTemplates());
        this.writeUIWebAppList(writer, uiConfig.getWebAppLists());
        writer.writeEnd();
    }

    private void writeUIPermissions(JsonWriter writer, Collection<UIPermission> uiPermissions) {
        if (uiPermissions.isEmpty()) {
            return;
        }
        writer.writeStartArray("dcmuiPermission");
        for (UIPermission uiPermission : uiPermissions) {
            writer.writeStartObject();
            writer.writeNotNullOrDef("dcmuiPermissionName", (Object)uiPermission.getName(), null);
            writer.writeNotNullOrDef("dcmuiAction", (Object)uiPermission.getAction(), null);
            writer.writeNotEmpty("dcmuiActionParam", (Object[])uiPermission.getActionParams(), (Object[])new String[0]);
            writer.writeNotEmpty("dcmAcceptedUserRole", (Object[])uiPermission.getAcceptedUserRoles(), (Object[])new String[0]);
            writer.writeEnd();
        }
        writer.writeEnd();
    }

    private void writeUIAetList(JsonWriter writer, Collection<UIAetList> uiAetLists) {
        if (uiAetLists.isEmpty()) {
            return;
        }
        writer.writeStartArray("dcmuiAetConfig");
        for (UIAetList uiAetList : uiAetLists) {
            writer.writeStartObject();
            writer.writeNotNullOrDef("dcmuiAetListName", (Object)uiAetList.getAetListName(), null);
            writer.writeNotNullOrDef("dcmuiAetListDescription", (Object)uiAetList.getAetListDescription(), null);
            writer.writeNotNullOrDef("dcmuiMode", (Object)uiAetList.getMode(), null);
            writer.writeNotEmpty("dcmuiAets", (Object[])uiAetList.getAets(), (Object[])new String[0]);
            writer.writeNotEmpty("dcmAcceptedUserRole", (Object[])uiAetList.getAcceptedRole(), (Object[])new String[0]);
            writer.writeEnd();
        }
        writer.writeEnd();
    }

    private void writeUICreateDialogTemplate(JsonWriter writer, Collection<UICreateDialogTemplate> uiCreateDialogTemplates) {
        if (uiCreateDialogTemplates.isEmpty()) {
            return;
        }
        writer.writeStartArray("dcmuiCreateDialogTemplate");
        for (UICreateDialogTemplate uiCreateDialogTemplate : uiCreateDialogTemplates) {
            writer.writeStartObject();
            writer.writeNotNullOrDef("dcmuiTemplateName", (Object)uiCreateDialogTemplate.getTemplateName(), null);
            writer.writeNotNullOrDef("dicomDescription", (Object)uiCreateDialogTemplate.getDescription(), null);
            writer.writeNotNullOrDef("dcmuiDialog", (Object)uiCreateDialogTemplate.getDialog(), (Object)UIFunction.mwl);
            writer.writeNotEmpty("dcmTag", (Object[])TagUtils.toHexStrings((int[])uiCreateDialogTemplate.getTags()), (Object[])new String[0]);
            writer.writeEnd();
        }
        writer.writeEnd();
    }

    private void writeUIWebAppList(JsonWriter writer, Collection<UIWebAppList> uiWebAppLists) {
        if (uiWebAppLists.isEmpty()) {
            return;
        }
        writer.writeStartArray("dcmuiWebAppConfig");
        for (UIWebAppList uiWebAppList : uiWebAppLists) {
            writer.writeStartObject();
            writer.writeNotNullOrDef("dcmuiWebAppListName", (Object)uiWebAppList.getWebAppListName(), null);
            writer.writeNotNullOrDef("dcmuiWebAppListDescription", (Object)uiWebAppList.getWebAppListDescription(), null);
            writer.writeNotNullOrDef("dcmuiMode", (Object)uiWebAppList.getMode(), null);
            writer.writeNotEmpty("dcmuiWebApps", (Object[])uiWebAppList.getWebApps(), (Object[])new String[0]);
            writer.writeNotEmpty("dcmAcceptedUserRole", (Object[])uiWebAppList.getAcceptedRole(), (Object[])new String[0]);
            writer.writeNotEmpty("dcmAcceptedUserName", (Object[])uiWebAppList.getAcceptedUserName(), (Object[])new String[0]);
            writer.writeEnd();
        }
        writer.writeEnd();
    }

    private void writeUIDeviceURLs(JsonWriter writer, Collection<UIDeviceURL> uiDeviceURLs) {
        if (uiDeviceURLs.isEmpty()) {
            return;
        }
        writer.writeStartArray("dcmuiDeviceURLObject");
        for (UIDeviceURL uiDeviceURL : uiDeviceURLs) {
            writer.writeStartObject();
            writer.writeNotNullOrDef("dcmuiDeviceURLName", (Object)uiDeviceURL.getDeviceName(), null);
            writer.writeNotNullOrDef("dcmuiDeviceURL", (Object)uiDeviceURL.getDeviceURL(), null);
            writer.writeNotNullOrDef("dcmuiDeviceURLDescription", (Object)uiDeviceURL.getDescription(), null);
            writer.writeNotDef("dcmuiDeviceURLInstalled", uiDeviceURL.isInstalled(), true);
            writer.writeEnd();
        }
        writer.writeEnd();
    }

    private void writeUIDeviceClusters(JsonWriter writer, Collection<UIDeviceCluster> uiDeviceClusters) {
        if (uiDeviceClusters.isEmpty()) {
            return;
        }
        writer.writeStartArray("dcmuiDeviceClusterObject");
        for (UIDeviceCluster uiDeviceCluster : uiDeviceClusters) {
            writer.writeStartObject();
            writer.writeNotNullOrDef("dcmuiDeviceClusterName", (Object)uiDeviceCluster.getClusterName(), null);
            writer.writeNotNullOrDef("dcmuiDeviceClusterDescription", (Object)uiDeviceCluster.getDescription(), null);
            writer.writeNotNullOrDef("dcmuiClusterWebApp", (Object)uiDeviceCluster.getClusterWebApp(), null);
            writer.writeNotEmpty("dcmuiDeviceClusterDevices", (Object[])uiDeviceCluster.getDevices(), (Object[])new String[0]);
            writer.writeNotDef("dcmuiDeviceClusterInstalled", uiDeviceCluster.isInstalled(), true);
            writer.writeEnd();
        }
        writer.writeEnd();
    }

    private void writeUIFilterTemplate(JsonWriter writer, Collection<UIFiltersTemplate> uiFiltersTemplates) {
        if (uiFiltersTemplates.isEmpty()) {
            return;
        }
        writer.writeStartArray("dcmuiFilterTemplateObject");
        for (UIFiltersTemplate uiFiltersTemplate : uiFiltersTemplates) {
            writer.writeStartObject();
            writer.writeNotNullOrDef("dcmuiFilterTemplateGroupName", (Object)uiFiltersTemplate.getFilterGroupName(), null);
            writer.writeNotNullOrDef("dcmuiFilterTemplateID", (Object)uiFiltersTemplate.getFilterGroupID(), null);
            writer.writeNotNullOrDef("dcmuiFilterTemplateDescription", (Object)uiFiltersTemplate.getFilterGroupDescription(), null);
            writer.writeNotNullOrDef("dcmuiFilterTemplateUsername", (Object)uiFiltersTemplate.getFilterGroupUsername(), null);
            writer.writeNotNullOrDef("dcmuiFilterTemplateRole", (Object)uiFiltersTemplate.getFilterGroupRole(), null);
            writer.writeNotEmpty("dcmuiFilterTemplateFilters", (Object[])uiFiltersTemplate.getFilters(), (Object[])new String[0]);
            writer.writeNotDef("dcmuiFilterTemplateDefault", uiFiltersTemplate.isDefault(), false);
            writer.writeEnd();
        }
        writer.writeEnd();
    }

    private void writeUIDiffConfigs(JsonWriter writer, Collection<UIDiffConfig> uiDiffConfigs) {
        if (uiDiffConfigs.isEmpty()) {
            return;
        }
        writer.writeStartArray("dcmuiDiffConfig");
        for (UIDiffConfig uiDiffConfig : uiDiffConfigs) {
            writer.writeStartObject();
            writer.writeNotNullOrDef("dcmuiDiffConfigName", (Object)uiDiffConfig.getName(), null);
            writer.writeNotNullOrDef("dcmuiDiffCallingAET", (Object)uiDiffConfig.getCallingAET(), null);
            writer.writeNotNullOrDef("dcmuiDiffPrimaryCFindSCP", (Object)uiDiffConfig.getPrimaryCFindSCP(), null);
            writer.writeNotNullOrDef("dcmuiDiffPrimaryCMoveSCP", (Object)uiDiffConfig.getPrimaryCMoveSCP(), null);
            writer.writeNotNullOrDef("dcmuiDiffPrimaryCStoreSCP", (Object)uiDiffConfig.getPrimaryCStoreSCP(), null);
            writer.writeNotNullOrDef("dcmuiDiffSecondaryCFindSCP", (Object)uiDiffConfig.getSecondaryCFindSCP(), null);
            writer.writeNotNullOrDef("dcmuiDiffSecondaryCMoveSCP", (Object)uiDiffConfig.getSecondaryCMoveSCP(), null);
            writer.writeNotNullOrDef("dcmuiDiffSecondaryCStoreSCP", (Object)uiDiffConfig.getSecondaryCStoreSCP(), null);
            this.writeUIDiffCriteria(writer, uiDiffConfig.getCriterias());
            writer.writeEnd();
        }
        writer.writeEnd();
    }

    private void writeUIElasticsearchConfigs(JsonWriter writer, Collection<UIElasticsearchConfig> uiElasticsearchConfigs) {
        if (uiElasticsearchConfigs.isEmpty()) {
            return;
        }
        writer.writeStartArray("dcmuiElasticsearchConfig");
        for (UIElasticsearchConfig uiElasticsearchConfig : uiElasticsearchConfigs) {
            writer.writeStartObject();
            writer.writeNotNullOrDef("dcmuiElasticsearchConfigName", (Object)uiElasticsearchConfig.getName(), null);
            this.writeUIElasticsearchURL(writer, uiElasticsearchConfig.getURLS());
            writer.writeEnd();
        }
        writer.writeEnd();
    }

    private void writeUILanguageConfigs(JsonWriter writer, Collection<UILanguageConfig> uiLanguageConfigs) {
        if (uiLanguageConfigs.isEmpty()) {
            return;
        }
        writer.writeStartArray("dcmuiLanguageConfig");
        for (UILanguageConfig uiLanguageConfig : uiLanguageConfigs) {
            writer.writeStartObject();
            writer.writeNotNullOrDef("dcmuiLanguageConfigName", (Object)uiLanguageConfig.getName(), null);
            writer.writeNotEmpty("dcmLanguages", (Object[])uiLanguageConfig.getLanguages(), (Object[])new String[0]);
            this.writeUILanguageProfile(writer, uiLanguageConfig.getLanguageProfiles());
            writer.writeEnd();
        }
        writer.writeEnd();
    }

    private void writeUITableConfigs(JsonWriter writer, Collection<UITableConfig> uiTableConfigs) {
        if (uiTableConfigs.isEmpty()) {
            return;
        }
        writer.writeStartArray("dcmuiTableConfig");
        for (UITableConfig uiTableConfig : uiTableConfigs) {
            writer.writeStartObject();
            writer.writeNotNullOrDef("dcmuiTableConfigName", (Object)uiTableConfig.getName(), null);
            writer.writeNotEmpty("dcmuiTableConfigUsername", (Object[])uiTableConfig.getUsername(), (Object[])new String[0]);
            writer.writeNotEmpty("dcmuiTableConfigRoles", (Object[])uiTableConfig.getRoles(), (Object[])new String[0]);
            writer.writeNotNullOrDef("dcmuiTableID", (Object)uiTableConfig.getTableId(), null);
            writer.writeNotDef("dcmuiTableConfigIsDefault", uiTableConfig.isDefault(), false);
            this.writeUITableColumn(writer, uiTableConfig.getTableColumns());
            writer.writeEnd();
        }
        writer.writeEnd();
    }

    private void writeUIElasticsearchURL(JsonWriter writer, Collection<UIElasticsearchURL> uiElasticsearchURLS) {
        if (uiElasticsearchURLS.isEmpty()) {
            return;
        }
        writer.writeStartArray("dcmuiElasticsearchURLObjects");
        for (UIElasticsearchURL uiElasticsearchURL : uiElasticsearchURLS) {
            writer.writeStartObject();
            writer.writeNotNullOrDef("dcmuiElasticsearchURLName", (Object)uiElasticsearchURL.getUrlName(), null);
            writer.writeNotNullOrDef("dcmuiElasticsearchWebApp", (Object)uiElasticsearchURL.getUrl(), null);
            writer.writeNotNullOrDef("dcmuiAuditEnterpriseSiteID", (Object)uiElasticsearchURL.getAuditEnterpriseSiteID(), null);
            writer.writeNotDef("dcmuiElasticsearchIsDefault", uiElasticsearchURL.isDefault(), false);
            writer.writeNotDef("dcmuiElasticsearchInstalled", uiElasticsearchURL.isInstalled(), true);
            writer.writeEnd();
        }
        writer.writeEnd();
    }

    private void writeUILanguageProfile(JsonWriter writer, Collection<UILanguageProfile> uiLanguageProfiles) {
        if (uiLanguageProfiles.isEmpty()) {
            return;
        }
        writer.writeStartArray("dcmuiLanguageProfileObjects");
        for (UILanguageProfile uiLanguageProfile : uiLanguageProfiles) {
            writer.writeStartObject();
            writer.writeNotNullOrDef("dcmuiLanguageProfileName", (Object)uiLanguageProfile.getProfileName(), null);
            writer.writeNotNullOrDef("dcmDefaultLanguage", (Object)uiLanguageProfile.getDefaultLanguage(), null);
            writer.writeNotEmpty("dcmuiLanguageProfileRole", (Object[])uiLanguageProfile.getAcceptedUserRoles(), (Object[])new String[0]);
            writer.writeNotNullOrDef("dcmuiLanguageProfileUsername", (Object)uiLanguageProfile.getUserName(), null);
            writer.writeEnd();
        }
        writer.writeEnd();
    }

    private void writeUITableColumn(JsonWriter writer, Collection<UITableColumn> uiTableColumns) {
        if (uiTableColumns.isEmpty()) {
            return;
        }
        writer.writeStartArray("dcmuiTableColumnConfigObjects");
        for (UITableColumn uiTableColumn : uiTableColumns) {
            writer.writeStartObject();
            writer.writeNotNullOrDef("dcmuiColumnName", (Object)uiTableColumn.getColumnName(), null);
            writer.writeNotNullOrDef("dcmuiColumnId", (Object)uiTableColumn.getColumnId(), null);
            writer.writeNotNullOrDef("dcmuiColumnTitle", (Object)uiTableColumn.getColumnTitle(), null);
            writer.writeNotNullOrDef("dcmuiValuePath", (Object)uiTableColumn.getValuePath(), null);
            writer.writeNotNullOrDef("dcmuiValueType", (Object)uiTableColumn.getValueType(), null);
            writer.writeNotNullOrDef("dcmuiColumnWidth", (Object)uiTableColumn.getColumnWidth(), null);
            writer.writeNotNullOrDef("dcmuiColumnOrder", (Object)uiTableColumn.getColumnOrder(), null);
            writer.writeEnd();
        }
        writer.writeEnd();
    }

    private void writeUIDiffCriteria(JsonWriter writer, Collection<UIDiffCriteria> uiDiffCriterias) {
        if (uiDiffCriterias.isEmpty()) {
            return;
        }
        writer.writeStartArray("dcmuiDiffCriteria");
        for (UIDiffCriteria uiDiffCriteria : uiDiffCriterias) {
            writer.writeStartObject();
            writer.writeNotNullOrDef("dcmuiDiffCriteriaTitle", (Object)uiDiffCriteria.getTitle(), null);
            writer.writeNotNullOrDef("dicomDescription", (Object)uiDiffCriteria.getDescription(), null);
            writer.writeNotDef("dcmuiDiffCriteriaNumber", uiDiffCriteria.getNumber(), 0);
            writer.writeNotDef("dcmuiDiffIncludeMissing", uiDiffCriteria.isIncludeMissing(), false);
            writer.writeNotNullOrDef("dcmAttributeSetID", (Object)uiDiffCriteria.getAttributeSetID(), null);
            writer.writeNotEmpty("dcmuiDiffGroupButton", (Object[])uiDiffCriteria.getGroupButtons(), (Object[])new String[0]);
            writer.writeNotEmpty("dcmuiDiffAction", (Object[])uiDiffCriteria.getActions(), (Object[])new String[0]);
            writer.writeEnd();
        }
        writer.writeEnd();
    }

    private void writeUIDashboardConfigs(JsonWriter writer, Collection<UIDashboardConfig> dashboardConfigs) {
        if (dashboardConfigs.isEmpty()) {
            return;
        }
        writer.writeStartArray("dcmuiDashboardConfig");
        for (UIDashboardConfig uiDashboardConfig : dashboardConfigs) {
            writer.writeStartObject();
            writer.writeNotNullOrDef("dcmuiDashboardConfigName", (Object)uiDashboardConfig.getName(), null);
            writer.writeNotEmpty("dcmuiQueueName", (Object[])uiDashboardConfig.getQueueNames(), (Object[])new String[0]);
            writer.writeNotEmpty("dcmuiExportName", (Object[])uiDashboardConfig.getExportNames(), (Object[])new String[0]);
            writer.writeNotDef("dcmuiShowStarBlock", uiDashboardConfig.isShowStarBlock(), true);
            writer.writeNotEmpty("dicomuiDeviceName", (Object[])uiDashboardConfig.getDeviceNames(), (Object[])new String[0]);
            writer.writeNotEmpty("dicomuiIgnoreParams", (Object[])uiDashboardConfig.getIgnoreParams(), (Object[])new String[0]);
            writer.writeNotEmpty("dicomuiDockerContainer", (Object[])uiDashboardConfig.getDockerContainers(), (Object[])new String[0]);
            writer.writeNotNullOrDef("dcmuiCountWebApp", (Object)uiDashboardConfig.getCountWebApp(), null);
            this.writeUICompareSide(writer, uiDashboardConfig.getCompareSides());
            writer.writeEnd();
        }
        writer.writeEnd();
    }

    private void writeUICompareSide(JsonWriter writer, Collection<UICompareSide> uiCompareSides) {
        if (uiCompareSides.isEmpty()) {
            return;
        }
        writer.writeStartArray("dcmuiCompareSideObjects");
        for (UICompareSide uiCompareSide : uiCompareSides) {
            writer.writeStartObject();
            writer.writeNotNullOrDef("dcmuiCompareSideName", (Object)uiCompareSide.getName(), null);
            writer.writeNotNullOrDef("dcmuiCompareSideDescription", (Object)uiCompareSide.getDescription(), null);
            writer.writeNotDef("dcmuiCompareSideOrder", uiCompareSide.getOrder(), 0);
            writer.writeNotNullOrDef("dcmuiCompareSideCluster", (Object)uiCompareSide.getCluster(), null);
            writer.writeNotNullOrDef("dcmuiCompareSideElasticsearch", (Object)uiCompareSide.getElasticsearch(), null);
            writer.writeNotNullOrDef("dcmuiCompareSideQueueName", (Object)uiCompareSide.getQueueName(), null);
            writer.writeNotDef("dcmuiCompareSideInstalled", uiCompareSide.isInstalled(), true);
            writer.writeEnd();
        }
        writer.writeEnd();
    }

    private void loadFrom(UIConfigDeviceExtension ext, JsonReader reader) {
        reader.next();
        reader.expect(JsonParser.Event.START_ARRAY);
        while (reader.next() == JsonParser.Event.START_OBJECT) {
            UIConfig uiConfig = new UIConfig();
            this.loadFrom(uiConfig, reader);
            reader.expect(JsonParser.Event.END_OBJECT);
            ext.addUIConfig(uiConfig);
        }
        reader.expect(JsonParser.Event.END_ARRAY);
    }

    private void loadFrom(UIConfig uiConfig, JsonReader reader) {
        block52: while (reader.next() == JsonParser.Event.KEY_NAME) {
            switch (reader.getString()) {
                case "dcmuiConfigName": {
                    uiConfig.setName(reader.stringValue());
                    continue block52;
                }
                case "dcmuiModalities": {
                    uiConfig.setModalities(reader.stringArray());
                    continue block52;
                }
                case "dcmuiWidgetAets": {
                    uiConfig.setWidgetAets(reader.stringArray());
                    continue block52;
                }
                case "dcmuiXDSInterfaceURL": {
                    uiConfig.setXdsUrl(reader.stringValue());
                    continue block52;
                }
                case "dcmuiBackgroundURL": {
                    uiConfig.setBackgroundUrl(reader.stringValue());
                    continue block52;
                }
                case "dcmuiDateTimeFormat": {
                    uiConfig.setDateTimeFormat(reader.stringValue());
                    continue block52;
                }
                case "dcmuiHideClock": {
                    uiConfig.setHideClock(reader.booleanValue());
                    continue block52;
                }
                case "dcmuiPageTitle": {
                    uiConfig.setPageTitle(reader.stringValue());
                    continue block52;
                }
                case "dcmuiPersonNameFormat": {
                    uiConfig.setPersonNameFormat(reader.stringValue());
                    continue block52;
                }
                case "dcmuiLogoURL": {
                    uiConfig.setLogoUrl(reader.stringValue());
                    continue block52;
                }
                case "dcmuiDefaultWidgetAets": {
                    uiConfig.setDefaultWidgetAets(reader.stringArray());
                    continue block52;
                }
                case "dcmuiMWLWorklistLabel": {
                    uiConfig.setMWLWorklistLabels(reader.stringArray());
                    continue block52;
                }
                case "dcmuiPermission": {
                    this.loadUIPermissions(uiConfig, reader);
                    continue block52;
                }
                case "dcmuiAetConfig": {
                    this.loadUIAetList(uiConfig, reader);
                    continue block52;
                }
                case "dcmuiCreateDialogTemplate": {
                    this.loadUICreateDialogTemplate(uiConfig, reader);
                    continue block52;
                }
                case "dcmuiWebAppConfig": {
                    this.loadUIWebAppList(uiConfig, reader);
                    continue block52;
                }
                case "dcmuiDiffConfig": {
                    this.loadUIDiffConfigs(uiConfig, reader);
                    continue block52;
                }
                case "dcmuiDashboardConfig": {
                    this.loadUIDashboardConfigs(uiConfig, reader);
                    continue block52;
                }
                case "dcmuiElasticsearchConfig": {
                    this.loadUIElasticsearchConfigs(uiConfig, reader);
                    continue block52;
                }
                case "dcmuiLanguageConfig": {
                    this.loadUILanguageConfigs(uiConfig, reader);
                    continue block52;
                }
                case "dcmuiTableConfig": {
                    this.loadUITableConfigs(uiConfig, reader);
                    continue block52;
                }
                case "dcmuiDeviceURLObject": {
                    this.loadUIDeviceURLs(uiConfig, reader);
                    continue block52;
                }
                case "dcmuiDeviceClusterObject": {
                    this.loadUIDeviceClusters(uiConfig, reader);
                    continue block52;
                }
                case "dcmuiFilterTemplateObject": {
                    this.loadUIFilterTemplate(uiConfig, reader);
                    continue block52;
                }
            }
            reader.skipUnknownProperty();
        }
    }

    private void loadUIPermissions(UIConfig uiConfig, JsonReader reader) {
        reader.next();
        reader.expect(JsonParser.Event.START_ARRAY);
        while (reader.next() == JsonParser.Event.START_OBJECT) {
            reader.expect(JsonParser.Event.START_OBJECT);
            UIPermission uiPermission = new UIPermission();
            block13: while (reader.next() == JsonParser.Event.KEY_NAME) {
                switch (reader.getString()) {
                    case "dcmuiPermissionName": {
                        uiPermission.setName(reader.stringValue());
                        continue block13;
                    }
                    case "dcmuiAction": {
                        uiPermission.setAction(reader.stringValue());
                        continue block13;
                    }
                    case "dcmuiActionParam": {
                        uiPermission.setActionParams(reader.stringArray());
                        continue block13;
                    }
                    case "dcmAcceptedUserRole": {
                        uiPermission.setAcceptedUserRoles(reader.stringArray());
                        continue block13;
                    }
                }
                reader.skipUnknownProperty();
            }
            reader.expect(JsonParser.Event.END_OBJECT);
            uiConfig.addPermission(uiPermission);
        }
        reader.expect(JsonParser.Event.END_ARRAY);
    }

    private void loadUIAetList(UIConfig uiConfig, JsonReader reader) {
        reader.next();
        reader.expect(JsonParser.Event.START_ARRAY);
        while (reader.next() == JsonParser.Event.START_OBJECT) {
            reader.expect(JsonParser.Event.START_OBJECT);
            UIAetList uiAetList = new UIAetList();
            block15: while (reader.next() == JsonParser.Event.KEY_NAME) {
                switch (reader.getString()) {
                    case "dcmuiAetListName": {
                        uiAetList.setAetListName(reader.stringValue());
                        continue block15;
                    }
                    case "dcmuiAetListDescription": {
                        uiAetList.setAetListDescription(reader.stringValue());
                        continue block15;
                    }
                    case "dcmuiMode": {
                        uiAetList.setMode(reader.stringValue());
                        continue block15;
                    }
                    case "dcmuiAets": {
                        uiAetList.setAets(reader.stringArray());
                        continue block15;
                    }
                    case "dcmAcceptedUserRole": {
                        uiAetList.setAcceptedRole(reader.stringArray());
                        continue block15;
                    }
                }
                reader.skipUnknownProperty();
            }
            reader.expect(JsonParser.Event.END_OBJECT);
            uiConfig.addAetList(uiAetList);
        }
        reader.expect(JsonParser.Event.END_ARRAY);
    }

    private void loadUICreateDialogTemplate(UIConfig uiConfig, JsonReader reader) {
        reader.next();
        reader.expect(JsonParser.Event.START_ARRAY);
        while (reader.next() == JsonParser.Event.START_OBJECT) {
            reader.expect(JsonParser.Event.START_OBJECT);
            UICreateDialogTemplate uiCreateDialogTemplate = new UICreateDialogTemplate();
            block13: while (reader.next() == JsonParser.Event.KEY_NAME) {
                switch (reader.getString()) {
                    case "dcmuiTemplateName": {
                        uiCreateDialogTemplate.setTemplateName(reader.stringValue());
                        continue block13;
                    }
                    case "dicomDescription": {
                        uiCreateDialogTemplate.setDescription(reader.stringValue());
                        continue block13;
                    }
                    case "dcmuiDialog": {
                        uiCreateDialogTemplate.setDialog(UIFunction.valueOf(reader.stringValue()));
                        continue block13;
                    }
                    case "dcmTag": {
                        uiCreateDialogTemplate.setTags(TagUtils.fromHexStrings((String[])reader.stringArray()));
                        continue block13;
                    }
                }
                reader.skipUnknownProperty();
            }
            reader.expect(JsonParser.Event.END_OBJECT);
            uiConfig.addCreatDialogTemplate(uiCreateDialogTemplate);
        }
        reader.expect(JsonParser.Event.END_ARRAY);
    }

    private void loadUIWebAppList(UIConfig uiConfig, JsonReader reader) {
        reader.next();
        reader.expect(JsonParser.Event.START_ARRAY);
        while (reader.next() == JsonParser.Event.START_OBJECT) {
            reader.expect(JsonParser.Event.START_OBJECT);
            UIWebAppList uiWebAppList = new UIWebAppList();
            block17: while (reader.next() == JsonParser.Event.KEY_NAME) {
                switch (reader.getString()) {
                    case "dcmuiWebAppListName": {
                        uiWebAppList.setWebAppListName(reader.stringValue());
                        continue block17;
                    }
                    case "dcmuiWebAppListDescription": {
                        uiWebAppList.setWebAppListDescription(reader.stringValue());
                        continue block17;
                    }
                    case "dcmuiMode": {
                        uiWebAppList.setMode(reader.stringValue());
                        continue block17;
                    }
                    case "dcmuiWebApps": {
                        uiWebAppList.setWebApps(reader.stringArray());
                        continue block17;
                    }
                    case "dcmAcceptedUserRole": {
                        uiWebAppList.setAcceptedRole(reader.stringArray());
                        continue block17;
                    }
                    case "dcmAcceptedUserName": {
                        uiWebAppList.setAcceptedUserName(reader.stringArray());
                        continue block17;
                    }
                }
                reader.skipUnknownProperty();
            }
            reader.expect(JsonParser.Event.END_OBJECT);
            uiConfig.addWebAppList(uiWebAppList);
        }
        reader.expect(JsonParser.Event.END_ARRAY);
    }

    private void loadUIDeviceURLs(UIConfig uiConfig, JsonReader reader) {
        reader.next();
        reader.expect(JsonParser.Event.START_ARRAY);
        while (reader.next() == JsonParser.Event.START_OBJECT) {
            reader.expect(JsonParser.Event.START_OBJECT);
            UIDeviceURL uiDeviceURL = new UIDeviceURL();
            block13: while (reader.next() == JsonParser.Event.KEY_NAME) {
                switch (reader.getString()) {
                    case "dcmuiDeviceURLName": {
                        uiDeviceURL.setDeviceName(reader.stringValue());
                        continue block13;
                    }
                    case "dcmuiDeviceURL": {
                        uiDeviceURL.setDeviceURL(reader.stringValue());
                        continue block13;
                    }
                    case "dcmuiDeviceURLDescription": {
                        uiDeviceURL.setDescription(reader.stringValue());
                        continue block13;
                    }
                    case "dcmuiDeviceURLInstalled": {
                        uiDeviceURL.setInstalled(reader.booleanValue());
                        continue block13;
                    }
                }
                reader.skipUnknownProperty();
            }
            reader.expect(JsonParser.Event.END_OBJECT);
            uiConfig.addDeviceURL(uiDeviceURL);
        }
        reader.expect(JsonParser.Event.END_ARRAY);
    }

    private void loadUIDeviceClusters(UIConfig uiConfig, JsonReader reader) {
        reader.next();
        reader.expect(JsonParser.Event.START_ARRAY);
        while (reader.next() == JsonParser.Event.START_OBJECT) {
            reader.expect(JsonParser.Event.START_OBJECT);
            UIDeviceCluster uiDeviceCluster = new UIDeviceCluster();
            block15: while (reader.next() == JsonParser.Event.KEY_NAME) {
                switch (reader.getString()) {
                    case "dcmuiDeviceClusterName": {
                        uiDeviceCluster.setClusterName(reader.stringValue());
                        continue block15;
                    }
                    case "dcmuiDeviceClusterDevices": {
                        uiDeviceCluster.setDevices(reader.stringArray());
                        continue block15;
                    }
                    case "dcmuiDeviceClusterDescription": {
                        uiDeviceCluster.setDescription(reader.stringValue());
                        continue block15;
                    }
                    case "dcmuiClusterWebApp": {
                        uiDeviceCluster.setClusterWebApp(reader.stringValue());
                        continue block15;
                    }
                    case "dcmuiDeviceClusterInstalled": {
                        uiDeviceCluster.setInstalled(reader.booleanValue());
                        continue block15;
                    }
                }
                reader.skipUnknownProperty();
            }
            reader.expect(JsonParser.Event.END_OBJECT);
            uiConfig.addDeviceCluster(uiDeviceCluster);
        }
        reader.expect(JsonParser.Event.END_ARRAY);
    }

    private void loadUIFilterTemplate(UIConfig uiConfig, JsonReader reader) {
        reader.next();
        reader.expect(JsonParser.Event.START_ARRAY);
        while (reader.next() == JsonParser.Event.START_OBJECT) {
            reader.expect(JsonParser.Event.START_OBJECT);
            UIFiltersTemplate uiFiltersTemplate = new UIFiltersTemplate();
            block19: while (reader.next() == JsonParser.Event.KEY_NAME) {
                switch (reader.getString()) {
                    case "dcmuiFilterTemplateGroupName": {
                        uiFiltersTemplate.setFilterGroupName(reader.stringValue());
                        continue block19;
                    }
                    case "dcmuiFilterTemplateID": {
                        uiFiltersTemplate.setFilterGroupID(reader.stringValue());
                        continue block19;
                    }
                    case "dcmuiFilterTemplateDescription": {
                        uiFiltersTemplate.setFilterGroupDescription(reader.stringValue());
                        continue block19;
                    }
                    case "dcmuiFilterTemplateUsername": {
                        uiFiltersTemplate.setFilterGroupUsername(reader.stringValue());
                        continue block19;
                    }
                    case "dcmuiFilterTemplateRole": {
                        uiFiltersTemplate.setFilterGroupRole(reader.stringValue());
                        continue block19;
                    }
                    case "dcmuiFilterTemplateFilters": {
                        uiFiltersTemplate.setFilters(reader.stringArray());
                        continue block19;
                    }
                    case "dcmuiFilterTemplateDefault": {
                        uiFiltersTemplate.setDefault(reader.booleanValue());
                        continue block19;
                    }
                }
                reader.skipUnknownProperty();
            }
            reader.expect(JsonParser.Event.END_OBJECT);
            uiConfig.addFilterTemplate(uiFiltersTemplate);
        }
        reader.expect(JsonParser.Event.END_ARRAY);
    }

    private void loadUILanguageConfigs(UIConfig uiConfig, JsonReader reader) {
        reader.next();
        reader.expect(JsonParser.Event.START_ARRAY);
        while (reader.next() == JsonParser.Event.START_OBJECT) {
            reader.expect(JsonParser.Event.START_OBJECT);
            UILanguageConfig uiLanguageConfig = new UILanguageConfig();
            block11: while (reader.next() == JsonParser.Event.KEY_NAME) {
                switch (reader.getString()) {
                    case "dcmuiLanguageConfigName": {
                        uiLanguageConfig.setName(reader.stringValue());
                        continue block11;
                    }
                    case "dcmLanguages": {
                        uiLanguageConfig.setLanguages(reader.stringArray());
                        continue block11;
                    }
                    case "dcmuiLanguageProfileObjects": {
                        this.loadUILanguageProfile(uiLanguageConfig, reader);
                        continue block11;
                    }
                }
                reader.skipUnknownProperty();
            }
            reader.expect(JsonParser.Event.END_OBJECT);
            uiConfig.addLanguageConfig(uiLanguageConfig);
        }
        reader.expect(JsonParser.Event.END_ARRAY);
    }

    private void loadUITableConfigs(UIConfig uiConfig, JsonReader reader) {
        reader.next();
        reader.expect(JsonParser.Event.START_ARRAY);
        while (reader.next() == JsonParser.Event.START_OBJECT) {
            reader.expect(JsonParser.Event.START_OBJECT);
            UITableConfig uiTableConfig = new UITableConfig();
            block17: while (reader.next() == JsonParser.Event.KEY_NAME) {
                switch (reader.getString()) {
                    case "dcmuiTableConfigName": {
                        uiTableConfig.setName(reader.stringValue());
                        continue block17;
                    }
                    case "dcmuiTableConfigUsername": {
                        uiTableConfig.setUsername(reader.stringArray());
                        continue block17;
                    }
                    case "dcmuiTableConfigRoles": {
                        uiTableConfig.setRoles(reader.stringArray());
                        continue block17;
                    }
                    case "dcmuiTableID": {
                        uiTableConfig.setTableId(reader.stringValue());
                        continue block17;
                    }
                    case "dcmuiTableConfigIsDefault": {
                        uiTableConfig.setDefault(reader.booleanValue());
                        continue block17;
                    }
                    case "dcmuiTableColumnConfigObjects": {
                        this.loadUITableColumn(uiTableConfig, reader);
                        continue block17;
                    }
                }
                reader.skipUnknownProperty();
            }
            reader.expect(JsonParser.Event.END_OBJECT);
            uiConfig.addTableConfig(uiTableConfig);
        }
        reader.expect(JsonParser.Event.END_ARRAY);
    }

    private void loadUIElasticsearchConfigs(UIConfig uiConfig, JsonReader reader) {
        reader.next();
        reader.expect(JsonParser.Event.START_ARRAY);
        while (reader.next() == JsonParser.Event.START_OBJECT) {
            reader.expect(JsonParser.Event.START_OBJECT);
            UIElasticsearchConfig uiElasticsearchConfig = new UIElasticsearchConfig();
            block9: while (reader.next() == JsonParser.Event.KEY_NAME) {
                switch (reader.getString()) {
                    case "dcmuiElasticsearchConfigName": {
                        uiElasticsearchConfig.setName(reader.stringValue());
                        continue block9;
                    }
                    case "dcmuiElasticsearchURLObjects": {
                        this.loadUIElasticsearchURL(uiElasticsearchConfig, reader);
                        continue block9;
                    }
                }
                reader.skipUnknownProperty();
            }
            reader.expect(JsonParser.Event.END_OBJECT);
            uiConfig.addElasticsearchConfig(uiElasticsearchConfig);
        }
        reader.expect(JsonParser.Event.END_ARRAY);
    }

    private void loadUIElasticsearchURL(UIElasticsearchConfig uiDiffConfig, JsonReader reader) {
        reader.next();
        reader.expect(JsonParser.Event.START_ARRAY);
        while (reader.next() == JsonParser.Event.START_OBJECT) {
            reader.expect(JsonParser.Event.START_OBJECT);
            UIElasticsearchURL uiElasticsearchURL = new UIElasticsearchURL();
            block15: while (reader.next() == JsonParser.Event.KEY_NAME) {
                switch (reader.getString()) {
                    case "dcmuiElasticsearchURLName": {
                        uiElasticsearchURL.setUrlName(reader.stringValue());
                        continue block15;
                    }
                    case "dcmuiElasticsearchWebApp": {
                        uiElasticsearchURL.setUrl(reader.stringValue());
                        continue block15;
                    }
                    case "dcmuiAuditEnterpriseSiteID": {
                        uiElasticsearchURL.setAuditEnterpriseSiteID(reader.stringValue());
                        continue block15;
                    }
                    case "dcmuiElasticsearchIsDefault": {
                        uiElasticsearchURL.setDefault(reader.booleanValue());
                        continue block15;
                    }
                    case "dcmuiElasticsearchInstalled": {
                        uiElasticsearchURL.setInstalled(reader.booleanValue());
                        continue block15;
                    }
                }
                reader.skipUnknownProperty();
            }
            reader.expect(JsonParser.Event.END_OBJECT);
            uiDiffConfig.addURL(uiElasticsearchURL);
        }
        reader.expect(JsonParser.Event.END_ARRAY);
    }

    private void loadUILanguageProfile(UILanguageConfig uiLanguageConfig, JsonReader reader) {
        reader.next();
        reader.expect(JsonParser.Event.START_ARRAY);
        while (reader.next() == JsonParser.Event.START_OBJECT) {
            reader.expect(JsonParser.Event.START_OBJECT);
            UILanguageProfile uiLanguageProfile = new UILanguageProfile();
            block13: while (reader.next() == JsonParser.Event.KEY_NAME) {
                switch (reader.getString()) {
                    case "dcmuiLanguageProfileName": {
                        uiLanguageProfile.setProfileName(reader.stringValue());
                        continue block13;
                    }
                    case "dcmDefaultLanguage": {
                        uiLanguageProfile.setDefaultLanguage(reader.stringValue());
                        continue block13;
                    }
                    case "dcmuiLanguageProfileRole": {
                        uiLanguageProfile.setAcceptedUserRoles(reader.stringArray());
                        continue block13;
                    }
                    case "dcmuiLanguageProfileUsername": {
                        uiLanguageProfile.setUserName(reader.stringValue());
                        continue block13;
                    }
                }
                reader.skipUnknownProperty();
            }
            reader.expect(JsonParser.Event.END_OBJECT);
            uiLanguageConfig.addLanguageProfile(uiLanguageProfile);
        }
        reader.expect(JsonParser.Event.END_ARRAY);
    }

    private void loadUITableColumn(UITableConfig uiTableConfig, JsonReader reader) {
        reader.next();
        reader.expect(JsonParser.Event.START_ARRAY);
        while (reader.next() == JsonParser.Event.START_OBJECT) {
            reader.expect(JsonParser.Event.START_OBJECT);
            UITableColumn uiTableColumn = new UITableColumn();
            block19: while (reader.next() == JsonParser.Event.KEY_NAME) {
                switch (reader.getString()) {
                    case "dcmuiColumnName": {
                        uiTableColumn.setColumnName(reader.stringValue());
                        continue block19;
                    }
                    case "dcmuiColumnId": {
                        uiTableColumn.setColumnId(reader.stringValue());
                        continue block19;
                    }
                    case "dcmuiColumnTitle": {
                        uiTableColumn.setColumnTitle(reader.stringValue());
                        continue block19;
                    }
                    case "dcmuiValuePath": {
                        uiTableColumn.setValuePath(reader.stringValue());
                        continue block19;
                    }
                    case "dcmuiValueType": {
                        uiTableColumn.setValueType(reader.stringValue());
                        continue block19;
                    }
                    case "dcmuiColumnWidth": {
                        uiTableColumn.setColumnWidth(reader.stringValue());
                        continue block19;
                    }
                    case "dcmuiColumnOrder": {
                        uiTableColumn.setColumnOrder(reader.intValue());
                        continue block19;
                    }
                }
                reader.skipUnknownProperty();
            }
            reader.expect(JsonParser.Event.END_OBJECT);
            uiTableConfig.addTableColumn(uiTableColumn);
        }
        reader.expect(JsonParser.Event.END_ARRAY);
    }

    private void loadUIDiffConfigs(UIConfig uiConfig, JsonReader reader) {
        reader.next();
        reader.expect(JsonParser.Event.START_ARRAY);
        while (reader.next() == JsonParser.Event.START_OBJECT) {
            reader.expect(JsonParser.Event.START_OBJECT);
            UIDiffConfig uiDiffConfig = new UIDiffConfig();
            block23: while (reader.next() == JsonParser.Event.KEY_NAME) {
                switch (reader.getString()) {
                    case "dcmuiDiffConfigName": {
                        uiDiffConfig.setName(reader.stringValue());
                        continue block23;
                    }
                    case "dcmuiDiffCallingAET": {
                        uiDiffConfig.setCallingAET(reader.stringValue());
                        continue block23;
                    }
                    case "dcmuiDiffPrimaryCFindSCP": {
                        uiDiffConfig.setPrimaryCFindSCP(reader.stringValue());
                        continue block23;
                    }
                    case "dcmuiDiffPrimaryCMoveSCP": {
                        uiDiffConfig.setPrimaryCMoveSCP(reader.stringValue());
                        continue block23;
                    }
                    case "dcmuiDiffPrimaryCStoreSCP": {
                        uiDiffConfig.setPrimaryCStoreSCP(reader.stringValue());
                        continue block23;
                    }
                    case "dcmuiDiffSecondaryCFindSCP": {
                        uiDiffConfig.setSecondaryCFindSCP(reader.stringValue());
                        continue block23;
                    }
                    case "dcmuiDiffSecondaryCMoveSCP": {
                        uiDiffConfig.setSecondaryCMoveSCP(reader.stringValue());
                        continue block23;
                    }
                    case "dcmuiDiffSecondaryCStoreSCP": {
                        uiDiffConfig.setSecondaryCStoreSCP(reader.stringValue());
                        continue block23;
                    }
                    case "dcmuiDiffCriteria": {
                        this.loadUIDiffCriterias(uiDiffConfig, reader);
                        continue block23;
                    }
                }
                reader.skipUnknownProperty();
            }
            reader.expect(JsonParser.Event.END_OBJECT);
            uiConfig.addDiffConfig(uiDiffConfig);
        }
        reader.expect(JsonParser.Event.END_ARRAY);
    }

    private void loadUIDiffCriterias(UIDiffConfig uiDiffConfig, JsonReader reader) {
        reader.next();
        reader.expect(JsonParser.Event.START_ARRAY);
        while (reader.next() == JsonParser.Event.START_OBJECT) {
            reader.expect(JsonParser.Event.START_OBJECT);
            UIDiffCriteria uiDiffCriteria = new UIDiffCriteria();
            block19: while (reader.next() == JsonParser.Event.KEY_NAME) {
                switch (reader.getString()) {
                    case "dcmuiDiffCriteriaTitle": {
                        uiDiffCriteria.setTitle(reader.stringValue());
                        continue block19;
                    }
                    case "dicomDescription": {
                        uiDiffCriteria.setDescription(reader.stringValue());
                        continue block19;
                    }
                    case "dcmuiDiffCriteriaNumber": {
                        uiDiffCriteria.setNumber(reader.intValue());
                        continue block19;
                    }
                    case "dcmuiDiffIncludeMissing": {
                        uiDiffCriteria.setIncludeMissing(reader.booleanValue());
                        continue block19;
                    }
                    case "dcmAttributeSetID": {
                        uiDiffCriteria.setAttributeSetID(reader.stringValue());
                        continue block19;
                    }
                    case "dcmuiDiffGroupButton": {
                        uiDiffCriteria.setGroupButtons(reader.stringArray());
                        continue block19;
                    }
                    case "dcmuiDiffAction": {
                        uiDiffCriteria.setActions(reader.stringArray());
                        continue block19;
                    }
                }
                reader.skipUnknownProperty();
            }
            reader.expect(JsonParser.Event.END_OBJECT);
            uiDiffConfig.addCriteria(uiDiffCriteria);
        }
        reader.expect(JsonParser.Event.END_ARRAY);
    }

    private void loadUIDashboardConfigs(UIConfig uiConfig, JsonReader reader) {
        reader.next();
        reader.expect(JsonParser.Event.START_ARRAY);
        while (reader.next() == JsonParser.Event.START_OBJECT) {
            reader.expect(JsonParser.Event.START_OBJECT);
            UIDashboardConfig uiDashboardConfig = new UIDashboardConfig();
            block23: while (reader.next() == JsonParser.Event.KEY_NAME) {
                switch (reader.getString()) {
                    case "dcmuiDashboardConfigName": {
                        uiDashboardConfig.setName(reader.stringValue());
                        continue block23;
                    }
                    case "dcmuiQueueName": {
                        uiDashboardConfig.setQueueNames(reader.stringArray());
                        continue block23;
                    }
                    case "dcmuiExportName": {
                        uiDashboardConfig.setExportNames(reader.stringArray());
                        continue block23;
                    }
                    case "dicomuiDeviceName": {
                        uiDashboardConfig.setDeviceNames(reader.stringArray());
                        continue block23;
                    }
                    case "dicomuiIgnoreParams": {
                        uiDashboardConfig.setIgnoreParams(reader.stringArray());
                        continue block23;
                    }
                    case "dcmuiShowStarBlock": {
                        uiDashboardConfig.setShowStarBlock(reader.booleanValue());
                        continue block23;
                    }
                    case "dicomuiDockerContainer": {
                        uiDashboardConfig.setDockerContainers(reader.stringArray());
                        continue block23;
                    }
                    case "dcmuiCountWebApp": {
                        uiDashboardConfig.setCountWebApp(reader.stringValue());
                        continue block23;
                    }
                    case "dcmuiCompareSideObjects": {
                        this.loadCompareSides(uiDashboardConfig, reader);
                        continue block23;
                    }
                }
                reader.skipUnknownProperty();
            }
            reader.expect(JsonParser.Event.END_OBJECT);
            uiConfig.addDashboardConfig(uiDashboardConfig);
        }
        reader.expect(JsonParser.Event.END_ARRAY);
    }

    private void loadCompareSides(UIDashboardConfig uiDashboardConfig, JsonReader reader) {
        reader.next();
        reader.expect(JsonParser.Event.START_ARRAY);
        while (reader.next() == JsonParser.Event.START_OBJECT) {
            reader.expect(JsonParser.Event.START_OBJECT);
            UICompareSide uiCompareSide = new UICompareSide();
            block19: while (reader.next() == JsonParser.Event.KEY_NAME) {
                switch (reader.getString()) {
                    case "dcmuiCompareSideName": {
                        uiCompareSide.setName(reader.stringValue());
                        continue block19;
                    }
                    case "dcmuiCompareSideDescription": {
                        uiCompareSide.setDescription(reader.stringValue());
                        continue block19;
                    }
                    case "dcmuiCompareSideOrder": {
                        uiCompareSide.setOrder(reader.intValue());
                        continue block19;
                    }
                    case "dcmuiCompareSideCluster": {
                        uiCompareSide.setCluster(reader.stringValue());
                        continue block19;
                    }
                    case "dcmuiCompareSideElasticsearch": {
                        uiCompareSide.setElasticsearch(reader.stringValue());
                        continue block19;
                    }
                    case "dcmuiCompareSideQueueName": {
                        uiCompareSide.setQueueName(reader.stringValue());
                        continue block19;
                    }
                    case "dcmuiCompareSideInstalled": {
                        uiCompareSide.setInstalled(reader.booleanValue());
                        continue block19;
                    }
                }
                reader.skipUnknownProperty();
            }
            reader.expect(JsonParser.Event.END_OBJECT);
            uiDashboardConfig.addCompareSide(uiCompareSide);
        }
        reader.expect(JsonParser.Event.END_ARRAY);
    }
}

