/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.conf.rs;

import java.io.File;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import javax.json.Json;
import javax.json.stream.JsonGenerator;
import javax.json.stream.JsonParsingException;
import javax.servlet.http.HttpServletRequest;
import javax.validation.constraints.Pattern;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.dcm4che3.conf.api.ConfigurationChanges;
import org.dcm4che3.conf.api.ConfigurationException;
import org.dcm4che3.conf.api.ConfigurationNotFoundException;
import org.dcm4che3.conf.api.DicomConfiguration;
import org.dcm4che3.conf.api.hl7.HL7Configuration;
import org.dcm4che3.conf.json.ConfigurationDelegate;
import org.dcm4che3.conf.json.JsonConfiguration;
import org.dcm4che3.net.ApplicationEntityInfo;
import org.dcm4che3.net.Device;
import org.dcm4che3.net.DeviceInfo;
import org.dcm4che3.net.KeycloakClient;
import org.dcm4che3.net.WebApplication;
import org.dcm4che3.net.WebApplicationInfo;
import org.dcm4che3.net.hl7.HL7ApplicationInfo;
import org.dcm4che3.util.ByteUtils;
import org.dcm4che3.util.StringUtils;
import org.dcm4chee.arc.conf.ArchiveDeviceExtension;
import org.dcm4chee.arc.event.SoftwareConfiguration;
import org.dcm4chee.arc.validation.constraints.ValidValueOf;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/")
@RequestScoped
public class ConfigurationRS {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigurationRS.class);
    @Inject
    private DicomConfiguration conf;
    @Inject
    private JsonConfiguration jsonConf;
    @Context
    private UriInfo uriInfo;
    @Context
    private HttpServletRequest request;
    @Inject
    private Event<SoftwareConfiguration> softwareConfigurationEvent;
    @Inject
    private Device device;
    @QueryParam(value="register")
    @Pattern(regexp="true|false")
    private @Pattern(regexp="true|false") String register;
    @QueryParam(value="dcmWebServiceClass")
    @ValidValueOf(type=WebServiceClasses.class, methodParameterType=List.class)
    private List<String> dcmWebServiceClass;
    private ConfigurationDelegate configDelegate = new ConfigurationDelegate(){

        public Device findDevice(String name) {
            try {
                return ConfigurationRS.this.conf.findDevice(name);
            }
            catch (ConfigurationException e) {
                LOG.info("Failed to load device with name " + name, (Throwable)e);
                return null;
            }
        }
    };

    public String toString() {
        String requestURI = this.request.getRequestURI();
        String queryString = this.request.getQueryString();
        return queryString == null ? requestURI : requestURI + "?" + queryString;
    }

    @GET
    @NoCache
    @Path(value="/devices/{DeviceName}")
    @Produces(value={"application/json"})
    public Response getDevice(@PathParam(value="DeviceName") String deviceName) {
        this.logRequest();
        try {
            Device device = this.conf.findDevice(deviceName);
            return Response.ok(out -> {
                JsonGenerator w = Json.createGenerator((OutputStream)out);
                this.jsonConf.writeTo(device, w, true);
                w.flush();
            }).build();
        }
        catch (ConfigurationNotFoundException e) {
            return this.errResponse(e.getMessage(), Response.Status.NOT_FOUND);
        }
        catch (ConfigurationException e) {
            throw new WebApplicationException(this.errResponse(e.getMessage(), Response.Status.CONFLICT));
        }
        catch (Exception e) {
            return this.errResponseAsTextPlain(this.exceptionAsString(e), Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @GET
    @NoCache
    @Path(value="/devices")
    @Produces(value={"application/json"})
    public Response listDevices() {
        this.logRequest();
        try {
            DeviceInfo[] deviceInfos = this.conf.listDeviceInfos(ConfigurationRS.toDeviceInfo(this.uriInfo));
            Arrays.sort(deviceInfos, Comparator.comparing(DeviceInfo::getDeviceName));
            return Response.ok(out -> {
                JsonGenerator gen = Json.createGenerator((OutputStream)out);
                gen.writeStartArray();
                for (DeviceInfo deviceInfo : deviceInfos) {
                    this.jsonConf.writeTo(deviceInfo, gen);
                }
                gen.writeEnd();
                gen.flush();
            }).build();
        }
        catch (ConfigurationException e) {
            throw new WebApplicationException(this.errResponse(e.getMessage(), Response.Status.CONFLICT));
        }
        catch (Exception e) {
            return this.errResponseAsTextPlain(this.exceptionAsString(e), Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @GET
    @NoCache
    @Path(value="/aes")
    @Produces(value={"application/json"})
    public Response listAETs() {
        this.logRequest();
        try {
            ApplicationEntityInfo[] aeInfos = this.conf.listAETInfos(ConfigurationRS.toApplicationEntityInfo(this.uriInfo));
            Arrays.sort(aeInfos, Comparator.comparing(ApplicationEntityInfo::getAETitle));
            return Response.ok(out -> {
                JsonGenerator gen = Json.createGenerator((OutputStream)out);
                gen.writeStartArray();
                for (ApplicationEntityInfo aeInfo : aeInfos) {
                    this.jsonConf.writeTo(aeInfo, gen);
                }
                gen.writeEnd();
                gen.flush();
            }).build();
        }
        catch (ConfigurationException e) {
            throw new WebApplicationException(this.errResponse(e.getMessage(), Response.Status.CONFLICT));
        }
        catch (Exception e) {
            return this.errResponseAsTextPlain(this.exceptionAsString(e), Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @GET
    @NoCache
    @Path(value="/webapps")
    @Produces(value={"application/json"})
    public Response listWebApps() {
        this.logRequest();
        try {
            WebApplicationInfo[] webappInfos = this.conf.listWebApplicationInfos(ConfigurationRS.toWebApplicationInfo(this.uriInfo));
            Arrays.sort(webappInfos, Comparator.comparing(WebApplicationInfo::getApplicationName));
            return Response.ok(out -> {
                JsonGenerator gen = Json.createGenerator((OutputStream)out);
                gen.writeStartArray();
                for (WebApplicationInfo webappInfo : webappInfos) {
                    this.jsonConf.writeTo(webappInfo, gen, this.keycloakClientID(webappInfo));
                }
                gen.writeEnd();
                gen.flush();
            }).build();
        }
        catch (ConfigurationException e) {
            throw new WebApplicationException(this.errResponse(e.getMessage(), Response.Status.CONFLICT));
        }
        catch (Exception e) {
            return this.errResponseAsTextPlain(this.exceptionAsString(e), Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    private String keycloakClientID(WebApplicationInfo webAppInfo) {
        String authURL = System.getProperty("auth-server-url");
        KeycloakClient keycloakClient = webAppInfo.getKeycloakClient();
        return keycloakClient == null || authURL == null || authURL.equals(keycloakClient.getKeycloakServerURL()) && System.getProperty("realm-name", "dcm4che").equals(keycloakClient.getKeycloakRealm()) ? null : webAppInfo.getKeycloakClientID();
    }

    @GET
    @NoCache
    @Path(value="/hl7apps")
    @Produces(value={"application/json"})
    public Response listHL7Apps() {
        this.logRequest();
        try {
            HL7Configuration hl7Conf = (HL7Configuration)this.conf.getDicomConfigurationExtension(HL7Configuration.class);
            HL7ApplicationInfo[] hl7AppInfos = hl7Conf.listHL7AppInfos(ConfigurationRS.toHL7ApplicationInfo(this.uriInfo));
            Arrays.sort(hl7AppInfos, Comparator.comparing(HL7ApplicationInfo::getHl7ApplicationName));
            return Response.ok(out -> {
                JsonGenerator gen = Json.createGenerator((OutputStream)out);
                gen.writeStartArray();
                for (HL7ApplicationInfo hl7AppInfo : hl7AppInfos) {
                    this.jsonConf.writeTo(hl7AppInfo, gen);
                }
                gen.writeEnd();
                gen.flush();
            }).build();
        }
        catch (ConfigurationException e) {
            throw new WebApplicationException(this.errResponse(e.getMessage(), Response.Status.CONFLICT));
        }
        catch (Exception e) {
            return this.errResponseAsTextPlain(this.exceptionAsString(e), Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @GET
    @NoCache
    @Path(value="/unique/aets")
    @Produces(value={"application/json"})
    public Response listRegisteredAETS() {
        this.logRequest();
        try {
            return this.writeJsonArray(this.conf.listRegisteredAETitles());
        }
        catch (ConfigurationException e) {
            throw new WebApplicationException(this.errResponse(e.getMessage(), Response.Status.CONFLICT));
        }
        catch (Exception e) {
            return this.errResponseAsTextPlain(this.exceptionAsString(e), Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @GET
    @NoCache
    @Path(value="/unique/hl7apps")
    @Produces(value={"application/json"})
    public Response listRegisteredHL7Apps() {
        this.logRequest();
        try {
            return this.writeJsonArray(((HL7Configuration)this.conf.getDicomConfigurationExtension(HL7Configuration.class)).listRegisteredHL7ApplicationNames());
        }
        catch (ConfigurationException e) {
            throw new WebApplicationException(this.errResponse(e.getMessage(), Response.Status.CONFLICT));
        }
        catch (Exception e) {
            return this.errResponseAsTextPlain(this.exceptionAsString(e), Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @GET
    @NoCache
    @Path(value="/unique/webAppNames")
    @Produces(value={"application/json"})
    public Response listRegisteredWebAppNames() {
        this.logRequest();
        try {
            return this.writeJsonArray(this.conf.listRegisteredWebAppNames());
        }
        catch (ConfigurationException e) {
            throw new WebApplicationException(this.errResponse(e.getMessage(), Response.Status.CONFLICT));
        }
        catch (Exception e) {
            return this.errResponseAsTextPlain(this.exceptionAsString(e), Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    private Response writeJsonArray(String[] values) {
        return Response.ok(out -> {
            JsonGenerator gen = Json.createGenerator((OutputStream)out);
            gen.writeStartArray();
            for (String value : values) {
                gen.write(value);
            }
            gen.writeEnd();
            gen.flush();
        }).build();
    }

    private EnumSet<DicomConfiguration.Option> options() {
        ArchiveDeviceExtension arcDev = (ArchiveDeviceExtension)this.device.getDeviceExtensionNotNull(ArchiveDeviceExtension.class);
        EnumSet<DicomConfiguration.Option> options = EnumSet.of(DicomConfiguration.Option.PRESERVE_VENDOR_DATA, DicomConfiguration.Option.PRESERVE_CERTIFICATE, arcDev.isAuditSoftwareConfigurationVerbose() ? DicomConfiguration.Option.CONFIGURATION_CHANGES_VERBOSE : DicomConfiguration.Option.CONFIGURATION_CHANGES);
        if (this.register == null || Boolean.parseBoolean(this.register)) {
            options.add(DicomConfiguration.Option.REGISTER);
        }
        return options;
    }

    @POST
    @Path(value="/devices/{DeviceName}")
    @Consumes(value={"application/json"})
    public void createDevice(@PathParam(value="DeviceName") String deviceName, Reader content) {
        this.logRequest();
        Device device = this.toDevice(deviceName, content);
        try {
            ConfigurationChanges diffs = this.conf.persist(device, this.options());
            this.softwareConfigurationEvent.fire((Object)new SoftwareConfiguration(this.request, deviceName, diffs));
        }
        catch (IllegalStateException | ConfigurationNotFoundException e) {
            throw new WebApplicationException(this.errResponse(e.getMessage(), Response.Status.NOT_FOUND));
        }
        catch (IllegalArgumentException e) {
            throw new WebApplicationException(this.errResponse(e.getMessage(), Response.Status.BAD_REQUEST));
        }
        catch (ConfigurationException e) {
            throw new WebApplicationException(this.errResponse(e.getMessage(), Response.Status.CONFLICT));
        }
        catch (Exception e) {
            throw new WebApplicationException(this.errResponseAsTextPlain(this.exceptionAsString(e), Response.Status.INTERNAL_SERVER_ERROR));
        }
    }

    @PUT
    @Path(value="/devices/{DeviceName}")
    @Consumes(value={"application/json"})
    public void updateDevice(@PathParam(value="DeviceName") String deviceName, Reader content) {
        this.logRequest();
        Device device = this.toDevice(deviceName, content);
        try {
            ConfigurationChanges diffs = this.conf.merge(device, this.options());
            if (!diffs.isEmpty()) {
                this.softwareConfigurationEvent.fire((Object)new SoftwareConfiguration(this.request, deviceName, diffs));
            }
        }
        catch (IllegalStateException | ConfigurationNotFoundException e) {
            throw new WebApplicationException(this.errResponse(e.getMessage(), Response.Status.NOT_FOUND));
        }
        catch (IllegalArgumentException e) {
            throw new WebApplicationException(this.errResponse(e.getMessage(), Response.Status.BAD_REQUEST));
        }
        catch (ConfigurationException e) {
            throw new WebApplicationException(this.errResponse(e.getMessage(), Response.Status.CONFLICT));
        }
        catch (Exception e) {
            throw new WebApplicationException(this.errResponseAsTextPlain(this.exceptionAsString(e), Response.Status.INTERNAL_SERVER_ERROR));
        }
    }

    @POST
    @Path(value="/unique/aets/{aet}")
    @Consumes(value={"application/json"})
    public void registerAET(@PathParam(value="aet") String aet) {
        this.logRequest();
        try {
            if (!this.conf.registerAETitle(aet)) {
                throw new WebApplicationException(this.errResponse("Application Entity Title " + aet + " already registered.", Response.Status.CONFLICT));
            }
        }
        catch (ConfigurationException e) {
            throw new WebApplicationException(this.errResponse(e.getMessage(), Response.Status.CONFLICT));
        }
        catch (Exception e) {
            throw new WebApplicationException(this.errResponseAsTextPlain(this.exceptionAsString(e), Response.Status.INTERNAL_SERVER_ERROR));
        }
    }

    @DELETE
    @Path(value="/unique/aets/{aet}")
    public void unregisterAET(@PathParam(value="aet") String aet) {
        this.logRequest();
        try {
            List<String> aets = Arrays.asList(this.conf.listRegisteredAETitles());
            if (!aets.contains(aet)) {
                throw new WebApplicationException(this.errResponse("Application Entity Title " + aet + " not registered.", Response.Status.NOT_FOUND));
            }
            this.conf.unregisterAETitle(aet);
        }
        catch (ConfigurationException e) {
            throw new WebApplicationException(this.errResponse(e.getMessage(), Response.Status.CONFLICT));
        }
        catch (Exception e) {
            throw new WebApplicationException(this.errResponseAsTextPlain(this.exceptionAsString(e), Response.Status.INTERNAL_SERVER_ERROR));
        }
    }

    @POST
    @Path(value="/unique/hl7apps/{appName}")
    @Consumes(value={"application/json"})
    public void registerHL7App(@PathParam(value="appName") String appName) {
        this.logRequest();
        try {
            HL7Configuration hl7Conf = (HL7Configuration)this.conf.getDicomConfigurationExtension(HL7Configuration.class);
            if (!hl7Conf.registerHL7Application(appName)) {
                throw new WebApplicationException(this.errResponse("HL7 Application " + appName + " already registered.", Response.Status.CONFLICT));
            }
        }
        catch (ConfigurationException e) {
            throw new WebApplicationException(this.errResponse(e.getMessage(), Response.Status.CONFLICT));
        }
        catch (Exception e) {
            throw new WebApplicationException(this.errResponseAsTextPlain(this.exceptionAsString(e), Response.Status.INTERNAL_SERVER_ERROR));
        }
    }

    @DELETE
    @Path(value="/unique/hl7apps/{appName}")
    public void unregisterHL7App(@PathParam(value="appName") String appName) {
        this.logRequest();
        try {
            HL7Configuration hl7Conf = (HL7Configuration)this.conf.getDicomConfigurationExtension(HL7Configuration.class);
            List<String> hl7apps = Arrays.asList(hl7Conf.listRegisteredHL7ApplicationNames());
            if (!hl7apps.contains(appName)) {
                throw new WebApplicationException(this.errResponse("HL7 Application " + appName + " not registered.", Response.Status.NOT_FOUND));
            }
            hl7Conf.unregisterHL7Application(appName);
        }
        catch (ConfigurationException e) {
            throw new WebApplicationException(this.errResponse(e.getMessage(), Response.Status.CONFLICT));
        }
        catch (Exception e) {
            throw new WebApplicationException(this.errResponseAsTextPlain(this.exceptionAsString(e), Response.Status.INTERNAL_SERVER_ERROR));
        }
    }

    @POST
    @Path(value="/unique/webApps/{webAppName}")
    @Consumes(value={"application/json"})
    public void registerWebApp(@PathParam(value="webAppName") String webAppName) {
        this.logRequest();
        try {
            if (!this.conf.registerWebAppName(webAppName)) {
                throw new WebApplicationException(this.errResponse("Web Application " + webAppName + " already registered.", Response.Status.CONFLICT));
            }
        }
        catch (ConfigurationException e) {
            throw new WebApplicationException(this.errResponse(e.getMessage(), Response.Status.CONFLICT));
        }
        catch (Exception e) {
            throw new WebApplicationException(this.errResponseAsTextPlain(this.exceptionAsString(e), Response.Status.INTERNAL_SERVER_ERROR));
        }
    }

    @DELETE
    @Path(value="/unique/webApps/{webAppName}")
    public void unregisterWebApp(@PathParam(value="webAppName") String webAppName) {
        this.logRequest();
        try {
            List<String> webApps = Arrays.asList(this.conf.listRegisteredWebAppNames());
            if (!webApps.contains(webAppName)) {
                throw new WebApplicationException(this.errResponse("Web Application " + webAppName + " not registered.", Response.Status.NOT_FOUND));
            }
            this.conf.unregisterWebAppName(webAppName);
        }
        catch (ConfigurationException e) {
            throw new WebApplicationException(this.errResponse(e.getMessage(), Response.Status.CONFLICT));
        }
        catch (Exception e) {
            throw new WebApplicationException(this.errResponseAsTextPlain(this.exceptionAsString(e), Response.Status.INTERNAL_SERVER_ERROR));
        }
    }

    @DELETE
    @Path(value="/devices/{DeviceName}")
    public void deleteDevice(@PathParam(value="DeviceName") String deviceName) {
        this.logRequest();
        try {
            ConfigurationChanges diffs = this.conf.removeDevice(deviceName, this.options());
            this.softwareConfigurationEvent.fire((Object)new SoftwareConfiguration(this.request, deviceName, diffs));
        }
        catch (IllegalStateException | ConfigurationNotFoundException e) {
            throw new WebApplicationException(this.errResponse(e.getMessage(), Response.Status.NOT_FOUND));
        }
        catch (ConfigurationException e) {
            throw new WebApplicationException(this.errResponse(e.getMessage(), Response.Status.CONFLICT));
        }
        catch (Exception e) {
            throw new WebApplicationException(this.errResponseAsTextPlain(this.exceptionAsString(e), Response.Status.INTERNAL_SERVER_ERROR));
        }
    }

    @GET
    @NoCache
    @Path(value="/devices/{deviceName}/vendordata")
    @Produces(value={"application/zip"})
    public Response getVendorData(@PathParam(value="deviceName") String deviceName) {
        this.logRequest();
        byte[] content = ByteUtils.EMPTY_BYTES;
        Response.Status status = Response.Status.NO_CONTENT;
        try {
            byte[][] vendorData = this.conf.loadDeviceVendorData(deviceName);
            if (vendorData.length > 0) {
                content = vendorData[0];
                status = Response.Status.OK;
            }
        }
        catch (ConfigurationNotFoundException e) {
            return this.errResponse(e.getMessage(), Response.Status.NOT_FOUND);
        }
        catch (ConfigurationException e) {
            throw new WebApplicationException(this.errResponse(e.getMessage(), Response.Status.CONFLICT));
        }
        catch (Exception e) {
            return this.errResponseAsTextPlain(this.exceptionAsString(e), Response.Status.INTERNAL_SERVER_ERROR);
        }
        return Response.status((Response.Status)status).entity((Object)content).type("application/zip").header("Content-Disposition", (Object)"attachment; filename=vendordata.zip").build();
    }

    @PUT
    @Path(value="/devices/{deviceName}/vendordata")
    @Consumes(value={"application/zip"})
    public Response updateVendorData(@PathParam(value="deviceName") String deviceName, File file) {
        this.logRequest();
        try {
            ConfigurationChanges diffs = this.conf.updateDeviceVendorData(deviceName, (byte[][])new byte[][]{Files.readAllBytes(file.toPath())});
            if (!diffs.isEmpty()) {
                this.softwareConfigurationEvent.fire((Object)new SoftwareConfiguration(this.request, deviceName, diffs));
            }
        }
        catch (ConfigurationNotFoundException e) {
            return this.errResponse(e.getMessage(), Response.Status.NOT_FOUND);
        }
        catch (ConfigurationException e) {
            throw new WebApplicationException(this.errResponse(e.getMessage(), Response.Status.CONFLICT));
        }
        catch (Exception e) {
            return this.errResponseAsTextPlain(this.exceptionAsString(e), Response.Status.INTERNAL_SERVER_ERROR);
        }
        return Response.noContent().build();
    }

    @DELETE
    @Path(value="/devices/{deviceName}/vendordata")
    public Response deleteVendorData(@PathParam(value="deviceName") String deviceName) {
        this.logRequest();
        try {
            ConfigurationChanges diffs = this.conf.updateDeviceVendorData(deviceName, (byte[][])new byte[0][]);
            if (!diffs.isEmpty()) {
                this.softwareConfigurationEvent.fire((Object)new SoftwareConfiguration(this.request, deviceName, diffs));
            }
        }
        catch (ConfigurationNotFoundException e) {
            return this.errResponse(e.getMessage(), Response.Status.NOT_FOUND);
        }
        catch (ConfigurationException e) {
            throw new WebApplicationException(this.errResponse(e.getMessage(), Response.Status.CONFLICT));
        }
        catch (Exception e) {
            return this.errResponseAsTextPlain(this.exceptionAsString(e), Response.Status.INTERNAL_SERVER_ERROR);
        }
        return Response.noContent().build();
    }

    private Device toDevice(String deviceName, Reader content) {
        Device device;
        try {
            device = this.jsonConf.loadDeviceFrom(Json.createParser((Reader)content), this.configDelegate);
        }
        catch (JsonParsingException e) {
            throw new WebApplicationException(this.errResponse(e.getMessage() + " at location : " + e.getLocation(), Response.Status.BAD_REQUEST));
        }
        catch (ConfigurationNotFoundException e) {
            throw new WebApplicationException(this.errResponse(e.getMessage(), Response.Status.NOT_FOUND));
        }
        catch (IllegalArgumentException e) {
            throw new WebApplicationException(this.errResponse(e.getMessage(), Response.Status.BAD_REQUEST));
        }
        catch (ConfigurationException e) {
            throw new WebApplicationException(this.errResponse(e.getMessage(), Response.Status.CONFLICT));
        }
        catch (Exception e) {
            throw new WebApplicationException(this.errResponseAsTextPlain(this.exceptionAsString(e), Response.Status.INTERNAL_SERVER_ERROR));
        }
        if (!device.getDeviceName().equals(deviceName)) {
            throw new WebApplicationException(this.errResponse("Device name in content[" + device.getDeviceName() + "] does not match Device name in URL", Response.Status.BAD_REQUEST));
        }
        return device;
    }

    private static DeviceInfo toDeviceInfo(UriInfo info) {
        DeviceInfo deviceInfo = new DeviceInfo();
        info.getQueryParameters().forEach((key, value) -> {
            switch (key) {
                case "dicomDeviceName": {
                    deviceInfo.setDeviceName(ConfigurationRS.firstValueOf(value));
                    break;
                }
                case "dicomDescription": {
                    deviceInfo.setDescription(ConfigurationRS.firstValueOf(value));
                    break;
                }
                case "dicomManufacturer": {
                    deviceInfo.setManufacturer(ConfigurationRS.firstValueOf(value));
                    break;
                }
                case "dicomManufacturerModelName": {
                    deviceInfo.setManufacturerModelName(ConfigurationRS.firstValueOf(value));
                    break;
                }
                case "dicomSoftwareVersion": {
                    deviceInfo.setSoftwareVersions(ConfigurationRS.toArray(value));
                    break;
                }
                case "dicomStationName": {
                    deviceInfo.setStationName(ConfigurationRS.firstValueOf(value));
                    break;
                }
                case "dicomInstitutionName": {
                    deviceInfo.setInstitutionNames(ConfigurationRS.toArray(value));
                    break;
                }
                case "dicomInstitutionDepartmentName": {
                    deviceInfo.setInstitutionalDepartmentNames(ConfigurationRS.toArray(value));
                    break;
                }
                case "dicomPrimaryDeviceType": {
                    deviceInfo.setPrimaryDeviceTypes(ConfigurationRS.toArray(value));
                    break;
                }
                case "dicomInstalled": {
                    deviceInfo.setInstalled(Boolean.valueOf(Boolean.parseBoolean(ConfigurationRS.firstValueOf(value))));
                    break;
                }
                case "hasArcDevExt": {
                    deviceInfo.setArcDevExt(Boolean.valueOf(Boolean.parseBoolean(ConfigurationRS.firstValueOf(value))));
                }
            }
        });
        return deviceInfo;
    }

    private static String firstValueOf(List<String> value) {
        return value.get(0);
    }

    private static String[] toArray(List<String> value) {
        return value.toArray(StringUtils.EMPTY_STRING);
    }

    private static ApplicationEntityInfo toApplicationEntityInfo(UriInfo info) {
        ApplicationEntityInfo aetInfo = new ApplicationEntityInfo();
        info.getQueryParameters().forEach((key, value) -> {
            switch (key) {
                case "dicomDeviceName": {
                    aetInfo.setDeviceName(ConfigurationRS.firstValueOf(value));
                    break;
                }
                case "dicomAETitle": {
                    aetInfo.setAETitle(ConfigurationRS.firstValueOf(value));
                    break;
                }
                case "dicomAssociationInitiator": {
                    aetInfo.setAssociationInitiator(Boolean.valueOf(Boolean.parseBoolean(ConfigurationRS.firstValueOf(value))));
                    break;
                }
                case "dicomAssociationAcceptor": {
                    aetInfo.setAssociationAcceptor(Boolean.valueOf(Boolean.parseBoolean(ConfigurationRS.firstValueOf(value))));
                    break;
                }
                case "dicomDescription": {
                    aetInfo.setDescription(ConfigurationRS.firstValueOf(value));
                    break;
                }
                case "dicomApplicationCluster": {
                    aetInfo.setApplicationClusters(ConfigurationRS.toArray(value));
                }
            }
        });
        return aetInfo;
    }

    private static WebApplicationInfo toWebApplicationInfo(UriInfo info) {
        WebApplicationInfo webappInfo = new WebApplicationInfo();
        info.getQueryParameters().forEach((key, value) -> {
            switch (key) {
                case "dicomDeviceName": {
                    webappInfo.setDeviceName(ConfigurationRS.firstValueOf(value));
                    break;
                }
                case "dcmWebAppName": {
                    webappInfo.setApplicationName(ConfigurationRS.firstValueOf(value));
                    break;
                }
                case "dicomDescription": {
                    webappInfo.setDescription(ConfigurationRS.firstValueOf(value));
                    break;
                }
                case "dcmWebServicePath": {
                    webappInfo.setServicePath(ConfigurationRS.firstValueOf(value));
                    break;
                }
                case "dcmWebServiceClass": {
                    webappInfo.setServiceClasses(new WebServiceClasses((List<String>)value).list);
                    break;
                }
                case "dicomAETitle": {
                    webappInfo.setAETitle(ConfigurationRS.firstValueOf(value));
                    break;
                }
                case "dicomApplicationCluster": {
                    webappInfo.setApplicationClusters(ConfigurationRS.toArray(value));
                    break;
                }
                case "dcmKeycloakClientID": {
                    webappInfo.setKeycloakClientID(ConfigurationRS.firstValueOf(value));
                }
            }
        });
        return webappInfo;
    }

    private static HL7ApplicationInfo toHL7ApplicationInfo(UriInfo info) {
        HL7ApplicationInfo hl7AppInfo = new HL7ApplicationInfo();
        info.getQueryParameters().forEach((key, value) -> {
            switch (key) {
                case "dicomDeviceName": {
                    hl7AppInfo.setDeviceName(ConfigurationRS.firstValueOf(value));
                    break;
                }
                case "hl7ApplicationName": {
                    hl7AppInfo.setHl7ApplicationName(ConfigurationRS.firstValueOf(value));
                    break;
                }
                case "dicomApplicationCluster": {
                    hl7AppInfo.setApplicationClusters(ConfigurationRS.toArray(value));
                }
            }
        });
        return hl7AppInfo;
    }

    private void logRequest() {
        LOG.info("Process {} {} from {}@{}", new Object[]{this.request.getMethod(), this.toString(), this.request.getRemoteUser(), this.request.getRemoteHost()});
    }

    private Response errResponse(String msg, Response.Status status) {
        return this.errResponseAsTextPlain("{\"errorMessage\":\"" + msg + "\"}", status);
    }

    private Response errResponseAsTextPlain(String errorMsg, Response.Status status) {
        LOG.warn("Response {} caused by {}", (Object)status, (Object)errorMsg);
        return Response.status((Response.Status)status).entity((Object)errorMsg).type("text/plain").build();
    }

    private String exceptionAsString(Exception e) {
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    public static class WebServiceClasses {
        final List<WebApplication.ServiceClass> list;

        public WebServiceClasses(List<String> values) {
            this.list = values.stream().flatMap(s -> Stream.of(StringUtils.split((String)s, (char)','))).map(WebApplication.ServiceClass::valueOf).collect(Collectors.toList());
        }
    }
}

