/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.conf;

import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.Code;
import org.dcm4che3.data.Issuer;
import org.dcm4che3.util.AttributesFormat;
import org.dcm4che3.util.StringUtils;
import org.dcm4che3.util.UIDUtils;
import org.dcm4chee.arc.conf.Conditions;
import org.dcm4chee.arc.conf.Duration;
import org.dcm4chee.arc.conf.Entity;
import org.dcm4chee.arc.conf.InputReadinessState;
import org.dcm4chee.arc.conf.UPSPriority;

public class UPSOnUPSCompleted {
    public static final UPSOnUPSCompleted[] EMPTY = new UPSOnUPSCompleted[0];
    private String upsOnUPSCompletedID;
    private Conditions conditions = new Conditions(new String[0]);
    private String[] requiresOtherUPSCompleted = new String[0];
    private UPSPriority upsPriority = UPSPriority.MEDIUM;
    private InputReadinessState inputReadinessState = InputReadinessState.READY;
    private IncludeInputInformation includeInputInformation = IncludeInputInformation.COPY_OUTPUT;
    private Duration startDateTimeDelay;
    private Duration completionDateTimeDelay;
    private AttributesFormat procedureStepLabel;
    private AttributesFormat worklistLabel;
    private AttributesFormat instanceUIDBasedOnName;
    private AttributesFormat scheduledHumanPerformerName;
    private AttributesFormat scheduledHumanPerformerOrganization;
    private AttributesFormat admissionID;
    private Issuer issuerOfAdmissionID;
    private Code scheduledWorkitemCode;
    private Code[] scheduledStationNames = new Code[0];
    private Code[] scheduledStationClasses = new Code[0];
    private Code[] scheduledStationLocations = new Code[0];
    private Code[] scheduledHumanPerformers = new Code[0];
    private String destinationAE;
    private Entity scopeOfAccumulation;
    private String xsltStylesheetURI;
    private boolean noKeywords;
    private boolean includeStudyInstanceUID;
    private boolean includeReferencedRequest;
    private boolean includePatient = true;

    public UPSOnUPSCompleted() {
    }

    public UPSOnUPSCompleted(String upsOnUPSCompletedID) {
        this.setUPSonUPSCompletedID(upsOnUPSCompletedID);
    }

    public String getUPSonUPSCompletedID() {
        return this.upsOnUPSCompletedID;
    }

    public void setUPSonUPSCompletedID(String UPSonUPSCompletedID) {
        this.upsOnUPSCompletedID = UPSonUPSCompletedID;
    }

    public Conditions getConditions() {
        return this.conditions;
    }

    public void setConditions(Conditions conditions) {
        this.conditions = conditions;
    }

    public String[] getRequiresOtherUPSCompleted() {
        return this.requiresOtherUPSCompleted;
    }

    public void setRequiresOtherUPSCompleted(String[] requiresOtherUPSCompleted) {
        this.requiresOtherUPSCompleted = requiresOtherUPSCompleted;
    }

    public UPSPriority getUPSPriority() {
        return this.upsPriority;
    }

    public void setUPSPriority(UPSPriority upsPriority) {
        this.upsPriority = upsPriority;
    }

    public InputReadinessState getInputReadinessState() {
        return this.inputReadinessState;
    }

    public void setInputReadinessState(InputReadinessState inputReadinessState) {
        this.inputReadinessState = inputReadinessState;
    }

    public IncludeInputInformation getIncludeInputInformation() {
        return this.includeInputInformation;
    }

    public void setIncludeInputInformation(IncludeInputInformation includeInputInformation) {
        this.includeInputInformation = includeInputInformation;
    }

    public boolean isIncludePatient() {
        return this.includePatient;
    }

    public void setIncludePatient(boolean includePatient) {
        this.includePatient = includePatient;
    }

    public boolean isIncludeStudyInstanceUID() {
        return this.includeStudyInstanceUID;
    }

    public void setIncludeStudyInstanceUID(boolean includeStudyInstanceUID) {
        this.includeStudyInstanceUID = includeStudyInstanceUID;
    }

    public boolean isIncludeReferencedRequest() {
        return this.includeReferencedRequest;
    }

    public void setIncludeReferencedRequest(boolean includeReferencedRequest) {
        this.includeReferencedRequest = includeReferencedRequest;
    }

    public Duration getStartDateTimeDelay() {
        return this.startDateTimeDelay;
    }

    public void setStartDateTimeDelay(Duration startDateTimeDelay) {
        this.startDateTimeDelay = startDateTimeDelay;
    }

    public Duration getCompletionDateTimeDelay() {
        return this.completionDateTimeDelay;
    }

    public void setCompletionDateTimeDelay(Duration completionDateTimeDelay) {
        this.completionDateTimeDelay = completionDateTimeDelay;
    }

    public String getProcedureStepLabel() {
        return Objects.toString(this.procedureStepLabel, null);
    }

    public void setProcedureStepLabel(String procedureStepLabel) {
        this.procedureStepLabel = AttributesFormat.valueOf((String)procedureStepLabel);
    }

    public String getProcedureStepLabel(Attributes attrs) {
        return UPSOnUPSCompleted.format(this.procedureStepLabel, attrs);
    }

    public String getWorklistLabel() {
        return Objects.toString(this.worklistLabel, null);
    }

    public void setWorklistLabel(String worklistLabel) {
        this.worklistLabel = AttributesFormat.valueOf((String)worklistLabel);
    }

    public String getWorklistLabel(Attributes attrs) {
        return UPSOnUPSCompleted.format(this.worklistLabel, attrs);
    }

    public String getInstanceUIDBasedOnName() {
        return Objects.toString(this.instanceUIDBasedOnName, null);
    }

    public void setInstanceUIDBasedOnName(String instanceUIDBasedOnName) {
        this.instanceUIDBasedOnName = AttributesFormat.valueOf((String)instanceUIDBasedOnName);
    }

    public String getInstanceUID(Attributes attrs) {
        return this.instanceUIDBasedOnName != null ? UIDUtils.createNameBasedUID((byte[])this.instanceUIDBasedOnName.format((Object)attrs).getBytes(StandardCharsets.UTF_8)) : UIDUtils.createUID();
    }

    public String getScheduledHumanPerformerName() {
        return Objects.toString(this.scheduledHumanPerformerName, null);
    }

    public void setScheduledHumanPerformerName(String scheduledHumanPerformerName) {
        this.scheduledHumanPerformerName = AttributesFormat.valueOf((String)scheduledHumanPerformerName);
    }

    public String getScheduledHumanPerformerName(Attributes attrs) {
        return UPSOnUPSCompleted.format(this.scheduledHumanPerformerName, attrs);
    }

    public String getScheduledHumanPerformerOrganization() {
        return Objects.toString(this.scheduledHumanPerformerOrganization, null);
    }

    public void setScheduledHumanPerformerOrganization(String scheduledHumanPerformerOrganization) {
        this.scheduledHumanPerformerOrganization = AttributesFormat.valueOf((String)scheduledHumanPerformerOrganization);
    }

    public String getScheduledHumanPerformerOrganization(Attributes attrs) {
        return UPSOnUPSCompleted.format(this.scheduledHumanPerformerOrganization, attrs);
    }

    public String getAdmissionID() {
        return Objects.toString(this.admissionID, null);
    }

    public void setAdmissionID(String admissionID) {
        this.admissionID = AttributesFormat.valueOf((String)admissionID);
    }

    public String getAdmissionID(Attributes attrs) {
        return UPSOnUPSCompleted.format(this.admissionID, attrs);
    }

    public Issuer getIssuerOfAdmissionID() {
        return this.issuerOfAdmissionID;
    }

    public void setIssuerOfAdmissionID(Issuer issuerOfAdmissionID) {
        this.issuerOfAdmissionID = issuerOfAdmissionID;
    }

    public Code getScheduledWorkitemCode() {
        return this.scheduledWorkitemCode;
    }

    public void setScheduledWorkitemCode(Code scheduledWorkitemCode) {
        this.scheduledWorkitemCode = scheduledWorkitemCode;
    }

    public Code[] getScheduledStationNames() {
        return this.scheduledStationNames;
    }

    public void setScheduledStationNames(Code ... scheduledStationNames) {
        this.scheduledStationNames = scheduledStationNames;
    }

    public Code[] getScheduledStationClasses() {
        return this.scheduledStationClasses;
    }

    public void setScheduledStationClasses(Code ... scheduledStationClasses) {
        this.scheduledStationClasses = scheduledStationClasses;
    }

    public Code[] getScheduledStationLocations() {
        return this.scheduledStationLocations;
    }

    public void setScheduledStationLocations(Code ... scheduledStationLocations) {
        this.scheduledStationLocations = scheduledStationLocations;
    }

    public Code[] getScheduledHumanPerformers() {
        return this.scheduledHumanPerformers;
    }

    public void setScheduledHumanPerformers(Code[] scheduledHumanPerformers) {
        this.scheduledHumanPerformers = scheduledHumanPerformers;
    }

    public String getDestinationAE() {
        return this.destinationAE;
    }

    public void setDestinationAE(String destinationAE) {
        this.destinationAE = destinationAE;
    }

    public Entity getScopeOfAccumulation() {
        return this.scopeOfAccumulation;
    }

    public void setScopeOfAccumulation(Entity scopeOfAccumulation) {
        this.scopeOfAccumulation = scopeOfAccumulation;
    }

    public String getXSLTStylesheetURI() {
        return this.xsltStylesheetURI;
    }

    public void setXSLTStylesheetURI(String xsltStylesheetURI) {
        this.xsltStylesheetURI = xsltStylesheetURI;
    }

    public boolean isNoKeywords() {
        return this.noKeywords;
    }

    public void setNoKeywords(boolean noKeywords) {
        this.noKeywords = noKeywords;
    }

    public String toString() {
        return "UPSOnUPSCompleted{cn='" + this.upsOnUPSCompletedID + "'}";
    }

    private static String format(AttributesFormat format, Attributes attrs) {
        return format != null ? (String)StringUtils.nullify((Object)format.format((Object)attrs), (Object)"null") : null;
    }

    public static enum IncludeInputInformation {
        NO,
        COPY_INPUT,
        COPY_OUTPUT;

    }
}

