/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.conf;

import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.dcm4che3.data.Code;
import org.dcm4che3.data.Issuer;
import org.dcm4che3.util.UIDUtils;
import org.dcm4chee.arc.conf.Duration;
import org.dcm4chee.arc.conf.HL7Conditions;
import org.dcm4chee.arc.conf.HL7Fields;
import org.dcm4chee.arc.conf.InputReadinessState;
import org.dcm4chee.arc.conf.ScheduleExpression;
import org.dcm4chee.arc.conf.UPSPriority;

public class UPSOnHL7 {
    public static final UPSOnHL7[] EMPTY = new UPSOnHL7[0];
    private String upsOnHL7ID;
    private HL7Conditions conditions = new HL7Conditions(new String[0]);
    private ScheduleExpression[] schedules = new ScheduleExpression[0];
    private String procedureStepLabel;
    private String worklistLabel;
    private UPSPriority upsPriority = UPSPriority.MEDIUM;
    private InputReadinessState inputReadinessState = InputReadinessState.READY;
    private Duration startDateTimeDelay;
    private Duration completionDateTimeDelay;
    private String instanceUIDBasedOnName;
    private String destinationAE;
    private Code scheduledWorkitemCode;
    private Code[] scheduledStationNames = new Code[0];
    private Code[] scheduledStationClasses = new Code[0];
    private Code[] scheduledStationLocations = new Code[0];
    private Code[] scheduledHumanPerformers = new Code[0];
    private String scheduledHumanPerformerName;
    private String scheduledHumanPerformerOrganization;
    private String studyInstanceUID;
    private String admissionID;
    private String accessionNumber;
    private String requestedProcedureID;
    private String requestedProcedureDescription;
    private String requestingPhysician;
    private String requestingService;
    private Issuer issuerOfAdmissionID;
    private Issuer issuerOfAccessionNumber;
    private String xsltStylesheetURI;
    private boolean includeStudyInstanceUID;
    private boolean includeReferencedRequest;

    public UPSOnHL7() {
    }

    public UPSOnHL7(String upsOnHL7ID) {
        this.upsOnHL7ID = upsOnHL7ID;
    }

    public String getUPSOnHL7ID() {
        return this.upsOnHL7ID;
    }

    public void setUPSOnHL7ID(String UPSOnHL7ID) {
        this.upsOnHL7ID = UPSOnHL7ID;
    }

    public HL7Conditions getConditions() {
        return this.conditions;
    }

    public void setConditions(HL7Conditions conditions) {
        this.conditions = conditions;
    }

    public ScheduleExpression[] getSchedules() {
        return this.schedules;
    }

    public void setSchedules(ScheduleExpression[] schedules) {
        this.schedules = schedules;
    }

    public String getProcedureStepLabel() {
        return this.procedureStepLabel;
    }

    public void setProcedureStepLabel(String procedureStepLabel) {
        this.procedureStepLabel = procedureStepLabel;
    }

    public String getProcedureStepLabel(HL7Fields hl7Fields) {
        return Objects.requireNonNull(hl7Fields.get(this.procedureStepLabel, null), "Missing value for Procedure Step Label at " + this.procedureStepLabel + " configured in UPSOnHL7[cn=" + this.upsOnHL7ID + "]");
    }

    public String getWorklistLabel() {
        return this.worklistLabel;
    }

    public void setWorklistLabel(String worklistLabel) {
        this.worklistLabel = worklistLabel;
    }

    public String getWorklistLabel(HL7Fields hl7Fields) {
        return this.worklistLabel != null ? hl7Fields.get(this.worklistLabel, null) : null;
    }

    public UPSPriority getUPSPriority() {
        return this.upsPriority;
    }

    public void setUPSPriority(UPSPriority upsPriority) {
        this.upsPriority = upsPriority;
    }

    public InputReadinessState getInputReadinessState() {
        return this.inputReadinessState;
    }

    public void setInputReadinessState(InputReadinessState inputReadinessState) {
        this.inputReadinessState = inputReadinessState;
    }

    public Duration getStartDateTimeDelay() {
        return this.startDateTimeDelay;
    }

    public void setStartDateTimeDelay(Duration startDateTimeDelay) {
        this.startDateTimeDelay = startDateTimeDelay;
    }

    public Duration getCompletionDateTimeDelay() {
        return this.completionDateTimeDelay;
    }

    public void setCompletionDateTimeDelay(Duration completionDateTimeDelay) {
        this.completionDateTimeDelay = completionDateTimeDelay;
    }

    public String getInstanceUIDBasedOnName() {
        return this.instanceUIDBasedOnName;
    }

    public void setInstanceUIDBasedOnName(String instanceUIDBasedOnName) {
        this.instanceUIDBasedOnName = instanceUIDBasedOnName;
    }

    public String getInstanceUID(HL7Fields hl7Fields) {
        return this.instanceUIDBasedOnName != null ? UIDUtils.createNameBasedUID((byte[])hl7Fields.get(this.instanceUIDBasedOnName, "*").getBytes(StandardCharsets.UTF_8)) : UIDUtils.createUID();
    }

    public String getDestinationAE() {
        return this.destinationAE;
    }

    public void setDestinationAE(String destinationAE) {
        this.destinationAE = destinationAE;
    }

    public Code getScheduledWorkitemCode() {
        return this.scheduledWorkitemCode;
    }

    public void setScheduledWorkitemCode(Code scheduledWorkitemCode) {
        this.scheduledWorkitemCode = scheduledWorkitemCode;
    }

    public Code[] getScheduledStationNames() {
        return this.scheduledStationNames;
    }

    public void setScheduledStationNames(Code ... scheduledStationNames) {
        this.scheduledStationNames = scheduledStationNames;
    }

    public Code[] getScheduledStationClasses() {
        return this.scheduledStationClasses;
    }

    public void setScheduledStationClasses(Code ... scheduledStationClasses) {
        this.scheduledStationClasses = scheduledStationClasses;
    }

    public Code[] getScheduledStationLocations() {
        return this.scheduledStationLocations;
    }

    public void setScheduledStationLocations(Code ... scheduledStationLocations) {
        this.scheduledStationLocations = scheduledStationLocations;
    }

    public Code[] getScheduledHumanPerformers() {
        return this.scheduledHumanPerformers;
    }

    public void setScheduledHumanPerformers(Code[] scheduledHumanPerformers) {
        this.scheduledHumanPerformers = scheduledHumanPerformers;
    }

    public String getScheduledHumanPerformerName() {
        return this.scheduledHumanPerformerName;
    }

    public void setScheduledHumanPerformerName(String scheduledHumanPerformerName) {
        this.scheduledHumanPerformerName = scheduledHumanPerformerName;
    }

    public String getScheduledHumanPerformerName(HL7Fields hl7Fields) {
        return this.scheduledHumanPerformerName != null ? hl7Fields.get(this.scheduledHumanPerformerName, null) : null;
    }

    public String getScheduledHumanPerformerOrganization() {
        return this.scheduledHumanPerformerOrganization;
    }

    public void setScheduledHumanPerformerOrganization(String scheduledHumanPerformerOrganization) {
        this.scheduledHumanPerformerOrganization = scheduledHumanPerformerOrganization;
    }

    public String getScheduledHumanPerformerOrganization(HL7Fields hl7Fields) {
        return this.scheduledHumanPerformerOrganization != null ? hl7Fields.get(this.scheduledHumanPerformerOrganization, null) : null;
    }

    public String getRequestingService() {
        return this.requestingService;
    }

    public void setRequestingService(String requestingService) {
        this.requestingService = requestingService;
    }

    public String getRequestingService(HL7Fields hl7Fields) {
        return this.requestingService != null ? hl7Fields.get(this.requestingService, null) : null;
    }

    public String getStudyInstanceUID() {
        return this.studyInstanceUID;
    }

    public void setStudyInstanceUID(String studyInstanceUID) {
        this.studyInstanceUID = studyInstanceUID;
    }

    public String getStudyInstanceUID(HL7Fields hl7Fields) {
        return this.studyInstanceUID != null ? hl7Fields.get(this.studyInstanceUID, null) : null;
    }

    public String getAdmissionID() {
        return this.admissionID;
    }

    public void setAdmissionID(String admissionID) {
        this.admissionID = admissionID;
    }

    public String getAdmissionID(HL7Fields hl7Fields) {
        return this.admissionID != null ? hl7Fields.get(this.admissionID, null) : null;
    }

    public String getAccessionNumber() {
        return this.accessionNumber;
    }

    public void setAccessionNumber(String accessionNumber) {
        this.accessionNumber = accessionNumber;
    }

    public String getAccessionNumber(HL7Fields hl7Fields) {
        return this.accessionNumber != null ? hl7Fields.get(this.accessionNumber, null) : null;
    }

    public String getRequestedProcedureID() {
        return this.requestedProcedureID;
    }

    public void setRequestedProcedureID(String requestedProcedureID) {
        this.requestedProcedureID = requestedProcedureID;
    }

    public String getRequestedProcedureID(HL7Fields hl7Fields) {
        return this.requestedProcedureID != null ? hl7Fields.get(this.requestedProcedureID, null) : null;
    }

    public String getRequestedProcedureDescription() {
        return this.requestedProcedureDescription;
    }

    public void setRequestedProcedureDescription(String requestedProcedureDescription) {
        this.requestedProcedureDescription = requestedProcedureDescription;
    }

    public String getRequestedProcedureDescription(HL7Fields hl7Fields) {
        return this.requestedProcedureDescription != null ? hl7Fields.get(this.requestedProcedureDescription, null) : null;
    }

    public String getRequestingPhysician() {
        return this.requestingPhysician;
    }

    public void setRequestingPhysician(String requestingPhysician) {
        this.requestingPhysician = requestingPhysician;
    }

    public String getRequestingPhysician(HL7Fields hl7Fields) {
        return this.requestingPhysician != null ? hl7Fields.get(this.requestingPhysician, null) : null;
    }

    public Issuer getIssuerOfAdmissionID() {
        return this.issuerOfAdmissionID;
    }

    public void setIssuerOfAdmissionID(Issuer issuerOfAdmissionID) {
        this.issuerOfAdmissionID = issuerOfAdmissionID;
    }

    public Issuer getIssuerOfAccessionNumber() {
        return this.issuerOfAccessionNumber;
    }

    public void setIssuerOfAccessionNumber(Issuer issuerOfAccessionNumber) {
        this.issuerOfAccessionNumber = issuerOfAccessionNumber;
    }

    public boolean isIncludeStudyInstanceUID() {
        return this.includeStudyInstanceUID;
    }

    public void setIncludeStudyInstanceUID(boolean includeStudyInstanceUID) {
        this.includeStudyInstanceUID = includeStudyInstanceUID;
    }

    public boolean isIncludeReferencedRequest() {
        return this.includeReferencedRequest;
    }

    public void setIncludeReferencedRequest(boolean includeReferencedRequest) {
        this.includeReferencedRequest = includeReferencedRequest;
    }

    public String getXSLTStylesheetURI() {
        return this.xsltStylesheetURI;
    }

    public void setXSLTStylesheetURI(String xsltStylesheetURI) {
        this.xsltStylesheetURI = xsltStylesheetURI;
    }

    public String toString() {
        return "UPSOnHL7{commonName='" + this.upsOnHL7ID + "'}";
    }
}

