/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.conf;

import org.dcm4che3.data.Code;
import org.dcm4chee.arc.conf.Duration;

public class RejectionNote {
    private String rejectionNoteLabel;
    private Type rejectionNoteType;
    private Code rejectionNoteCode;
    private int seriesNumber;
    private int instanceNumber;
    private AcceptPreviousRejectedInstance acceptPreviousRejectedInstance = AcceptPreviousRejectedInstance.REJECT;
    private Code[] overwritePreviousRejection = new Code[0];
    private Duration acceptRejectionBeforeStorage;
    private Duration deleteRejectedInstanceDelay;
    private Duration deleteRejectionNoteDelay;

    public String getRejectionNoteLabel() {
        return this.rejectionNoteLabel;
    }

    public void setRejectionNoteLabel(String rejectionNoteLabel) {
        this.rejectionNoteLabel = rejectionNoteLabel;
    }

    public Type getRejectionNoteType() {
        return this.rejectionNoteType;
    }

    public void setRejectionNoteType(Type rejectionNoteType) {
        this.rejectionNoteType = rejectionNoteType;
    }

    public boolean isRevokeRejection() {
        return this.rejectionNoteType == Type.REVOKE_REJECTION;
    }

    public boolean isDataRetentionPolicyExpired() {
        return this.rejectionNoteType == Type.DATA_RETENTION_POLICY_EXPIRED;
    }

    public boolean isIncorrectModalityWorklistEntry() {
        return this.rejectionNoteType == Type.INCORRECT_MODALITY_WORKLIST_ENTRY;
    }

    public Code getRejectionNoteCode() {
        return this.rejectionNoteCode;
    }

    public void setRejectionNoteCode(Code rejectionNoteCode) {
        this.rejectionNoteCode = rejectionNoteCode;
    }

    public int getSeriesNumber() {
        return this.seriesNumber;
    }

    public void setSeriesNumber(int seriesNumber) {
        this.seriesNumber = seriesNumber;
    }

    public int getInstanceNumber() {
        return this.instanceNumber;
    }

    public void setInstanceNumber(int instanceNumber) {
        this.instanceNumber = instanceNumber;
    }

    public AcceptPreviousRejectedInstance getAcceptPreviousRejectedInstance() {
        return this.acceptPreviousRejectedInstance;
    }

    public void setAcceptPreviousRejectedInstance(AcceptPreviousRejectedInstance acceptPreviousRejectedInstance) {
        this.acceptPreviousRejectedInstance = acceptPreviousRejectedInstance;
    }

    public Code[] getOverwritePreviousRejection() {
        return this.overwritePreviousRejection;
    }

    public boolean canOverwritePreviousRejection(Code code) {
        for (Code code1 : this.overwritePreviousRejection) {
            if (!code1.equalsIgnoreMeaning(code)) continue;
            return true;
        }
        return false;
    }

    public void setOverwritePreviousRejection(Code[] overwritePreviousRejection) {
        this.overwritePreviousRejection = overwritePreviousRejection;
    }

    public Duration getAcceptRejectionBeforeStorage() {
        return this.acceptRejectionBeforeStorage;
    }

    public void setAcceptRejectionBeforeStorage(Duration acceptRejectionBeforeStorage) {
        this.acceptRejectionBeforeStorage = acceptRejectionBeforeStorage;
    }

    public Duration getDeleteRejectedInstanceDelay() {
        return this.deleteRejectedInstanceDelay;
    }

    public void setDeleteRejectedInstanceDelay(Duration deleteRejectedInstanceDelay) {
        this.deleteRejectedInstanceDelay = deleteRejectedInstanceDelay;
    }

    public Duration getDeleteRejectionNoteDelay() {
        return this.deleteRejectionNoteDelay;
    }

    public void setDeleteRejectionNoteDelay(Duration deleteRejectionNoteDelay) {
        this.deleteRejectionNoteDelay = deleteRejectionNoteDelay;
    }

    public static enum Type {
        REJECTED_FOR_QUALITY_REASONS,
        REJECTED_FOR_PATIENT_SAFETY_REASONS,
        INCORRECT_MODALITY_WORKLIST_ENTRY,
        DATA_RETENTION_POLICY_EXPIRED,
        REVOKE_REJECTION;

    }

    public static enum AcceptPreviousRejectedInstance {
        REJECT,
        RESTORE,
        IGNORE;

    }
}

