/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.conf;

import java.net.URI;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.dcm4chee.arc.conf.Entity;

public class PDQServiceDescriptor {
    private String pdqServiceID;
    private String description;
    private URI pdqServiceURI;
    private int[] selection = new int[0];
    private final Map<String, String> properties = new HashMap<String, String>();
    private Entity entity = Entity.Patient;

    public PDQServiceDescriptor() {
    }

    public PDQServiceDescriptor(String pdqServiceID) {
        this.pdqServiceID = pdqServiceID;
    }

    public String getPDQServiceID() {
        return this.pdqServiceID;
    }

    public void setPDQServiceID(String pdqServiceID) {
        this.pdqServiceID = pdqServiceID;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public URI getPDQServiceURI() {
        return this.pdqServiceURI;
    }

    public void setPDQServiceURI(URI pdqServiceURI) {
        this.pdqServiceURI = pdqServiceURI;
    }

    public int[] getSelection() {
        return this.selection;
    }

    public void setSelection(int[] selection) {
        this.selection = selection;
        Arrays.sort(selection);
    }

    public void setProperty(String name, String value) {
        this.properties.put(name, value);
    }

    public String getProperty(String name, String defValue) {
        String value = this.properties.get(name);
        return value != null ? value : defValue;
    }

    public Entity getEntity() {
        return this.entity;
    }

    public void setEntity(Entity entity) {
        switch (entity) {
            case Study: 
            case Patient: {
                this.entity = entity;
                break;
            }
            default: {
                throw new IllegalArgumentException("entity: " + entity);
            }
        }
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(String[] ss) {
        this.properties.clear();
        for (String s : ss) {
            int index = s.indexOf(61);
            if (index < 0) {
                throw new IllegalArgumentException("Property in incorrect format : " + s);
            }
            this.setProperty(s.substring(0, index), s.substring(index + 1));
        }
    }

    public String toString() {
        return "PDQService{id=" + this.pdqServiceID + ", uri=" + this.pdqServiceURI + "}";
    }
}

