/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.conf;

import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Pattern;
import org.dcm4chee.arc.conf.HL7Fields;

public class HL7Conditions {
    public static final String SENDING_HOSTNAME = "SendingHostname";
    private final Map<String, Pattern> map = new TreeMap<String, Pattern>();

    public HL7Conditions(String ... props) {
        for (String s : props) {
            int index = s.indexOf(61);
            if (index == -1) {
                throw new IllegalArgumentException("Condition in incorrect format : " + s);
            }
            this.setCondition(s.substring(0, index), s.substring(index + 1));
        }
    }

    public void setSendingHostname(String value) {
        this.setCondition(SENDING_HOSTNAME, value);
    }

    public void setNotSendingHostname(String value) {
        this.setCondition("SendingHostname!", value);
    }

    public void setCondition(String tagPath, String value) {
        this.map.put(tagPath, Pattern.compile(value));
    }

    public Map<String, Pattern> getMap() {
        return this.map;
    }

    public boolean match(String hostName, HL7Fields hl7Fields) {
        for (Map.Entry<String, Pattern> entry : this.map.entrySet()) {
            String hl7Field = entry.getKey();
            Pattern pattern = entry.getValue();
            boolean ne = hl7Field.endsWith("!");
            if (ne) {
                hl7Field = hl7Field.substring(0, hl7Field.length() - 1);
            }
            if (!(hl7Field.equals(SENDING_HOSTNAME) ? (ne ? hostName != null && pattern.matcher(hostName).matches() : hostName == null || !pattern.matcher(hostName).matches()) : !this.match(hl7Fields, hl7Field, pattern, ne))) continue;
            return false;
        }
        return true;
    }

    private boolean match(HL7Fields hl7Fields, String hl7Field, Pattern pattern, boolean ne) {
        try {
            String value = hl7Fields.get(hl7Field, null);
            if (ne ? value != null && pattern.matcher(value).matches() : value == null || !pattern.matcher(value).matches()) {
                return false;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return true;
    }

    public String toString() {
        return this.map.toString();
    }
}

